(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[12],{

/***/ 1509:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2012-2013 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * Employee grid panel
 * 
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.EmployeeGridPanel
 * @extends     Tine.widgets.grid.GridPanel
 * 
 * <p>Employee Grid Panel</p>
 * <p><pre>
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>    
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.HumanResources.EmployeeGridPanel
 */

Tine.HumanResources.EmployeeGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  renderSalutation: function renderSalutation(value, row, record) {
    if (!this.salutationRenderer) {
      this.salutationRenderer = Tine.Tinebase.widgets.keyfield.Renderer.get('Addressbook', 'contactSalutation');
    }

    return this.salutationRenderer(value, row, record);
  }
});
Tine.widgets.grid.RendererManager.register('HumanResources', 'Employee', 'salutation', Tine.HumanResources.EmployeeGridPanel.prototype.renderSalutation);

/***/ }),

/***/ 1510:
/***/ (function(module, exports) {

/*
* Tine 2.0
* 
* @package     HumanResources
* @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
* @author      Alexander Stintzing <a.stintzing@metaways.de>
* @copyright   Copyright (c) 2012-2013 Metaways Infosystems GmbH (http://www.metaways.de)
*/
Ext.namespace('Tine.HumanResources.Model');

/***/ }),

/***/ 1511:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2012 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.ExceptionHandler
 * 
 * <p>Exception Handler for HumanResources</p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 */

Tine.HumanResources.handleRequestException = function (exception, callback, callbackScope) {
  if (!exception.code && exception.responseText) {
    // we need to decode the exception first
    var response = Ext.util.JSON.decode(exception.responseText);
    exception = response.data;
  }

  var app = Tine.Tinebase.appMgr.get('HumanResources');
  var defaults = {
    buttons: Ext.Msg.OK,
    icon: Ext.MessageBox.ERROR,
    fn: callback,
    scope: callbackScope,
    title: app.i18n._(exception.title),
    msg: app.i18n._(exception.message)
  };
  Tine.log.warn('Request exception :');
  Tine.log.warn(exception);

  switch (exception.code) {
    case 911: // HumanResources_Exception_NoContract

    case 912: // HumanResources_Exception_ContractNotEditable

    case 913: // HumanResources_Exception_RemainingNotBookable

    case 914: // HumanResources_Exception_NoAccount

    case 915: // HumanResources_Exception_ContractOverlap

    case 916: // HumanResources_Exception_ContractDates

    case 917:
      // HumanResources_Exception_NeedsYear
      Ext.MessageBox.show(defaults);
      break;
    // return false will the generic exceptionhandler handle the caught exception

    default:
      return false;
  }

  return true;
};

Tine.Tinebase.ExceptionHandlerRegistry.register('HumanResources', Tine.HumanResources.handleRequestException);

/***/ }),

/***/ 1512:
/***/ (function(module, exports, __webpack_require__) {

/*
 * Tine 2.0
 * 
 * @package     HumanResources
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2012-2013 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.HumanResources');

__webpack_require__(1513);

__webpack_require__(1514);

__webpack_require__(1515);

__webpack_require__(1516);

Tine.HumanResources.Application = Ext.extend(Tine.Tinebase.Application, {
  hasMainScreen: true,
  init: function init() {
    if (this.featureEnabled('workingTimeAccounting')) {
      Tine.widgets.MainScreen.registerContentType('HumanResources', {
        contentType: 'FreeTimePlanning',
        text: 'Free Time Planning',
        // _('Free Time Planning'),
        xtype: 'humanresources.freetimeplanning'
      });
    }
  },

  /**
   * Get translated application title of the HumanResources App
   *
   * @return {String}
   */
  getTitle: function getTitle() {
    return this.i18n.ngettext('Human Resources', 'Human Resources', 1);
  },
  registerCoreData: function registerCoreData() {
    Tine.log.info('Tine.HumanResources.Application - registering core data ... ');
    Tine.CoreData.Manager.registerGrid('hr_wts', Tine.HumanResources.WorkingTimeSchemeGridPanel);
  }
});
/**
 * register special renderer for contract workingtime_json
 */

Tine.widgets.grid.RendererManager.register('HumanResources', 'Contract', 'workingtime_json', function (v, m, r) {
  var _ = window.lodash; // NOTE: workingtime_json is not longer used

  v = _.get(r, 'data.working_time_scheme.json', 0);

  if (!v) {
    return 0;
  }

  var object = Ext.isString(v) ? Ext.decode(v) : v;
  var sum = 0;

  for (var i = 0; i < object.days.length; i++) {
    sum = sum + parseFloat(object.days[i]);
  }

  return sum / 3600;
});
Tine.widgets.grid.RendererManager.register('HumanResources', 'FreeTime', 'account_id', function (v) {
  if (!v) {
    return '';
  }

  return v.year;
}); // working time schema translations

Tine.widgets.grid.RendererManager.register('HumanResources', 'WorkingTimeScheme', 'type', function (v) {
  var i18n = Tine.Tinebase.appMgr.get('HumanResources').i18n;

  switch (String(v)) {
    case 'template':
      v = i18n._('Template');
      break;

    case 'individual':
      v = i18n._('Individual');
      break;

    case 'shared':
      v = i18n._('Shared');
      break;
  }

  return v;
});

/***/ }),

/***/ 1513:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiß <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2019 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources'); // NOTE: recordClass and some other config is injected by appStarter

Tine.HumanResources.DailyWTReportGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  initComponent: function initComponent() {
    Ext.applyIf(this, {
      filterConfig: {},
      defaultFilters: [{
        field: 'date',
        operator: 'within',
        value: 'monthThis'
        /*,
        {field: 'employee_id', operator: 'equals', value: null}*/

      }]
    }); // show ftb initially

    Ext.apply(this.filterConfig, {
      quickFilterConfig: {
        detailsToggleBtnConfig: {
          initialState: {
            detailsButtonPressed: true
          }
        }
      }
    });
    Tine.HumanResources.DailyWTReportGridPanel.superclass.initComponent.apply(this, arguments);
  },
  initActions: function initActions() {
    this.action_calculateAllReports = new Ext.Action({
      text: this.app.i18n._('Calculate all Reports'),
      handler: this.onCalculateAllReports,
      iconCls: 'action_create_reports',
      scope: this
    });
    this.actionToolbarItems = [Ext.apply(new Ext.Button(this.action_calculateAllReports), {
      scale: 'medium',
      rowspan: 2,
      iconAlign: 'top'
    })];
    Tine.HumanResources.DailyWTReportGridPanel.superclass.initActions.apply(this, arguments);
    this.action_addInNewWindow.setHidden(true);
    this.action_deleteRecord.setHidden(true);
  },
  onCalculateAllReports: function onCalculateAllReports(btn) {
    var me = this,
        apiName = 'calculateAll' + this.recordClass.getMeta('modelName') + 's'; // NOTE: loading animation not possible with medium btn

    btn.setDisabled(true);
    me.pagingToolbar.refresh.disable();
    Tine.HumanResources[apiName]().finally(function () {
      btn.setDisabled(false);
      me.loadGridData();
    });
  }
});

/***/ }),

/***/ 1514:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiß <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2019 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources'); // NOTE: recordClass and some other config is injected by appStarter

Tine.HumanResources.MonthlyWTReportGridPanel = Ext.extend(Tine.HumanResources.DailyWTReportGridPanel, {
  initComponent: function initComponent() {
    this.defaultFilters = [{
      field: 'month',
      operator: 'equals',
      value: new Date().format('Y-m')
      /*,
      {field: 'employee_id', operator: 'equals', value: null}*/

    }];
    Tine.HumanResources.MonthlyWTReportGridPanel.superclass.initComponent.apply(this, arguments);
  }
});

/***/ }),

/***/ 1515:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiß <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2019 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
Tine.HumanResources.MonthlyWTReportEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  initComponent: function initComponent() {
    Tine.HumanResources.MonthlyWTReportEditDialog.superclass.initComponent.apply(this, arguments); // auto recalc after a daily report got changed

    this.getForm().findField('dailywtreports').on('update', this.onApplyChanges.createDelegate(this, [false])); // ok btn was not pressed - so let's not autosave it!
    // this.getForm().findField('working_time_correction').on('change', this.onApplyChanges.createDelegate(this, [false]));
  },
  initButtons: function initButtons() {
    this.tbarItems = this.tbarItems || [];
    this.action_calculateEmployeeReports = new Ext.Action({
      text: this.app.i18n._('Recalculate'),
      handler: this.onApplyChanges.createDelegate(this, [false]),
      iconCls: 'x-tbar-loading',
      scope: this
    });
    this.actionUpdater.addAction(this.action_calculateEmployeeReports);
    this.tbarItems.push(this.action_calculateEmployeeReports);
    Tine.HumanResources.MonthlyWTReportEditDialog.superclass.initButtons.apply(this, arguments);
  }
});

/***/ }),

/***/ 1516:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiß <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2019 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
Tine.HumanResources.FreeTimePlanningPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  /**
   * @cfg {String} dateFormatString
   */
  dateFormatString: null,

  /**
   * @property {Ext.ux.form.PeriodPicker} periodPicker
   */
  periodPicker: null,

  /**
   * @property {Array} resolvedFreeTimePeriods
   */
  resolvedFreeTimePeriods: null,
  // private
  // border: false,
  // layout: 'border',
  recordClass: 'Tine.HumanResources.Model.Employee',
  autoRefreshInterval: null,
  listenMessageBus: false,
  displaySelectionHelper: false,
  initComponent: function initComponent() {
    let me = this;
    me.dateFormatString = me.dateFormatString || Locale.getTranslationData('Date', 'short');
    me.periodPicker = new Ext.ux.form.PeriodPicker({
      // availableRanges: 'week,month,quarter,year',
      availableRanges: 'month',
      listeners: {
        'change': _.bind(me.onPeriodChange, me)
      }
    });
    me.recordProxy = Tine.HumanResources.employeeBackend;
    me.defaultSortInfo = {
      field: 'account_id'
    };
    me.i18nRecordName = 'Free Time';
    Tine.HumanResources.FreeTimePlanningPanel.superclass.initComponent.call(me);
    me.grid.on('cellmousedown', _.bind(me.onCellMouseDown, me));
    me.grid.on('cellclick', _.bind(me.onCellClick, me));
    me.grid.on('celldblclick', _.bind(me.action_editInNewWindow.execute, me.action_editInNewWindow));
  },
  initGrid: function initGrid() {
    let me = this;
    let columns = me.getColumns(); // me.gridConfig.autoExpandColumn = 'account_id';

    me.gridConfig.forceFit = false;
    me.gridConfig.cm = new Ext.grid.ColumnModel({
      defaults: {
        width: 30,
        fixed: true,
        resizable: false,
        sortable: false,
        menuDisabled: true
      },
      columns: columns
    });
    me.selectionModel = new Ext.ux.grid.MultiCellSelectionModel({
      // getCount: function() {return 0},
      // getSelections: function() { return []},
      selectRow: function selectRow() {},
      listeners: {
        'beforecellselect': _.bind(me.onBeforeCellSelect, me),
        'selectionchange': _.bind(me.onSelectionChange, me)
      }
    });
    Tine.HumanResources.FreeTimePlanningPanel.superclass.initGrid.call(me);
  },
  getColumns: function getColumns() {
    let me = this;

    let colManager = _.bind(Tine.widgets.grid.ColumnManager.get, Tine.widgets.grid.ColumnManager, 'HumanResources', 'Employee', _, 'mainScreen', {
      fixed: false,
      resizable: true,
      sortable: true,
      menuDisabled: false
    });

    let columns = [colManager('number'), _.assign(colManager('account_id'), {
      width: 100
    }), _.assign(colManager('division_id'), {
      width: 100
    })];
    let period = me.periodPicker.getValue();
    let day = period.from;

    do {
      columns.push({
        id: day.format('Y-m-d'),
        day: day,
        header: day.format('D').substring(0, 2) + '<br>' + day.format('d'),
        renderer: _.bind(me.renderFreeDay, me, _, _, _, _, _, _, day),
        dataIndex: 'virtual'
      });
      day = day.add(Date.DAY, 1);
    } while (day < period.until);

    return columns;
  },
  renderFreeDay: function renderFreeDay(value, metaData, record, rowIndex, colIndex, store, day) {
    let me = this;

    let feastAndFreeDays = _.get(record, 'feastAndFreeDays.' + day.format('Y'));

    let bgColor = '#FFFFFF';
    let char = '';

    if (me.isExcludeDay(record, day)) {
      bgColor = 'lightgrey';
      char = 'X';
    } else {
      let freeTimes = me.getFreeTimes(record, day);

      if (freeTimes.length) {
        // support multiple freetimes per day?
        let freeTimeType = freeTimes[0].type;
        char = _.get(freeTimeType, 'abbreviation', freeTimeType[0]); // @TODO color
      }
    }

    return '<div class="hr-freetimeplanning-daycell" style="background-color: ' + bgColor + ';">' + char + '</div>';
  },
  afterRender: function afterRender() {
    let me = this;
    me.pagingToolbar.insert(me.pagingToolbar.items.length - 4, {
      xtype: 'tbseparator'
    });
    me.pagingToolbar.insert(me.pagingToolbar.items.length - 4, me.periodPicker);
    Tine.HumanResources.FreeTimePlanningPanel.superclass.afterRender.call(me);
  },
  onPeriodChange: function onPeriodChange(pp, period) {
    let me = this;
    let year = me.periodPicker.getValue().from.format('Y');

    if (_.indexOf(me.resolvedFreeTimePeriods, year) < 0) {
      me.resolveRecords(year);
    }

    me.gridConfig.cm.setConfig(me.getColumns());
  },
  onRowClick: function onRowClick() {// prevent default
  },

  /**
   * NOTE: onCellClick is executed after selection model has already selected the cell
   *       so we need to get the initial state from the mousedown event
   */
  onCellMouseDown: function onCellMouseDown(grid, rowIndex, columnIndex, e) {
    let me = this;
    e.isSelected = me.selectionModel.isSelected([rowIndex, columnIndex]);
  },
  onCellClick: function onCellClick(grid, rowIndex, columnIndex, e) {
    let me = this;
    let day = me.getColumns()[columnIndex].day;

    if (day) {
      let employee = me.getStore().getAt(rowIndex);
      let freeTimes = me.getFreeTimes(employee, day);

      if (freeTimes.length) {
        let freeDates = _.map(_.concat.apply([], _.map(freeTimes, 'freedays')), 'date');

        _.each(me.getColumns(), (col, idx) => {
          if (col.day && _.indexOf(freeDates, col.day.format('Y-m-d 00:00:00')) >= 0) {
            if (e.isSelected && e.ctrlKey) {
              me.selectionModel.deselectCell([rowIndex, idx]);
            } else {
              me.selectionModel.selectCell([rowIndex, idx], true);
            }
          }
        });
      }
    }
  },
  onCellDblClick: function onCellDblClick() {
    // if (! this.action_editInNewWindow.isDisabled())
    this.action_editInNewWindow.execute();
  },
  onBeforeCellSelect: function onBeforeCellSelect(sm, cellInfo, keepExisting) {
    let me = this;
    let col = me.getColumns()[cellInfo[1]];
    let employee = me.getStore().getAt(cellInfo[0]);
    let isDay = _.get(col, 'dataIndex') === 'virtual';
    let isSameRow = _.get(me.selectionModel.getSelections(), 0, cellInfo)[0] === cellInfo[0];
    let isExludeDay = me.isExcludeDay(employee, col.day);
    return isDay && !isExludeDay && (keepExisting ? isSameRow : true);
  },
  onSelectionChange: function onSelectionChange(sm, selections) {
    let me = this;
    let selectedFreeTimes = me.getSelectedFreeTimes();
    me.action_deleteRecord.setDisabled(selectedFreeTimes.length < 1);
    me.action_editInNewWindow.setDisabled(selectedFreeTimes.length !== 1);
  },
  getSelectedEmployee: function getSelectedEmployee() {
    let me = this;
    return me.getStore().getAt(_.get(_.map(me.selectionModel.getSelections(), 0), 0));
  },
  getSelectedDays: function getSelectedDays() {
    let me = this;
    return _.map(_.map(_.map(me.selectionModel.getSelections(), 1), _.bind(_.get, me, me.getColumns())), 'day');
  },
  getSelectedFreeTimes: function getSelectedFreeTimes() {
    let me = this;
    let employee = me.getSelectedEmployee();
    let selectedDays = me.getSelectedDays();
    return me.getFreeTimes(employee, selectedDays);
  },

  /**
   * called before store queries for data
   */
  onStoreBeforeload: function onStoreBeforeload(store, options) {
    let me = this;
    me.resolvedFreeTimePeriods = [];
    me.showLoadMask(); // filter = [{field: 'shadow_path', operator: 'contains', value: '{SITE}'}]

    Tine.HumanResources.FreeTimePlanningPanel.superclass.onStoreBeforeload.apply(me, arguments);
  },

  /**
   * called after a new set of Records has been loaded
   *
   * @param  {Ext.data.Store} this.store
   * @param  {Array}          loaded records
   * @param  {Array}          load options
   * @return {Void}
   */
  onStoreLoad: function onStoreLoad(store, records, options) {
    let me = this;
    Tine.HumanResources.FreeTimePlanningPanel.superclass.onStoreLoad.apply(me, arguments);
    me.resolveRecords(me.periodPicker.getValue().from.format('Y'));
  },
  resolveRecords: function resolveRecords(year) {
    let me = this;
    let promises = [];
    return me.showLoadMask().then(() => {
      me.pagingToolbar.refresh.disable();
    }).then(() => {
      let employeeIds = _.map(me.store.data.items, 'data.id');

      const reflect = p => p.then(v => ({
        v,
        status: "resolved"
      }), e => ({
        e,
        status: "rejected"
      })); // NOTE: we reflect the calls as some of them might fail (e.g. employee has no contract)


      _.each(employeeIds, employeeId => {
        promises.push(reflect(Tine.HumanResources.getFeastAndFreeDays(employeeId, year, null, null)));
      });

      return Promise.all(promises);
    }).then(feastAndFreeDays => {
      feastAndFreeDays = _.map(_.filter(feastAndFreeDays, {
        status: 'resolved'
      }), 'v.results');

      _.each(feastAndFreeDays, feastAndFreeDaysFor => {
        // sort freedays into freetime
        let allFreeDays = _.get(feastAndFreeDaysFor, 'allFreeDays', []);

        let freeTimeTypes = _.get(feastAndFreeDaysFor, 'freeTimeTypes', []);

        _.each(_.get(feastAndFreeDaysFor, 'allFreeTimes', []), freeTime => {
          _.set(freeTime, 'freedays', _.filter(allFreeDays, {
            freetime_id: freeTime.id
          }), []);

          _.set(freeTime, 'type', _.find(freeTimeTypes, {
            id: freeTime.type
          }));
        }); // reference feastAndFreeDays in corresponding employee record


        let employee = _.find(me.store.data.items, {
          id: _.get(feastAndFreeDaysFor, 'employee.id')
        });

        _.set(employee, 'feastAndFreeDays.' + year, feastAndFreeDaysFor);
      });

      me.resolvedFreeTimePeriods.push(year);
    }).then(function () {
      me.grid.getView().refresh();
    }).finally(() => {
      me.hideLoadMask();
      me.pagingToolbar.refresh.enable();
    });
  },
  showLoadMask: function showLoadMask() {
    if (!this.loadMask) {
      this.loadMask = new Ext.LoadMask(this.getEl(), {
        msg: this.app.i18n._("Loading free time planning data...")
      });
    }

    this.loadMask.show.defer(100, this.loadMask);
    return Promise.resolve();
  },
  hideLoadMask: function hideLoadMask() {
    this.loadMask.hide.defer(100, this.loadMask);
    return Promise.resolve();
  },
  initActions: function initActions() {
    let me = this;
    me.action_addInNewWindow = new Ext.Action({
      text: me.app.i18n._('Add Free Time'),
      handler: _.bind(me.onEditInNewWindow, me, 'add'),
      iconCls: 'action_add'
    });
    me.action_editInNewWindow = new Ext.Action({
      text: me.app.i18n._('Edit Free Time'),
      disabled: true,
      handler: _.bind(me.onEditInNewWindow, me, 'edit'),
      iconCls: 'action_edit'
    });
    me.action_deleteRecord = new Ext.Action({
      text: me.app.i18n._('Delete Free Time'),
      handler: _.bind(me.onDeleteRecords, me),
      disabled: true,
      iconCls: 'action_delete'
    });
  },
  onEditInNewWindow: function onEditInNewWindow(actionType) {
    let me = this;
    let selectedEmployee = me.getSelectedEmployee();

    let selectedFreeTime = _.get(me.getSelectedFreeTimes(), 0);

    let record = null;
    let fixedFields = null;

    if (actionType === 'edit') {
      if (selectedFreeTime) {
        record = selectedFreeTime;
        fixedFields = {
          'employee_id': selectedEmployee.data,
          'type': selectedFreeTime.type
        };
      }
    } else if (actionType === 'add') {
      record = {
        'employee_id': _.get(selectedEmployee, 'data'),
        'freedays': selectedFreeTime ? [] : _.map(me.getSelectedDays(), day => {
          return {
            date: day.format('Y-m-d 00:00:00')
          };
        })
      };
    }

    if (record) {
      Tine.HumanResources.FreeTimeEditDialog.openWindow({
        record: JSON.stringify(record),
        fixedFields: JSON.stringify(fixedFields)
      });
    }
  },

  /**
   *
   * @param {custom} employee
   * @param {Date} day
   */
  isExcludeDay(employee, day) {
    let feastAndFreeDays = _.get(employee, 'feastAndFreeDays.' + day.format('Y'));

    let isExcludeDay = false;

    if (feastAndFreeDays) {
      if (_.find(_.get(feastAndFreeDays, 'excludeDates', []), {
        date: day.format('Y-m-d 00:00:00.000000')
      })) {
        isExcludeDay = true;
      }
    }

    return isExcludeDay;
  },

  /**
   *
   * @param {custom} employee
   * @param {Date|Date[]}day
   */
  getFreeTimes(employee, day) {
    return _.uniq(_.reduce(_.isArray(day) ? day : [day], (freeTimes, day) => {
      let feastAndFreeDays = _.get(employee, 'feastAndFreeDays.' + day.format('Y'), []);

      let freeDayIds = _.map(_.filter(_.get(feastAndFreeDays, 'allFreeDays', []), {
        date: day.format('Y-m-d 00:00:00')
      }), 'freetime_id');

      return freeTimes.concat(_.filter(_.get(feastAndFreeDays, 'allFreeTimes', []), freeTime => {
        return _.indexOf(freeDayIds, freeTime.id) >= 0;
      }));
    }, []));
  }

});
Ext.reg('humanresources.freetimeplanning', Tine.HumanResources.FreeTimePlanningPanel);
Tine.HumanResources.FreeTimePlanningWestPanel = Ext.extend(Tine.widgets.mainscreen.WestPanel, {
  recordClass: 'Tine.HumanResources.Model.Employee',
  hasContainerTreePanel: false,
  hasFavoritesPanel: true
});

/***/ }),

/***/ 1517:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2013 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.ContractEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>Contract Compose Dialog</p>
 * <p></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.HumanResources.ContractEditDialog
 */

Tine.HumanResources.ContractEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  appName: 'HumanResources',
  evalGrants: false,
  windowHeight: 550,

  /**
   * just update the contract grid panel, no persisten
   * 
   * @type String
   */
  mode: 'local',

  /**
   * The record is editable if the valid interval is in the future or not older than 2 hours
   * This property is set accordingly
   * 
   * @type 
   */
  allowEdit: null,
  displayNotes: true,

  /**
   * overwrite update toolbars function (we don't have record grants yet)
   * @private
   */
  updateToolbars: function updateToolbars() {},

  /**
   * inits the component
   */
  initComponent: function initComponent() {
    Tine.HumanResources.ContractEditDialog.superclass.initComponent.call(this);
  },

  /**
   * executed after record got updated from proxy, if json Data is given, it's used
   * 
   * @private
   */
  onRecordLoad: function onRecordLoad() {
    // interrupt process flow until dialog is rendered
    if (!this.rendered) {
      this.onRecordLoad.defer(250, this);
      return;
    }

    Tine.HumanResources.ContractEditDialog.superclass.onRecordLoad.call(this);

    if (!this.record.id) {
      this.getForm().findField('feast_calendar_id').setValue(Tine.HumanResources.registry.get('defaultFeastCalendar'));
    } else {
      this.window.setTitle(String.format(i18n._('Edit {0}'), this.i18nRecordName));
    }

    this.applyWorkingTimeSchema(this.record.get('working_time_scheme')); // disable fields if there are already some vacations booked
    // but allow setting end_date

    if (this.record.get('creation_time')) {
      if (!this.record.get('is_editable')) {
        this.getForm().items.each(function (formField) {
          if (formField.name != 'end_date') {
            formField.setDisabled(true);
          }
        }, this);
        this.blConfigPanel.setReadOnly(true);
      }
    }
  },
  applyWorkingTimeSchema: function applyWorkingTimeSchema(workingtimeSchema) {
    if (!workingtimeSchema) {
      return;
    }

    var _ = window.lodash,
        type = _.get(workingtimeSchema, 'data.type', _.get(workingtimeSchema, 'type'));

    this.applyJsonData(_.get(workingtimeSchema, 'data.json', _.get(workingtimeSchema, 'json')));
    this.blConfigPanel.onRecordLoad(this, this.record);
    var readOnly = type == 'shared';
    this.blConfigPanel.setReadOnly(readOnly);
    this.getForm().items.each(function (formField) {
      if (formField.name.match(/^weekdays/)) {
        formField.setDisabled(readOnly);
      }
    }, this);
  },

  /**
   * applies the json data to the form
   * 
   * @param {Object} jsonData
   */
  applyJsonData: function applyJsonData(jsonData) {
    jsonData = Ext.isString(jsonData) ? Ext.decode(jsonData) : jsonData;
    var days = jsonData.days,
        form = this.getForm(),
        sum = 0.0;

    for (var index = 0; index < 7; index++) {
      form.findField('weekdays_' + index).setValue(days[index]);
      sum = sum + parseFloat(days[index]);
    }

    form.findField('working_hours').setValue(sum);
  },
  updateWorkingHours: function updateWorkingHours(formField, newValue, oldValue) {
    var sum = 0;

    for (var index = 0; index < 7; index++) {
      sum += parseFloat(this.getForm().findField('weekdays_' + index).getValue());
    }

    this.getForm().findField('working_hours').setValue(sum);
  },

  /**
   * returns appropriate json for the template or the contract
   * 
   * @return {String}
   */
  getJsonData: function getJsonData() {
    var values = this.getForm().getFieldValues(),
        days = [];

    for (var index = 0; index < 7; index++) {
      days[index] = parseFloat(values['weekdays_' + index]);
    }

    return {
      days: days
    };
  },

  /**
   * closes open subpanels on cancel
   */
  onCancel: function onCancel() {
    Tine.HumanResources.ContractEditDialog.superclass.onCancel.call(this);
  },

  /**
   * executed when record gets updated from form
   * @private
   */
  onRecordUpdate: function onRecordUpdate() {
    var _ = window.lodash,
        working_time_scheme = this.record.get('working_time_scheme'); // NOTE: this reduces working_time_scheme to id...

    Tine.HumanResources.ContractEditDialog.superclass.onRecordUpdate.call(this);
    this.record.set('feast_calendar_id', this.getForm().findField('feast_calendar_id').selectedContainer);
    this.record.set('working_time_scheme', working_time_scheme);
    this.blConfigPanel.onRecordUpdate(this, this.record);

    _.set(this.record, 'data.working_time_scheme.json', this.getJsonData());
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   * 
   * @return {Object}
   * @private
   */
  getFormItems: function getFormItems() {
    // blpipes is of type records with subrecord hr.blconfig
    this.blConfigPanel = new Tine.Tinebase.BL.BLConfigPanel({
      app: this.app,
      editDialog: this,
      owningRecordClass: Tine.HumanResources.Model.WorkingTimeScheme,
      dataPath: 'data.working_time_scheme.blpipe',
      title: this.app.i18n._('Working Time Rules')
    });
    var weekdayFieldDefaults = {
      xtype: 'durationspinner',
      baseUnit: 'seconds',
      anchor: '100%',
      labelSeparator: '',
      allowBlank: true,
      columnWidth: 1 / 7,
      listeners: {
        scope: this,
        blur: this.updateWorkingHours.createDelegate(this),
        spin: this.updateWorkingHours.createDelegate(this)
      }
    };
    return {
      xtype: 'tabpanel',
      plain: true,
      plugins: [{
        ptype: 'ux.tabpanelkeyplugin'
      }],
      defaults: {
        hideMode: 'offsets'
      },
      activeTab: 0,
      items: [{
        title: this.app.i18n._('Contract'),
        autoScroll: true,
        border: false,
        frame: true,
        layout: 'border',
        items: [{
          region: 'north',
          layout: 'hfit',
          height: 220,
          border: false,
          items: [{
            xtype: 'fieldset',
            layout: 'hfit',
            autoHeight: true,
            title: this.app.i18n._('Contract'),
            items: [{
              xtype: 'columnform',
              labelAlign: 'top',
              defaults: {
                columnWidth: 1 / 2
              },
              items: [[{
                xtype: 'datefield',
                name: 'start_date',
                fieldLabel: this.app.i18n._('Start Date'),
                allowBlank: false,
                columnWidth: 1 / 2
              }, {
                xtype: 'extuxclearabledatefield',
                name: 'end_date',
                fieldLabel: this.app.i18n._('End Date'),
                columnWidth: 1 / 2
              }], [{
                xtype: 'tinewidgetscontainerselectcombo',
                name: 'feast_calendar_id',
                containerName: this.app.i18n._('Calendar'),
                containersName: this.app.i18n._('Calendars'),
                recordClass: Tine.Calendar.Model.Event,
                requiredGrant: 'readGrant',
                hideTrigger2: true,
                allowBlank: false,
                blurOnSelect: true,
                columnWidth: 1 / 2,
                fieldLabel: this.app.i18n._('Feast Calendar')
              }, {
                name: 'vacation_days',
                fieldLabel: this.app.i18n._('Vacation days of one calendar year'),
                allowBlank: false,
                columnWidth: 1 / 2
              }]]
            }]
          }, {
            xtype: 'fieldset',
            layout: 'hfit',
            autoHeight: true,
            title: this.app.i18n._('Working Time'),
            items: [{
              xtype: 'columnform',
              labelAlign: 'top',
              items: [[Tine.widgets.form.RecordPickerManager.get('HumanResources', 'WorkingTimeScheme', {
                value: this.record,
                fieldLabel: this.app.i18n._('Working Time Schema'),
                selectedRecord: this.record,
                ref: '../../../../../../../templateChooser',
                columnWidth: 2 / 3,
                name: 'working_time_scheme',
                listeners: {
                  scope: this,
                  select: this.onWorkingtimeSchemaSelect.createDelegate(this)
                }
              }), {
                fieldLabel: this.app.i18n._('Working Hours per week'),
                xtype: 'durationspinner',
                baseUnit: 'seconds',
                disabled: true,
                name: 'working_hours',
                columnWidth: 1 / 3
              }], [Ext.apply({
                fieldLabel: this.app.i18n._('Mon.'),
                name: 'weekdays_0'
              }, weekdayFieldDefaults), Ext.apply({
                fieldLabel: this.app.i18n._('Tue.'),
                name: 'weekdays_1'
              }, weekdayFieldDefaults), Ext.apply({
                fieldLabel: this.app.i18n._('Wed.'),
                name: 'weekdays_2'
              }, weekdayFieldDefaults), Ext.apply({
                fieldLabel: this.app.i18n._('Thu.'),
                name: 'weekdays_3'
              }, weekdayFieldDefaults), Ext.apply({
                fieldLabel: this.app.i18n._('Fri.'),
                name: 'weekdays_4'
              }, weekdayFieldDefaults), Ext.apply({
                fieldLabel: this.app.i18n._('Sat.'),
                name: 'weekdays_5'
              }, weekdayFieldDefaults), Ext.apply({
                fieldLabel: this.app.i18n._('Sun.'),
                name: 'weekdays_6'
              }, weekdayFieldDefaults)]]
            }]
          }]
        }, {
          region: 'center',
          layout: 'fit',
          flex: 1,
          border: false,
          items: [this.blConfigPanel]
        }]
      }]
    };
  },
  onWorkingtimeSchemaSelect: function onWorkingtimeSchemaSelect(combo, record, index) {
    this.record.set('working_time_scheme', record.data);
    this.applyWorkingTimeSchema(record);
  }
});

/***/ }),

/***/ 1518:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2012-2013 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.EmployeeEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>Employee Compose Dialog</p>
 * <p></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.HumanResources.EmployeeEditDialog
 */

Tine.HumanResources.EmployeeEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  evalGrants: false,
  windowWidth: 800,
  windowHeight: 670,

  /**
   * show private Information (autoset due to rights)
   * 
   * @type {Boolean}
   */
  showPrivateInformation: null,

  /**
   * inits the component
   */
  initComponent: function initComponent() {
    this.showPrivateInformation = Tine.Tinebase.common.hasRight('edit_private', 'HumanResources') ? true : false;
    this.useSales = Tine.Tinebase.appMgr.get('Sales') ? true : false;
    Tine.HumanResources.EmployeeEditDialog.superclass.initComponent.call(this);
    this.on('updateDependent', function () {
      this.disableFreetimes();
    }, this);
  },

  /**
   * updates the display name on change of n_given or n_fanily
   */
  updateDisplayName: function updateDisplayName() {
    var nfn = this.getForm().findField('n_given').getValue() + (this.getForm().findField('n_family').getValue() ? ' ' + this.getForm().findField('n_family').getValue() : '');
    this.getForm().findField('n_fn').setValue(nfn);
  },

  /**
   * checks if the freetime grids should be disabled
   * 
   * @return {Boolean}
   */
  checkDisableFreetimes: function checkDisableFreetimes() {
    // if user is not allowed to see private information, disable the grids
    if (!this.showPrivateInformation) {
      return true;
    }

    if (!this.record) {
      return true;
    }

    var c = this.record.get('contracts');

    if (Ext.isArray(c) && c.length > 0) {
      // any of the contracts has an id
      for (var index = 0; index < c.length; index++) {
        if (c[index].id) return false;
      }
    }

    return true;
  },

  /**
   * disable freetime gridpanels if neccessary
   */
  disableFreetimes: function disableFreetimes() {
    if (this.checkDisableFreetimes()) {
      this.vacationGridPanel.disable();
      this.sicknessGridPanel.disable();
    } else {
      this.vacationGridPanel.enable();
      this.sicknessGridPanel.enable();
    }
  },
  onAfterRecordLoad: function onAfterRecordLoad() {
    Tine.HumanResources.EmployeeEditDialog.superclass.onAfterRecordLoad.call(this);
    this.disableFreetimes();

    if (this.record.get('id') && this.record.get('account_id') && !Ext.isObject(this.record.get('account_id'))) {
      var f = this.getForm().findField('account_id');
      f.disable();
      f.setRawValue(this.app.i18n._('Account is disabled or deleted!'));
    }
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   * 
   * @return {Object}
   * @private
   */
  getFormItems: function getFormItems() {
    var formFieldDefaults = {
      xtype: 'textfield',
      anchor: '100%',
      labelSeparator: '',
      columnWidth: .333
    };
    var firstRow = [Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'supervisor_id', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG, {
      allowLinkingItself: false
    })];

    if (this.useSales) {
      firstRow.push(Tine.widgets.form.RecordPickerManager.get('Sales', 'Division', {
        name: 'division_id',
        fieldLabel: this.app.i18n._('Division'),
        allowBlank: true
      }));
    }

    firstRow.push({
      name: 'health_insurance',
      fieldLabel: this.app.i18n._('Health Insurance'),
      allowBlank: true,
      maxLength: 128
    });
    this.contractGridPanel = new Tine.HumanResources.ContractGridPanel({
      app: this.app,
      editDialog: this,
      disabled: !this.showPrivateInformation,
      frame: false,
      border: true,
      autoScroll: true,
      layout: 'border',
      hideColumns: ['employee_id']
    });
    this.vacationGridPanel = new Tine.HumanResources.FreeTimeGridPanel({
      app: this.app,
      editDialog: this,
      disabled: this.checkDisableFreetimes(),
      frame: false,
      border: true,
      autoScroll: true,
      layout: 'border',
      freetimeType: 'VACATION',
      editDialogRecordProperty: 'vacation',
      hideColumns: ['employee_id']
    });
    this.sicknessGridPanel = new Tine.HumanResources.FreeTimeGridPanel({
      app: this.app,
      editDialog: this,
      disabled: this.checkDisableFreetimes(),
      frame: false,
      border: true,
      autoScroll: true,
      layout: 'border',
      freetimeType: 'SICKNESS',
      editDialogRecordProperty: 'sickness',
      hideColumns: ['employee_id']
    });
    var tabs = [{
      title: this.app.i18n._('Employee'),
      autoScroll: true,
      border: false,
      frame: true,
      layout: 'border',
      items: [{
        region: 'center',
        layout: 'hfit',
        border: false,
        items: [{
          xtype: 'fieldset',
          layout: 'hfit',
          autoHeight: true,
          title: this.app.i18n._('Employee'),
          items: [{
            xtype: 'columnform',
            labelAlign: 'top',
            formDefaults: formFieldDefaults,
            items: [[Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'number', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG, {
              columnWidth: .125,
              maxValue: 999999999
            }), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'account_id', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG, {
              columnWidth: .380,
              ref: '../../../../../../../contactPicker',
              userOnly: true,
              useAccountRecord: true,
              blurOnSelect: true,
              listeners: {
                scope: this,
                blur: function blur() {
                  if (this.contactPicker.selectedRecord) {
                    this.contactButton.enable();
                  } else {
                    this.contactButton.disable();
                  }
                }
              }
            }), {
              columnWidth: .045,
              xtype: 'button',
              ref: '../../../../../../../contactButton',
              iconCls: 'applyContactData',
              tooltip: Ext.util.Format.htmlEncode(this.app.i18n._('Apply contact data on form')),
              disabled: this.record && Ext.isObject(this.record.get('account_id')) ? false : true,
              fieldLabel: '&nbsp;',
              lazyLoading: false,
              listeners: {
                scope: this,
                click: function click() {
                  var sr = this.contactPicker.selectedRecord || new Tine.Addressbook.Model.Contact(this.record.data.account_id.contact_id);

                  if (sr) {
                    Ext.each(['n_fn', 'title', 'salutation', 'n_given', 'n_family'], function (f) {
                      this.form.findField(f).setValue(sr.get(f));
                    }, this);

                    if (this.showPrivateInformation) {
                      this.form.findField('bank_account_holder').setValue(sr.get('n_fn'));
                      Ext.each(['countryname', 'locality', 'postalcode', 'region', 'street', 'street2'], function (f) {
                        this.form.findField(f).setValue(sr.get('adr_two_' + f));
                      }, this);
                      Ext.each(['email', 'tel_home', 'tel_cell', 'bday'], function (f) {
                        this.form.findField(f).setValue(sr.get(f));
                      }, this);
                    }
                  }
                }
              }
            }, Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'n_fn', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG, {
              columnWidth: .450,
              disabled: true
            })], [new Tine.Tinebase.widgets.keyfield.ComboBox({
              fieldLabel: this.app.i18n._('Salutation'),
              name: 'salutation',
              app: 'Addressbook',
              keyFieldName: 'contactSalutation',
              value: '',
              columnWidth: .25
            }), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'title', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG, {
              columnWidth: .25
            }), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'n_given', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG, {
              columnWidth: .25,
              listeners: {
                scope: this,
                change: this.updateDisplayName
              }
            }), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'n_family', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG, {
              columnWidth: .25,
              listeners: {
                scope: this,
                change: this.updateDisplayName
              }
            })], [Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'dfcom_id', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG, {
              columnWidth: 1
            })]]
          }]
        }, {
          xtype: 'fieldset',
          layout: 'hfit',
          autoHeight: true,
          title: this.app.i18n._('Personal Information'),
          disabled: !this.showPrivateInformation,
          items: [{
            xtype: 'columnform',
            labelAlign: 'top',
            formDefaults: Ext.apply(Ext.decode(Ext.encode(formFieldDefaults)), {
              disabled: !this.showPrivateInformation,
              readOnly: !this.showPrivateInformation
            }),
            items: [[{
              xtype: 'widget-countrycombo',
              name: 'countryname',
              fieldLabel: this.app.i18n._('Country')
            }, Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'locality', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'postalcode', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG)], [Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'region', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'street', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'street2', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG)], [Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'email', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'tel_home', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'tel_cell', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG)], [{
              xtype: 'extuxclearabledatefield',
              name: 'bday',
              fieldLabel: this.app.i18n._('Birthday')
            }]]
          }]
        }, {
          xtype: 'fieldset',
          layout: 'hfit',
          autoHeight: true,
          title: this.app.i18n._('Internal Information'),
          items: [{
            xtype: 'columnform',
            labelAlign: 'top',
            formDefaults: Ext.apply(Ext.decode(Ext.encode(formFieldDefaults)), {}),
            items: [firstRow, [Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'employment_begin', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG, {
              columnWidth: .5
            }), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'employment_end', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG, {
              columnWidth: .5
            }), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'profession', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG, {
              columnWidth: .5
            }), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'position', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG, {
              columnWidth: .5
            })]]
          }]
        }, {
          xtype: 'fieldset',
          layout: 'hfit',
          autoHeight: true,
          title: this.app.i18n._('Banking Information'),
          disabled: !this.showPrivateInformation,
          items: [{
            xtype: 'columnform',
            labelAlign: 'top',
            formDefaults: Ext.apply(Ext.decode(Ext.encode(formFieldDefaults)), {
              disabled: !this.showPrivateInformation,
              readOnly: !this.showPrivateInformation
            }),
            items: [[Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'bank_account_holder', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'bank_account_number', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'bank_name', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG)], [Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'bank_code_number', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'iban', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG), Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'bic', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG)]]
          }]
        }]
      }, {
        // activities and tags
        layout: 'ux.multiaccordion',
        animate: true,
        region: 'east',
        width: 210,
        split: true,
        collapsible: true,
        collapseMode: 'mini',
        header: false,
        margins: '0 5 0 5',
        border: true,
        items: [new Ext.Panel({
          title: this.app.i18n._('Description'),
          iconCls: 'descriptionIcon',
          layout: 'form',
          labelAlign: 'top',
          border: false,
          items: [{
            style: 'margin-top: -4px; border 0px;',
            labelSeparator: '',
            xtype: 'textarea',
            name: 'description',
            hideLabel: true,
            grow: false,
            preventScrollbars: false,
            anchor: '100% 100%',
            emptyText: this.app.i18n._('Enter description'),
            requiredGrant: 'editGrant'
          }]
        }), new Tine.widgets.tags.TagPanel({
          app: 'HumanResources',
          border: false,
          bodyStyle: 'border:1px solid #B5B8C8;'
        })]
      }]
    }];

    if (this.useSales) {
      this.costCenterGridPanel = new Tine.HumanResources.CostCenterGridPanel({
        app: this.app,
        editDialog: this,
        disabled: !this.showPrivateInformation
      });
      tabs.push(this.costCenterGridPanel);
    }

    tabs = tabs.concat([this.contractGridPanel, this.vacationGridPanel, this.sicknessGridPanel, new Tine.widgets.activities.ActivitiesTabPanel({
      app: this.appName,
      record_id: this.record.id,
      record_model: 'HumanResources_Model_Employee'
    })]);
    return {
      xtype: 'tabpanel',
      defaults: {
        hideMode: 'offsets'
      },
      border: false,
      plain: true,
      activeTab: 0,
      items: tabs
    };
  }
});

/***/ }),

/***/ 1519:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2012-2016 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.FreeTimeEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>DatePicker with multiple days</p>
 * <p></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * Create a new Tine.HumanResources.DatePicker
 */

Tine.HumanResources.DatePicker = Ext.extend(Ext.DatePicker, {
  recordClass: null,
  app: null,

  /**
   * the employee to use for this freetime
   * 
   * @type {Tine.HumanResources.Model.Employee}
   */
  employee: null,

  /**
   * dates higlighted as vacation day
   * 
   * @type {Array}
   */
  vacationDates: null,

  /**
   * dates higlighted as feast day
   * 
   * @type {Array}
   */
  feastDates: null,

  /**
   * dates higlighted as sickness day
   * 
   * @type {Array}
   */
  sicknessDates: null,

  /**
   * holds the freetime type (SICKNESS or VACATION)
   * 
   * @type {String}
   */
  freetimeType: null,

  /**
   * the editdialog this is nested in
   * 
   * @type {Tine.HumanResources.FreeTimeEditDialog}
   */
  editDialog: null,

  /**
   * if vacation is handled, the account picker of the edit dialog is active
   * 
   * @type {Boolean}
   */
  accountPickerActive: null,
  dateProperty: 'date',
  recordsProperty: 'freedays',
  foreignIdProperty: 'freetime_id',
  useWeekPickerPlugin: false,

  /**
   * holds the previous year selected (to switch back on no account found exception
   * 
   * @type {Number}
   */
  previousYear: null,

  /**
   * holds the current year selected
   * 
   * @type {Number}
   */
  currentYear: null,

  /**
   * used to enable/disable checks in update()
   */
  initializing: true,

  /**
   * initializes the component
   */
  initComponent: function initComponent() {
    if (this.useWeekPickerPlugin) {
      this.plugins = this.plugins ? this.plugins : [];
      this.plugins.push(new Ext.ux.DatePickerWeekPlugin({
        weekHeaderString: Tine.Tinebase.appMgr.get('Calendar').i18n._('WK')
      }));
    }

    this.vacationDates = [];
    this.sicknessDates = [];
    this.feastDates = [];
    this.initStore();
    Tine.HumanResources.DatePicker.superclass.initComponent.call(this);
  },

  /**
   * initializes the store
   */
  initStore: function initStore() {
    Tine.log.debug('Initializing the store...');
    var picker = this;
    this.store = new Tine.Tinebase.data.RecordStore({
      remoteSort: false,
      recordClass: this.recordClass,
      autoSave: false,
      getByDate: function getByDate(timestamp) {
        var date = !Ext.isDate(timestamp) ? new Date(timestamp) : timestamp,
            index = this.findBy(function (record) {
          if (record.get(picker.dateProperty).toString() == date.toString()) {
            return true;
          }
        });
        return this.getAt(index);
      },
      getFirstDay: function getFirstDay() {
        this.sort('date', 'ASC');
        return this.getAt(0);
      },
      getLastDay: function getLastDay() {
        this.sort('date', 'ASC');
        return this.getAt(this.getCount() - 1);
      }
    }, this);
  },

  /**
   * loads the feast days of the configured feast calendar from the server
   * 
   * @param {Boolean} fromYearChange
   * @param {Boolean} onInit
   * @param {Date} date
   * @param {Number} year
   */
  loadFeastDays: function loadFeastDays(fromYearChange, onInit, date, year) {
    Tine.log.debug('Loading feast and freedays, using the year ' + year);
    this.disableYearChange = fromYearChange;
    var employeeId = this.editDialog.fixedFields.get('employee_id').id;
    var freeTimeId = this.editDialog.record.get('id') ? this.editDialog.record.get('id') : null;
    var accountId = this.editDialog.record.get('account_id') ? this.editDialog.record.get('account_id').id : null;
    this.loadMask = new Ext.LoadMask(this.getEl(), {
      msg: this.app.i18n._('Loading calendar data...')
    });
    this.loadMask.show();
    var that = this;
    Ext.Ajax.request({
      url: 'index.php',
      params: {
        method: 'HumanResources.getFeastAndFreeDays',
        _employeeId: employeeId,
        _year: year,
        _freeTimeId: freeTimeId,
        _accountId: accountId
      },
      success: function success(_result, _request) {
        that.onFeastDaysLoad(Ext.decode(_result.responseText), onInit, date, year);
      },
      failure: function failure(exception) {
        Tine.log.debug('Loading feast and freedays failed with the exception:', exception);
        Tine.Tinebase.ExceptionHandler.handleRequestException(exception, that.onFeastDaysLoadFailureCallback, that);
      },
      scope: that
    });
  },

  /**
   * loads the feast days from loadFeastDays
   * 
   * @param {Object} result
   * @param {Boolean} onInit
   * @param {Date} date
   * @param {Number} year
   */
  onFeastDaysLoad: function onFeastDaysLoad(result, onInit, date, year) {
    var _ = window.lodash;
    Tine.log.debug('Loaded feast and freedays for the year ' + year + ':');
    var rr = result.results;
    Tine.log.debug(rr);
    Tine.log.debug(result);
    this.initializing = onInit;
    this.disabledDates = []; //  days not to work on by contract

    var exdates = rr.excludeDates || [];
    var freetime = this.editDialog.record; // format dates to fit the datepicker format

    Ext.each(exdates, function (d) {
      Ext.each(d, function (date) {
        // TODO invent helper function for this date splitting stuff
        var split = date.date.split(' '),
            dateSplit = split[0].split('-');
        var disabledDate = new Date(dateSplit[0], dateSplit[1] - 1, dateSplit[2]);
        this.disabledDates.push(disabledDate);
      }, this);
    }, this);
    this.setVacationDates(this.editDialog.localVacationDays);
    this.setSicknessDates(this.editDialog.localSicknessDays);
    this.setFeastDates(rr.feastDays);
    this.setDisabledDates(this.disabledDates);
    this.updateCellClasses();
    var split = rr.firstDay.date.split(' '),
        dateSplit = split[0].split('-');
    var firstDay = new Date(dateSplit[0], dateSplit[1] - 1, dateSplit[2]);
    this.setMinDate(firstDay);
    var split = rr.lastDay.date.split(' '),
        dateSplit = split[0].split('-');
    var lastDay = new Date(dateSplit[0], dateSplit[1] - 1, dateSplit[2]); // allow too book last years leftover holidays

    lastDay.setFullYear(lastDay.getFullYear() + 1);
    this.setMaxDate(lastDay); // if ownFreeDays is empty, the record hasn't been saved already, so use the properties from the local record

    var iterate = rr.ownFreeDays && rr.ownFreeDays.length > 0 ? rr.ownFreeDays : freetime ? freetime.get('freedays') : null;

    if (Ext.isArray(iterate)) {
      Ext.each(iterate, function (fd) {
        // TODO check cases when fd.date has no split()
        if (Ext.isFunction(fd.date.split)) {
          var split = fd.date.split(' '),
              dateSplit = split[0].split('-');
          fd.date = new Date(dateSplit[0], dateSplit[1] - 1, dateSplit[2]);
          fd.date.clearTime();
          this.store.add(new this.recordClass(fd));
        }
      }, this);
    }

    if (this.accountPickerActive && onInit) {
      // set remaining vacation days in edit dialog
      // TODO this should be refactored and moved to edit dialog as this is an unexpected place here
      var substractDays = this.editDialog.getDaysToSubstract();
      this.editDialog.getForm().findField('remaining_vacation_days').setValue(rr.allVacation - substractDays);
    }

    this.updateCellClasses();
    this.loadMask.hide();

    if (onInit) {
      this.previousYear = this.currentYear;
      this.currentYear = parseInt(rr.firstDay.date.split('-')[0]);
    } // NOTE: firstday_date is not declared in model


    var focusDate = Date.parseDate(_.get(freetime, 'json.firstday_date'), Date.patterns.ISO8601Long);

    if (date) {
      focusDate = date;
    } else if (this.disableYearChange) {
      if (this.previousYear < this.currentYear) {
        focusDate = new Date(this.currentYear + '/01/01 12:00:00 AM');
      } else {
        focusDate = new Date(this.currentYear + '/12/31 12:00:00 AM');
      }
    } // disableYearChange here to make sure we don't load feast and free days again during update() or enable()
    // TODO this needs to be refactored!!


    this.disableYearChange = true; // focus

    if (focusDate) {
      Tine.log.debug('focusDate ' + focusDate + ' currentYear ' + this.currentYear);
      this.update(focusDate);
    }

    this.enable();
    this.disableYearChange = false;
  },

  /**
   * if loading feast and freedays fails
   */
  onFeastDaysLoadFailureCallback: function onFeastDaysLoadFailureCallback() {
    Tine.log.debug('Calling onFeastDaysLoadFailureCallback with current year ' + this.currentYear + ' and previous year ' + this.previousYear);
    var year = this.currentYear;
    this.currentYear = this.previousYear;
    this.previousYear = year;
    this.onYearChange();
  },

  /**
   * set vacation dates
   * 
   * @param {Object} localVacationDays
   * @param {Array} remoteVacationDays
   * @param {Object} locallyRemovedDays
   */
  setVacationDates: function setVacationDates(localVacationDays, remoteVacationDays, locallyRemovedDays) {
    this.vacationDates = this.getTimestampsFromDays(localVacationDays, remoteVacationDays, locallyRemovedDays);
  },

  /**
   * set sickness dates
   * 
   * @param {Object} localSicknessDays
   * @param {Array} remoteSicknessDays
   * @param {Object} locallyRemovedDays
   */
  setSicknessDates: function setSicknessDates(localSicknessDays, remoteSicknessDays, locallyRemovedDays) {
    this.sicknessDates = this.getTimestampsFromDays(localSicknessDays, remoteSicknessDays, locallyRemovedDays);
  },

  /**
   * set feast dates
   */
  setFeastDates: function setFeastDates(feastDays) {
    this.feastDates = this.getTimestampsFromDays([], feastDays);
  },

  /**
   * returns a timestamp from a day
   * 
   * @param {Object} localDays
   * @param {Array} remoteDays
   * @param {Object} locallyRemovedDays
   * 
   * @return {Array}
   */
  getTimestampsFromDays: function getTimestampsFromDays(localDays, remoteDays, locallyRemovedDays) {
    var dates = [];
    Ext.iterate(localDays, function (accountId, localdates) {
      for (var index = 0; index < localdates.length; index++) {
        var newdate = new Date(localdates[index].date.replace(/-/g, '/') + ' AM');
        newdate.setHours(0);
        dates.push(newdate.getTime());
      }
    }); // find out removed dates

    var remove = [];

    if (locallyRemovedDays) {
      Ext.iterate(locallyRemovedDays, function (accountId, removeDays) {
        for (var index = 0; index < removeDays.length; index++) {
          remove.push(removeDays[index].date.split(' ')[0]);
        }
      }, this);
    } // do not mark day as taken, if it is deleted already in the grid


    if (remoteDays) {
      for (var index = 0; index < remoteDays.length; index++) {
        var day = remoteDays[index].date.split(' ')[0];

        if (remove.indexOf(day) == -1) {
          var newdate = new Date(remoteDays[index].date.replace(/-/g, '/') + ' AM');
          dates.push(newdate.getTime());
        }
      }
    }

    return dates;
  },

  /**
   * is called on year change
   *
   * @param {Date} date
   */
  onYearChange: function onYearChange(date) {
    Tine.log.debug('Calling onYearChange with the date ' + date); // this is called on changing the year in the picker

    this.loadFeastDays(true, false, date, date.format('Y'));
  },

  /**
   * overwrites update function of superclass
   * 
   * @param {Date} date
   * @param {Boolean} forceRefresh
   */
  update: function update(date, forceRefresh) {
    Tine.HumanResources.DatePicker.superclass.update.call(this, date, forceRefresh);

    if (!this.disableYearChange && !this.initializing) {
      var year = parseInt(date.format('Y'));

      if (year !== this.currentYear) {
        if (this.getData().length > 0) {
          Ext.MessageBox.show({
            title: this.app.i18n._('Year can not be changed'),
            msg: this.app.i18n._('You have already selected some dates from another year. Please create a new record to add dates from another year!'),
            buttons: Ext.Msg.OK,
            icon: Ext.MessageBox.WARNING,
            // jump to the first day of the selected
            fn: function fn() {
              var firstDay = this.store.getFirstDay();
              this.update(firstDay.get('date'));
            },
            scope: this
          });
        } else {
          this.previousYear = this.currentYear;
          this.currentYear = parseInt(date.format('Y'));
          this.onYearChange(date);
        }
      }
    }

    this.updateCellClasses();
  },

  /**
   * removes or adds a date on date click
   * 
   * @param {Object} e
   * @param {Object} t
   */
  handleDateClick: function handleDateClick(e, t) {
    // don't handle date click, if this is disabled, or the clicked node doesn't have a timestamp assigned
    if (this.disabled || !t.dateValue) {
      return Tine.HumanResources.DatePicker.superclass.handleDateClick.call(this, e, t);
    } // don't handle click on disabled dates defined by contract or feast calendar


    if (Ext.fly(t.parentNode).hasClass('x-date-disabled')) {
      return Tine.HumanResources.DatePicker.superclass.handleDateClick.call(this, e, t);
    } // dont't handle click on already defined sickness days


    if (Ext.fly(t.parentNode).hasClass('hr-date-sickness')) {
      return Tine.HumanResources.DatePicker.superclass.handleDateClick.call(this, e, t);
    } // dont't handle click on feast days


    if (Ext.fly(t.parentNode).hasClass('hr-date-feast')) {
      return;
    } // dont't handle click on already defined vacation days from different vacation entries


    if (Ext.fly(t.parentNode).hasClass('hr-date-vacation') && !Ext.fly(t.parentNode).hasClass('x-date-selected')) {
      return;
    }

    var date = new Date(t.dateValue),
        existing = this.store.getByDate(date);
    date.clearTime();

    if (this.accountPickerActive) {
      var remaining = this.editDialog.getForm().findField('remaining_vacation_days').getValue();

      if (existing) {
        remaining++;
      } else {
        remaining--;
      }

      if (remaining < 0) {
        Ext.MessageBox.show({
          title: this.app.i18n._('No more vacation days'),
          msg: this.app.i18n._('The Employee has no more possible vacation days left for this year. Create a new vacation and use another personal account the vacation should be taken from.'),
          icon: Ext.MessageBox.WARNING,
          buttons: Ext.Msg.OK
        });
        return Tine.HumanResources.DatePicker.superclass.handleDateClick.call(this, e, t);
      }
    } else {
      var remaining = 0;
    }

    if (existing) {
      this.store.remove(existing);
      var index = this.vacationDates.indexOf(t.dateValue);

      if (index > -1) {
        this.vacationDates.splice(index, 1);
      }
    } else {
      this.store.addSorted(new this.recordClass({
        date: date,
        duration: 1
      }));
    }

    if (this.accountPickerActive) {
      if (this.store.getCount() > 0) {
        this.editDialog.accountPicker.disable();
      } else {
        this.editDialog.accountPicker.enable();
      }

      this.editDialog.getForm().findField('remaining_vacation_days').setValue(remaining);
    }

    Tine.HumanResources.DatePicker.superclass.handleDateClick.call(this, e, t);
  },

  /**
   * updates the cell classes
   */
  updateCellClasses: function updateCellClasses() {
    this.cells.each(function (c) {
      var timestamp = c.dom.firstChild.dateValue;

      if (this.store.getByDate(timestamp)) {
        c.addClass('x-date-selected');
      } else {
        c.removeClass('x-date-selected');

        if (c.hasClass('hr-date-vacation')) {
          c.removeClass('hr-date-vacation');
        }
      }

      if (this.vacationDates.indexOf(timestamp) > -1) {
        c.addClass('hr-date-vacation');
      }

      if (this.sicknessDates.indexOf(timestamp) > -1) {
        c.addClass('hr-date-sickness');
      }

      if (this.feastDates.indexOf(timestamp) > -1) {
        c.addClass('hr-date-feast');
      }
    }, this);
  },

  /**
   * returns data for the editDialog
   * 
   * @return {Array}
   */
  getData: function getData() {
    var ret = [];
    this.store.sort({
      field: 'date',
      direction: 'ASC'
    });
    this.store.query().each(function (record) {
      ret.push(record.data);
    }, this);
    return ret;
  }
});

/***/ }),

/***/ 1520:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2013 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * FreeDay grid panel
 * 
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.FreeDayGridPanel
 * @extends     Tine.widgets.grid.GridPanel
 * 
 * <p>FreeDay Grid Panel</p>
 * <p><pre>
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>    
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.HumanResources.FreeDayGridPanel
 */

Tine.HumanResources.FreeDayGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {});

/***/ }),

/***/ 1521:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2012-2013 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.FreeTimeEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>FreeTime Compose Dialog</p>
 * <p></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * Create a new Tine.HumanResources.FreeTimeEditDialog
 */

Tine.HumanResources.FreeTimeEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  mode: 'local',

  /**
   * show private Information (autoset due to rights)
   * 
   * @type {Boolean}
   */
  showPrivateInformation: null,

  /**
   * holds cached getFeastAndFreeDaysQueries
   * 
   * @type {Array}
   */
  calculatedFeastDays: null,

  /**
   * either SICKNESS or VACATION
   * 
   * @type {String}
   */
  freetimeType: null,

  /**
   * the datepicker holds a calendar to select the dates of vacation or sickness
   * 
   * @type {Tine.HumanResources.DatePicker}
   */
  datePicker: null,

  /**
   * the account picker holds the account the (vacation-)days are taken from
   * @type {Tine.Tinebase.widgets.form.RecordPickerComboBox}
   */
  accountPicker: null,

  /**
   * two years ago for the accountPicker search
   * 
   * @type {Number}
   */
  twoYearsAgo: null,

  /**
   * year on init time
   * 
   * @type {Number}
   */
  startYear: null,

  /**
   * holds the current account (by the startYear, if no account is given by the record)
   * 
   * @type {Tine.HumanResources.Model.Account}
   */
  currentAccount: null,

  /**
   * overwrite update toolbars function (we don't have record grants yet)
   * @private
   */
  updateToolbars: Ext.emptyFn,

  /**
   * holds vacation day records already inserted in the employee by account_id
   * 
   * @type {Object}
   */
  localVacationDays: null,

  /**
   * holds already removed sickness days which are not persisted
   * 
   * @type {Object}
   */
  removedSicknessDays: null,

  /**
   * holds already removed vacation days which are not persisted
   * 
   * @type {Object}
   */
  removedVacationDays: null,

  /**
   * holds sickness day records already inserted in the employee by account_id
   * 
   * @type {Object}
   */
  localSicknessDays: null,

  /**
   * inits the component
   */
  initComponent: function initComponent() {
    this.app = Tine.Tinebase.appMgr.get('HumanResources');
    this.showPrivateInformation = Tine.Tinebase.common.hasRight('edit_private', 'HumanResources') ? true : false;
    this.calculatedFeastDays = [];
    this.localVacationDays = {};
    this.localSicknessDays = {}; // calculate current year and two years ago for the accountPicker search

    var date = new Date();
    this.startYear = parseInt(date.format('Y'));
    this.twoYearsAgo = this.startYear - 2;
    Tine.HumanResources.FreeTimeEditDialog.superclass.initComponent.call(this);
  },

  /**
   * executed after record got updated from proxy
   * 
   * @private
   */
  onRecordLoad: function onRecordLoad() {
    // interrupt process flow until dialog is rendered
    if (!this.rendered) {
      this.onRecordLoad.defer(250, this);
      return;
    }

    if (Ext.isString(this.record)) {
      this.record = this.recordProxy.recordReader({
        responseText: this.record
      });
    }

    this.record.set('employee_id', this.fixedFields.get('employee_id'));

    if (this.record.get('employee_id')) {
      this.window.setTitle(String.format(i18n._('Edit {0} "{1}"'), this.i18nRecordName, this.record.getTitle()));
    }

    Tine.HumanResources.FreeTimeEditDialog.superclass.onRecordLoad.call(this);

    if (this.accountPicker) {
      this.accountPicker.onRecordLoad(this.record);
    } // set title after record load to determine if it's an update or new record


    var typeString = this.freetimeType == 'SICKNESS' ? 'Sickness Days' : 'Vacation Days';

    if (this.record.id) {
      if (this.accountPicker) {
        this.accountPicker.disable();
      }

      this.window.setTitle(String.format(this.app.i18n._('Edit {0} for {1}'), this.app.i18n._hidden(typeString), this.record.get('employee_id').n_fn));
    } else {
      this.window.setTitle(String.format(this.app.i18n._('Add {0} for {1}'), this.app.i18n._hidden(typeString), this.record.get('employee_id').n_fn));
      this.statusPicker.setValue(this.freetimeType == 'SICKNESS' ? 'EXCUSED' : 'ACCEPTED');
    }
  },

  /**
   * just break if at least one day is selected, otherwise close the window
   * 
   * @param {Boolean} closeWindow
   * @return {Boolean}
   */
  onApplyChanges: function onApplyChanges(closeWindow) {
    // if no day is selected, show message and break saving
    if (!this.datePicker.store.getFirstDay()) {
      var msg = this.freetimeType == 'SICKNESS' ? this.app.i18n._('You have to select at least one day to save this sickness entry.') : this.app.i18n._('You have to select at least one day to save this vacation entry.');
      Ext.MessageBox.show({
        buttons: Ext.Msg.OK,
        icon: Ext.MessageBox.WARNING,
        title: this.app.i18n._('No day selected'),
        msg: msg
      });
      return false;
    } else {
      Tine.HumanResources.FreeTimeEditDialog.superclass.onApplyChanges.call(this, closeWindow);
    }
  },

  /**
   * executed when record gets updated from form
   * @private
   */
  onRecordUpdate: function onRecordUpdate() {
    Tine.HumanResources.FreeTimeEditDialog.superclass.onRecordUpdate.call(this);
    var _ = window.lodash;
    var firstDay = this.datePicker.store.getFirstDay();
    var lastDay = this.datePicker.store.getLastDay(); // add in json by year if sickness record

    if (!this.accountPicker) {
      this.record.set('account_id', null);
    } else {
      this.record.set('account_id', _.get(this, 'currentAccount.data'));
    }

    this.record.set('freedays', this.datePicker.getData());
    this.record.set('type', this.fixedFields.get('type').toLowerCase());
    this.record.set('firstday_date', firstDay ? firstDay.get('date') : null);
    this.record.set('lastday_date', lastDay ? lastDay.get('date') : null);
    this.record.set('days_count', this.datePicker.store.getCount());
  },

  /**
   * creates the date picker
   */
  initDatePicker: function initDatePicker() {
    var date,
        account = null;

    if (this.record.id && (account = this.record.get('account_id'))) {
      var year = account.year;
    } else {
      var year = this.startYear;
    } // init to current date if year is current


    if (year == new Date().format('Y')) {
      date = new Date().clearTime();
    }

    Tine.log.debug('Initializing the date picker. Using year ' + year);
    this.datePicker = new Tine.HumanResources.DatePicker({
      accountPickerActive: this.freetimeType == 'VACATION' ? true : false,
      recordClass: Tine.HumanResources.Model.FreeDay,
      app: this.app,
      editDialog: this,
      dateProperty: 'date',
      recordsProperty: 'freedays',
      foreignIdProperty: 'freeday_id',
      freetimeType: this.freetimeType,
      currentYear: year,
      value: date || new Date(year, 0, 1)
    });
  },

  /**
   * validates day length
   * 
   * @param {Float/Integer} value
   * @return {Boolean}
   */
  isDayLengthValid: function isDayLengthValid(value) {
    return value <= 1 && value >= 0.25;
  },

  /**
   * initializes the account picker
   */
  initAccountPicker: function initAccountPicker() {
    Tine.log.debug('Initializing the account picker...');
    var that = this;
    this.accountPicker = Tine.widgets.form.RecordPickerManager.get('HumanResources', 'Account', {
      name: 'account_id',
      fieldLabel: this.app.i18n._('Personal account'),
      additionalFilters: [{
        field: 'employee_id',
        operator: 'AND',
        value: [{
          field: ':id',
          operator: 'equals',
          value: this.fixedFields.get('employee_id').id
        }]
      }],

      /**
       * fills the accountPicker on init with the account associated to 
       * the record or current year if the record is new
       * 
       * @param {Tine.HumanResources.Model.Account} record
       */
      onRecordLoad: function onRecordLoad(record) {
        Tine.log.debug('Called onRecordLoad of the account picker...');

        if (record.get('account_id')) {
          Tine.log.debug('The record has an account attached:', record.get('account_id'));
          that.currentAccount = new Tine.HumanResources.Model.Account(record.get('account_id'));
          that.datePicker.loadFeastDays(false, true, null, that.currentAccount.get('year'));
          return;
        }

        Tine.log.debug('The record is new, so no account has been attached. So we search one for the year ' + this.startYear);
        var addFilters = [{
          field: 'employee_id',
          operator: 'AND',
          value: [{
            field: ':id',
            operator: 'equals',
            value: record.get('employee_id').id
          }]
        }, {
          field: 'year',
          operator: 'equals',
          value: this.startYear
        }];
        var request = Ext.Ajax.request({
          url: 'index.php',
          params: {
            method: 'HumanResources.searchAccounts',
            filter: addFilters
          },
          success: function success(_result, _request) {
            var result = Ext.decode(_result.responseText);
            this.store.loadData(result);
            var rr = result.results;

            for (var index = 0; index < rr.length; index++) {
              if (rr[index].year == that.startYear) {
                this.setValue(rr[index]);
                that.currentAccount = new Tine.HumanResources.Model.Account(rr[index]);
                that.datePicker.loadFeastDays(false, true, null, that.currentAccount.get('year'));
              }
            }
          },
          failure: function failure(exception) {
            Tine.Tinebase.ExceptionHandler.handleRequestException(exception);
          },
          scope: this
        });
      }
    }); // update remaining days on account change

    this.accountPicker.on('select', function (combo, record, index) {
      var year = record.get('year');
      Tine.log.debug('On select event handler called. Using year ' + year);
      that.currentAccount = record; // if not cached, fetch from server

      if (!that.calculatedFeastDays[year]) {
        Tine.log.debug('No cached feast days found. Creating request...');
        var request = Ext.Ajax.request({
          url: 'index.php',
          params: {
            method: 'HumanResources.getFeastAndFreeDays',
            _employeeId: this.fixedFields.get('employee_id').id,
            _year: year
          },
          success: function success(_result, _request) {
            var response = Ext.decode(_result.responseText); // cache result

            this.calculatedFeastDays[year] = response.results;
            this.onAccountLoad(response.results); // update date picker

            this.datePicker.onFeastDaysLoad(response, false, null, year);
          },
          failure: function failure(exception) {
            Tine.Tinebase.ExceptionHandler.handleRequestException(exception, this.onFeastDaysLoadFailureCallback, this);
          },
          scope: that
        });
      } else {
        Tine.log.debug('Cached feast days found for year ' + year);
        that.onAccountLoad(this.calculatedFeastDays[year]);
      }
    }, this);
  },

  /**
   * initializes the status picker
   */
  initStatusPicker: function initStatusPicker() {
    this.freetimeType = this.fixedFields.get('type');
    Tine.log.debug('Initializing status picker with type "' + this.freetimeType + '"');
    var statusPickerDefaults = {
      fieldLabel: this.app.i18n._('Status'),
      xtype: 'widget-keyfieldcombo',
      app: 'HumanResources',
      name: 'status'
    };

    if (this.freetimeType != 'VACATION') {
      this.statusPicker = new Tine.Tinebase.widgets.keyfield.ComboBox(Ext.apply({
        keyFieldName: 'sicknessStatus',
        value: 'EXCUSED',
        columnWidth: 1
      }, statusPickerDefaults));
    } else {
      this.statusPicker = new Tine.Tinebase.widgets.keyfield.ComboBox(Ext.apply({
        keyFieldName: 'vacationStatus',
        value: 'REQUESTED',
        columnWidth: 2 / 3
      }, statusPickerDefaults));
    }
  },

  /**
   * 
   * @param {} calculated
   */
  onAccountLoad: function onAccountLoad(calculated) {
    var remaining = calculated.allVacation - this.getDaysToSubstract();
    Tine.log.debug('Called onAccountLoad. Calculated ' + remaining + ' remaining feast days.');
    this.form.findField('remaining_vacation_days').setValue(remaining);
  },

  /**
   * if loading feast and freedays failes
   */
  onFeastDaysLoadFailureCallback: function onFeastDaysLoadFailureCallback() {},

  /**
   * calculates the amount of days to substract for the remaining_vacation_days field
   * 
   * @return {Number}
   */
  getDaysToSubstract: function getDaysToSubstract() {
    var substractDays = 0; // find out local free days to substract. this is by account only

    var accountId = this.currentAccount.get('id');

    if (this.localVacationDays.hasOwnProperty(accountId)) {
      substractDays = substractDays + this.localVacationDays[accountId].length;
    }

    return substractDays;
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   * 
   * @return {Object}
   * @private
   */
  getFormItems: function getFormItems() {
    this.initDatePicker();

    if (this.freetimeType == 'VACATION') {
      this.initAccountPicker();
    }

    this.initStatusPicker();
    var firstRow = [this.statusPicker];

    if (this.freetimeType == 'VACATION') {
      firstRow.push(this.accountPicker);
      firstRow.push({
        columnWidth: 1 / 3,
        name: 'remaining_vacation_days',
        readOnly: true,
        fieldLabel: this.app.i18n._('Remaining')
      });
      var freeTimeTypeName = 'Vacation Days';
    } else {
      var freeTimeTypeName = 'Sickness Days';
    }

    return {
      xtype: 'tabpanel',
      plain: true,
      defaults: {
        hideMode: 'offsets'
      },
      plugins: [{
        ptype: 'ux.tabpanelkeyplugin'
      }],
      activeTab: 0,
      border: false,
      items: [{
        title: this.app.i18n._(freeTimeTypeName),
        autoScroll: true,
        border: false,
        frame: true,
        layout: 'border',
        items: [{
          region: 'center',
          layout: 'hfit',
          border: false,
          items: [{
            xtype: 'fieldset',
            autoHeight: true,
            title: this.app.i18n._(freeTimeTypeName),
            items: [{
              xtype: 'columnform',
              style: {
                'float': 'left',
                width: '50%',
                'min-width': '178px'
              },
              labelAlign: 'top',
              formDefaults: {
                xtype: 'textfield',
                anchor: '100%',
                labelSeparator: '',
                allowBlank: false,
                columnWidth: 1
              },
              items: [firstRow, [{
                xtype: 'panel',
                cls: 'HumanResources x-form-item',
                width: 220,
                style: {
                  'float': 'right',
                  margin: '0 5px 10px 0'
                },
                items: [{
                  html: '<label style="display:block; margin-bottom: 5px">' + this.app.i18n._('Select Days') + '</label>'
                }, this.datePicker]
              }]]
            }]
          }]
        }, {
          // activities and tags
          layout: 'ux.multiaccordion',
          animate: true,
          region: 'east',
          width: 210,
          split: true,
          collapsible: true,
          collapseMode: 'mini',
          header: false,
          margins: '0 5 0 5',
          border: true,
          items: [new Ext.Panel({
            title: this.app.i18n._('Description'),
            iconCls: 'descriptionIcon',
            layout: 'form',
            labelAlign: 'top',
            border: false,
            items: [{
              style: 'margin-top: -4px; border 0px;',
              labelSeparator: '',
              xtype: 'textarea',
              name: 'description',
              hideLabel: true,
              grow: false,
              preventScrollbars: false,
              anchor: '100% 100%',
              emptyText: this.app.i18n._('Enter description'),
              requiredGrant: 'editGrant'
            }]
          })]
        }]
      }]
    };
  }
});

/***/ }),

/***/ 1522:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2013 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.VacationEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>Vacation Compose Dialog</p>
 * <p></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * Create a new Tine.HumanResources.VacationEditDialog
 */

Tine.HumanResources.VacationEditDialog = Ext.extend(Tine.HumanResources.FreeTimeEditDialog, {
  freetimeType: 'VACATION'
});

Tine.HumanResources.VacationEditDialog.openWindow = function (cfg) {
  var id = cfg.record && cfg.record.id ? cfg.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 440,
    height: 450,
    name: 'VacationEditWindow_' + id,
    contentPanelConstructor: 'Tine.HumanResources.VacationEditDialog',
    contentPanelConstructorConfig: cfg
  });
  return window;
};

/***/ }),

/***/ 1523:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2013 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.SicknessEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>Sickness Compose Dialog</p>
 * <p></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * Create a new Tine.HumanResources.SicknessEditDialog
 */

Tine.HumanResources.SicknessEditDialog = Ext.extend(Tine.HumanResources.FreeTimeEditDialog, {
  freetimeType: 'SICKNESS'
});

Tine.HumanResources.SicknessEditDialog.openWindow = function (cfg) {
  var id = cfg.record && cfg.record.id ? cfg.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 440,
    height: 450,
    name: 'SicknessEditWindow_' + id,
    contentPanelConstructor: 'Tine.HumanResources.SicknessEditDialog',
    contentPanelConstructorConfig: cfg
  });
  return window;
};

/***/ }),

/***/ 1524:
/***/ (function(module, exports) {

/* 
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2013 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * @class     Tine.HumanResources.ContractDetailsPanel
 * @namespace HumanResources
 * @extends   Tine.widgets.grid.DetailsPanel
 * @author    Alexander Stintzing <a.stintzing@metaways.de>
 */

Tine.HumanResources.ContractDetailsPanel = Ext.extend(Tine.widgets.grid.DetailsPanel, {
  app: null,

  /**
   * the model configuration
   * @type 
   */
  modelConfig: null,

  /**
   * @cfg {Number} defaultHeight
   * default Heights
   */
  defaultHeight: 110,
  initComponent: function initComponent() {
    Tine.HumanResources.ContractDetailsPanel.superclass.initComponent.call(this);
  },

  /**
   * main event details panel
   * 
   * @return {Ext.ux.display.DisplayPanel}
   */
  getSingleRecordPanel: function getSingleRecordPanel() {
    if (!this.singleRecordPanel) {
      var mc = this.modelConfig,
          items = [];

      for (var index = 0; index < mc.fieldKeys.length; index++) {
        var fieldConfig = mc.fields[mc.fieldKeys[index]];

        if (fieldConfig.showInDetailsPanel) {
          items.push({
            xtype: 'ux.displayfield',
            name: fieldConfig.key,
            fieldLabel: fieldConfig.hasOwnProperty('useGlobalTranslation') ? i18n._(fieldConfig.label) : this.app.i18n._(fieldConfig.label),
            renderer: Tine.widgets.grid.RendererManager.get(mc.appName, mc.modelName, fieldConfig.key),
            htmlEncode: false
          });
        }
      }

      this.singleRecordPanel = new Ext.ux.display.DisplayPanel(this.wrapPanel(items, 110));
    }

    return this.singleRecordPanel;
  },

  /**
   * update event details panel
   * 
   * @param {Tine.Tinebase.data.Record} record
   * @param {Mixed} body
   */
  updateDetails: function updateDetails(record, body) {
    this.getSingleRecordPanel().loadRecord.defer(100, this.getSingleRecordPanel(), [record]);
  },

  /**
   * show default template
   * 
   * @param {Mixed} body
   */
  showDefault: function showDefault(body) {
    this.showMulti(this.grid.getSelectionModel());
  }
});

/***/ }),

/***/ 1525:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2012-2013 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.EmployeeEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>Employee Compose Dialog</p>
 * <p></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.HumanResources.EmployeeEditDialog
 */

Tine.HumanResources.ContractGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  /*
   * config
   */
  editDialogRecordProperty: 'contracts',

  /**
   * the calling editDialog
   * @type {Tine.HumanResources.EmployeeEditDialog}
   */
  editDialog: null,
  usePagingToolbar: false,

  /**
   * initializes the component
   */
  initComponent: function initComponent() {
    this.title = this.app.i18n.ngettext('Contract', 'Contracts', 2);

    if (this.editDialog) {
      this.bbar = [];
    }

    this.initDetailsPanel();
    Tine.HumanResources.ContractGridPanel.superclass.initComponent.call(this);

    if (this.editDialog) {
      this.fillBottomToolbar();
    }
  },

  /**
   * @private
   */
  initDetailsPanel: function initDetailsPanel() {
    this.detailsPanel = new Tine.HumanResources.ContractDetailsPanel({
      modelConfig: this.modelConfig,
      grid: this,
      app: this.app
    });
  },

  /**
   * will be called in Edit Dialog Mode
   */
  fillBottomToolbar: function fillBottomToolbar() {
    this.action_deleteRecord.initialConfig.actionUpdater = function (action) {
      var selection = this.getGrid().getSelectionModel().getSelections();

      if (selection.length != 1) {
        action.disable();
        return;
      } else {
        var record = selection[0];
      }

      if (!record) {
        action.disable();
        return;
      }

      if (record.id.length == 13) {
        action.enable();
        return;
      }

      action.setDisabled(!(record.get('is_editable') == true)); // may be undefined
    };

    var tbar = this.getBottomToolbar();
    tbar.addButton(new Ext.Button(this.action_editInNewWindow));
    tbar.addButton(new Ext.Button(this.action_addInNewWindow));
    tbar.addButton(new Ext.Button(this.action_deleteRecord));
  },

  /**
   * Opens the required EditDialog
   * @param {Object} actionButton the button the action was called from
   * @param {Tine.Tinebase.data.Record} record the record to display/edit in the dialog
   * @param {Array} plugins the plugins used for the edit dialog
   * @return {Boolean}
   */
  onEditInNewWindow: function onEditInNewWindow(button, record, plugins) {
    Tine.HumanResources.ContractGridPanel.superclass.onEditInNewWindow.call(this, button, record, plugins);
  },

  /**
   * called when Records have been added to the Store
   */
  onStoreAdd: function onStoreAdd(store, records, index) {
    var contract = records[0]; // has a temporary id -> check vacation overlap

    if (contract.id.length == 13) {
      this.checkVacationOverlap(contract);
    }

    Tine.HumanResources.ContractGridPanel.superclass.onStoreAdd.call(this, store, records, index);
  },

  /**
   * shows message if a previous defined vacation is in the time periodof the added contract
   * 
   * @param {Tine.Sales.Model.Contract} contract
   */
  checkVacationOverlap: function checkVacationOverlap(contract) {
    var startDate = contract.get('start_date');
    var store = this.editDialog.vacationGridPanel.getStore(); // if vacation grid panel has not been loaded, fetch records from the parent record

    if (store.getCount() == 0) {
      store = new Ext.util.MixedCollection();

      if (this.editDialog.record.data.vacation && this.editDialog.record.data.vacation.length) {
        for (var index = 0; index < this.editDialog.record.data.vacation.length; index++) {
          store.add(new Tine.HumanResources.Model.FreeDay(this.editDialog.record.data.vacation[index]));
        }
      }
    }

    var found = false;
    store.each(function (record, index) {
      if (record.get('firstday_date') >= startDate) {
        found = true;
      }
    });

    if (found) {
      Ext.MessageBox.show({
        title: this.app.i18n._('Vacation in same period'),
        msg: this.app.i18n._('There are some vacation days matching the period of the contract you added. After saving this employee, changing the contract is not possible anymore.'),
        buttons: Ext.Msg.OK,
        scope: this,
        icon: Ext.MessageBox.WARNING
      });
    }
  }
});

/***/ }),

/***/ 1526:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2012 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.EmployeeEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>Employee Compose Dialog</p>
 * <p></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.HumanResources.EmployeeEditDialog
 */

Tine.HumanResources.CostCenterGridPanel = Ext.extend(Tine.widgets.grid.QuickaddGridPanel, {
  /*
   * config
   */
  frame: true,
  border: true,
  autoScroll: true,
  layout: 'fit',
  defaultSortInfo: {
    field: 'start_date',
    direction: 'DESC'
  },
  autoExpandColumn: 'cost_center_id',
  quickaddMandatory: 'cost_center_id',
  clicksToEdit: 1,
  enableColumnHide: false,
  enableColumnMove: false,
  enableHdMenu: false,
  recordClass: Tine.HumanResources.Model.CostCenter,
  validate: true,

  /*
   * public
   */
  app: null,

  /**
   * the calling editDialog
   * Tine.HumanResources.EmployeeEditDialog
   */
  editDialog: null,

  /**
   * initializes the component
   */
  initComponent: function initComponent() {
    this.title = this.app.i18n.ngettext('CostCenter', 'CostCenters', 2), Tine.HumanResources.CostCenterGridPanel.superclass.initComponent.call(this);
    this.store.sortInfo = this.defaultSortInfo;
    this.on('afteredit', this.onAfterEdit, this);
    this.editDialog.on('load', this.loadRecord, this);
    this.store.sort(); // sync record on these events

    this.store.on('update', this.syncStoreToRecord.createDelegate(this));
    this.store.on('add', this.syncStoreToRecord.createDelegate(this));
    this.store.on('remove', this.syncStoreToRecord.createDelegate(this));
  },

  /**
   * 
   * @param {} store
   * @param {} record
   * @param {} operation
   */
  syncStoreToRecord: function syncStoreToRecord(store, record, operation) {
    if (this.editDialog.record) {
      var items = [];
      store.each(function (item) {
        items.push(item.data);
      });
      this.editDialog.record.set('costcenters', items);
    }
  },

  /**
   * loads the existing CostCenters into the store
   */
  loadRecord: function loadRecord() {
    var c = this.editDialog.record.get('costcenters');

    if (Ext.isArray(c)) {
      Ext.each(c, function (ar) {
        this.store.addSorted(new this.recordClass(ar));
      }, this);
    }
  },

  /**
   * new entry event -> add new record to store
   * @see Tine.widgets.grid.QuickaddGridPanel
   * @param {Object} recordData
   * @return {Boolean}
   */
  onNewentry: function onNewentry(recordData) {
    recordData.employee_id = this.editDialog.record.get('id');
    var relatedRecord = this.costcenterQuickadd.store.getById(this.costcenterQuickadd.getValue());
    recordData.cost_center_id = relatedRecord.data;
    this.store.addSorted(new this.recordClass(recordData));
  },

  /**
   * returns column model
   * 
   * @return Ext.grid.ColumnModel
   * @private
   */
  getColumnModel: function getColumnModel() {
    this.costCenterEditor = Tine.widgets.form.RecordPickerManager.get('Sales', 'CostCenter', {
      allowBlank: true
    });
    this.startdateEditor = new Ext.ux.form.ClearableDateField();
    this.costcenterQuickadd = Tine.widgets.form.RecordPickerManager.get('Sales', 'CostCenter', {
      allowBlank: true
    });
    var columns = [{
      id: 'cost_center_id',
      dataIndex: 'cost_center_id',
      type: Tine.Sales.Model.CostCenter,
      header: this.app.i18n._('Cost Center'),
      quickaddField: this.costcenterQuickadd,
      renderer: this.renderCostCenter,
      editor: this.costCenterEditor,
      scope: this
    }, {
      id: 'start_date',
      renderer: Tine.Tinebase.common.dateRenderer,
      editor: this.startdateEditor,
      quickaddField: new Ext.ux.form.ClearableDateField(),
      dataIndex: 'start_date',
      header: this.app.i18n._('Startdate'),
      scope: this,
      width: 120
    }];
    return new Ext.grid.ColumnModel({
      defaults: {
        sortable: true,
        width: 160,
        editable: true
      },
      columns: columns
    });
  },

  /**
   * is called on after edit to set related records
   * @param {} o
   */
  onAfterEdit: function onAfterEdit(o) {
    if (o.field == 'start_date') {
      o.record.set('start_date', this.startdateEditor.getValue());
    } else if (o.field == 'cost_center_id') {
      var relatedRecord = this.costCenterEditor.store.getById(this.costCenterEditor.getValue());
      o.record.set('cost_center_id', relatedRecord.data);
    }
  },

  /**
   * renders the cost center
   * @param {Object} value
   * @param {Object} row
   * @param {Tine.Tinebase.data.Record} record
   * 
   * return {String}
   */
  renderCostCenter: function renderCostCenter(value, row, record) {
    return '<span class="tine-recordclass-gridicon SalesCostCenter">&nbsp;</span>' + (record ? record.get('cost_center_id').number + ' - ' + record.getTitle() : '');
  }
});

/***/ }),

/***/ 1527:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     HumanResources
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2012 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.FreeTimeEmployeeFilterModel
 * @extends     Tine.widgets.grid.ForeignRecordFilter
 * 
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 */

Tine.HumanResources.FreeTimeEmployeeFilterModel = Ext.extend(Tine.widgets.grid.ForeignRecordFilter, {
  // private
  ownField: 'employee_id',
  linkType: 'foreignId',
  foreignRecordClass: Tine.HumanResources.Model.Employee,
  filterName: 'EmployeeFilter',

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.app = Tine.Tinebase.appMgr.get('HumanResources');
    this.label = this.app.i18n._('Employee');
    this.pickerConfig = {
      allowBlank: true
    };
    Tine.HumanResources.FreeTimeEmployeeFilterModel.superclass.initComponent.call(this);
  }
});
Tine.widgets.grid.FilterToolbar.FILTERS['humanresources.freetimeemployee'] = Tine.HumanResources.FreeTimeEmployeeFilterModel;

/***/ }),

/***/ 1528:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2013 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * Account grid panel
 * 
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.AccountGridPanel
 * @extends     Tine.widgets.grid.GridPanel
 * 
 * <p>Account Grid Panel</p>
 * <p><pre>
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>    
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.HumanResources.AccountGridPanel
 */

Tine.HumanResources.AccountGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  initComponent: function initComponent() {
    this.actions_bookVacation = new Ext.Action({
      text: this.app.i18n._('Book remaining vacation'),
      iconCls: 'action_export',
      allowMultiple: true,
      handler: this.bookRemaining.createDelegate(this)
    });
    this.contextMenuItems = [this.actions_bookVacation];
    Tine.HumanResources.AccountGridPanel.superclass.initComponent.call(this);
    this.action_addInNewWindow.hide();
    this.action_deleteRecord.hide();
  },
  createMissingAccounts: function createMissingAccounts() {
    Ext.Msg.prompt(this.app.i18n._('Year'), this.app.i18n._('Please enter the year you want to create accounts for:'), function (btn, year) {
      if (btn == 'ok') {
        Ext.Ajax.request({
          url: 'index.php',
          timeout: 60000 * 5,
          params: {
            method: 'HumanResources.createMissingAccounts',
            year: year
          },
          success: function success(_result, _request) {
            this.onAccountCreateSuccess(Ext.decode(_result.responseText));
          },
          failure: function failure(exception) {
            Tine.Tinebase.ExceptionHandler.handleRequestException(exception);
          },
          scope: this
        });
      }
    }, this);
  },
  onAccountCreateSuccess: function onAccountCreateSuccess(data) {
    Ext.MessageBox.show({
      buttons: Ext.Msg.OK,
      icon: Ext.MessageBox.INFO,
      title: this.app.i18n._('Accounts have been created'),
      msg: String.format(this.app.i18n._('{0} accounts for the year {1} have been created successfully!'), data.totalcount, data.year)
    });
  },

  /**
   * returns additional toobar items
   * 
   * @return {Array} of Ext.Action
   */
  getActionToolbarItems: function getActionToolbarItems() {
    this.actions_createAccounts = new Ext.Action({
      text: this.app.i18n._('Create new accounts'),
      iconCls: 'action_create_accounts',
      allowMultiple: true,
      handler: this.createMissingAccounts.createDelegate(this)
    });
    var button = Ext.apply(new Ext.Button(this.actions_createAccounts), {
      scale: 'medium',
      rowspan: 2,
      iconAlign: 'top'
    });
    var additionalActions = [this.actions_exportIPAggregate];
    this.actionUpdater.addActions(additionalActions);
    return [button];
  },

  /**
   * Books remaining vacation from an old year to the new year
   * 
   * @param {} action
   * @param {} event
   */
  bookRemaining: function bookRemaining(action, event) {
    var selections = this.getGrid().getSelectionModel().getSelections();
    var ids = [];
    Ext.each(selections, function (sel) {
      ids.push(sel.getId());
    });
    var req = Ext.Ajax.request({
      url: 'index.php',
      timeout: 60000 * 5,
      params: {
        method: 'HumanResources.bookRemaining',
        ids: ids
      },
      success: function success(_result, _request) {
        this.onAfterBookRemaining(Ext.decode(_result.responseText));
      },
      failure: function failure(exception) {
        Tine.HumanResources.handleRequestException(exception);
      },
      scope: this
    });
  },

  /**
   * is called if booking remaining was successfull
   * 
   * @param {Object} response
   */
  onAfterBookRemaining: function onAfterBookRemaining(response) {
    Ext.MessageBox.show({
      buttons: Ext.Msg.OK,
      icon: Ext.MessageBox.INFO,
      title: this.app.i18n._('Booking has been successfull!'),
      msg: this.app.i18n._('The remaining vacation days of the selected accounts have been booked successfully!')
    });
  }
});

/***/ }),

/***/ 1529:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2012-2013 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * FreeTime grid panel
 * 
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.FreeTimeGridPanel
 * @extends     Tine.widgets.grid.GridPanel
 * 
 * <p>FreeTime Grid Panel</p>
 * <p><pre>
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>    
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.HumanResources.FreeTimeGridPanel
 */

Tine.HumanResources.FreeTimeGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  editDialogRecordProperty: null,
  editDialog: null,
  storeRemoteSort: false,
  defaultSortInfo: {
    field: 'firstday_date',
    direction: 'DESC'
  },

  /**
   * if a vacation record gets deleted, this is needed to calculate
   * the remaining vacation days in the freetime edit dialog (vacation)
   * 
   * @type array
   */
  removedVacationDays: null,
  removedSicknessDays: null,
  localSicknessDays: null,
  localVacationDays: null,

  /**
   * set type before to diff vacation/sickness
   * @type 
   */
  freetimeType: null,
  usePagingToolbar: false,

  /**
   * inits this cmp
   * 
   * @private
   */
  initComponent: function initComponent() {
    this.bbar = [];
    this.action_bookSicknessAsVacation = new Ext.Action({
      text: this.app.i18n._('Book as vacation'),
      hidden: true,
      handler: this.onBookSicknessAsVacation,
      scope: this,
      allowMultiple: false
    });
    this.contextMenuItems = [this.action_bookSicknessAsVacation];

    if (this.freetimeType) {
      if (this.freetimeType == 'SICKNESS') {
        this.setTitle(this.app.i18n._('Sickness'));
        this.i18nRecordName = this.app.i18n._('Sickness Days');
        this.i18nRecordsName = this.app.i18n._('Sickness Days');
      } else {
        this.setTitle(this.app.i18n._('Vacation'));
        this.i18nRecordName = this.app.i18n._('Vacation Days');
        this.i18nRecordsName = this.app.i18n._('Vacation Days');
      }
    }

    this.removedSicknessDays = {};
    this.removedVacationDays = {};
    this.localSicknessDays = null;
    this.localVacationDays = null;
    this.i18nEmptyText = this.i18nEmptyText || String.format(this.app.i18n._("There could not be found any {0}. Please try to change your filter-criteria or view-options."), this.i18nRecordsName);
    Tine.HumanResources.FreeTimeGridPanel.superclass.initComponent.call(this);
    this.fillBottomToolbar();
  },

  /**
   * book sickness as vacation
   * 
   * @param {Ext.grid.GridPanel} grid
   * @param {Ext.EventObject} e
   */
  onBookSicknessAsVacation: function onBookSicknessAsVacation(grid, e) {
    var record = this.getGrid().getSelectionModel().getSelections()[0]; // check if enough vacation days are available

    var request = Ext.Ajax.request({
      url: 'index.php',
      params: {
        method: 'HumanResources.getFeastAndFreeDays',
        _employeeId: record.get('employee_id'),
        _year: parseInt(record.get('firstday_date').format('Y')),
        _freeTimeId: null,
        _accountId: record.get('account_id') ? record.get('account_id').id : null
      },
      success: function success(_result, _request) {
        var response = Ext.decode(_result.responseText);
        this.onBookSicknessAsVacationSuccess(response.results, record);
      },
      failure: function failure(exception) {
        Tine.Tinebase.ExceptionHandler.handleRequestException(exception);
      },
      scope: this
    });
  },

  /**
   * callback if the request from onBookSicknessAsVacation doesn't fail
   * 
   * @param {Object} results
   * @param {Tine.HumanResources.Model.Freetime} record
   */
  onBookSicknessAsVacationSuccess: function onBookSicknessAsVacationSuccess(results, record) {
    // if there are not enough vacation days left
    if (results.remainingVacation < record.get('days_count')) {
      Ext.MessageBox.show({
        title: this.app.i18n._('Could not book as vacation'),
        msg: this.app.i18n._('The unexcused sickness days could not be booked as vacation. There are not enough days left!'),
        buttons: Ext.Msg.OK,
        icon: Ext.MessageBox.WARNING
      });
      return;
    }

    this.store.remove(record);
    record.set('type', 'vacation');
    record.set('status', 'ACCEPTED');
    this.editDialog.vacationGridPanel.getStore().add(record); // set sickness of parent record (employee)

    var sickness = [];
    this.getGrid().getStore().each(function (item) {
      sickness.push(item.data);
    });
    this.editDialog.record.set('sickness', sickness); // set vacation of parent record (employee)

    var vacation = [];
    this.editDialog.vacationGridPanel.getStore().each(function (item) {
      vacation.push(item.data);
    });
    this.editDialog.record.set('vacation', vacation);
  },

  /**
   * returns rows context menu
   * 
   * @param {Ext.grid.GridPanel} grid
   * @param {Number} row
   * @param {Ext.EventObject} e
   */
  getContextMenu: function getContextMenu(grid, row, e) {
    var selModel = grid.getSelectionModel();
    this.action_bookSicknessAsVacation.setHidden(true);

    if (selModel.getSelections().length == 1) {
      if (selModel.getSelections()[0].data.status == 'UNEXCUSED') {
        this.action_bookSicknessAsVacation.setHidden(false);
      }
    }

    return Tine.HumanResources.FreeTimeGridPanel.superclass.getContextMenu.call(this, grid, row, e);
  },

  /**
   * will be called in Edit Dialog Mode
   */
  fillBottomToolbar: function fillBottomToolbar() {
    var tbar = this.getBottomToolbar();
    tbar.addButton(new Ext.Button(this.action_editInNewWindow));
    tbar.addButton(new Ext.Button(this.action_addInNewWindow));
    tbar.addButton(new Ext.Button(this.action_deleteRecord));
  },

  /**
   * overwrites and calls superclass
   * 
   * @param {Object} button
   * @param {Tine.Tinebase.data.Record} record
   * @param {Array} plugins
   */
  onEditInNewWindow: function onEditInNewWindow(button, record, plugins) {
    // the name 'button' should be changed as this can be called in other ways also
    button.fixedFields = {
      'employee_id': this.editDialog.record.data,
      'type': this.freetimeType
    }; // collect free days not saved already

    var localVacationDays = {},
        localSicknessDays = {};
    this.editDialog.vacationGridPanel.store.each(function (record) {
      var accountId = Ext.isObject(record.get('account_id')) ? record.get('account_id').id : record.get('account_id');

      if (!localVacationDays.hasOwnProperty(accountId)) {
        localVacationDays[accountId] = [];
      }

      localVacationDays[accountId] = localVacationDays[accountId].concat(record.data.freedays ? record.data.freedays : []);
    }, this);
    this.editDialog.sicknessGridPanel.store.each(function (record) {
      var accountId = Ext.isObject(record.get('account_id')) ? record.get('account_id').id : record.get('account_id');

      if (!localSicknessDays.hasOwnProperty(accountId)) {
        localSicknessDays[accountId] = [];
      }

      localSicknessDays[accountId] = localSicknessDays[accountId].concat(record.data.freedays ? record.data.freedays : []);
    });
    var additionalConfig = {
      localVacationDays: localVacationDays,
      localSicknessDays: localSicknessDays,
      removedVacationDays: this.removedVacationDays,
      removedSicknessDays: this.removedSicknessDays
    };
    this.editDialogClass = this.freetimeType == 'SICKNESS' ? Tine.HumanResources.SicknessEditDialog : Tine.HumanResources.VacationEditDialog;
    Tine.HumanResources.FreeTimeGridPanel.superclass.onEditInNewWindow.call(this, button, record, plugins, additionalConfig);
  },

  /**
   * overwrites the default function, no refactoring needed, this file will be deleted in the next release
   */
  initFilterPanel: function initFilterPanel() {},

  /**
   * renders the different status keyfields
   * @param {String} value
   * @param {Object} b
   * @param {Tine.HumanResources.Model.FreeTime} record
   */
  renderStatus: function renderStatus(value, row, record) {
    if (record.get('type') == 'sickness') {
      if (!this.sicknessStatusRenderer) {
        this.sicknessStatusRenderer = Tine.Tinebase.widgets.keyfield.Renderer.get('HumanResources', 'sicknessStatus');
      }

      return this.sicknessStatusRenderer(value, row, record);
    } else {
      if (!this.vacationStatusRenderer) {
        this.vacationStatusRenderer = Tine.Tinebase.widgets.keyfield.Renderer.get('HumanResources', 'vacationStatus');
      }

      return this.vacationStatusRenderer(value, row, record);
    }
  },

  /**
   * renders the type
   * @param {String} value
   * @param {Object} b
   * @param {Tine.HumanResources.Model.FreeTime} record
   */
  renderType: function renderType(value, row, record) {
    if (!this.app) {
      this.app = Tine.Tinebase.appMgr.get('HumanResources');
    }

    if (record.get('type') == 'sickness') {
      return this.app.i18n._('Sickness');
    } else {
      return this.app.i18n._('Vacation');
    }
  },

  /**
   * delete records
   * 
   * @param {SelectionModel} sm
   * @param {Array} records
   */
  deleteRecords: function deleteRecords(sm, records) {
    if (!this.removedVacationDays) {
      this.removedVacationDays = {};
    } // collect freetimes deleted locally but not persisted already


    Ext.each(records, function (record) {
      if (record.get('id').length > 13) {
        var accountId = Ext.isObject(record.get('account_id')) ? record.get('account_id').id : record.get('account_id');

        if (record.get('type') == 'vacation') {
          if (!this.removedVacationDays.hasOwnProperty(accountId)) {
            this.removedVacationDays[accountId] = [];
          }

          this.removedVacationDays[accountId] = this.removedVacationDays[accountId].concat(record.get('freedays'));
        } else {
          if (!this.removedSicknessDays.hasOwnProperty(accountId)) {
            this.removedSicknessDays[accountId] = [];
          }

          this.removedSicknessDays[accountId] = this.removedSicknessDays[accountId].concat(record.get('freedays'));
        }
      }
    }, this);
    Tine.HumanResources.FreeTimeGridPanel.superclass.deleteRecords.call(this, sm, records);
  },

  /**
   * called when the store gets updated, e.g. from editgrid
   * 
   * @param {Ext.data.store} store
   * @param {Tine.Tinebase.data.Record} record
   * @param {String} operation
   */
  onStoreUpdate: function onStoreUpdate(store, record, operation) {
    if (Ext.isObject(record.get('employee_id'))) {
      record.set('employee_id', record.get('employee_id').id);
    }

    Tine.HumanResources.FreeTimeGridPanel.superclass.onStoreUpdate.call(this, store, record, operation);
  }
});
Tine.widgets.grid.RendererManager.register('HumanResources', 'FreeTime', 'status', Tine.HumanResources.FreeTimeGridPanel.prototype.renderStatus);
Tine.widgets.grid.RendererManager.register('HumanResources', 'FreeTime', 'type', Tine.HumanResources.FreeTimeGridPanel.prototype.renderType);

/***/ }),

/***/ 1530:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2013 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.ExtraFreeTimeEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>ExtraFreeTime Compose Dialog</p>
 * <p></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * Create a new Tine.HumanResources.ExtraFreeTimeEditDialog
 */

Tine.HumanResources.ExtraFreeTimeEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowNamePrefix: 'ExtraFreeTimeEditWindow_',
  appName: 'HumanResources',
  recordClass: Tine.HumanResources.Model.ExtraFreeTime,
  recordProxy: Tine.HumanResources.freetimeBackend,
  evalGrants: false,
  showContainerSelector: false,
  mode: 'local',
  windowWidth: 400,
  windowHeight: 350,

  /**
   * show private Information (autoset due to rights)
   * @type 
   */
  showPrivateInformation: null,

  /**
   * overwrite update toolbars function (we don't have record grants yet)
   * @private
   */
  updateToolbars: Ext.emptyFn,

  /**
   * inits the component
   */
  initComponent: function initComponent() {
    this.app = Tine.Tinebase.appMgr.get('HumanResources');
    Tine.HumanResources.ExtraFreeTimeEditDialog.superclass.initComponent.call(this);
  },

  /**
   * executed after record got updated from proxy
   * 
   * @private
   */
  onRecordLoad: function onRecordLoad() {
    // interrupt process flow until dialog is rendered
    if (!this.rendered) {
      this.onRecordLoad.defer(250, this);
      return;
    }

    if (Ext.isString(this.record)) {
      this.record = this.recordProxy.recordReader({
        responseText: this.record
      });
    }

    Tine.HumanResources.ExtraFreeTimeEditDialog.superclass.onRecordLoad.call(this);
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   * 
   * @return {Object}
   * @private
   */
  getFormItems: function getFormItems() {
    return {
      xtype: 'tabpanel',
      plain: true,
      plugins: [{
        ptype: 'ux.tabpanelkeyplugin'
      }],
      defaults: {
        hideMode: 'offsets'
      },
      activeTab: 0,
      border: false,
      items: [{
        title: this.app.i18n._('Extra free time'),
        autoScroll: true,
        border: false,
        frame: true,
        layout: 'border',
        items: [{
          region: 'center',
          layout: 'hfit',
          border: false,
          items: [{
            xtype: 'fieldset',
            autoHeight: true,
            title: this.app.i18n._('Extra free time'),
            items: [{
              xtype: 'columnform',
              labelAlign: 'top',
              formDefaults: {
                xtype: 'numberfield',
                anchor: '100%',
                labelSeparator: '',
                allowBlank: false,
                columnWidth: 1
              },
              items: [[{
                name: 'days',
                fieldLabel: this.app.i18n._('Days')
              }], [{
                xtype: 'widget-keyfieldcombo',
                app: 'HumanResources',
                keyFieldName: 'extraFreetimeType',
                fieldLabel: this.app.i18n._('Type'),
                name: 'type',
                showIcon: false
              }], [{
                fieldLabel: this.app.i18n._('Expiration date'),
                xtype: 'datefield',
                name: 'expires'
              }]]
            }]
          }]
        }, {
          // activities and tags
          layout: 'ux.multiaccordion',
          animate: true,
          region: 'east',
          width: 210,
          split: true,
          collapsible: true,
          collapseMode: 'mini',
          header: false,
          margins: '0 5 0 5',
          border: true,
          items: [new Ext.Panel({
            title: this.app.i18n._('Description'),
            iconCls: 'descriptionIcon',
            layout: 'form',
            labelAlign: 'top',
            border: false,
            items: [{
              style: 'margin-top: -4px; border 0px;',
              labelSeparator: '',
              xtype: 'textarea',
              name: 'description',
              hideLabel: true,
              grow: false,
              preventScrollbars: false,
              anchor: '100% 100%',
              emptyText: this.app.i18n._('Enter description'),
              requiredGrant: 'editGrant'
            }]
          }), new Tine.widgets.tags.TagPanel({
            app: 'HumanResources',
            border: false,
            bodyStyle: 'border:1px solid #B5B8C8;'
          })]
        }]
      }, new Tine.widgets.activities.ActivitiesTabPanel({
        app: this.appName,
        record_id: this.record.id,
        record_model: this.appName + '_Model_' + this.recordClass.getMeta('modelName')
      })]
    };
  },

  /**
   * updates the statusbox wrap
   * 
   * @param {Tine.Tinebase.widgets.keyfield.ComboBox} the calling combo
   * @param {Tine.Tinebase.data.Record} the selected record
   * @param {Integer} the index of the selected value of the typecombo store
   */
  updateStatusBox: function updateStatusBox(typeCombo, keyfieldRecord, index) {
    this.statusBoxWrap.layout.setActiveItem(index);
  },

  /**
   * initializes the status box
   */
  initStatusBox: function initStatusBox() {
    var isSickness = this.fixedFields.get('type') == 'SICKNESS';
    this.updateStatusBox(null, null, isSickness ? 0 : 1);
    var fieldName = isSickness ? 'sicknessStatus' : 'vacationStatus';
    this.getForm().findField(fieldName).setValue(this.record.get('status'));
  }
});

/***/ }),

/***/ 1531:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2013-2014 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * ExtraFreeTime grid panel
 * 
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.ExtraFreeTimeGridPanel
 * @extends     Tine.widgets.grid.GridPanel
 * 
 * <p>ExtraFreeTime Grid Panel</p>
 * <p><pre>
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.HumanResources.ExtraFreeTimeGridPanel
 */

Tine.HumanResources.ExtraFreeTimeGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  /* local */
  storeRemoteSort: false,
  usePagingToolbar: false,

  /**
   * inits this cmp
   * 
   * @private
   */
  initComponent: function initComponent() {
    this.bbar = [];
    Tine.HumanResources.ExtraFreeTimeGridPanel.superclass.initComponent.call(this);
    this.fillBottomToolbar();
  },

  /**
   * will be called in Edit Dialog Mode
   */
  fillBottomToolbar: function fillBottomToolbar() {
    var tbar = this.getBottomToolbar();
    tbar.addButton(new Ext.Button(this.action_editInNewWindow));
    tbar.addButton(new Ext.Button(this.action_addInNewWindow));
    tbar.addButton(new Ext.Button(this.action_deleteRecord));
  },

  /**
   * overwrites and calls superclass
   * 
   * @param {Object} button
   * @param {Tine.Tinebase.data.Record} record
   * @param {Array} addRelations
   */
  onEditInNewWindow: function onEditInNewWindow(button, record, plugins) {
    // the name 'button' should be changed as this can be called in other ways also
    button.fixedFields = {
      'account_id': this.editDialog.record.data
    };
    Tine.HumanResources.ExtraFreeTimeGridPanel.superclass.onEditInNewWindow.call(this, button, record, plugins);
  },

  /**
   * called when the store gets updated, e.g. from editgrid
   * 
   * @param {Ext.data.store} store
   * @param {Tine.Tinebase.data.Record} record
   * @param {String} operation
   */
  onStoreUpdate: function onStoreUpdate(store, record, operation) {
    if (Ext.isObject(record.get('account_id'))) {
      record.set('account_id', record.get('account_id').id);
    }

    Tine.HumanResources.ExtraFreeTimeGridPanel.superclass.onStoreUpdate.call(this, store, record, operation);
  }
});
Tine.widgets.grid.RendererManager.register('HumanResources', 'ExtraFreeTime', 'status', Tine.HumanResources.ExtraFreeTimeGridPanel.prototype.renderStatus);

/***/ }),

/***/ 1532:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2012 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.AccountEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>Account Edit Dialog</p>
 * <p></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * Create a new Tine.HumanResources.AccountEditDialog
 */

Tine.HumanResources.AccountEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /*
   * @private
   */
  evalGrants: false,
  windowWidth: 550,
  windowHeight: 560,

  /**
   * inits the component
   */
  initComponent: function initComponent() {
    this.app = Tine.Tinebase.appMgr.get('HumanResources');
    Tine.HumanResources.AccountEditDialog.superclass.initComponent.call(this);
  },

  /**
   * executed after record got updated from proxy
   * 
   * @private
   */
  onRecordLoad: function onRecordLoad() {
    // interrupt process flow until dialog is rendered
    if (!this.rendered) {
      this.onRecordLoad.defer(250, this);
      return;
    }

    Tine.HumanResources.AccountEditDialog.superclass.onRecordLoad.call(this);
    var employee = this.record.get('employee_id'),
        name = employee ? employee.n_fn : 'unknown';
    this.window.setTitle(String.format(this.app.i18n._('Edit {0} for {1} - {2}'), this.i18nRecordName, Ext.util.Format.htmlEncode(name), this.record.get('year')));
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   * 
   * @return {Object}
   * @private
   */
  getFormItems: function getFormItems() {
    this.extraFreeTimeGridPanel = new Tine.HumanResources.ExtraFreeTimeGridPanel({
      app: this.app,
      editDialog: this,
      editDialogRecordProperty: 'extra_free_times',
      disabled: false,
      frame: false,
      border: true,
      autoScroll: true,
      layout: 'border',
      title: this.app.i18n._('Extra free time')
    }); // columnForm defaults

    var cfDefaults = {
      xtype: 'textfield',
      readOnly: true,
      columnWidth: .5,
      anchor: '100%'
    };
    return {
      xtype: 'tabpanel',
      plain: true,
      plugins: [{
        ptype: 'ux.tabpanelkeyplugin'
      }],
      defaults: {
        hideMode: 'offsets'
      },
      activeTab: 0,
      border: false,
      items: [{
        title: this.app.i18n._('Summary'),
        autoScroll: true,
        border: false,
        frame: true,
        layout: 'border',
        items: [{
          region: 'center',
          layout: 'hfit',
          border: false,
          items: [{
            xtype: 'fieldset',
            layout: 'hfit',
            autoHeight: true,
            title: this.app.i18n._('Free Times'),
            items: [{
              xtype: 'columnform',
              formDefaults: cfDefaults,
              labelAlign: 'top',
              items: [[{
                fieldLabel: this.app.i18n._('Possible vaction days'),
                name: 'possible_vacation_days',
                columnWidth: 1 / 5
              }, {
                fieldLabel: this.app.i18n._('Remaining vaction days'),
                name: 'remaining_vacation_days',
                columnWidth: 1 / 5
              }, {
                fieldLabel: this.app.i18n._('Taken vaction days'),
                name: 'taken_vacation_days',
                columnWidth: 1 / 5
              }, {
                fieldLabel: this.app.i18n._('Expired vaction days'),
                name: 'expired_vacation_days',
                columnWidth: 1 / 5
              }, {
                fieldLabel: this.app.i18n._('Rebooked vaction days'),
                name: 'rebooked_vacation_days',
                columnWidth: 1 / 5
              }]]
            }]
          }, {
            xtype: 'fieldset',
            layout: 'hfit',
            autoHeight: true,
            title: this.app.i18n._('Sickness'),
            items: [{
              xtype: 'columnform',
              formDefaults: cfDefaults,
              labelAlign: 'top',
              items: [[{
                fieldLabel: this.app.i18n._('Excused sickness days'),
                name: 'excused_sickness'
              }, {
                fieldLabel: this.app.i18n._('Unexcused sickness days'),
                name: 'unexcused_sickness'
              }]]
            }]
          }, {
            xtype: 'fieldset',
            layout: 'hfit',
            autoHeight: true,
            title: this.app.i18n._('Working Time'),
            items: [{
              xtype: 'columnform',
              formDefaults: cfDefaults,
              labelAlign: 'top',
              items: [[{
                fieldLabel: this.app.i18n._('Days to work'),
                name: 'working_days'
              }, {
                fieldLabel: this.app.i18n._('Hours to work'),
                name: 'working_hours'
              }], [{
                fieldLabel: this.app.i18n._('Days to work after vacation and sickness'),
                name: 'working_days_real'
              }, {
                fieldLabel: this.app.i18n._('Hours to work after vacation and sickness'),
                name: 'working_hours_real'
              }]]
            }]
          }, {
            xtype: 'fieldset',
            layout: 'hfit',
            autoHeight: true,
            title: this.app.i18n._('Miscellaneous'),
            items: [{
              xtype: 'columnform',
              labelAlign: 'top',
              items: [[{
                xtype: 'textarea',
                height: 180,
                disabled: false,
                readOnly: false,
                fieldLabel: this.app.i18n._('Description'),
                name: 'description',
                columnWidth: 1
              }]]
            }]
          }]
        }]
      }, this.extraFreeTimeGridPanel, new Tine.widgets.activities.ActivitiesTabPanel({
        app: this.appName,
        record_id: this.record.id,
        record_model: this.appName + '_Model_' + this.recordClass.getMeta('modelName')
      })]
    };
  }
});

/***/ }),

/***/ 1533:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     HumanResources
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2009-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 * TODO make config saving work and activate update action again
 */
Ext.ns('Tine.HumanResources');
/**
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.AdminPanel
 * @extends     Ext.FormPanel
 * @author      Alexander Stintzing <alex@stintzing.net>
 */

Tine.HumanResources.AdminPanel = Ext.extend(Ext.FormPanel, {
  appName: 'HumanResources',
  layout: 'fit',
  border: false,
  cls: 'tw-editdialog',
  labelAlign: 'top',
  anchor: '100% 100%',
  deferredRender: false,
  buttonAlign: null,
  bufferResize: 500,

  /**
   * init component
   */
  initComponent: function initComponent() {
    if (!this.app) {
      this.app = Tine.Tinebase.appMgr.get(this.appName);
    }

    Tine.log.debug('initComponent: appName: ', this.appName);
    Tine.log.debug('initComponent: app: ', this.app); // init actions

    this.initActions(); // init buttons and tbar

    this.initButtons(); // get items for this dialog

    this.items = this.getFormItems();
    this.loadRecord();
    Tine.HumanResources.AdminPanel.superclass.initComponent.call(this);
  },

  /**
   * init actions
   */
  initActions: function initActions() {
    this.action_cancel = new Ext.Action({
      text: this.app.i18n._('Cancel'),
      minWidth: 70,
      scope: this,
      handler: this.onCancel,
      iconCls: 'action_cancel'
    });
    this.action_update = new Ext.Action({
      text: this.app.i18n._('OK'),
      minWidth: 70,
      scope: this,
      handler: this.onUpdate,
      iconCls: 'action_saveAndClose'
    });
  },

  /**
   * init buttons
   */
  initButtons: function initButtons() {
    this.fbar = ['->', this.action_cancel, this.action_update];
  },

  /**
   * is called when the component is rendered
   * @param {} ct
   * @param {} position
   */
  onRender: function onRender(ct, position) {
    Tine.HumanResources.AdminPanel.superclass.onRender.call(this, ct, position); // generalized keybord map for edit dlgs

    new Ext.KeyMap(this.el, [{
      key: [10, 13],
      // ctrl + return
      ctrl: true,
      fn: this.onUpdate,
      scope: this
    }]);
    this.loadMaskCt = ct;
  },

  /**
   * closes the window
   */
  onCancel: function onCancel() {
    this.fireEvent('cancel');
    this.purgeListeners();
    this.window.close();
  },

  /**
   * save record and close window
   */
  onUpdate: function onUpdate() {
    // check date
    var date = this.getForm().findField('vacationExpires').getValue();
    dates = date.split(/-/);
    var date = new Date(2013, parseInt(dates[0]) - 1, dates[1]);

    if (!(parseInt(date.format('m')) == parseInt(dates[0]) && parseInt(date.format('d')) == parseInt(dates[1]))) {
      this.getForm().findField('vacationExpires').markInvalid(this.app.i18n._('Please use the following format: MM-DD'));
      return;
    }

    if (!this.loadMask) {
      this.loadMask = new Ext.LoadMask(this.loadMaskCt);
    }

    this.loadMask.msg = 'Saving...';
    this.loadMask.show();
    Ext.Ajax.request({
      url: 'index.php',
      scope: this,
      params: {
        method: 'HumanResources.setConfig',
        config: {
          defaultFeastCalendar: this.getForm().findField('defaultFeastCalendar').getValue(),
          vacationExpires: this.getForm().findField('vacationExpires').getValue()
        }
      },
      success: function success(_result, _request) {
        this.loadMask.hide(); // reload mainscreen to make sure registry gets updated

        Tine.Tinebase.common.reload();
      }
    });
  },
  loadRecord: function loadRecord() {
    if (!this.rendered) {
      this.loadRecord.defer(100, this);
      return false;
    }

    this.loadMask = new Ext.LoadMask(this.loadMaskCt);
    this.loadMask.show();
    var config = Tine.HumanResources.registry.get('config');
    var calId = config.defaultFeastCalendar.value;

    if (calId) {
      var request = Ext.Ajax.request({
        url: 'index.php',
        scope: this,
        params: {
          method: 'Admin.getContainer',
          id: calId
        },
        success: function success(_result, _request) {
          this.onRecordLoad(Ext.decode(_result.responseText), config.vacationExpires.value);
        }
      });
    } else {
      this.onRecordLoad(null, config.vacationExpires.value);
    }
  },
  onRecordLoad: function onRecordLoad(defaultFeastCalendar, vacationExpires) {
    this.getForm().findField('defaultFeastCalendar').setValue(defaultFeastCalendar);
    this.getForm().findField('vacationExpires').setValue(vacationExpires);
    this.loadMask.hide();
  },

  /**
   * create and return form items
   * @return Object
   */
  getFormItems: function getFormItems() {
    var dfc = Tine.HumanResources.registry.get('config').defaultFeastCalendar;
    return {
      border: false,
      frame: false,
      layout: 'border',
      items: [{
        region: 'center',
        border: false,
        frame: false,
        layout: {
          align: 'stretch',
          type: 'vbox'
        },
        items: [{
          layout: 'form',
          margins: '10px 10px',
          border: false,
          frame: false,
          items: [Tine.widgets.form.RecordPickerManager.get('Tinebase', 'Container', {
            containerName: this.app.i18n._('Calendar'),
            containersName: this.app.i18n._('Calendars'),
            recordClass: Tine.Calendar.Model.Event,
            appName: 'Calendar',
            requiredGrant: 'readGrant',
            hideTrigger2: true,
            allowBlank: false,
            fieldLabel: this.app.i18n._(dfc.definition.label),
            name: 'defaultFeastCalendar',
            blurOnSelect: true
          }), new Ext.form.TextField({
            fieldLabel: this.app.i18n._('Vacation expires'),
            name: 'vacationExpires'
          })]
        }]
      }]
    };
  }
});

Tine.HumanResources.AdminPanel.openWindow = function (config) {
  var window = Tine.WindowFactory.getWindow({
    modal: true,
    width: 240,
    height: 250,
    contentPanelConstructor: 'Tine.HumanResources.AdminPanel',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 1534:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2013-2019 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.HumanResources');
/**
 * @namespace   Tine.HumanResources
 * @class       Tine.HumanResources.WorkingTimeSchemeEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * 
 * @param       {Object} config
 * @constructor
 */

Tine.HumanResources.WorkingTimeSchemeEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowNamePrefix: 'WorkingTimeEditWindow_',
  appName: 'HumanResources',
  modelName: 'WorkingTimeScheme',
  windowHeight: 500,
  evalGrants: false,

  /**
   * overwrite update toolbars function (we don't have record grants yet)
   * @private
   */
  updateToolbars: function updateToolbars() {},

  /**
   * inits the component
   */
  initComponent: function initComponent() {
    this.recordClass = Tine.HumanResources.Model.WorkingTimeScheme;
    Tine.HumanResources.WorkingTimeSchemeEditDialog.superclass.initComponent.call(this);
  },

  /**
   * executed after record got updated from proxy, if json Data is given, it's used
   * 
   * @private
   */
  onRecordLoad: function onRecordLoad(jsonData) {
    Tine.HumanResources.WorkingTimeSchemeEditDialog.superclass.onRecordLoad.call(this);
    var jsonData = jsonData || this.record.get('json') || null;

    if (Ext.isString(jsonData)) {
      jsonData = Ext.decode(jsonData);
    }

    if (jsonData) {
      this.applyJsonData(jsonData);
    }

    var type = this.record.get('type');

    if (type == 'individual') {
      this.setReadOnly(true);
    }

    if (type == 'shared') {
      this.typeCombo.readOnly = true;
    }
  },
  setReadOnly: function setReadOnly(readOnly) {
    this.typeCombo.readOnly = true;
    this.blConfigPanel.setReadOnly(readOnly);
    this.getForm().items.each(function (formField) {
      if (formField.name.match(/^weekdays/)) {
        formField.setDisabled(readOnly);
      }
    }, this);
    this.btnSaveAndClose.setDisabled(readOnly);
  },

  /**
   * applies the json data to the form
   * 
   * @param {Object} jsonData
   */
  applyJsonData: function applyJsonData(jsonData) {
    var days = jsonData.days,
        form = this.getForm(),
        sum = 0.0;

    for (var index = 0; index < 7; index++) {
      form.findField('weekdays_' + index).setValue(days[index]);
      sum = sum + parseFloat(days[index]);
    }

    form.findField('working_hours').setValue(sum);
  },
  updateWorkingHours: function updateWorkingHours(formField, newValue, oldValue) {
    var sum = 0;

    for (var index = 0; index < 7; index++) {
      sum += this.getForm().findField('weekdays_' + index).getValue();
    }

    this.getForm().findField('working_hours').setValue(sum);
  },

  /**
   * returns appropriate json for the template or the contract
   * 
   * @return {String}
   */
  getJson: function getJson() {
    var values = this.getForm().getFieldValues(),
        days = [];

    for (var index = 0; index < 7; index++) {
      days[index] = parseFloat(values['weekdays_' + index]);
    }

    return {
      days: days
    };
  },

  /**
   * closes open subpanels on cancel
   */
  onCancel: function onCancel() {
    Tine.HumanResources.ContractEditDialog.superclass.onCancel.call(this);
  },

  /**
   * executed when record gets updated from form
   * @private
   */
  onRecordUpdate: function onRecordUpdate() {
    Tine.HumanResources.ContractEditDialog.superclass.onRecordUpdate.call(this);
    this.record.set('json', this.getJson());
  },
  onAfterRecordLoad: function onAfterRecordLoad() {
    Tine.HumanResources.WorkingTimeSchemeEditDialog.superclass.onAfterRecordLoad.call(this);
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   * 
   * @return {Object}
   * @private
   */
  getFormItems: function getFormItems() {
    // blpipes is of type records with subrecord hr.blconfig
    this.blConfigPanel = new Tine.Tinebase.BL.BLConfigPanel({
      app: this.app,
      editDialog: this,
      title: this.app.i18n._('Working Time Rules')
    });
    var weekdayFieldDefaults = {
      xtype: 'durationspinner',
      baseUnit: 'seconds',
      anchor: '100%',
      labelSeparator: '',
      allowBlank: false,
      columnWidth: 1 / 7,
      listeners: {
        scope: this,
        blur: this.updateWorkingHours.createDelegate(this),
        spin: this.updateWorkingHours.createDelegate(this)
      }
    };
    return {
      xtype: 'tabpanel',
      plain: true,
      plugins: [{
        ptype: 'ux.tabpanelkeyplugin'
      }],
      defaults: {
        hideMode: 'offsets'
      },
      activeTab: 0,
      items: [{
        title: this.app.i18n._('Working Time Schema'),
        autoScroll: true,
        border: false,
        frame: true,
        layout: 'border',
        items: [{
          region: 'north',
          height: 130,
          layout: 'hfit',
          border: false,
          items: [this.typeCombo = new Ext.form.ComboBox({
            name: 'type',
            fieldLabel: this.app.i18n._('Type'),
            store: [['template', this.app.i18n._('Template (individual working time schemas are created for each contract)')], ['shared', this.app.i18n._('Shared (this working time schemas can be shared among contracts)')]]
          }), {
            xtype: 'fieldset',
            layout: 'hfit',
            autoHeight: true,
            title: this.app.i18n._('Working Time'),
            items: [{
              xtype: 'columnform',
              items: [[Tine.widgets.form.FieldManager.get(this.appName, this.modelName, 'title', Tine.widgets.form.FieldManager.CATEGORY_EDITDIALOG, {
                columnWidth: 2 / 3
              }), {
                fieldLabel: this.app.i18n._('Working Hours per week'),
                xtype: 'durationspinner',
                baseUnit: 'seconds',
                name: 'working_hours',
                disabled: true,
                columnWidth: 1 / 3
              }], [Ext.apply({
                fieldLabel: this.app.i18n._('Mon.'),
                name: 'weekdays_0'
              }, weekdayFieldDefaults), Ext.apply({
                fieldLabel: this.app.i18n._('Tue.'),
                name: 'weekdays_1'
              }, weekdayFieldDefaults), Ext.apply({
                fieldLabel: this.app.i18n._('Wed.'),
                name: 'weekdays_2'
              }, weekdayFieldDefaults), Ext.apply({
                fieldLabel: this.app.i18n._('Thu.'),
                name: 'weekdays_3'
              }, weekdayFieldDefaults), Ext.apply({
                fieldLabel: this.app.i18n._('Fri.'),
                name: 'weekdays_4'
              }, weekdayFieldDefaults), Ext.apply({
                fieldLabel: this.app.i18n._('Sat.'),
                name: 'weekdays_5'
              }, weekdayFieldDefaults), Ext.apply({
                fieldLabel: this.app.i18n._('Sun.'),
                name: 'weekdays_6'
              }, weekdayFieldDefaults)]]
            }]
          }]
        }, {
          region: 'center',
          layout: 'fit',
          flex: 1,
          border: false,
          items: [this.blConfigPanel // this.breaksPanel
          ]
        }]
      }]
    };
  },
  updateTemplate: function updateTemplate(combo, record, index) {
    this.applyJsonData(Ext.decode(record.get('json')));
  }
});
/**
 * Opens a new contact edit dialog window
 *
 * @return {Ext.ux.Window}
 */

Tine.HumanResources.WorkingTimeSchemeEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 600,
    height: 520,
    name: Tine.HumanResources.WorkingTimeSchemeEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.HumanResources.WorkingTimeSchemeEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 1535:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(1536);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(19)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 1536:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(189);
exports = module.exports = __webpack_require__(18)(false);
// imports


// module
exports.push([module.i, "/**\n * Tine 2.0\n * \n * @package     HumanResources\n * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3\n * @author      Alexander Stintzing <a.stintzing@metaways.de>\n * @copyright   Copyright (c) 2007-2012 Metaways Infosystems GmbH (http://www.metaways.de)\n *\n */\n \n.HumanResourcesEmployee, .HumanResourcesIconCls {\n    background-image:url(" + escape(__webpack_require__(1537)) + ") !important;\n}\n\n.HumanResourcesAccount {\n    background-image:url(" + escape(__webpack_require__(362)) + ") !important;\n}\n\n.HumanResourcesDailyWTReport {\n    background-image:url(" + escape(__webpack_require__(242)) + ") !important;\n}\n\n.HumanResourcesMonthlyWTReport {\n    background-image:url(" + escape(__webpack_require__(355)) + ") !important;\n}\n\n.action_create_reports,\n.action_create_accounts,\n.applyContactData {\n    background-image:url(" + escape(__webpack_require__(347)) + ") !important;\n}\n\n.HumanResources .x-date-picker {\n    border-color: #B5B8C8!important;\n}\n\n.hr-date-sickness a, .hr-date-vacation a, .hr-date-feast a {\n    color: white!important;\n}\n\n.hr-date-sickness {\n    background-color: #e1d8d3!important;\n}\n\n.hr-date-vacation {\n    background-color: #8DB2E3!important;\n}\n\n.hr-date-feast {\n    background-color: #ffac71!important;\n}\n\n.FreeTimePlanning {\n    background-image:url(" + escape(__webpack_require__(1538)) + ") !important;\n}\n\n.hr-freetimeplanning-daycell {\n    box-sizing: border-box;\n    text-align: center;\n    padding-top: 1px;\n    margin: -3px;\n    height: 17px;\n    border: 1px solid lightgrey;\n}\n\n.x-grid3-cell-selected .hr-freetimeplanning-daycell {\n    border: 2px solid #b8cfee;\n    border-right: 3px solid #b8cfee;\n}\n", ""]);

// exports


/***/ }),

/***/ 1537:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M31.2,29.1c4.5-6.1,3.9-14.7-1.7-20C23.4,3.4,13.9,3.7,8.1,9.7c-5.7,6.1-5.5,15.6,0.6,21.4c5.6,5.3,14.3,5.5,20.1,0.7 M10.6,29.1c-4.9-4.7-5.2-12.5-0.5-17.5c4.7-4.9,12.5-5.2,17.5-0.5c4.9,4.7,5.2,12.5,0.5,17.5C23.4,33.6,15.6,33.8,10.6,29.1z M31.2,29.1l7.2,6.8c0.4,0.3,0.5,0.8,0.6,1.2c0,0.5-0.2,0.9-0.5,1.3S37.7,39,37.2,39c-0.5,0-0.9-0.2-1.3-0.5l-7.2-6.8 M26.8,25.3 c0,0.9-0.3,1.6-0.8,2.2c-0.5,0.6-1.1,0.9-1.8,0.9H14c-0.7,0-1.3-0.3-1.8-0.9s-0.8-1.4-0.8-2.2c0-0.7,0-1.3,0.1-1.9 c0.1-0.6,0.2-1.2,0.4-1.8c0.2-0.6,0.4-1.1,0.7-1.6c0.3-0.4,0.7-0.8,1.1-1.1c0.5-0.3,1-0.4,1.6-0.4c1.1,1,2.3,1.5,3.8,1.5 c1.5,0,2.7-0.5,3.8-1.5c0.6,0,1.1,0.1,1.6,0.4c0.5,0.3,0.8,0.6,1.1,1.1s0.5,1,0.7,1.6c0.2,0.6,0.3,1.2,0.4,1.8 C26.8,23.9,26.8,24.6,26.8,25.3z M23.7,14.6c0,1.3-0.5,2.4-1.4,3.3c-0.9,0.9-2,1.4-3.3,1.4c-1.3,0-2.4-0.5-3.3-1.4 c-0.9-0.9-1.4-2-1.4-3.3s0.5-2.4,1.4-3.3s2-1.4,3.3-1.4c1.3,0,2.4,0.5,3.3,1.4S23.7,13.3,23.7,14.6z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1538:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cstyle type='text/css'%3E .st0%7Bfill:%23FFFFFF;%7D .st1%7Bfill:%2304BAEE;%7D %3C/style%3E %3Crect x='6.7' y='15.3' class='st0' width='28.3' height='20.9'/%3E %3Cpath class='st1' d='M12.9,21.6H7.4v-5.5h5.5V21.6z M20.8,22.8H14v6.1h6.7V22.8z M27.8,30.1h-7.2v5.5h7.2V30.1z'/%3E %3Cpath d='M7.4,35.6h5.5v-5.5H7.4V35.6z M14.1,35.6h6.1v-5.5h-6.1V35.6z M7.4,28.9h5.5v-6.1H7.4V28.9z M14.1,28.9h6.1v-6.1h-6.1V28.9z M7.4,21.6h5.5v-5.5H7.4V21.6z M21.4,35.6h6.1v-5.5h-6.1V35.6z M14.1,21.6h6.1v-5.5h-6.1V21.6z M28.7,35.6h5.5v-5.5h-5.5V35.6z M21.4,28.9h6.1v-6.1h-6.1V28.9z M14.7,12.5V7c0-0.2-0.1-0.3-0.2-0.4s-0.3-0.2-0.4-0.2h-1.2c-0.2,0-0.3,0.1-0.4,0.2 c-0.1,0.1-0.2,0.3-0.2,0.4v5.5c0,0.2,0.1,0.3,0.2,0.4c0.1,0.1,0.3,0.2,0.4,0.2h1.2c0.2,0,0.3-0.1,0.4-0.2 C14.7,12.8,14.7,12.7,14.7,12.5z M28.7,28.9h5.5v-6.1h-5.5V28.9z M21.4,21.6h6.1v-5.5h-6.1V21.6z M28.7,21.6h5.5v-5.5h-5.5V21.6z M29.3,12.5V7c0-0.2-0.1-0.3-0.2-0.4s-0.3-0.2-0.4-0.2h-1.2c-0.2,0-0.3,0.1-0.4,0.2S26.9,6.9,26.9,7v5.5c0,0.2,0.1,0.3,0.2,0.4 c0.1,0.1,0.3,0.2,0.4,0.2h1.2c0.2,0,0.3-0.1,0.4-0.2C29.2,12.8,29.3,12.7,29.3,12.5z M36.6,11.3v24.3c0,0.7-0.2,1.2-0.7,1.7 c-0.5,0.5-1.1,0.7-1.7,0.7H7.4c-0.7,0-1.2-0.2-1.7-0.7C5.2,36.8,5,36.2,5,35.6V11.3c0-0.7,0.2-1.2,0.7-1.7c0.5-0.5,1.1-0.7,1.7-0.7 h2.4V7c0-0.8,0.3-1.6,0.9-2.1S12.1,4,12.9,4h1.2c0.8,0,1.6,0.3,2.1,0.9c0.6,0.6,0.9,1.3,0.9,2.1v1.8h7.3V7c0-0.8,0.3-1.6,0.9-2.1 C25.9,4.3,26.6,4,27.5,4h1.2c0.8,0,1.6,0.3,2.1,0.9s0.9,1.3,0.9,2.1v1.8h2.4c0.7,0,1.2,0.2,1.7,0.7C36.3,10.1,36.6,10.6,36.6,11.3z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 179:
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(1509);
__webpack_require__(1510);
__webpack_require__(1511);
__webpack_require__(1512);
__webpack_require__(1517);
__webpack_require__(1518);
__webpack_require__(1519);
__webpack_require__(1520);
__webpack_require__(1521);
__webpack_require__(1522);
__webpack_require__(1523);
__webpack_require__(1524);
__webpack_require__(1525);
__webpack_require__(1526);
__webpack_require__(1527);
__webpack_require__(1528);
__webpack_require__(1529);
__webpack_require__(1530);
__webpack_require__(1531);
__webpack_require__(1532);
__webpack_require__(1533);
__webpack_require__(1534);
__webpack_require__(1535);


/***/ }),

/***/ 18:
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),

/***/ 189:
/***/ (function(module, exports) {

module.exports = function escape(url) {
    if (typeof url !== 'string') {
        return url
    }
    // If url is already wrapped in quotes, remove them
    if (/^['"].*['"]$/.test(url)) {
        url = url.slice(1, -1);
    }
    // Should url be wrapped?
    // See https://drafts.csswg.org/css-values-3/#urls
    if (/["'() \t\n]/.test(url)) {
        return '"' + url.replace(/"/g, '\\"').replace(/\n/g, '\\n') + '"'
    }

    return url
}


/***/ }),

/***/ 19:
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getElement = (function (fn) {
	var memo = {};

	return function(selector) {
		if (typeof memo[selector] === "undefined") {
			var styleTarget = fn.call(this, selector);
			// Special case to return head of iframe instead of iframe itself
			if (styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[selector] = styleTarget;
		}
		return memo[selector]
	};
})(function (target) {
	return document.querySelector(target)
});

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(75);

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
	if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertInto + " " + options.insertAt.before);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	options.attrs.type = "text/css";

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	options.attrs.type = "text/css";
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = options.transform(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),

/***/ 242:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cstyle type='text/css'%3E .st0%7Bfill:%23FFFFFF;%7D .st1%7Bfill:%2304BAEE;%7D %3C/style%3E %3Cpath class='st0' d='M34.2,14.5h-27v21.3h27V14.5z'/%3E %3Cpath class='st1' d='M27.5,22.8h-6.1v6.1h6.1V22.8z'/%3E %3Cpath d='M7.4,35.6h5.5v-5.5H7.4V35.6z M14.1,35.6h6.1v-5.5h-6.1V35.6z M7.4,28.9h5.5v-6.1H7.4V28.9z M14.1,28.9h6.1v-6.1h-6.1V28.9z M7.4,21.6h5.5v-5.5H7.4V21.6z M21.4,35.6h6.1v-5.5h-6.1V35.6z M14.1,21.6h6.1v-5.5h-6.1V21.6z M28.7,35.6h5.5v-5.5h-5.5V35.6z M21.4,28.9h6.1v-6.1h-6.1V28.9z M14.7,12.5V7c0-0.2-0.1-0.3-0.2-0.4s-0.3-0.2-0.4-0.2h-1.2c-0.2,0-0.3,0.1-0.4,0.2 c-0.1,0.1-0.2,0.3-0.2,0.4v5.5c0,0.2,0.1,0.3,0.2,0.4c0.1,0.1,0.3,0.2,0.4,0.2h1.2c0.2,0,0.3-0.1,0.4-0.2 C14.7,12.8,14.7,12.7,14.7,12.5z M28.7,28.9h5.5v-6.1h-5.5V28.9z M21.4,21.6h6.1v-5.5h-6.1V21.6z M28.7,21.6h5.5v-5.5h-5.5V21.6z M29.3,12.5V7c0-0.2-0.1-0.3-0.2-0.4s-0.3-0.2-0.4-0.2h-1.2c-0.2,0-0.3,0.1-0.4,0.2S26.9,6.9,26.9,7v5.5c0,0.2,0.1,0.3,0.2,0.4 c0.1,0.1,0.3,0.2,0.4,0.2h1.2c0.2,0,0.3-0.1,0.4-0.2C29.2,12.8,29.3,12.7,29.3,12.5z M36.6,11.3v24.3c0,0.7-0.2,1.2-0.7,1.7 c-0.5,0.5-1.1,0.7-1.7,0.7H7.4c-0.7,0-1.2-0.2-1.7-0.7C5.2,36.8,5,36.2,5,35.6V11.3c0-0.7,0.2-1.2,0.7-1.7c0.5-0.5,1.1-0.7,1.7-0.7 h2.4V7c0-0.8,0.3-1.6,0.9-2.1S12.1,4,12.9,4h1.2c0.8,0,1.6,0.3,2.1,0.9c0.6,0.6,0.9,1.3,0.9,2.1v1.8h7.3V7c0-0.8,0.3-1.6,0.9-2.1 C25.9,4.3,26.6,4,27.5,4h1.2c0.8,0,1.6,0.3,2.1,0.9s0.9,1.3,0.9,2.1v1.8h2.4c0.7,0,1.2,0.2,1.7,0.7C36.3,10.1,36.6,10.6,36.6,11.3z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 347:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M25.5,20.2l-3.4-3.4l3.7-3.7l3.4,3.4L25.5,20.2z M10.4,35.3l13.8-13.8l-3.4-3.4L7,32L10.4,35.3z M17.9,10v1.5h-1.5v1.3h1.5 v1.5h1.3v-1.5h1.5v-1.3h-1.5V10H17.9z M30.6,7v1.5H29v1.3h1.5v1.5h1.3V9.8h1.5V8.5h-1.5V7H30.6z M35.5,16.4H34v-1.5h-1.3v1.5h-1.5 v1.3h1.5v1.5H34v-1.5h1.5V16.4z M35.5,16.4'/%3E %3C/svg%3E\""

/***/ }),

/***/ 355:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cstyle type='text/css'%3E .st0%7Bfill:%2304BAEE;%7D %3C/style%3E %3Cpath class='st0' d='M34.2,35.7H7.4V16.1h26.7V35.7z'/%3E %3Cpath d='M7.4,35.6h5.5v-5.5H7.4V35.6z M14.1,35.6h6.1v-5.5h-6.1V35.6z M7.4,28.9h5.5v-6.1H7.4V28.9z M14.1,28.9h6.1v-6.1h-6.1V28.9z M7.4,21.6h5.5v-5.5H7.4V21.6z M21.4,35.6h6.1v-5.5h-6.1V35.6z M14.1,21.6h6.1v-5.5h-6.1V21.6z M28.7,35.6h5.5v-5.5h-5.5V35.6z M21.4,28.9h6.1v-6.1h-6.1V28.9z M14.7,12.5V7c0-0.2-0.1-0.3-0.2-0.4s-0.3-0.2-0.4-0.2h-1.2c-0.2,0-0.3,0.1-0.4,0.2 c-0.1,0.1-0.2,0.3-0.2,0.4v5.5c0,0.2,0.1,0.3,0.2,0.4c0.1,0.1,0.3,0.2,0.4,0.2h1.2c0.2,0,0.3-0.1,0.4-0.2 C14.7,12.8,14.7,12.7,14.7,12.5z M28.7,28.9h5.5v-6.1h-5.5V28.9z M21.4,21.6h6.1v-5.5h-6.1V21.6z M28.7,21.6h5.5v-5.5h-5.5V21.6z M29.3,12.5V7c0-0.2-0.1-0.3-0.2-0.4s-0.3-0.2-0.4-0.2h-1.2c-0.2,0-0.3,0.1-0.4,0.2S26.9,6.9,26.9,7v5.5c0,0.2,0.1,0.3,0.2,0.4 c0.1,0.1,0.3,0.2,0.4,0.2h1.2c0.2,0,0.3-0.1,0.4-0.2C29.2,12.8,29.3,12.7,29.3,12.5z M36.6,11.3v24.3c0,0.7-0.2,1.2-0.7,1.7 c-0.5,0.5-1.1,0.7-1.7,0.7H7.4c-0.7,0-1.2-0.2-1.7-0.7C5.2,36.8,5,36.2,5,35.6V11.3c0-0.7,0.2-1.2,0.7-1.7c0.5-0.5,1.1-0.7,1.7-0.7 h2.4V7c0-0.8,0.3-1.6,0.9-2.1S12.1,4,12.9,4h1.2c0.8,0,1.6,0.3,2.1,0.9c0.6,0.6,0.9,1.3,0.9,2.1v1.8h7.3V7c0-0.8,0.3-1.6,0.9-2.1 C25.9,4.3,26.6,4,27.5,4h1.2c0.8,0,1.6,0.3,2.1,0.9s0.9,1.3,0.9,2.1v1.8h2.4c0.7,0,1.2,0.2,1.7,0.7C36.3,10.1,36.6,10.6,36.6,11.3z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 362:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M34.8,28.5c0.6-0.3,1.1-0.7,1.6-1.2v3.5c0,1.2-0.4,2.3-1.3,3.2c-0.9,0.9-1.9,1.3-3.2,1.3H7.5c-1.2,0-2.3-0.4-3.2-1.3 C3.4,33.1,3,32,3,30.8V11.5c0-1.2,0.4-2.3,1.3-3.2C5.2,7.4,6.3,7,7.5,7h6.4c1.2,0,2.3,0.4,3.2,1.3s1.3,1.9,1.3,3.2v0.6h5.5 c-0.9,0.7-1.7,1.6-2.3,2.6h-3.8c-0.5,0-1-0.2-1.4-0.6c-0.4-0.4-0.6-0.8-0.6-1.4v-1.3c0-0.5-0.2-1-0.6-1.4c-0.4-0.4-0.8-0.6-1.4-0.6 H7.5c-0.5,0-1,0.2-1.4,0.6c-0.4,0.4-0.6,0.8-0.6,1.4v19.3c0,0.5,0.2,1,0.6,1.4c0.4,0.4,0.8,0.6,1.4,0.6h24.4c0.5,0,1-0.2,1.4-0.6 c0.4-0.4,0.6-0.8,0.6-1.4V29C34.1,28.8,34.5,28.6,34.8,28.5z M38.4,15c-0.9-1.5-2.1-2.7-3.6-3.6c-1.5-0.9-3.1-1.3-4.9-1.3 s-3.4,0.4-4.9,1.3c-0.4,0.2-0.7,0.5-1,0.7h5.9c0,0,0,0,0.1,0s0,0,0.1,0h2c1.2,0,2.3,0.4,3.2,1.3c0.5,0.5,0.9,1.2,1.1,1.9 c0.2,0.2,0.3,0.5,0.5,0.7c0.7,1.2,1,2.5,1,3.9c0,1.4-0.3,2.7-1,3.9c-0.1,0.1-0.2,0.3-0.3,0.4v3c0.8-0.7,1.5-1.5,2-2.4 c0.9-1.5,1.3-3.1,1.3-4.9C39.7,18.2,39.3,16.5,38.4,15z M29.9,27.8c-1.4,0-2.7-0.3-3.9-1c-1.2-0.7-2.1-1.6-2.8-2.8 c-0.7-1.2-1-2.5-1-3.9c0-1.4,0.3-2.7,1-3.9c0.3-0.5,0.6-0.9,1-1.3h-2.5c-0.1,0.1-0.1,0.2-0.2,0.3c-0.9,1.5-1.3,3.1-1.3,4.9 c0,1.8,0.4,3.4,1.3,4.9c0.9,1.5,2.1,2.7,3.6,3.6s3.1,1.3,4.9,1.3c1.4,0,2.7-0.3,3.9-0.8v-2.3c0,0,0,0,0,0 C32.6,27.4,31.3,27.8,29.9,27.8z M36.2,15.3c-0.2-0.7-0.6-1.3-1.1-1.9c-0.9-0.9-1.9-1.3-3.2-1.3h-2c1.4,0,2.7,0.4,3.9,1 C34.7,13.7,35.5,14.5,36.2,15.3z M33.8,26.7V29c0.3-0.1,0.7-0.3,1-0.5c0.6-0.3,1.1-0.7,1.6-1.2v-3C35.7,25.3,34.9,26.1,33.8,26.7z M21.6,14.7h2.5c0.5-0.6,1.2-1.1,1.9-1.5c1.2-0.7,2.5-1,3.9-1h-5.9C23,12.8,22.2,13.7,21.6,14.7z M31.8,15h-1.1 c-0.2,0-0.3,0.1-0.4,0.2c-0.1,0.1-0.2,0.2-0.2,0.4v6.2h-3.9c-0.2,0-0.3,0.1-0.4,0.2c-0.1,0.1-0.2,0.2-0.2,0.4v1.1 c0,0.2,0.1,0.3,0.2,0.4C25.9,24,26,24,26.2,24h5.6c0.2,0,0.3-0.1,0.4-0.2c0.1-0.1,0.2-0.2,0.2-0.4v-7.9c0-0.2-0.1-0.3-0.2-0.4 C32.1,15.1,32,15,31.8,15z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 75:
/***/ (function(module, exports) {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ })

}]);