(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[20],{

/***/ 1657:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 *
 * @package     Tasks
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Tasks.Model'); // Task model

Tine.Tasks.Model.TaskArray = Tine.Tinebase.Model.genericFields.concat([{
  name: 'id'
}, {
  name: 'uid'
}, {
  name: 'percent',
  header: 'Percent'
}, {
  name: 'completed',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long
}, {
  name: 'due',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long
}, // ical common fields
{
  name: 'class'
}, {
  name: 'description'
}, {
  name: 'geo'
}, {
  name: 'location'
}, {
  name: 'organizer'
}, {
  name: 'originator_tz'
}, {
  name: 'priority'
}, {
  name: 'status'
}, {
  name: 'summary'
}, {
  name: 'url'
}, // ical common fields with multiple appearance
{
  name: 'attach'
}, {
  name: 'attendee'
}, {
  name: 'tags'
}, {
  name: 'comment'
}, {
  name: 'contact'
}, {
  name: 'related'
}, {
  name: 'resources'
}, {
  name: 'rstatus'
}, // scheduleable interface fields
{
  name: 'dtstart',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long
}, {
  name: 'duration',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long
}, {
  name: 'recurid'
}, // scheduleable interface fields with multiple appearance
{
  name: 'exdate'
}, {
  name: 'exrule'
}, {
  name: 'rdate'
}, {
  name: 'rrule'
}, // tine 2.0 notes field
{
  name: 'notes'
}, // tine 2.0 alarms field
{
  name: 'alarms'
}, // relations with other objects
{
  name: 'relations'
}, {
  name: 'attachments'
}]);
/**
 * Task record definition
 */

Tine.Tasks.Model.Task = Tine.Tinebase.data.Record.create(Tine.Tasks.Model.TaskArray, {
  appName: 'Tasks',
  modelName: 'Task',
  idProperty: 'id',
  titleProperty: 'summary',
  // ngettext('Task', 'Tasks', n); gettext('Tasks');
  recordName: 'Task',
  recordsName: 'Tasks',
  containerProperty: 'container_id',
  // ngettext('to do list', 'to do lists', n); gettext('to do lists');
  containerName: 'to do list',
  containersName: 'to do lists'
});
/**
 * returns default account data
 *
 * @namespace Tine.Tasks.Model.Task
 * @static
 * @return {Object} default data
 */

Tine.Tasks.Model.Task.getDefaultData = function () {
  var app = Tine.Tinebase.appMgr.get('Tasks');
  return {
    'class': 'PUBLIC',
    percent: 0,
    organizer: Tine.Tinebase.registry.get('currentAccount'),
    container_id: app.getMainScreen().getWestPanel().getContainerTreePanel().getDefaultContainer()
  };
};
/**
 * @namespace Tine.Tasks.Model.Task
 *
 * get task filter
 *
 * @return {Array} filter objects
 * @static
 */


Tine.Tasks.Model.Task.getFilterModel = function () {
  var app = Tine.Tinebase.appMgr.get('Tasks');
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }, {
    filtertype: 'tine.widget.container.filtermodel',
    app: app,
    recordClass: Tine.Tasks.Model.Task
  }, {
    label: app.i18n._('Summary'),
    field: 'summary'
  }, {
    label: app.i18n._('Due Date'),
    field: 'due',
    valueType: 'date',
    operators: ['within', 'before', 'after']
  }, {
    label: app.i18n._('Status'),
    field: 'status',
    filtertype: 'tine.widget.keyfield.filter',
    app: app,
    defaultValue: Tine.Tasks.Model.Task.getClosedStatus(),
    keyfieldName: 'taskStatus',
    defaultOperator: 'notin'
  }, {
    label: app.i18n._('Responsible'),
    field: 'organizer',
    valueType: 'user'
  }, {
    filtertype: 'tinebase.tag',
    app: app
  }, {
    label: i18n._('Last Modified Time'),
    field: 'last_modified_time',
    valueType: 'date'
  }, {
    label: i18n._('Last Modified By'),
    field: 'last_modified_by',
    valueType: 'user'
  }, {
    label: i18n._('Creation Time'),
    field: 'creation_time',
    valueType: 'date'
  }, {
    label: i18n._('Created By'),
    field: 'created_by',
    valueType: 'user'
  }];
};
/**
 * @namespace Tine.Tasks.Model.Task
 *
 * get closed status ids
 *
 * @return {Array} status ids objects
 * @static
 */


Tine.Tasks.Model.Task.getClosedStatus = function () {
  var reqStatus = [];
  Tine.Tinebase.widgets.keyfield.StoreMgr.get('Tasks', 'taskStatus').each(function (status) {
    if (!status.get('is_open')) {
      reqStatus.push(status.get('id'));
    }
  }, this);
  return reqStatus;
};
/**
 * default tasks backend
 */


Tine.Tasks.JsonBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'Tasks',
  modelName: 'Task',
  recordClass: Tine.Tasks.Model.Task
});
Tine.Tasks.Model.Status = Tine.Tinebase.data.Record.create([{
  name: 'id'
}, {
  name: 'value'
}, {
  name: 'icon'
}, {
  name: 'system'
}, {
  name: 'is_open'
}, {
  name: 'i18nValue'
}], {
  appName: 'Tasks',
  modelName: 'Status',
  idProperty: 'id',
  titleProperty: 'i18nValue',
  // ngettext('Status', 'Status', n); gettext('Status');
  recordName: 'Status',
  recordsName: 'Status'
});

/***/ }),

/***/ 1658:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Tasks
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine', 'Tine.Tasks');
Tine.Tasks.CrmLeadRenderer = new Tine.widgets.relation.GridRenderer({
  appName: 'Tasks',
  type: 'TASK',
  foreignApp: 'Crm',
  foreignModel: 'Lead'
});
Tine.widgets.grid.RendererManager.register('Tasks', 'Task', 'lead', Tine.Tasks.CrmLeadRenderer.render, null, Tine.Tasks.CrmLeadRenderer);
/**
 * @namespace   Tine.Tasks
 * @class       Tine.Tasks.Application
 * @extends     Tine.Tinebase.Application
 * Tasks Application Object <br>
 * 
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 */

Tine.Tasks.Application = Ext.extend(Tine.Tinebase.Application, {
  /**
   * auto hook text i18n._('New Task')
   */
  addButtonText: 'New Task'
}); // default mainscreen

Tine.Tasks.MainScreen = Ext.extend(Tine.widgets.MainScreen, {
  activeContentType: 'Task'
});

Tine.Tasks.TaskTreePanel = function (config) {
  Ext.apply(this, config);
  this.id = 'TasksTreePanel';
  this.recordClass = Tine.Tasks.Model.Task;
  this.filterMode = 'filterToolbar';
  Tine.Tasks.TaskTreePanel.superclass.constructor.call(this);
};

Ext.extend(Tine.Tasks.TaskTreePanel, Tine.widgets.container.TreePanel, {
  afterRender: function afterRender() {
    this.supr().afterRender.apply(this, arguments);
  }
});

Tine.Tasks.TaskFilterPanel = function (config) {
  Ext.apply(this, config);
  Tine.Tasks.TaskFilterPanel.superclass.constructor.call(this);
};

Ext.extend(Tine.Tasks.TaskFilterPanel, Tine.widgets.persistentfilter.PickerPanel, {
  filter: [{
    field: 'model',
    operator: 'equals',
    value: 'Tasks_Model_TaskFilter'
  }]
});

/***/ }),

/***/ 1659:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Tasks
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Tasks');
/**
 * Tasks grid panel
 * 
 * @namespace   Tine.Tasks
 * @class       Tine.Tasks.TaskGridPanel
 * @extends     Tine.widgets.grid.GridPanel
 * 
 * <p>Tasks Grid Panel</p>
 * <p><pre>
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2007-2008 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Tasks.TaskGridPanel
 */

Tine.Tasks.TaskGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  /**
   * record class
   * @cfg {Tine.Tasks.Model.Task} recordClass
   */
  recordClass: Tine.Tasks.Model.Task,

  /**
   * @private grid cfg
   */
  defaultSortInfo: {
    field: 'due',
    dir: 'ASC'
  },
  gridConfig: {
    clicksToEdit: 'auto',
    quickaddMandatory: 'summary',
    resetAllOnNew: false,
    autoExpandColumn: 'summary',
    // drag n drop
    enableDragDrop: true,
    ddGroup: 'containerDDGroup'
  },
  // specialised translations
  // ngettext('Do you really want to delete the selected task?', 'Do you really want to delete the selected tasks?', n);
  i18nDeleteQuestion: ['Do you really want to delete the selected task?', 'Do you really want to delete the selected tasks?'],

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.recordProxy = Tine.Tasks.JsonBackend;
    this.gridConfig.cm = this.getColumnModel();
    this.defaultFilters = [{
      field: 'container_id',
      operator: 'equals',
      value: {
        path: Tine.Tinebase.container.getMyNodePath()
      }
    }];
    Tine.Tasks.TaskGridPanel.superclass.initComponent.call(this); // the editGrids onEditComplete calls the focusCell after a edit operation
    // this leads to a 'flicker' effect we dont want!
    // mhh! but disabling this, breaks keynav 
    //this.grid.view.focusCell = Ext.emptyFn;
  },

  /**
   * returns cm
   * @return Ext.grid.ColumnModel
   * @private
   */
  getColumnModel: function getColumnModel() {
    var columns = [{
      id: 'attachments',
      header: window.i18n._('Attachments'),
      tooltip: window.i18n._('Attachments'),
      dataIndex: 'attachments',
      width: 20,
      sortable: false,
      resizable: false,
      renderer: Tine.widgets.grid.attachmentRenderer,
      hidden: false
    }, {
      id: 'tags',
      header: this.app.i18n._('Tags'),
      width: 40,
      dataIndex: 'tags',
      sortable: false,
      renderer: Tine.Tinebase.common.tagsRenderer
    }];

    if (Tine.hasOwnProperty('Crm') && Tine.Tinebase.common.hasRight('run', 'Crm')) {
      columns.push({
        id: 'lead',
        header: this.app.i18n._('Lead name'),
        width: 150,
        dataIndex: 'relations',
        renderer: Tine.widgets.grid.RendererManager.get('Tasks', 'Task', 'lead'),
        sortable: false
      });
    }

    columns = columns.concat([{
      id: 'summary',
      header: this.app.i18n._("Summary"),
      width: 400,
      dataIndex: 'summary',
      quickaddField: new Ext.form.TextField({
        emptyText: this.app.i18n._('Add a task...')
      })
    }, {
      id: 'due',
      header: this.app.i18n._("Due Date"),
      width: 145,
      dataIndex: 'due',
      renderer: Tine.Tinebase.common.dateTimeRenderer,
      editor: new Ext.ux.form.DateTimeField({
        defaultTime: '12:00',
        allowBlank: true
      }),
      quickaddField: new Ext.ux.form.DateTimeField({
        defaultTime: '12:00',
        allowBlank: true
      })
    }, {
      id: 'priority',
      header: this.app.i18n._("Priority"),
      width: 65,
      dataIndex: 'priority',
      renderer: Tine.Tinebase.widgets.keyfield.Renderer.get('Tasks', 'taskPriority'),
      editor: {
        xtype: 'widget-keyfieldcombo',
        app: 'Tasks',
        keyFieldName: 'taskPriority'
      },
      quickaddField: new Tine.Tinebase.widgets.keyfield.ComboBox({
        app: 'Tasks',
        keyFieldName: 'taskPriority'
      })
    }, {
      id: 'percent',
      header: this.app.i18n._("Percent"),
      width: 50,
      dataIndex: 'percent',
      renderer: Ext.ux.PercentRenderer,
      editor: new Ext.ux.PercentCombo({
        autoExpand: true,
        blurOnSelect: true
      }),
      quickaddField: new Ext.ux.PercentCombo({
        autoExpand: true
      })
    }, {
      id: 'status',
      header: this.app.i18n._("Status"),
      width: 85,
      dataIndex: 'status',
      renderer: Tine.Tinebase.widgets.keyfield.Renderer.get('Tasks', 'taskStatus'),
      editor: {
        xtype: 'widget-keyfieldcombo',
        app: 'Tasks',
        keyFieldName: 'taskStatus',
        allowBlank: false
      },
      quickaddField: new Tine.Tinebase.widgets.keyfield.ComboBox({
        app: 'Tasks',
        keyFieldName: 'taskStatus',
        value: 'NEEDS-ACTION',
        // TODO make this work ...
        allowBlank: false
      })
    }, {
      id: 'completed',
      header: this.app.i18n._("Completed"),
      hidden: true,
      width: 70,
      dataIndex: 'completed',
      renderer: Tine.Tinebase.common.dateTimeRenderer
    }, {
      id: 'organizer',
      header: this.app.i18n._('Responsible'),
      width: 200,
      dataIndex: 'organizer',
      renderer: Tine.Tinebase.common.accountRenderer,
      quickaddField: Tine.widgets.form.RecordPickerManager.get('Addressbook', 'Contact', {
        userOnly: true,
        useAccountRecord: true,
        blurOnSelect: true,
        selectOnFocus: true,
        allowBlank: true,
        value: Tine.Tinebase.registry.get('currentAccount')
      })
    }].concat(this.getModlogColumns().concat(this.getCustomfieldColumns())));
    return new Ext.grid.ColumnModel({
      defaults: {
        sortable: true,
        resizable: true
      },
      columns: columns
    });
  },

  /**
   * Return CSS class to apply to rows depending upon due status
   * 
   * @param {Tine.Tasks.Model.Task} record
   * @param {Integer} index
   * @return {String}
   */
  getViewRowClass: function getViewRowClass(record, index) {
    var due = record.get('due');
    var className = '';

    if (record.get('status') == 'COMPLETED') {
      className += 'tasks-grid-completed';
    } else if (due) {
      var dueDay = due.format('Y-m-d');
      var today = new Date().format('Y-m-d');

      if (dueDay == today) {
        className += 'tasks-grid-duetoday';
      } else if (dueDay < today) {
        className += 'tasks-grid-overdue';
      }
    }

    return className;
  }
});

/***/ }),

/***/ 1660:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Tasks
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Tasks');
/**
 * @namespace   Tine.Tasks
 * @class       Tine.Tasks.TaskEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>Tasks Edit Dialog</p>
 * <p>
 * TODO         refactor this: remove initRecord/containerId/relatedApp, 
 *              adopt to normal edit dialog flow and add getDefaultData to task model
 * </p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Tasks.TaskEditDialog
 */

Tine.Tasks.TaskEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @cfg {Number} containerId
   */
  containerId: -1,

  /**
   * @cfg {String} relatedApp
   */
  relatedApp: '',

  /**
   * @private
   */
  labelAlign: 'side',

  /**
   * @private
   */
  windowNamePrefix: 'TasksEditWindow_',
  appName: 'Tasks',
  recordClass: Tine.Tasks.Model.Task,
  recordProxy: Tine.Tasks.JsonBackend,
  showContainerSelector: true,
  displayNotes: true,

  /**
   * @private
   */
  initComponent: function initComponent() {
    if (!this.record) {
      this.record = new this.recordClass(this.recordClass.getDefaultData(), 0);
    }

    this.alarmPanel = new Tine.widgets.dialog.AlarmPanel({});
    Tine.Tasks.TaskEditDialog.superclass.initComponent.call(this);
  },

  /**
   * executed when record is loaded
   * @private
   */
  onRecordLoad: function onRecordLoad() {
    // interrupt process flow until dialog is rendered
    if (!this.rendered) {
      this.onRecordLoad.defer(250, this);
      return;
    }

    Tine.Tasks.TaskEditDialog.superclass.onRecordLoad.apply(this, arguments);
    this.handleCompletedDate(); // update tabpanels

    this.alarmPanel.onRecordLoad(this.record);

    if (!this.copyRecord && !this.record.id) {
      this.window.setTitle(this.app.i18n._('Add New Task'));
    }
  },

  /**
   * executed when record is updated
   * @private
   */
  onRecordUpdate: function onRecordUpdate() {
    Tine.Tasks.TaskEditDialog.superclass.onRecordUpdate.apply(this, arguments);
    this.alarmPanel.onRecordUpdate(this.record);
  },

  /**
   * handling for the completed field
   * @private
   */
  handleCompletedDate: function handleCompletedDate() {
    var statusStore = Tine.Tinebase.widgets.keyfield.StoreMgr.get('Tasks', 'taskStatus'),
        status = this.getForm().findField('status').getValue(),
        statusRecord = statusStore.getById(status),
        completedField = this.getForm().findField('completed');

    if (statusRecord) {
      if (statusRecord.get('is_open') !== 0) {
        completedField.setValue(null);
        completedField.setDisabled(true);
      } else {
        if (!Ext.isDate(completedField.getValue())) {
          completedField.setValue(new Date());
        }

        completedField.setDisabled(false);
      }
    }
  },

  /**
   * checks if form data is valid
   * 
   * @return {Boolean}
   */
  isValid: function isValid() {
    var isValid = true;
    var dueField = this.getForm().findField('due'),
        dueDate = dueField.getValue(),
        alarms = this.alarmPanel.alarmGrid.getFromStoreAsArray();

    if (!Ext.isEmpty(alarms) && !Ext.isDate(dueDate)) {
      dueField.markInvalid(this.app.i18n._('You have to supply a due date, because an alarm ist set!'));
      isValid = false;
    }

    return isValid && Tine.Tasks.TaskEditDialog.superclass.isValid.apply(this, arguments);
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   * @private
   */
  getFormItems: function getFormItems() {
    return {
      xtype: 'tabpanel',
      plain: true,
      activeTab: 0,
      border: false,
      plugins: [{
        ptype: 'ux.tabpanelkeyplugin'
      }],
      defaults: {
        hideMode: 'offsets'
      },
      items: [{
        title: this.app.i18n.n_('Task', 'Tasks', 1),
        autoScroll: true,
        border: false,
        frame: true,
        layout: 'border',
        items: [{
          region: 'center',
          xtype: 'columnform',
          labelAlign: 'top',
          formDefaults: {
            xtype: 'textfield',
            anchor: '100%',
            labelSeparator: '',
            columnWidth: .333
          },
          items: [[{
            columnWidth: 1,
            fieldLabel: this.app.i18n._('Summary'),
            name: 'summary',
            listeners: {
              render: function render(field) {
                field.focus(false, 250);
              }
            },
            allowBlank: false
          }], [new Ext.ux.form.DateTimeField({
            allowBlank: true,
            defaultTime: '12:00',
            fieldLabel: this.app.i18n._('Due date'),
            name: 'due'
          }), new Tine.Tinebase.widgets.keyfield.ComboBox({
            fieldLabel: this.app.i18n._('Priority'),
            name: 'priority',
            app: 'Tasks',
            keyFieldName: 'taskPriority'
          }), Tine.widgets.form.RecordPickerManager.get('Addressbook', 'Contact', {
            userOnly: true,
            fieldLabel: this.app.i18n._('Organizer'),
            emptyText: i18n._('Add Responsible ...'),
            useAccountRecord: true,
            name: 'organizer',
            allowBlank: true
          })], [{
            columnWidth: 1,
            fieldLabel: this.app.i18n._('Notes'),
            emptyText: this.app.i18n._('Enter description...'),
            name: 'description',
            xtype: 'textarea',
            height: 200
          }], [new Ext.ux.PercentCombo({
            fieldLabel: this.app.i18n._('Percentage'),
            editable: false,
            name: 'percent'
          }), new Tine.Tinebase.widgets.keyfield.ComboBox({
            app: 'Tasks',
            keyFieldName: 'taskStatus',
            fieldLabel: this.app.i18n._('Status'),
            name: 'status',
            value: 'NEEDS-ACTION',
            allowBlank: false,
            listeners: {
              scope: this,
              'change': this.handleCompletedDate
            }
          }), new Ext.ux.form.DateTimeField({
            allowBlank: true,
            defaultTime: '12:00',
            fieldLabel: this.app.i18n._('Completed'),
            name: 'completed'
          })]]
        }, {
          // activities and tags
          layout: 'ux.multiaccordion',
          animate: true,
          region: 'east',
          width: 210,
          split: true,
          collapsible: true,
          collapseMode: 'mini',
          header: false,
          margins: '0 5 0 5',
          border: true,
          items: [new Tine.widgets.tags.TagPanel({
            app: 'Tasks',
            border: false,
            bodyStyle: 'border:1px solid #B5B8C8;'
          })]
        }]
      }, new Tine.widgets.activities.ActivitiesTabPanel({
        app: this.appName,
        record_id: this.record ? this.record.id : '',
        record_model: this.appName + '_Model_' + this.recordClass.getMeta('modelName')
      }), this.alarmPanel]
    };
  }
});
/**
 * Tasks Edit Popup
 * 
 * @param   {Object} config
 * @return  {Ext.ux.Window}
 */

Tine.Tasks.TaskEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 900,
    height: 490,
    name: Tine.Tasks.TaskEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Tasks.TaskEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 1661:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2011-2014 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Tasks');
/**
 * render the CalDAV Url into property panel of containers
 * 
 * @class   Tine.Calendar.CalDAVContainerPropertiesHookField
 * @extends Tine.widgets.container.CalDAVContainerPropertiesHookField
 */

Tine.Tasks.CalDAVContainerPropertiesHookField = Ext.extend(Tine.widgets.container.CalDAVContainerPropertiesHookField, {
  appName: 'Tasks'
});
Ext.ux.ItemRegistry.registerItem('Tine.widgets.container.PropertiesDialog.FormItems.Properties', Tine.Tasks.CalDAVContainerPropertiesHookField, 100);

/***/ }),

/***/ 1662:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(1663);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(19)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 1663:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(189);
exports = module.exports = __webpack_require__(18)(false);
// imports


// module
exports.push([module.i, "/**\n * Tine 2.0\n * \n * @package     Tasks\n * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3\n * @author      Cornelius Weiss <c.weiss@metaways.de>\n * @copyright   Copyright (c) 2007-2008 Metaways Infosystems GmbH (http://www.metaways.de)\n * @version     $Id$\n *\n */\n\n.TasksIconCls, .TasksTask {\n    background-image:url(" + escape(__webpack_require__(361)) + ") !important;\n}\n\n.TasksMainGridStatus {\n    width: 12px;\n    height: 12px;\n}\n\n/***** tasks grid panel classes ******/\n\n.tasks-grid-overdue {\n    color: #aa0000;\n}\n\n.tasks-grid-duetoday {\n    color: #00aa00;\n}\n\n.tasks-grid-completed {\n    color: #777;\n}\n\n.t-contenttype-task .action_add {\n    background-image: url(" + escape(__webpack_require__(1664)) + ") !important;\n}\n\n.t-contenttype-task .action_edit {\n    background-image: url(" + escape(__webpack_require__(1665)) + ") !important;\n}\n\n.t-contenttype-task .action_delete {\n    background-image: url(" + escape(__webpack_require__(1666)) + ") !important;\n}", ""]);

// exports


/***/ }),

/***/ 1664:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M31.5,24v6c0,1.5-0.5,2.8-1.6,3.8s-2.3,1.6-3.8,1.6H5.4c-1.5,0-2.8-0.5-3.8-1.6S0,31.4,0,30V12.4c0-1.5,0.5-2.8,1.6-3.8 S3.9,7,5.4,7h20.6c0.8,0,1.5,0.2,2.2,0.5c0.2,0.1,0.3,0.2,0.3,0.4c0,0.2,0,0.4-0.2,0.5l-0.9,0.9c-0.1,0.1-0.3,0.2-0.4,0.2 c0,0-0.1,0-0.2,0c-0.3-0.1-0.6-0.1-0.8-0.1H5.4c-0.8,0-1.5,0.3-2.1,0.9s-0.9,1.3-0.9,2.1V30c0,0.8,0.3,1.5,0.9,2.1 C3.9,32.7,4.6,33,5.4,33h20.6c0.8,0,1.5-0.3,2.1-0.9c0.6-0.6,0.9-1.3,0.9-2.1v-4.8c0-0.2,0.1-0.3,0.2-0.4l1.2-1.2 c0.1-0.1,0.3-0.2,0.4-0.2c0.1,0,0.2,0,0.2,0.1C31.3,23.6,31.5,23.7,31.5,24z M28.4,15.6L15.7,28.4c-0.3,0.3-0.6,0.4-1,0.4 c-0.4,0-0.7-0.1-1-0.4l-6.1-6.1c-0.3-0.3-0.4-0.6-0.4-1s0.1-0.7,0.4-1l0.4-0.4c0.3-0.3,0.6-0.4,1-0.4c0.4,0,0.7,0.1,1,0.4l4.6,4.6 L26,13.1c0.3-0.3,0.6-0.4,1-0.4s0.7,0.1,1,0.4l0.5,0.5c0.3,0.3,0.4,0.6,0.4,1C28.9,15,28.7,15.3,28.4,15.6z M36.3,25.4h-1 c-0.1,0-0.3,0-0.3-0.1c-0.1-0.1-0.1-0.2-0.1-0.3v-5.3h-5.3c-0.1,0-0.3,0-0.3-0.1c-0.1-0.1-0.1-0.2-0.1-0.3v-1c0-0.1,0-0.3,0.1-0.3 c0.1-0.1,0.2-0.1,0.3-0.1h5.3v-5.3c0-0.1,0-0.3,0.1-0.3c0.1-0.1,0.2-0.1,0.3-0.1h1c0.1,0,0.3,0,0.3,0.1c0.1,0.1,0.1,0.2,0.1,0.3v5.3 H42c0.1,0,0.3,0,0.3,0.1c0.1,0.1,0.1,0.2,0.1,0.3v1c0,0.1,0,0.3-0.1,0.3c-0.1,0.1-0.2,0.1-0.3,0.1h-5.3v5.3c0,0.1,0,0.3-0.1,0.3 C36.6,25.3,36.4,25.4,36.3,25.4z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1665:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath id='edit_1_' d='M32.5,24v6c0,1.5-0.5,2.8-1.6,3.8s-2.3,1.6-3.8,1.6H6.4c-1.5,0-2.8-0.5-3.8-1.6S1,31.4,1,30V12.4 c0-1.5,0.5-2.8,1.6-3.8S4.9,7,6.4,7h20.6c0.8,0,1.5,0.2,2.2,0.5c0.2,0.1,0.3,0.2,0.3,0.4c0,0.2,0,0.4-0.2,0.5l-0.9,0.9 c-0.1,0.1-0.3,0.2-0.4,0.2c0,0-0.1,0-0.2,0c-0.3-0.1-0.6-0.1-0.8-0.1H6.4c-0.8,0-1.5,0.3-2.1,0.9c-0.6,0.6-0.9,1.3-0.9,2.1V30 c0,0.8,0.3,1.5,0.9,2.1C4.9,32.7,5.6,33,6.4,33h20.6c0.8,0,1.5-0.3,2.1-0.9c0.6-0.6,0.9-1.3,0.9-2.1v-4.8c0-0.2,0.1-0.3,0.2-0.4 l1.2-1.2c0.1-0.1,0.3-0.2,0.4-0.2c0.1,0,0.2,0,0.2,0.1C32.3,23.6,32.5,23.7,32.5,24z M16.5,12.8l-6.3,6.3c-0.1,0.1-0.3,0.2-0.5,0.2 c-0.2,0-0.4-0.1-0.5-0.2l-3-3C6.1,16,6,15.8,6,15.6c0-0.2,0.1-0.4,0.2-0.5L6.4,15c0.1-0.1,0.3-0.2,0.5-0.2c0.2,0,0.4,0.1,0.5,0.2 l2.3,2.3l5.6-5.6c0.1-0.1,0.3-0.2,0.5-0.2c0.2,0,0.4,0.1,0.5,0.2l0.2,0.2c0.1,0.1,0.2,0.3,0.2,0.5S16.7,12.7,16.5,12.8z M16.5,22.1 l-6.3,6.3c-0.1,0.1-0.3,0.2-0.5,0.2c-0.2,0-0.4-0.1-0.5-0.2l-3-3C6.1,25.3,6,25.1,6,24.9s0.1-0.4,0.2-0.5l0.2-0.2 C6.6,24.1,6.7,24,6.9,24c0.2,0,0.4,0.1,0.5,0.2l2.3,2.3l5.6-5.6c0.1-0.1,0.3-0.2,0.5-0.2c0.2,0,0.4,0.1,0.5,0.2l0.2,0.2 c0.1,0.1,0.2,0.3,0.2,0.5C16.7,21.8,16.7,22,16.5,22.1z'/%3E %3Cpath d='M26.5,23.4l2-1.8L26.1,19l-2,1.8l0,0.9l1.6,0.1l-0.1,1.6L26.5,23.4z M34.2,12.1c-0.2-0.2-0.3-0.2-0.5,0l-6,5.4 c-0.2,0.2-0.2,0.4,0,0.5c0.2,0.2,0.3,0.2,0.5,0l6-5.4C34.4,12.5,34.4,12.3,34.2,12.1z M34.1,9.8l4.4,4.9L27,25l-4.7-0.2l0.2-4.7 L34.1,9.8z M41.1,12.3l-1.6,1.4l-4.4-4.9l1.6-1.4C37,7.1,37.4,7,37.8,7c0.4,0,0.8,0.2,1.1,0.5l2.3,2.6c0.3,0.3,0.4,0.7,0.4,1.1 S41.4,12,41.1,12.3z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1666:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath id='clear_1_' d='M36.5,24v6c0,1.5-0.5,2.8-1.6,3.8s-2.3,1.6-3.8,1.6H10.4c-1.5,0-2.8-0.5-3.8-1.6S5,31.4,5,30V12.4 c0-1.5,0.5-2.8,1.6-3.8S8.9,7,10.4,7h20.6c0.8,0,1.5,0.2,2.2,0.5c0.2,0.1,0.3,0.2,0.3,0.4c0,0.2,0,0.4-0.2,0.5l-0.9,0.9 c-0.1,0.1-0.3,0.2-0.4,0.2c0,0-0.1,0-0.2,0c-0.3-0.1-0.6-0.1-0.8-0.1H10.4c-0.8,0-1.5,0.3-2.1,0.9c-0.6,0.6-0.9,1.3-0.9,2.1V30 c0,0.8,0.3,1.5,0.9,2.1c0.6,0.6,1.3,0.9,2.1,0.9h20.6c0.8,0,1.5-0.3,2.1-0.9c0.6-0.6,0.9-1.3,0.9-2.1v-4.8c0-0.2,0.1-0.3,0.2-0.4 l1.2-1.2c0.1-0.1,0.3-0.2,0.4-0.2c0.1,0,0.2,0,0.2,0.1C36.3,23.6,36.5,23.7,36.5,24z'/%3E %3Cpath id='clear_2_' d='M28.2,27.4l-1.2,1.2c-0.2,0.2-0.4,0.2-0.6,0.2c-0.2,0-0.4-0.1-0.6-0.2l-5-5l-5,5c-0.2,0.2-0.4,0.2-0.6,0.2 c-0.2,0-0.4-0.1-0.6-0.2l-1.2-1.2c-0.2-0.2-0.2-0.4-0.2-0.6s0.1-0.4,0.2-0.6l5-5l-5-5c-0.2-0.2-0.2-0.4-0.2-0.6 c0-0.2,0.1-0.4,0.2-0.6l1.2-1.2c0.2-0.2,0.4-0.2,0.6-0.2c0.2,0,0.4,0.1,0.6,0.2l5,5l5-5c0.2-0.2,0.4-0.2,0.6-0.2 c0.2,0,0.4,0.1,0.6,0.2l1.2,1.2c0.2,0.2,0.2,0.4,0.2,0.6c0,0.2-0.1,0.4-0.2,0.6l-5,5l5,5c0.2,0.2,0.2,0.4,0.2,0.6 S28.3,27.2,28.2,27.4z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 18:
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),

/***/ 186:
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(1657);
__webpack_require__(1658);
__webpack_require__(1659);
__webpack_require__(1660);
__webpack_require__(1661);
__webpack_require__(1662);


/***/ }),

/***/ 189:
/***/ (function(module, exports) {

module.exports = function escape(url) {
    if (typeof url !== 'string') {
        return url
    }
    // If url is already wrapped in quotes, remove them
    if (/^['"].*['"]$/.test(url)) {
        url = url.slice(1, -1);
    }
    // Should url be wrapped?
    // See https://drafts.csswg.org/css-values-3/#urls
    if (/["'() \t\n]/.test(url)) {
        return '"' + url.replace(/"/g, '\\"').replace(/\n/g, '\\n') + '"'
    }

    return url
}


/***/ }),

/***/ 19:
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getElement = (function (fn) {
	var memo = {};

	return function(selector) {
		if (typeof memo[selector] === "undefined") {
			var styleTarget = fn.call(this, selector);
			// Special case to return head of iframe instead of iframe itself
			if (styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[selector] = styleTarget;
		}
		return memo[selector]
	};
})(function (target) {
	return document.querySelector(target)
});

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(75);

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
	if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertInto + " " + options.insertAt.before);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	options.attrs.type = "text/css";

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	options.attrs.type = "text/css";
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = options.transform(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),

/***/ 361:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M36.5,24v6c0,1.5-0.5,2.8-1.6,3.8s-2.3,1.6-3.8,1.6H10.4c-1.5,0-2.8-0.5-3.8-1.6S5,31.4,5,30V12.4c0-1.5,0.5-2.8,1.6-3.8 S8.9,7,10.4,7h20.6c0.8,0,1.5,0.2,2.2,0.5c0.2,0.1,0.3,0.2,0.3,0.4c0,0.2,0,0.4-0.2,0.5l-0.9,0.9c-0.1,0.1-0.3,0.2-0.4,0.2 c0,0-0.1,0-0.2,0c-0.3-0.1-0.6-0.1-0.8-0.1H10.4c-0.8,0-1.5,0.3-2.1,0.9c-0.6,0.6-0.9,1.3-0.9,2.1V30c0,0.8,0.3,1.5,0.9,2.1 c0.6,0.6,1.3,0.9,2.1,0.9h20.6c0.8,0,1.5-0.3,2.1-0.9c0.6-0.6,0.9-1.3,0.9-2.1v-4.8c0-0.2,0.1-0.3,0.2-0.4l1.2-1.2 c0.1-0.1,0.3-0.2,0.4-0.2c0.1,0,0.2,0,0.2,0.1C36.3,23.6,36.5,23.7,36.5,24z M33.4,15.6L20.7,28.4c-0.3,0.3-0.6,0.4-1,0.4 c-0.4,0-0.7-0.1-1-0.4l-6.1-6.1c-0.3-0.3-0.4-0.6-0.4-1s0.1-0.7,0.4-1l0.4-0.4c0.3-0.3,0.6-0.4,1-0.4c0.4,0,0.7,0.1,1,0.4l4.6,4.6 L31,13.1c0.3-0.3,0.6-0.4,1-0.4c0.4,0,0.7,0.1,1,0.4l0.5,0.5c0.3,0.3,0.4,0.6,0.4,1C33.9,15,33.7,15.3,33.4,15.6z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 75:
/***/ (function(module, exports) {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ })

}]);