(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// install a JSONP callback for chunk loading
/******/ 	function webpackJsonpCallback(data) {
/******/ 		var chunkIds = data[0];
/******/ 		var moreModules = data[1];
/******/
/******/
/******/ 		// add "moreModules" to the modules object,
/******/ 		// then flag all "chunkIds" as loaded and fire callback
/******/ 		var moduleId, chunkId, i = 0, resolves = [];
/******/ 		for(;i < chunkIds.length; i++) {
/******/ 			chunkId = chunkIds[i];
/******/ 			if(installedChunks[chunkId]) {
/******/ 				resolves.push(installedChunks[chunkId][0]);
/******/ 			}
/******/ 			installedChunks[chunkId] = 0;
/******/ 		}
/******/ 		for(moduleId in moreModules) {
/******/ 			if(Object.prototype.hasOwnProperty.call(moreModules, moduleId)) {
/******/ 				modules[moduleId] = moreModules[moduleId];
/******/ 			}
/******/ 		}
/******/ 		if(parentJsonpFunction) parentJsonpFunction(data);
/******/
/******/ 		while(resolves.length) {
/******/ 			resolves.shift()();
/******/ 		}
/******/
/******/ 	};
/******/
/******/
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// object to store loaded and loading chunks
/******/ 	// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 	// Promise = chunk loading, 0 = chunk loaded
/******/ 	var installedChunks = {
/******/ 		18: 0
/******/ 	};
/******/
/******/
/******/
/******/ 	// script path function
/******/ 	function jsonpScriptSrc(chunkId) {
/******/ 		return __webpack_require__.p + "" + ({"0":"Tinebase/js/ace","1":"ActiveSync/js/ActiveSync","2":"Addressbook/js/Addressbook","3":"Admin/js/Admin","4":"Calendar/js/Calendar","6":"CoreData/js/CoreData","7":"Courses/js/Courses","8":"Crm/js/Crm","9":"ExampleApplication/js/ExampleApplication","10":"Felamimail/js/Felamimail","11":"Filemanager/js/Filemanager","12":"HumanResources/js/HumanResources","13":"Inventory/js/Inventory","14":"Phone/js/Phone","15":"Projects/js/Projects","16":"Sales/js/Sales","17":"Setup/js/Setup","19":"SimpleFAQ/js/SimpleFAQ","20":"Tasks/js/Tasks","21":"Timetracker/js/Timetracker","22":"Tinebase/js/OpenLayers","23":"Tinebase/js/Tinebase","24":"Tinebase/js/cytoscape","26":"Tinebase/js/hammerjs","27":"Tinebase/js/html2canvas","28":"Tinebase/js/linkify","30":"Voipmanager/js/Voipmanager"}[chunkId]||chunkId) + "-" + {"0":"e0bf52532ef99f77668c","1":"f039a88e0aaa03de0f70","2":"21d168bdaccd9cb3f43b","3":"6dc6fe0fa746dd011799","4":"6750eba6cb84239f4172","6":"ae2fd6db9bc6cf2689d7","7":"2ea9074cef598d4d0a80","8":"8593524b940f0781606d","9":"3e8c65c143d50a810982","10":"e41d202c20110630a0f4","11":"e0badfbf48bc6a7e7ad5","12":"0922dc1289c84a83c0c2","13":"3970a66cfccdf60b3c88","14":"6aaef21a98007d5e4918","15":"c0ba35a9c54c4814974d","16":"78d72022b2bdd5ea1061","17":"7dd3fe8294446aa84791","19":"17b59e934edcf07182c5","20":"85c15504b3a7a00994a5","21":"af5cbc89386f63e2d900","22":"7718ba5a40850615b93f","23":"e7bb972393214d8c110e","24":"1ad617a98088cfc35398","26":"b672d48173854610fe6c","27":"896b19ba771ff88182ac","28":"d692e66c05cfd6dd37af","30":"b0e6595007f3b2648165"}[chunkId] + "-FAT.debug.js";
/******/ 	}
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/ 	// This file contains only the entry chunk.
/******/ 	// The chunk loading function for additional chunks
/******/ 	__webpack_require__.e = function requireEnsure(chunkId) {
/******/ 		var promises = [];
/******/
/******/
/******/ 		// JSONP chunk loading for javascript
/******/
/******/ 		var installedChunkData = installedChunks[chunkId];
/******/ 		if(installedChunkData !== 0) { // 0 means "already installed".
/******/
/******/ 			// a Promise means "currently loading".
/******/ 			if(installedChunkData) {
/******/ 				promises.push(installedChunkData[2]);
/******/ 			} else {
/******/ 				// setup Promise in chunk cache
/******/ 				var promise = new Promise(function(resolve, reject) {
/******/ 					installedChunkData = installedChunks[chunkId] = [resolve, reject];
/******/ 				});
/******/ 				promises.push(installedChunkData[2] = promise);
/******/
/******/ 				// start chunk loading
/******/ 				var script = document.createElement('script');
/******/ 				var onScriptComplete;
/******/
/******/ 				script.charset = 'utf-8';
/******/ 				script.timeout = 120;
/******/ 				if (__webpack_require__.nc) {
/******/ 					script.setAttribute("nonce", __webpack_require__.nc);
/******/ 				}
/******/ 				script.src = jsonpScriptSrc(chunkId);
/******/
/******/ 				onScriptComplete = function (event) {
/******/ 					// avoid mem leaks in IE.
/******/ 					script.onerror = script.onload = null;
/******/ 					clearTimeout(timeout);
/******/ 					var chunk = installedChunks[chunkId];
/******/ 					if(chunk !== 0) {
/******/ 						if(chunk) {
/******/ 							var errorType = event && (event.type === 'load' ? 'missing' : event.type);
/******/ 							var realSrc = event && event.target && event.target.src;
/******/ 							var error = new Error('Loading chunk ' + chunkId + ' failed.\n(' + errorType + ': ' + realSrc + ')');
/******/ 							error.type = errorType;
/******/ 							error.request = realSrc;
/******/ 							chunk[1](error);
/******/ 						}
/******/ 						installedChunks[chunkId] = undefined;
/******/ 					}
/******/ 				};
/******/ 				var timeout = setTimeout(function(){
/******/ 					onScriptComplete({ type: 'timeout', target: script });
/******/ 				}, 120000);
/******/ 				script.onerror = script.onload = onScriptComplete;
/******/ 				document.head.appendChild(script);
/******/ 			}
/******/ 		}
/******/ 		return Promise.all(promises);
/******/ 	};
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// on error function for async loading
/******/ 	__webpack_require__.oe = function(err) { console.error(err); throw err; };
/******/
/******/ 	var jsonpArray = window["webpackJsonp"] = window["webpackJsonp"] || [];
/******/ 	var oldJsonpFunction = jsonpArray.push.bind(jsonpArray);
/******/ 	jsonpArray.push = webpackJsonpCallback;
/******/ 	jsonpArray = jsonpArray.slice();
/******/ 	for(var i = 0; i < jsonpArray.length; i++) webpackJsonpCallback(jsonpArray[i]);
/******/ 	var parentJsonpFunction = oldJsonpFunction;
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 164);
/******/ })
/************************************************************************/
/******/ ({

/***/ 100:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Setup
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */

/*global Ext, Tine*/
Ext.ns('Tine', 'Tine.Setup');
/**
 * local storage prefix for Setup
 */

Tine.Tinebase.tineInit.initAjax.lsPrefix = Tine.Tinebase.common.getUrl('path') + 'TineSetup';
/**
 * init ajax
 */

Tine.Tinebase.tineInit.initAjax = Tine.Tinebase.tineInit.initAjax.createInterceptor(function () {
  // setup calls can take quite a while
  Ext.Ajax.timeout = 900000; // 15 mins

  Tine.Tinebase.tineInit.requestUrl = 'setup.php';
  return true;
});
/**
 * init registry
 */

Tine.Tinebase.tineInit.initRegistry = Tine.Tinebase.tineInit.initRegistry.createInterceptor(function () {
  Tine.Tinebase.tineInit.clearRegistry();
  Tine.Tinebase.tineInit.getAllRegistryDataMethod = 'Setup.getAllRegistryData';
  Tine.Tinebase.tineInit.jsonKeyCookieId = 'TINE20SETUPJSONKEY';
  Tine.Tinebase.tineInit.stateful = false;
  return true;
});
Tine.Tinebase.tineInit.onRegistryLoad = Tine.Tinebase.tineInit.onRegistryLoad.createInterceptor(function () {
  // fake a setup user
  var setupUser = {
    accountId: 1,
    accountDisplayName: Tine.Setup.registry.get('currentAccount'),
    accountLastName: 'Admin',
    accountFirstName: 'Setup',
    accountFullName: 'Setup Admin'
  };
  Tine.Tinebase.registry.add('currentAccount', setupUser); // enable setup app

  Tine.Tinebase.registry.add('userApplications', [{
    name: 'Setup',
    status: 'enabled'
  }]);
  Tine.Tinebase.MainScreenPanel.prototype.defaultAppName = 'Setup';
  Tine.Tinebase.MainScreenPanel.prototype.hideAppTabs = true;
  return true;
});
/**
 * render window
 */

Tine.Tinebase.tineInit.renderWindow = Tine.Tinebase.tineInit.renderWindow.createInterceptor(function () {
  var mainCardPanel = Tine.Tinebase.viewport.tineViewportMaincardpanel; // if a config file exists, the admin needs to login!        

  if (Tine.Setup.registry.get('configExists') && !Tine.Setup.registry.get('currentAccount')) {
    Tine.loginPanel = new Tine.Tinebase.LoginPanel({
      loginMethod: 'Setup.login',
      headsUpText: window.i18n._('Setup'),
      scope: this,
      onLogin: function onLogin(response) {
        Tine.Tinebase.tineInit.initRegistry(true, function () {
          Ext.MessageBox.hide();
          Tine.Tinebase.tineInit.renderWindow();
        });
      }
    });
    mainCardPanel.layout.container.add(Tine.loginPanel);
    mainCardPanel.layout.setActiveItem(Tine.loginPanel.id);
    Tine.loginPanel.doLayout();
    return false;
  }
});

/***/ }),

/***/ 105:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

// CONCATENATED MODULE: ./AreaLocks/AbstractProvider.es6.js
/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2018 Metaways Infosystems GmbH (http://www.metaways.de)
 */

/* global Ext,Tine */
class AbstractProvider extends Ext.util.Observable {
  /**
   * @cfg {String} area name of area
   */

  /**
   * @cfg {String} validity 'session', 'lifetime', 'presence' or 'someotherthingonlyproviderunderstands',
   */

  /**
   * @cfg {Number} lifetime lifetime in minutes
   */

  /**
   * @cfg {Boolean} individual each area must be unlocked individually
   * (when applied hierarchically / with same provider) -> NOT YET IMPLEMENTED
   */

  /**
   * @property {Number} expires
   */

  /**
   * @property {Boolean} isUnlocking
   */
  constructor(config) {
    super(config);
    this.expires = 0;
    this.isUnlocking = false;
    this.addEvents(
    /**
     * @event lock
     * Fires when the provider locked the area.
     * @param {AbstractProvider} this The Provider
     */
    'lock',
    /**
     * @event unlocking
     * Fires when the provider started the async unlocking action.
     * @param {AbstractProvider} this The Provider
     */
    'unlocking',
    /**
     * @event unlock
     * Fires when the provider unlocked the area.
     * @param {AbstractProvider} this The Provider
     */
    'unlock',
    /**
     * @event stateChange
     * Fires when the state of this provider changes.
     * @param {AbstractProvider} this The Provider
     * @param {Object} state the output of the provider {@link #getState} function
     */
    'stateChange');
    Object.assign(this, config);
  }

  isLocked()
  /* askServer */
  {
    let me = this;
    return new Promise(resolve => {
      me.updateState();
      resolve(me.expires < new Date().getTime());
    });
  }

  unlock() {
    let me = this;
    return new Promise(resolve => {
      me.expires = new Date().getTime() + me.lifetime * 60000;
      me.assertTimerRunning();
      me.fireEvent('stateChange', me, me.getState());
      me.fireEvent('unlock', me);
      resolve(me.expires);
    });
  }

  lock() {
    let me = this;
    return new Promise(resolve => {
      if (me.presenceObserver) {
        me.presenceObserver.stopChecking();
      }

      if (me.timer) {
        clearTimeout(me.timer);
        me.timer = null;
      }

      me.expires = 0;
      me.fireEvent('stateChange', me, me.getState());
      me.fireEvent('lock', me);
      resolve(me.expires);
    });
  }

  assertTimerRunning() {
    let me = this;

    if (String(me.validity).toLowerCase() === 'presence') {
      if (!me.presenceObserver) {
        me.presenceObserver = new Tine.Tinebase.PresenceObserver({
          maxAbsenceTime: me.lifetime,
          absenceCallback: me.lock.bind(me),
          presenceCallback: me.updateState.bind(me)
        });
      } else {
        me.presenceObserver.startChecking();
      }
    } else {
      if (!me.timer) {
        let lifetime = Math.min(me.expires - new Date().getTime(), me.lifetime * 60000);
        me.timer = setTimeout(me.lock.bind(me), lifetime);
      }
    }
  }

  setState(state) {
    let _ = window.lodash;

    let expires = _.get(state, 'expires', 0);

    if (!_.isNumber(expires)) {
      _.set(state, 'expires', new Date(expires).getTime());
    }

    Object.assign(this, state);
  }

  getState() {
    return {
      area: this.area,
      expires: this.expires
    };
  }

  updateState() {
    let me = this;

    if (me.expires && String(me.validity).toLowerCase() === 'presence' && me.presenceObserver) {
      let expires = me.presenceObserver.getLastPresence() + me.lifetime * 60000;

      if (expires !== me.expires) {
        me.expires = expires;
        me.fireEvent('stateChange', me, me.getState());
      }
    } // timers are not running after page reload / new window


    if (me.expires > new Date().getTime()) {
      me.assertTimerRunning();
    }
  }

}

/* harmony default export */ var AbstractProvider_es6 = (AbstractProvider);
// CONCATENATED MODULE: ./AreaLocks/UserPasswordProvider.es6.js
/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2018 Metaways Infosystems GmbH (http://www.metaways.de)
 */

/* global Tine,i18n */

class UserPasswordProvider_es6_UserPasswordProvider extends AbstractProvider_es6 {
  constructor(config) {
    super(config);
    this.windowTitle = i18n._('Password required');
    this.questionText = i18n._('This area is locked. To unlock it you need to provide your password');
    this.passwordFieldLabel = i18n._('Password');
  }

  unlock() {
    let me = this;
    return new Promise((resolve, reject) => {
      let pwDlg = new Tine.Tinebase.widgets.dialog.PasswordDialog({
        windowTitle: me.windowTitle,
        questionText: me.questionText,
        passwordFieldLabel: me.passwordFieldLabel,
        allowEmptyPassword: false,
        hasPwGen: false
      });
      pwDlg.openWindow();
      pwDlg.on('apply', password => {
        me.isUnlocking = true;
        me.fireEvent('unlocking', me);
        return Tine.Tinebase_AreaLock.unlock(me.area, password).finally(() => {
          me.isUnlocking = false;
        }).then(() => {
          return super.unlock();
        }).catch(e => {
          reject(e);
        });
      });
    });
  }

  lock() {
    let me = this;
    me.isLocking = true;
    me.fireEvent('locking', me);
    return Tine.Tinebase_AreaLock.lock(me.area).finally(() => {
      me.isLocking = false;
    }).then(() => {
      return super.lock();
    });
  }

}

/* harmony default export */ var UserPasswordProvider_es6 = (UserPasswordProvider_es6_UserPasswordProvider);
// CONCATENATED MODULE: ./AreaLocks/PinProvider.es6.js
/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2018 Metaways Infosystems GmbH (http://www.metaways.de)
 */

/* global i18n */

class PinProvider_es6_PinProvider extends UserPasswordProvider_es6 {
  constructor(config) {
    super(config);
    this.windowTitle = i18n._('PIN required');
    this.questionText = i18n._('This area is locked. To unlock it you need to provide your PIN');
    this.passwordFieldLabel = i18n._('PIN');
  }

}

/* harmony default export */ var PinProvider_es6 = (PinProvider_es6_PinProvider);
// CONCATENATED MODULE: ./AreaLocks/TokenProvider.es6.js
/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2018 Metaways Infosystems GmbH (http://www.metaways.de)
 */

/* global i18n */

class TokenProvider_es6_TokenProvider extends UserPasswordProvider_es6 {
  constructor(config) {
    super(config);
    this.windowTitle = i18n._('Token required');
    this.questionText = i18n._('This area is locked. To unlock it you need to enter your Token');
    this.passwordFieldLabel = i18n._('Token');
  }

}

/* harmony default export */ var TokenProvider_es6 = (TokenProvider_es6_TokenProvider);
// CONCATENATED MODULE: ./AreaLocks.es6.js
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AreaLocks", function() { return AreaLocks; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "providers", function() { return providers; });
/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2018 Metaways Infosystems GmbH (http://www.metaways.de)
 */

/* global Ext,Tine,i18n,postal */



let providers = {
  UserPassword: UserPasswordProvider_es6,
  Pin: PinProvider_es6,
  Token: TokenProvider_es6
};

class AreaLocks {
  /**
   * @property {Object} areaOptions run time area options
   */

  /**
   * @property {Object} providerInstances areaName: providerInstance
   */

  /**
   * @property {Object} unlockPromises areaName: unlockPromise
   */
  constructor() {
    this.areaOptions = {};
    this.providerInstances = {};
    this.unlockPromises = {};
  }

  getProvider(config, lockState) {
    if (!this.providerInstances[config.area]) {
      if (!providers[config.provider]) {
        Tine.log.error('AreaLocks.getProvider no such provider: ' + config.provider);
        return;
      }

      this.providerInstances[config.area] = new providers[config.provider](config);
      this.providerInstances[config.area].on('unlock', this.onUnlock, this);
      this.providerInstances[config.area].on('lock', this.onLock, this);
      this.providerInstances[config.area].on('unlocking', this.manageMask.bind(this, config.area), this);
      this.providerInstances[config.area].on('stateChange', this.onStateChange, this);
    }

    this.providerInstances[config.area].setState(lockState);
    return this.providerInstances[config.area];
  }

  onUnlock(provider) {
    let area = provider.area;
    this.manageMask(area);
    postal.publish({
      channel: 'areaLocks',
      topic: [area, 'unlocked'].join('.'),
      data: provider.getState()
    });
  }

  onLock(provider) {
    let me = this;
    let area = provider.area;
    this.manageMask(area);
    postal.publish({
      channel: 'areaLocks',
      topic: [area, 'locked'].join('.'),
      data: provider.getState()
    }); // auto unlock

    let options = me.getOptions(area);

    if (options.maskEl && options.maskEl.isVisible(true)) {
      me.unlock(area);
    }
  }

  onStateChange(provider, state) {
    this.setLockState(provider.area, state);
  }
  /**
   * get areaLock config
   *
   * config definition:
   * [{
   *   area: 'string',        // name of area
   *   provider: 'string',    // PIN, token(auth_privaicyIdea), password, capture, ip, ...
   *   validity: 'once', '    // 'session', 'lifetime', 'presence', 'someotherthingonlyproviderunderstands',
   *   lifetime: seconds,     // absolute lifetime from unlock
   *   individual: true,      // each area must be unlocked individually (when applied hierarchically / with same provider) -> NOT YET
   *
   *   ... provider specific _public_ options
   * }]
   *
   * @param {String} area
   * @return {Object}
   */


  getConfig(area) {
    const _ = window.lodash;
    const config = Tine.Tinebase.configManager.get('areaLocks', 'Tinebase');

    const areaConfig = _.find(_.get(config, 'records', []), {
      area: area
    });

    return areaConfig;
  }
  /**
   * get areaLock state from registry
   *
   * [{
   *   area: 'string',
   *   expires: datetime (user timezone)
   *   ... provider specific _public_ state (would need server side event system - might not be needed)
   * }]
   */


  getLockState(area) {
    const _ = window.lodash;
    let lockStates = Tine.Tinebase.registry.get('areaLocks');
    return _.find(lockStates, {
      area: area
    });
  }
  /**
   * set areaLock state in registry
   *
   * @param {String|Provider} area
   * @param {Object} lockState
   */


  setLockState(area, lockState) {
    const _ = window.lodash;

    if (!Ext.isString(area)) {
      lockState = area.getState();
      area = area.area;
    }

    let lockStates = Tine.Tinebase.registry.get('areaLocks') || [];

    _.remove(lockStates, {
      area: area
    });

    lockStates.push(lockState);
    Tine.Tinebase.registry.set('areaLocks', lockStates);
  }

  manageMask(area) {
    let me = this;
    let options = me.getOptions(area); // @TODO: support array of maskEls?

    if (options.maskEl) {
      me.isLocked(area).then(isLocked => {
        if (isLocked) {
          let conf = this.getConfig(area);
          if (!conf) return Promise.reject(new Error('no areaLock configured for: ' + area));
          let lockState = this.getLockState(area);
          let provider = this.getProvider(conf, lockState);

          if (provider.isUnlocking) {
            options.maskEl.mask(i18n._('Unlocking ...'), 'x-mask-loading');
          } else {
            let mask = options.maskEl.mask(i18n._('Click here to unlock this area.'), 'tb-arealocks-msg');
            mask.next().on('click', () => {
              me.unlock(area);
            });
          }
        } else {
          options.maskEl.unmask();
        }
      });
    }
  } // public functions


  lock(area) {
    let me = this;
    return me.isLocked(area).then(locked => {
      if (locked) {
        // it's already locked
        return Promise.resolve();
      } else {
        let conf = me.getConfig(area);
        let lockState = me.getLockState(area);
        let provider = me.getProvider(conf, lockState);
        return provider.lock();
      }
    });
  }

  unlock(area) {
    let me = this;
    return me.isLocked(area).then(locked => {
      if (!locked) {
        // it's already unlocked
        return Promise.resolve();
      } else {
        let conf = me.getConfig(area);
        let lockState = me.getLockState(area);
        let provider = me.getProvider(conf, lockState);
        me.manageMask(area);

        if (!me.unlockPromises[area]) {
          me.unlockPromises = provider.unlock().finally(() => {
            me.unlockPromises[area] = null;
          }).catch(() => {
            // @TODO show failure message?
            me.unlock(area);
          });
        }

        return me.unlockPromises[area];
      }
    });
  }

  setOptions(area, options) {
    this.areaOptions[area] = options;
  }

  getOptions(area) {
    return this.areaOptions[area] || {};
  }

  isLocked(area, askServer) {
    let conf = this.getConfig(area);
    if (!conf) return Promise.reject(new Error('no areaLock configured for: ' + area));
    let lockState = this.getLockState(area);
    let provider = this.getProvider(conf, lockState);
    return provider.isLocked(askServer);
  }

  hasLock(area) {
    let conf = this.getConfig(area);
    return !!conf;
  }

}



/***/ }),

/***/ 13:
/***/ (function(module, exports) {

// @flow
var LONG = 'long'
var SHORT = 'short'
var NARROW = 'narrow'
var NUMERIC = 'numeric'
var TWODIGIT = '2-digit'

/**
 * formatting information
 **/
module.exports = {
  number: {
    decimal: {
      style: 'decimal'
    },
    integer: {
      style: 'decimal',
      maximumFractionDigits: 0
    },
    currency: {
      style: 'currency',
      currency: 'USD'
    },
    percent: {
      style: 'percent'
    },
    default: {
      style: 'decimal'
    }
  },
  date: {
    short: {
      month: NUMERIC,
      day: NUMERIC,
      year: TWODIGIT
    },
    medium: {
      month: SHORT,
      day: NUMERIC,
      year: NUMERIC
    },
    long: {
      month: LONG,
      day: NUMERIC,
      year: NUMERIC
    },
    full: {
      month: LONG,
      day: NUMERIC,
      year: NUMERIC,
      weekday: LONG
    },
    default: {
      month: SHORT,
      day: NUMERIC,
      year: NUMERIC
    }
  },
  time: {
    short: {
      hour: NUMERIC,
      minute: NUMERIC
    },
    medium: {
      hour: NUMERIC,
      minute: NUMERIC,
      second: NUMERIC
    },
    long: {
      hour: NUMERIC,
      minute: NUMERIC,
      second: NUMERIC,
      timeZoneName: SHORT
    },
    full: {
      hour: NUMERIC,
      minute: NUMERIC,
      second: NUMERIC,
      timeZoneName: SHORT
    },
    default: {
      hour: NUMERIC,
      minute: NUMERIC,
      second: NUMERIC
    }
  },
  duration: {
    default: {
      hours: {
        minimumIntegerDigits: 1,
        maximumFractionDigits: 0
      },
      minutes: {
        minimumIntegerDigits: 2,
        maximumFractionDigits: 0
      },
      seconds: {
        minimumIntegerDigits: 2,
        maximumFractionDigits: 3
      }
    }
  },
  parseNumberPattern: function (pattern/*: ?string */) {
    if (!pattern) return
    var options = {}
    var currency = pattern.match(/\b[A-Z]{3}\b/i)
    var syms = pattern.replace(/[^¤]/g, '').length
    if (!syms && currency) syms = 1
    if (syms) {
      options.style = 'currency'
      options.currencyDisplay = syms === 1 ? 'symbol' : syms === 2 ? 'code' : 'name'
      options.currency = currency ? currency[0].toUpperCase() : 'USD'
    } else if (pattern.indexOf('%') >= 0) {
      options.style = 'percent'
    }
    if (!/[@#0]/.test(pattern)) return options.style ? options : undefined
    options.useGrouping = pattern.indexOf(',') >= 0
    if (/E\+?[@#0]+/i.test(pattern) || pattern.indexOf('@') >= 0) {
      var size = pattern.replace(/E\+?[@#0]+|[^@#0]/gi, '')
      options.minimumSignificantDigits = Math.min(Math.max(size.replace(/[^@0]/g, '').length, 1), 21)
      options.maximumSignificantDigits = Math.min(Math.max(size.length, 1), 21)
    } else {
      var parts = pattern.replace(/[^#0.]/g, '').split('.')
      var integer = parts[0]
      var n = integer.length - 1
      while (integer[n] === '0') --n
      options.minimumIntegerDigits = Math.min(Math.max(integer.length - 1 - n, 1), 21)
      var fraction = parts[1] || ''
      n = 0
      while (fraction[n] === '0') ++n
      options.minimumFractionDigits = Math.min(Math.max(n, 0), 20)
      while (fraction[n] === '#') ++n
      options.maximumFractionDigits = Math.min(Math.max(n, 0), 20)
    }
    return options
  },
  parseDatePattern: function (pattern/*: ?string */) {
    if (!pattern) return
    var options = {}
    for (var i = 0; i < pattern.length;) {
      var current = pattern[i]
      var n = 1
      while (pattern[++i] === current) ++n
      switch (current) {
        case 'G':
          options.era = n === 5 ? NARROW : n === 4 ? LONG : SHORT
          break
        case 'y':
        case 'Y':
          options.year = n === 2 ? TWODIGIT : NUMERIC
          break
        case 'M':
        case 'L':
          n = Math.min(Math.max(n - 1, 0), 4)
          options.month = [ NUMERIC, TWODIGIT, SHORT, LONG, NARROW ][n]
          break
        case 'E':
        case 'e':
        case 'c':
          options.weekday = n === 5 ? NARROW : n === 4 ? LONG : SHORT
          break
        case 'd':
        case 'D':
          options.day = n === 2 ? TWODIGIT : NUMERIC
          break
        case 'h':
        case 'K':
          options.hour12 = true
          options.hour = n === 2 ? TWODIGIT : NUMERIC
          break
        case 'H':
        case 'k':
          options.hour12 = false
          options.hour = n === 2 ? TWODIGIT : NUMERIC
          break
        case 'm':
          options.minute = n === 2 ? TWODIGIT : NUMERIC
          break
        case 's':
        case 'S':
          options.second = n === 2 ? TWODIGIT : NUMERIC
          break
        case 'z':
        case 'Z':
        case 'v':
        case 'V':
          options.timeZoneName = n === 1 ? SHORT : LONG
          break
      }
    }
    return Object.keys(options).length ? options : undefined
  }
}


/***/ }),

/***/ 14:
/***/ (function(module, exports) {

// @flow
// "lookup" algorithm http://tools.ietf.org/html/rfc4647#section-3.4
// assumes normalized language tags, and matches in a case sensitive manner
module.exports = function lookupClosestLocale (locale/*: string | string[] | void */, available/*: { [string]: any } */)/*: ?string */ {
  if (typeof locale === 'string' && available[locale]) return locale
  var locales = [].concat(locale || [])
  for (var l = 0, ll = locales.length; l < ll; ++l) {
    var current = locales[l].split('-')
    while (current.length) {
      var candidate = current.join('-')
      if (available[candidate]) return candidate
      current.pop()
    }
  }
}


/***/ }),

/***/ 15:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// @flow


/*:: export type Rule = 'zero' | 'one' | 'two' | 'few' | 'many' | 'other' */
var zero = 'zero', one = 'one', two = 'two', few = 'few', many = 'many', other = 'other'
var f = [
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 1 ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return 0 <= n && n <= 1 ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var n = +s
    return i === 0 || n === 1 ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 0 ? zero
      : n === 1 ? one
      : n === 2 ? two
      : 3 <= n % 100 && n % 100 <= 10 ? few
      : 11 <= n % 100 && n % 100 <= 99 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var v = (s + '.').split('.')[1].length
    return i === 1 && v === 0 ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n % 10 === 1 && n % 100 !== 11 ? one
      : (2 <= n % 10 && n % 10 <= 4) && (n % 100 < 12 || 14 < n % 100) ? few
      : n % 10 === 0 || (5 <= n % 10 && n % 10 <= 9) || (11 <= n % 100 && n % 100 <= 14) ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n % 10 === 1 && (n % 100 !== 11 && n % 100 !== 71 && n % 100 !== 91) ? one
      : n % 10 === 2 && (n % 100 !== 12 && n % 100 !== 72 && n % 100 !== 92) ? two
      : ((3 <= n % 10 && n % 10 <= 4) || n % 10 === 9) && ((n % 100 < 10 || 19 < n % 100) && (n % 100 < 70 || 79 < n % 100) && (n % 100 < 90 || 99 < n % 100)) ? few
      : n !== 0 && n % 1000000 === 0 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var v = (s + '.').split('.')[1].length
    var f = +(s + '.').split('.')[1]
    return v === 0 && i % 10 === 1 && i % 100 !== 11 || f % 10 === 1 && f % 100 !== 11 ? one
      : v === 0 && (2 <= i % 10 && i % 10 <= 4) && (i % 100 < 12 || 14 < i % 100) || (2 <= f % 10 && f % 10 <= 4) && (f % 100 < 12 || 14 < f % 100) ? few
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var v = (s + '.').split('.')[1].length
    return i === 1 && v === 0 ? one
      : (2 <= i && i <= 4) && v === 0 ? few
      : v !== 0 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 0 ? zero
      : n === 1 ? one
      : n === 2 ? two
      : n === 3 ? few
      : n === 6 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var t = +('' + s).replace(/^[^.]*.?|0+$/g, '')
    var n = +s
    return n === 1 || t !== 0 && (i === 0 || i === 1) ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var v = (s + '.').split('.')[1].length
    var f = +(s + '.').split('.')[1]
    return v === 0 && i % 100 === 1 || f % 100 === 1 ? one
      : v === 0 && i % 100 === 2 || f % 100 === 2 ? two
      : v === 0 && (3 <= i % 100 && i % 100 <= 4) || (3 <= f % 100 && f % 100 <= 4) ? few
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    return i === 0 || i === 1 ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var v = (s + '.').split('.')[1].length
    var f = +(s + '.').split('.')[1]
    return v === 0 && (i === 1 || i === 2 || i === 3) || v === 0 && (i % 10 !== 4 && i % 10 !== 6 && i % 10 !== 9) || v !== 0 && (f % 10 !== 4 && f % 10 !== 6 && f % 10 !== 9) ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 1 ? one
      : n === 2 ? two
      : 3 <= n && n <= 6 ? few
      : 7 <= n && n <= 10 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 1 || n === 11 ? one
      : n === 2 || n === 12 ? two
      : ((3 <= n && n <= 10) || (13 <= n && n <= 19)) ? few
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var v = (s + '.').split('.')[1].length
    return v === 0 && i % 10 === 1 ? one
      : v === 0 && i % 10 === 2 ? two
      : v === 0 && (i % 100 === 0 || i % 100 === 20 || i % 100 === 40 || i % 100 === 60 || i % 100 === 80) ? few
      : v !== 0 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var v = (s + '.').split('.')[1].length
    var n = +s
    return i === 1 && v === 0 ? one
      : i === 2 && v === 0 ? two
      : v === 0 && (n < 0 || 10 < n) && n % 10 === 0 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var t = +('' + s).replace(/^[^.]*.?|0+$/g, '')
    return t === 0 && i % 10 === 1 && i % 100 !== 11 || t !== 0 ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 1 ? one
      : n === 2 ? two
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 0 ? zero
      : n === 1 ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var n = +s
    return n === 0 ? zero
      : (i === 0 || i === 1) && n !== 0 ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var f = +(s + '.').split('.')[1]
    var n = +s
    return n % 10 === 1 && (n % 100 < 11 || 19 < n % 100) ? one
      : (2 <= n % 10 && n % 10 <= 9) && (n % 100 < 11 || 19 < n % 100) ? few
      : f !== 0 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var v = (s + '.').split('.')[1].length
    var f = +(s + '.').split('.')[1]
    var n = +s
    return n % 10 === 0 || (11 <= n % 100 && n % 100 <= 19) || v === 2 && (11 <= f % 100 && f % 100 <= 19) ? zero
      : n % 10 === 1 && n % 100 !== 11 || v === 2 && f % 10 === 1 && f % 100 !== 11 || v !== 2 && f % 10 === 1 ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var v = (s + '.').split('.')[1].length
    var f = +(s + '.').split('.')[1]
    return v === 0 && i % 10 === 1 && i % 100 !== 11 || f % 10 === 1 && f % 100 !== 11 ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var v = (s + '.').split('.')[1].length
    var n = +s
    return i === 1 && v === 0 ? one
      : v !== 0 || n === 0 || n !== 1 && (1 <= n % 100 && n % 100 <= 19) ? few
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 1 ? one
      : n === 0 || (2 <= n % 100 && n % 100 <= 10) ? few
      : 11 <= n % 100 && n % 100 <= 19 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var v = (s + '.').split('.')[1].length
    return i === 1 && v === 0 ? one
      : v === 0 && (2 <= i % 10 && i % 10 <= 4) && (i % 100 < 12 || 14 < i % 100) ? few
      : v === 0 && i !== 1 && (0 <= i % 10 && i % 10 <= 1) || v === 0 && (5 <= i % 10 && i % 10 <= 9) || v === 0 && (12 <= i % 100 && i % 100 <= 14) ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    return 0 <= i && i <= 1 ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var v = (s + '.').split('.')[1].length
    return v === 0 && i % 10 === 1 && i % 100 !== 11 ? one
      : v === 0 && (2 <= i % 10 && i % 10 <= 4) && (i % 100 < 12 || 14 < i % 100) ? few
      : v === 0 && i % 10 === 0 || v === 0 && (5 <= i % 10 && i % 10 <= 9) || v === 0 && (11 <= i % 100 && i % 100 <= 14) ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var n = +s
    return i === 0 || n === 1 ? one
      : 2 <= n && n <= 10 ? few
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var f = +(s + '.').split('.')[1]
    var n = +s
    return (n === 0 || n === 1) || i === 0 && f === 1 ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    var v = (s + '.').split('.')[1].length
    return v === 0 && i % 100 === 1 ? one
      : v === 0 && i % 100 === 2 ? two
      : v === 0 && (3 <= i % 100 && i % 100 <= 4) || v !== 0 ? few
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return (0 <= n && n <= 1) || (11 <= n && n <= 99) ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 1 || n === 5 || n === 7 || n === 8 || n === 9 || n === 10 ? one
      : n === 2 || n === 3 ? two
      : n === 4 ? few
      : n === 6 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    return (i % 10 === 1 || i % 10 === 2 || i % 10 === 5 || i % 10 === 7 || i % 10 === 8) || (i % 100 === 20 || i % 100 === 50 || i % 100 === 70 || i % 100 === 80) ? one
      : (i % 10 === 3 || i % 10 === 4) || (i % 1000 === 100 || i % 1000 === 200 || i % 1000 === 300 || i % 1000 === 400 || i % 1000 === 500 || i % 1000 === 600 || i % 1000 === 700 || i % 1000 === 800 || i % 1000 === 900) ? few
      : i === 0 || i % 10 === 6 || (i % 100 === 40 || i % 100 === 60 || i % 100 === 90) ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return (n % 10 === 2 || n % 10 === 3) && (n % 100 !== 12 && n % 100 !== 13) ? few
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 1 || n === 3 ? one
      : n === 2 ? two
      : n === 4 ? few
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 0 || n === 7 || n === 8 || n === 9 ? zero
      : n === 1 ? one
      : n === 2 ? two
      : n === 3 || n === 4 ? few
      : n === 5 || n === 6 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n % 10 === 1 && n % 100 !== 11 ? one
      : n % 10 === 2 && n % 100 !== 12 ? two
      : n % 10 === 3 && n % 100 !== 13 ? few
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 1 ? one
      : n === 2 || n === 3 ? two
      : n === 4 ? few
      : n === 6 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 1 || n === 5 ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 11 || n === 8 || n === 80 || n === 800 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    return i === 1 ? one
      : i === 0 || ((2 <= i % 100 && i % 100 <= 20) || i % 100 === 40 || i % 100 === 60 || i % 100 === 80) ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n % 10 === 6 || n % 10 === 9 || n % 10 === 0 && n !== 0 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var i = Math.floor(Math.abs(+s))
    return i % 10 === 1 && i % 100 !== 11 ? one
      : i % 10 === 2 && i % 100 !== 12 ? two
      : (i % 10 === 7 || i % 10 === 8) && (i % 100 !== 17 && i % 100 !== 18) ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 1 ? one
      : n === 2 || n === 3 ? two
      : n === 4 ? few
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return 1 <= n && n <= 4 ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return (n === 1 || n === 5 || (7 <= n && n <= 9)) ? one
      : n === 2 || n === 3 ? two
      : n === 4 ? few
      : n === 6 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n === 1 ? one
      : n % 10 === 4 && n % 100 !== 14 ? many
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return (n % 10 === 1 || n % 10 === 2) && (n % 100 !== 11 && n % 100 !== 12) ? one
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return (n % 10 === 6 || n % 10 === 9) || n === 10 ? few
      : other
  },
  function (s/*: string | number */)/*: Rule */ {
    var n = +s
    return n % 10 === 3 && n % 100 !== 13 ? few
      : other
  }
]

module.exports = {
  af: { cardinal: f[0] },
  ak: { cardinal: f[1] },
  am: { cardinal: f[2] },
  ar: { cardinal: f[3] },
  ars: { cardinal: f[3] },
  as: { cardinal: f[2], ordinal: f[34] },
  asa: { cardinal: f[0] },
  ast: { cardinal: f[4] },
  az: { cardinal: f[0], ordinal: f[35] },
  be: { cardinal: f[5], ordinal: f[36] },
  bem: { cardinal: f[0] },
  bez: { cardinal: f[0] },
  bg: { cardinal: f[0] },
  bh: { cardinal: f[1] },
  bn: { cardinal: f[2], ordinal: f[34] },
  br: { cardinal: f[6] },
  brx: { cardinal: f[0] },
  bs: { cardinal: f[7] },
  ca: { cardinal: f[4], ordinal: f[37] },
  ce: { cardinal: f[0] },
  cgg: { cardinal: f[0] },
  chr: { cardinal: f[0] },
  ckb: { cardinal: f[0] },
  cs: { cardinal: f[8] },
  cy: { cardinal: f[9], ordinal: f[38] },
  da: { cardinal: f[10] },
  de: { cardinal: f[4] },
  dsb: { cardinal: f[11] },
  dv: { cardinal: f[0] },
  ee: { cardinal: f[0] },
  el: { cardinal: f[0] },
  en: { cardinal: f[4], ordinal: f[39] },
  eo: { cardinal: f[0] },
  es: { cardinal: f[0] },
  et: { cardinal: f[4] },
  eu: { cardinal: f[0] },
  fa: { cardinal: f[2] },
  ff: { cardinal: f[12] },
  fi: { cardinal: f[4] },
  fil: { cardinal: f[13], ordinal: f[0] },
  fo: { cardinal: f[0] },
  fr: { cardinal: f[12], ordinal: f[0] },
  fur: { cardinal: f[0] },
  fy: { cardinal: f[4] },
  ga: { cardinal: f[14], ordinal: f[0] },
  gd: { cardinal: f[15] },
  gl: { cardinal: f[4] },
  gsw: { cardinal: f[0] },
  gu: { cardinal: f[2], ordinal: f[40] },
  guw: { cardinal: f[1] },
  gv: { cardinal: f[16] },
  ha: { cardinal: f[0] },
  haw: { cardinal: f[0] },
  he: { cardinal: f[17] },
  hi: { cardinal: f[2], ordinal: f[40] },
  hr: { cardinal: f[7] },
  hsb: { cardinal: f[11] },
  hu: { cardinal: f[0], ordinal: f[41] },
  hy: { cardinal: f[12], ordinal: f[0] },
  io: { cardinal: f[4] },
  is: { cardinal: f[18] },
  it: { cardinal: f[4], ordinal: f[42] },
  iu: { cardinal: f[19] },
  iw: { cardinal: f[17] },
  jgo: { cardinal: f[0] },
  ji: { cardinal: f[4] },
  jmc: { cardinal: f[0] },
  ka: { cardinal: f[0], ordinal: f[43] },
  kab: { cardinal: f[12] },
  kaj: { cardinal: f[0] },
  kcg: { cardinal: f[0] },
  kk: { cardinal: f[0], ordinal: f[44] },
  kkj: { cardinal: f[0] },
  kl: { cardinal: f[0] },
  kn: { cardinal: f[2] },
  ks: { cardinal: f[0] },
  ksb: { cardinal: f[0] },
  ksh: { cardinal: f[20] },
  ku: { cardinal: f[0] },
  kw: { cardinal: f[19] },
  ky: { cardinal: f[0] },
  lag: { cardinal: f[21] },
  lb: { cardinal: f[0] },
  lg: { cardinal: f[0] },
  ln: { cardinal: f[1] },
  lt: { cardinal: f[22] },
  lv: { cardinal: f[23] },
  mas: { cardinal: f[0] },
  mg: { cardinal: f[1] },
  mgo: { cardinal: f[0] },
  mk: { cardinal: f[24], ordinal: f[45] },
  ml: { cardinal: f[0] },
  mn: { cardinal: f[0] },
  mo: { cardinal: f[25], ordinal: f[0] },
  mr: { cardinal: f[2], ordinal: f[46] },
  mt: { cardinal: f[26] },
  nah: { cardinal: f[0] },
  naq: { cardinal: f[19] },
  nb: { cardinal: f[0] },
  nd: { cardinal: f[0] },
  ne: { cardinal: f[0], ordinal: f[47] },
  nl: { cardinal: f[4] },
  nn: { cardinal: f[0] },
  nnh: { cardinal: f[0] },
  no: { cardinal: f[0] },
  nr: { cardinal: f[0] },
  nso: { cardinal: f[1] },
  ny: { cardinal: f[0] },
  nyn: { cardinal: f[0] },
  om: { cardinal: f[0] },
  or: { cardinal: f[0], ordinal: f[48] },
  os: { cardinal: f[0] },
  pa: { cardinal: f[1] },
  pap: { cardinal: f[0] },
  pl: { cardinal: f[27] },
  prg: { cardinal: f[23] },
  ps: { cardinal: f[0] },
  pt: { cardinal: f[28] },
  'pt-PT': { cardinal: f[4] },
  rm: { cardinal: f[0] },
  ro: { cardinal: f[25], ordinal: f[0] },
  rof: { cardinal: f[0] },
  ru: { cardinal: f[29] },
  rwk: { cardinal: f[0] },
  saq: { cardinal: f[0] },
  scn: { cardinal: f[4], ordinal: f[42] },
  sd: { cardinal: f[0] },
  sdh: { cardinal: f[0] },
  se: { cardinal: f[19] },
  seh: { cardinal: f[0] },
  sh: { cardinal: f[7] },
  shi: { cardinal: f[30] },
  si: { cardinal: f[31] },
  sk: { cardinal: f[8] },
  sl: { cardinal: f[32] },
  sma: { cardinal: f[19] },
  smi: { cardinal: f[19] },
  smj: { cardinal: f[19] },
  smn: { cardinal: f[19] },
  sms: { cardinal: f[19] },
  sn: { cardinal: f[0] },
  so: { cardinal: f[0] },
  sq: { cardinal: f[0], ordinal: f[49] },
  sr: { cardinal: f[7] },
  ss: { cardinal: f[0] },
  ssy: { cardinal: f[0] },
  st: { cardinal: f[0] },
  sv: { cardinal: f[4], ordinal: f[50] },
  sw: { cardinal: f[4] },
  syr: { cardinal: f[0] },
  ta: { cardinal: f[0] },
  te: { cardinal: f[0] },
  teo: { cardinal: f[0] },
  ti: { cardinal: f[1] },
  tig: { cardinal: f[0] },
  tk: { cardinal: f[0], ordinal: f[51] },
  tl: { cardinal: f[13], ordinal: f[0] },
  tn: { cardinal: f[0] },
  tr: { cardinal: f[0] },
  ts: { cardinal: f[0] },
  tzm: { cardinal: f[33] },
  ug: { cardinal: f[0] },
  uk: { cardinal: f[29], ordinal: f[52] },
  ur: { cardinal: f[4] },
  uz: { cardinal: f[0] },
  ve: { cardinal: f[0] },
  vo: { cardinal: f[0] },
  vun: { cardinal: f[0] },
  wa: { cardinal: f[1] },
  wae: { cardinal: f[0] },
  xh: { cardinal: f[0] },
  xog: { cardinal: f[0] },
  yi: { cardinal: f[4] },
  zu: { cardinal: f[2] },
  lo: { ordinal: f[0] },
  ms: { ordinal: f[0] },
  vi: { ordinal: f[0] }
}


/***/ }),

/***/ 164:
/***/ (function(module, exports, __webpack_require__) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiß <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2018 Metaways Infosystems GmbH (http://www.metaways.de)
 */

/**
 * setup webpack entry
 */
__webpack_require__.e(/* import() | Tinebase/js/Tinebase */ 23).then(__webpack_require__.t.bind(null, 46, 7)).then(function (libs) {
  libs.lodash.assign(window, libs);

  __webpack_require__(62);

  __webpack_require__(100);
});

/***/ }),

/***/ 42:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// @flow


/*::
export type AST = Element[]
export type Element = string | Placeholder
export type Placeholder = Plural | Styled | Typed | Simple
export type Plural = [ string, 'plural' | 'selectordinal', number, SubMessages ]
export type Styled = [ string, string, string | SubMessages ]
export type Typed = [ string, string ]
export type Simple = [ string ]
export type SubMessages = { [string]: AST }
export type Token = [ TokenType, string ]
export type TokenType = 'text' | 'space' | 'id' | 'type' | 'style' | 'offset' | 'number' | 'selector' | 'syntax'
type Context = {|
  pattern: string,
  index: number,
  tagsType: ?string,
  tokens: ?Token[]
|}
*/

var ARG_OPN = '{'
var ARG_CLS = '}'
var ARG_SEP = ','
var NUM_ARG = '#'
var TAG_OPN = '<'
var TAG_CLS = '>'
var TAG_END = '</'
var TAG_SELF_CLS = '/>'
var ESC = '\''
var OFFSET = 'offset:'
var simpleTypes = [
  'number',
  'date',
  'time',
  'ordinal',
  'duration',
  'spellout'
]
var submTypes = [
  'plural',
  'select',
  'selectordinal'
]

/**
 * parse
 *
 * Turns this:
 *  `You have { numBananas, plural,
 *       =0 {no bananas}
 *      one {a banana}
 *    other {# bananas}
 *  } for sale`
 *
 * into this:
 *  [ "You have ", [ "numBananas", "plural", 0, {
 *       "=0": [ "no bananas" ],
 *      "one": [ "a banana" ],
 *    "other": [ [ '#' ], " bananas" ]
 *  } ], " for sale." ]
 *
 * tokens:
 *  [
 *    [ "text", "You have " ],
 *    [ "syntax", "{" ],
 *    [ "space", " " ],
 *    [ "id", "numBananas" ],
 *    [ "syntax", ", " ],
 *    [ "space", " " ],
 *    [ "type", "plural" ],
 *    [ "syntax", "," ],
 *    [ "space", "\n     " ],
 *    [ "selector", "=0" ],
 *    [ "space", " " ],
 *    [ "syntax", "{" ],
 *    [ "text", "no bananas" ],
 *    [ "syntax", "}" ],
 *    [ "space", "\n    " ],
 *    [ "selector", "one" ],
 *    [ "space", " " ],
 *    [ "syntax", "{" ],
 *    [ "text", "a banana" ],
 *    [ "syntax", "}" ],
 *    [ "space", "\n  " ],
 *    [ "selector", "other" ],
 *    [ "space", " " ],
 *    [ "syntax", "{" ],
 *    [ "syntax", "#" ],
 *    [ "text", " bananas" ],
 *    [ "syntax", "}" ],
 *    [ "space", "\n" ],
 *    [ "syntax", "}" ],
 *    [ "text", " for sale." ]
 *  ]
 **/
exports = module.exports = function parse (
  pattern/*: string */,
  options/*:: ?: { tagsType?: string, tokens?: Token[] } */
)/*: AST */ {
  return parseAST({
    pattern: String(pattern),
    index: 0,
    tagsType: (options && options.tagsType) || null,
    tokens: (options && options.tokens) || null
  }, '')
}

function parseAST (current/*: Context */, parentType/*: string */)/*: AST */ {
  var pattern = current.pattern
  var length = pattern.length
  var elements/*: AST */ = []
  var start = current.index
  var text = parseText(current, parentType)
  if (text) elements.push(text)
  if (text && current.tokens) current.tokens.push([ 'text', pattern.slice(start, current.index) ])
  while (current.index < length) {
    if (pattern[current.index] === ARG_CLS) {
      if (!parentType) throw expected(current)
      break
    }
    if (parentType && current.tagsType && pattern.slice(current.index, current.index + TAG_END.length) === TAG_END) break
    elements.push(parsePlaceholder(current))
    start = current.index
    text = parseText(current, parentType)
    if (text) elements.push(text)
    if (text && current.tokens) current.tokens.push([ 'text', pattern.slice(start, current.index) ])
  }
  return elements
}

function parseText (current/*: Context */, parentType/*: string */)/*: string */ {
  var pattern = current.pattern
  var length = pattern.length
  var isHashSpecial = (parentType === 'plural' || parentType === 'selectordinal')
  var isAngleSpecial = !!current.tagsType
  var isArgStyle = (parentType === '{style}')
  var text = ''
  while (current.index < length) {
    var char = pattern[current.index]
    if (
      char === ARG_OPN || char === ARG_CLS ||
      (isHashSpecial && char === NUM_ARG) ||
      (isAngleSpecial && char === TAG_OPN) ||
      (isArgStyle && isWhitespace(char.charCodeAt(0)))
    ) {
      break
    } else if (char === ESC) {
      char = pattern[++current.index]
      if (char === ESC) { // double is always 1 '
        text += char
        ++current.index
      } else if (
        // only when necessary
        char === ARG_OPN || char === ARG_CLS ||
        (isHashSpecial && char === NUM_ARG) ||
        (isAngleSpecial && char === TAG_OPN) ||
        isArgStyle
      ) {
        text += char
        while (++current.index < length) {
          char = pattern[current.index]
          if (char === ESC && pattern[current.index + 1] === ESC) { // double is always 1 '
            text += ESC
            ++current.index
          } else if (char === ESC) { // end of quoted
            ++current.index
            break
          } else {
            text += char
          }
        }
      } else { // lone ' is just a '
        text += ESC
        // already incremented
      }
    } else {
      text += char
      ++current.index
    }
  }
  return text
}

function isWhitespace (code/*: number */)/*: boolean */ {
  return (
    (code >= 0x09 && code <= 0x0D) ||
    code === 0x20 || code === 0x85 || code === 0xA0 || code === 0x180E ||
    (code >= 0x2000 && code <= 0x200D) ||
    code === 0x2028 || code === 0x2029 || code === 0x202F || code === 0x205F ||
    code === 0x2060 || code === 0x3000 || code === 0xFEFF
  )
}

function skipWhitespace (current/*: Context */)/*: void */ {
  var pattern = current.pattern
  var length = pattern.length
  var start = current.index
  while (current.index < length && isWhitespace(pattern.charCodeAt(current.index))) {
    ++current.index
  }
  if (start < current.index && current.tokens) {
    current.tokens.push([ 'space', current.pattern.slice(start, current.index) ])
  }
}

function parsePlaceholder (current/*: Context */)/*: Placeholder */ {
  var pattern = current.pattern
  if (pattern[current.index] === NUM_ARG) {
    if (current.tokens) current.tokens.push([ 'syntax', NUM_ARG ])
    ++current.index // move passed #
    return [ NUM_ARG ]
  }

  var tag = parseTag(current)
  if (tag) return tag

  /* istanbul ignore if should be unreachable if parseAST and parseText are right */
  if (pattern[current.index] !== ARG_OPN) throw expected(current, ARG_OPN)
  if (current.tokens) current.tokens.push([ 'syntax', ARG_OPN ])
  ++current.index // move passed {
  skipWhitespace(current)

  var id = parseId(current)
  if (!id) throw expected(current, 'placeholder id')
  if (current.tokens) current.tokens.push([ 'id', id ])
  skipWhitespace(current)

  var char = pattern[current.index]
  if (char === ARG_CLS) { // end placeholder
    if (current.tokens) current.tokens.push([ 'syntax', ARG_CLS ])
    ++current.index // move passed }
    return [ id ]
  }

  if (char !== ARG_SEP) throw expected(current, ARG_SEP + ' or ' + ARG_CLS)
  if (current.tokens) current.tokens.push([ 'syntax', ARG_SEP ])
  ++current.index // move passed ,
  skipWhitespace(current)

  var type = parseId(current)
  if (!type) throw expected(current, 'placeholder type')
  if (current.tokens) current.tokens.push([ 'type', type ])
  skipWhitespace(current)
  char = pattern[current.index]
  if (char === ARG_CLS) { // end placeholder
    if (current.tokens) current.tokens.push([ 'syntax', ARG_CLS ])
    if (type === 'plural' || type === 'selectordinal' || type === 'select') {
      throw expected(current, type + ' sub-messages')
    }
    ++current.index // move passed }
    return [ id, type ]
  }

  if (char !== ARG_SEP) throw expected(current, ARG_SEP + ' or ' + ARG_CLS)
  if (current.tokens) current.tokens.push([ 'syntax', ARG_SEP ])
  ++current.index // move passed ,
  skipWhitespace(current)

  var arg
  if (type === 'plural' || type === 'selectordinal') {
    var offset = parsePluralOffset(current)
    skipWhitespace(current)
    arg = [ id, type, offset, parseSubMessages(current, type) ]
  } else if (type === 'select') {
    arg = [ id, type, parseSubMessages(current, type) ]
  } else if (simpleTypes.indexOf(type) >= 0) {
    arg = [ id, type, parseSimpleFormat(current) ]
  } else { // custom placeholder type
    var index = current.index
    var format/*: string | SubMessages */ = parseSimpleFormat(current)
    skipWhitespace(current)
    if (pattern[current.index] === ARG_OPN) {
      current.index = index // rewind, since should have been submessages
      format = parseSubMessages(current, type)
    }
    arg = [ id, type, format ]
  }

  skipWhitespace(current)
  if (pattern[current.index] !== ARG_CLS) throw expected(current, ARG_CLS)
  if (current.tokens) current.tokens.push([ 'syntax', ARG_CLS ])
  ++current.index // move passed }
  return arg
}

function parseTag (current/*: Context */)/*: ?Placeholder */ {
  var tagsType = current.tagsType
  if (!tagsType || current.pattern[current.index] !== TAG_OPN) return

  if (current.pattern.slice(current.index, current.index + TAG_END.length) === TAG_END) {
    throw expected(current, null, 'closing tag without matching opening tag')
  }
  if (current.tokens) current.tokens.push([ 'syntax', TAG_OPN ])
  ++current.index // move passed <

  var id = parseId(current, true)
  if (!id) throw expected(current, 'placeholder id')
  if (current.tokens) current.tokens.push([ 'id', id ])
  skipWhitespace(current)

  if (current.pattern.slice(current.index, current.index + TAG_SELF_CLS.length) === TAG_SELF_CLS) {
    if (current.tokens) current.tokens.push([ 'syntax', TAG_SELF_CLS ])
    current.index += TAG_SELF_CLS.length
    return [ id, tagsType ]
  }
  if (current.pattern[current.index] !== TAG_CLS) throw expected(current, TAG_CLS)
  if (current.tokens) current.tokens.push([ 'syntax', TAG_CLS ])
  ++current.index // move passed >

  var children = parseAST(current, tagsType)

  var end = current.index
  if (current.pattern.slice(current.index, current.index + TAG_END.length) !== TAG_END) throw expected(current, TAG_END + id + TAG_CLS)
  if (current.tokens) current.tokens.push([ 'syntax', TAG_END ])
  current.index += TAG_END.length
  var closeId = parseId(current, true)
  if (closeId && current.tokens) current.tokens.push([ 'id', closeId ])
  if (id !== closeId) {
    current.index = end // rewind for better error message
    throw expected(current, TAG_END + id + TAG_CLS, TAG_END + closeId + TAG_CLS)
  }
  skipWhitespace(current)
  if (current.pattern[current.index] !== TAG_CLS) throw expected(current, TAG_CLS)
  if (current.tokens) current.tokens.push([ 'syntax', TAG_CLS ])
  ++current.index // move passed >

  return [ id, tagsType, { children: children } ]
}

function parseId (current/*: Context */, isTag/*:: ?: boolean */)/*: string */ {
  var pattern = current.pattern
  var length = pattern.length
  var id = ''
  while (current.index < length) {
    var char = pattern[current.index]
    if (
      char === ARG_OPN || char === ARG_CLS || char === ARG_SEP ||
      char === NUM_ARG || char === ESC || isWhitespace(char.charCodeAt(0)) ||
      (isTag && (char === TAG_OPN || char === TAG_CLS || char === '/'))
    ) break
    id += char
    ++current.index
  }
  return id
}

function parseSimpleFormat (current/*: Context */)/*: string */ {
  var start = current.index
  var style = parseText(current, '{style}')
  if (!style) throw expected(current, 'placeholder style name')
  if (current.tokens) current.tokens.push([ 'style', current.pattern.slice(start, current.index) ])
  return style
}

function parsePluralOffset (current/*: Context */)/*: number */ {
  var pattern = current.pattern
  var length = pattern.length
  var offset = 0
  if (pattern.slice(current.index, current.index + OFFSET.length) === OFFSET) {
    if (current.tokens) current.tokens.push([ 'offset', 'offset' ], [ 'syntax', ':' ])
    current.index += OFFSET.length // move passed offset:
    skipWhitespace(current)
    var start = current.index
    while (current.index < length && isDigit(pattern.charCodeAt(current.index))) {
      ++current.index
    }
    if (start === current.index) throw expected(current, 'offset number')
    if (current.tokens) current.tokens.push([ 'number', pattern.slice(start, current.index) ])
    offset = +pattern.slice(start, current.index)
  }
  return offset
}

function isDigit (code/*: number */)/*: boolean */ {
  return (code >= 0x30 && code <= 0x39)
}

function parseSubMessages (current/*: Context */, parentType/*: string */)/*: SubMessages */ {
  var pattern = current.pattern
  var length = pattern.length
  var options/*: SubMessages */ = {}
  while (current.index < length && pattern[current.index] !== ARG_CLS) {
    var selector = parseId(current)
    if (!selector) throw expected(current, 'sub-message selector')
    if (current.tokens) current.tokens.push([ 'selector', selector ])
    skipWhitespace(current)
    options[selector] = parseSubMessage(current, parentType)
    skipWhitespace(current)
  }
  if (!options.other && submTypes.indexOf(parentType) >= 0) {
    throw expected(current, null, null, '"other" sub-message must be specified in ' + parentType)
  }
  return options
}

function parseSubMessage (current/*: Context */, parentType/*: string */)/*: AST */ {
  if (current.pattern[current.index] !== ARG_OPN) throw expected(current, ARG_OPN + ' to start sub-message')
  if (current.tokens) current.tokens.push([ 'syntax', ARG_OPN ])
  ++current.index // move passed {
  var message = parseAST(current, parentType)
  if (current.pattern[current.index] !== ARG_CLS) throw expected(current, ARG_CLS + ' to end sub-message')
  if (current.tokens) current.tokens.push([ 'syntax', ARG_CLS ])
  ++current.index // move passed }
  return message
}

function expected (current/*: Context */, expected/*:: ?: ?string */, found/*:: ?: ?string */, message/*:: ?: string */) {
  var pattern = current.pattern
  var lines = pattern.slice(0, current.index).split(/\r?\n/)
  var offset = current.index
  var line = lines.length
  var column = lines.slice(-1)[0].length
  found = found || (
    (current.index >= pattern.length) ? 'end of message pattern'
      : (parseId(current) || pattern[current.index])
  )
  if (!message) message = errorMessage(expected, found)
  message += ' in ' + pattern.replace(/\r?\n/g, '\n')
  return new SyntaxError(message, expected, found, offset, line, column)
}

function errorMessage (expected/*: ?string */, found/* string */) {
  if (!expected) return 'Unexpected ' + found + ' found'
  return 'Expected ' + expected + ' but found ' + found
}

/**
 * SyntaxError
 *  Holds information about bad syntax found in a message pattern
 **/
function SyntaxError (message/*: string */, expected/*: ?string */, found/*: ?string */, offset/*: number */, line/*: number */, column/*: number */) {
  Error.call(this, message)
  this.name = 'SyntaxError'
  this.message = message
  this.expected = expected
  this.found = found
  this.offset = offset
  this.line = line
  this.column = column
}
SyntaxError.prototype = Object.create(Error.prototype)
exports.SyntaxError = SyntaxError


/***/ }),

/***/ 43:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// @flow

var formats = __webpack_require__(13)
var lookupClosestLocale = __webpack_require__(14)
var plurals = __webpack_require__(15)

/*::
import type {
  AST,
  SubMessages
} from '../format-message-parse'
type Locale = string
type Locales = Locale | Locale[]
type Placeholder = any[] // https://github.com/facebook/flow/issues/4050
export type Type = (Placeholder, Locales) => (any, ?Object) => any
export type Types = { [string]: Type }
*/

exports = module.exports = function interpret (
  ast/*: AST */,
  locale/*:: ?: Locales */,
  types/*:: ?: Types */
)/*: (args?: Object) => string */ {
  return interpretAST(ast, null, locale || 'en', types || {}, true)
}

exports.toParts = function toParts (
  ast/*: AST */,
  locale/*:: ?: Locales */,
  types/*:: ?: Types */
)/*: (args?: Object) => any[] */ {
  return interpretAST(ast, null, locale || 'en', types || {}, false)
}

function interpretAST (
  elements/*: any[] */,
  parent/*: ?Placeholder */,
  locale/*: Locales */,
  types/*: Types */,
  join/*: boolean */
)/*: Function */ {
  var parts = elements.map(function (element) {
    return interpretElement(element, parent, locale, types, join)
  })

  if (!join) {
    return function format (args) {
      return parts.reduce(function (parts, part) {
        return parts.concat(part(args))
      }, [])
    }
  }

  if (parts.length === 1) return parts[0]
  return function format (args) {
    var message = ''
    for (var e = 0; e < parts.length; ++e) {
      message += parts[e](args)
    }
    return message
  }
}

function interpretElement (
  element/*: Placeholder */,
  parent/*: ?Placeholder */,
  locale/*: Locales */,
  types/*: Types */,
  join/*: boolean */
)/*: Function */ {
  if (typeof element === 'string') {
    var value/*: string */ = element
    return function format () { return value }
  }

  var id = element[0]
  var type = element[1]

  if (parent && element[0] === '#') {
    id = parent[0]
    var offset = parent[2]
    var formatter = (types.number || defaults.number)([ id, 'number' ], locale)
    return function format (args) {
      return formatter(getArg(id, args) - offset, args)
    }
  }

  // pre-process children
  var children
  if (type === 'plural' || type === 'selectordinal') {
    children = {}
    Object.keys(element[3]).forEach(function (key) {
      children[key] = interpretAST(element[3][key], element, locale, types, join)
    })
    element = [ element[0], element[1], element[2], children ]
  } else if (element[2] && typeof element[2] === 'object') {
    children = {}
    Object.keys(element[2]).forEach(function (key) {
      children[key] = interpretAST(element[2][key], element, locale, types, join)
    })
    element = [ element[0], element[1], children ]
  }

  var getFrmt = type && (types[type] || defaults[type])
  if (getFrmt) {
    var frmt = getFrmt(element, locale)
    return function format (args) {
      return frmt(getArg(id, args), args)
    }
  }

  return join
    ? function format (args) { return String(getArg(id, args)) }
    : function format (args) { return getArg(id, args) }
}

function getArg (id/*: string */, args/*: ?Object */)/*: any */ {
  if (args && (id in args)) return args[id]
  var parts = id.split('.')
  var a = args
  for (var i = 0, ii = parts.length; a && i < ii; ++i) {
    a = a[parts[i]]
  }
  return a
}

function interpretNumber (element/*: Placeholder */, locales/*: Locales */) {
  var style = element[2]
  var options = formats.number[style] || formats.parseNumberPattern(style) || formats.number.default
  return new Intl.NumberFormat(locales, options).format
}

function interpretDuration (element/*: Placeholder */, locales/*: Locales */) {
  var style = element[2]
  var options = formats.duration[style] || formats.duration.default
  var fs = new Intl.NumberFormat(locales, options.seconds).format
  var fm = new Intl.NumberFormat(locales, options.minutes).format
  var fh = new Intl.NumberFormat(locales, options.hours).format
  var sep = /^fi$|^fi-|^da/.test(String(locales)) ? '.' : ':'

  return function (s, args) {
    s = +s
    if (!isFinite(s)) return fs(s)
    var h = ~~(s / 60 / 60) // ~~ acts much like Math.trunc
    var m = ~~(s / 60 % 60)
    var dur = (h ? (fh(Math.abs(h)) + sep) : '') +
      fm(Math.abs(m)) + sep + fs(Math.abs(s % 60))
    return s < 0 ? fh(-1).replace(fh(1), dur) : dur
  }
}

function interpretDateTime (element/*: Placeholder */, locales/*: Locales */) {
  var type = element[1]
  var style = element[2]
  var options = formats[type][style] || formats.parseDatePattern(style) || formats[type].default
  return new Intl.DateTimeFormat(locales, options).format
}

function interpretPlural (element/*: Placeholder */, locales/*: Locales */) {
  var type = element[1]
  var pluralType = type === 'selectordinal' ? 'ordinal' : 'cardinal'
  var offset = element[2]
  var children = element[3]
  var pluralRules
  if (Intl.PluralRules && Intl.PluralRules.supportedLocalesOf(locales).length > 0) {
    pluralRules = new Intl.PluralRules(locales, { type: pluralType })
  } else {
    var locale = lookupClosestLocale(locales, plurals)
    var select = (locale && plurals[locale][pluralType]) || returnOther
    pluralRules = { select: select }
  }

  return function (value, args) {
    var clause =
      children['=' + +value] ||
      children[pluralRules.select(value - offset)] ||
      children.other
    return clause(args)
  }
}

function returnOther (/*:: n:number */) { return 'other' }

function interpretSelect (element/*: Placeholder */, locales/*: Locales */) {
  var children = element[2]
  return function (value, args) {
    var clause = children[value] || children.other
    return clause(args)
  }
}

var defaults/*: Types */ = {
  number: interpretNumber,
  ordinal: interpretNumber, // TODO: support rbnf
  spellout: interpretNumber, // TODO: support rbnf
  duration: interpretDuration,
  date: interpretDateTime,
  time: interpretDateTime,
  plural: interpretPlural,
  selectordinal: interpretPlural,
  select: interpretSelect
}
exports.types = defaults


/***/ }),

/***/ 44:
/***/ (function(module, exports) {

/**
 * @license     http://creativecommons.org/licenses/publicdomain Public Domain
 * @author      Koji Horaguchi <horaguchi@horaguchi.net>
 */
if (typeof window.Locale == 'undefined') {
  window.Locale = function (category, locale) {
    this._instance = true;
    this.LC_ALL = 'C';
    this.LC_COLLATE = 'C';
    this.LC_CTYPE = 'C';
    this.LC_MESSAGES = 'C';
    this.LC_MONETARY = 'C';
    this.LC_NUMERIC = 'C';
    this.LC_TIME = 'C';
    this.setlocale(category, locale);
  };
}

Locale.VERSION = '0.0.3';
Locale.EXPORT = ['LC_ALL', 'LC_COLLATE', 'LC_CTYPE', 'LC_MESSAGES', 'LC_MONETARY', 'LC_NUMERIC', 'LC_TIME'];
Locale.EXPORT_OK = ['setlocale'];
Locale.EXPORT_TAGS = {
  ':common': Locale.EXPORT,
  ':all': Locale.EXPORT.concat(Locale.EXPORT_OK)
};
Locale.prototype.TranslationLists = {};
Locale.LC_ALL = 'LC_ALL';
Locale.LC_COLLATE = 'LC_COLLATE';
Locale.LC_CTYPE = 'LC_CTYPE';
Locale.LC_MESSAGES = 'LC_MESSAGES';
Locale.LC_MONETARY = 'LC_MONETARY';
Locale.LC_NUMERIC = 'LC_NUMERIC';
Locale.LC_TIME = 'LC_TIME';

Locale.setlocale = Locale.prototype.setlocale = function (category, locale) {
  return function () {
    if (locale === null || typeof locale == 'undefined') {
      return this[category];
    }

    if (locale == '') {
      locale = (window.navigator.browserLanguage || window.navigator.language || 'C').replace(/^(.{2}).?(.{2})?.*$/, function (match, lang, terr) {
        return lang.toLowerCase() + (terr ? '_' + terr.toUpperCase() : '');
      });
    }

    switch (category) {
      case Locale.LC_ALL:
        this.LC_ALL = locale;
        this.LC_COLLATE = locale;
        this.LC_CTYPE = locale;
        this.LC_MESSAGES = locale;
        this.LC_MONETARY = locale;
        this.LC_NUMERIC = locale;
        this.LC_TIME = locale;
        break;

      case Locale.LC_COLLATE:
      case Locale.LC_CTYPE:
      case Locale.LC_MESSAGES:
      case Locale.LC_MONETARY:
      case Locale.LC_NUMERIC:
      case Locale.LC_TIME:
        this[category] = locale;
        break;

      default:
        return false;
    }

    return locale;
  }.call(this._instance ? this : arguments.callee);
};

Locale.setlocale.LC_ALL = 'C';
Locale.setlocale.LC_COLLATE = 'C';
Locale.setlocale.LC_CTYPE = 'C';
Locale.setlocale.LC_MESSAGES = 'C';
Locale.setlocale.LC_MONETARY = 'C';
Locale.setlocale.LC_NUMERIC = 'C';
Locale.setlocale.LC_TIME = 'C';
/**
 * get translation data from generic locale object (partial clone of Zend Frameworks locale data)
 * 
 * @param   type (Date, Symbol, ...)
 * @param   key  the key
 * @return  translation data
 */

Locale.getTranslationData = function (type, key) {
  var value = '';

  if (Tine.__translationData.TranslationLists[type] && Tine.__translationData.TranslationLists[type][key]) {
    value = Tine.__translationData.TranslationLists[type][key];
  }

  return value;
};
/**
 * get translation list from generic locale object (partial clone of Zend Frameworks locale data)
 * 
 * @param {String} type
 * @return {Object}
 */


Locale.getTranslationList = function (type) {
  return Tine.__translationData.TranslationLists[type];
};

/***/ }),

/***/ 45:
/***/ (function(module, exports) {

/**
 * @license     http://creativecommons.org/licenses/publicdomain Public Domain
 * @author      Koji Horaguchi <horaguchi@horaguchi.net>
 */

/* We don't support dynamic inclusion of po files any longer!
if (typeof ActiveXObject != 'undefined' && typeof XMLHttpRequest == 'undefined') {
  XMLHttpRequest = function () { try { return new ActiveXObject("Msxml2.XMLHTTP");
  } catch (e) { return new ActiveXObject("Microsoft.XMLHTTP"); } };
}
*/

/**
 * @constuctor
 */
Locale.Gettext = function (locale) {
  this.locale = typeof locale == 'string' ? new Locale(Locale.LC_ALL, locale) : locale || Locale;
  this.domain = 'messages';
  this.category = Locale.LC_MESSAGES;
  this.suffix = 'po';
  this.dir = '.';
};

Locale.Gettext.prototype.bindtextdomain = function (domain, dir) {
  this.dir = dir;
  this.domain = domain;
};

Locale.Gettext.prototype.textdomain = function (domain) {
  this.domain = domain;
};

Locale.Gettext.prototype.getmsg = function (domain, category, reload) {
  var key = this._getkey(category, domain);

  return Locale.Gettext.prototype._msgs[key];
};

Locale.Gettext.prototype._msgs = {};

Locale.Gettext.prototype._getkey = function (category, domain) {
  return this.dir + '/' + category + '/' + domain; // expect category is str
};

Locale.Gettext.prototype.dcgettext = function (domain, msgid, category) {
  var msg = this.getmsg(domain, category);
  return msg ? msg.get(msgid) || msgid : msgid;
};

Locale.Gettext.prototype.dcngettext = function (domain, msgid, msgid_plural, n, category) {
  var msg = this.getmsg(domain, category);

  if (msg) {
    return (msg.get(msgid, msgid_plural) || [msgid, msgid_plural])[msg.plural(n)] || (n > 1 ? msgid_plural : msgid);
  } else {
    // fallback if cataloge is not available
    return n > 1 ? msgid_plural : msgid;
  }
};

Locale.Gettext.prototype.dgettext = function (domain, msgid) {
  return this.dcgettext(domain, msgid, this.category);
};

Locale.Gettext.prototype.dngettext = function (domain, msgid, msgid_plural, n) {
  return this.dcngettext(domain, msgid, msgid_plural, n, this.category);
};

Locale.Gettext.prototype.gettext = Locale.Gettext.prototype._ = Locale.Gettext.prototype._hidden = function (msgid) {
  return this.dcgettext(this.domain, msgid, this.category);
};

Locale.Gettext.prototype.ngettext = Locale.Gettext.prototype.n_ = Locale.Gettext.prototype.n_hidden = function (msgid, msgid_plural, n) {
  return this.dcngettext(this.domain, msgid, msgid_plural, n, this.category);
};

Locale.Gettext.prototype.gettext_noop = Locale.Gettext.prototype.N_ = function (msgid) {
  return msgid;
}; // extend object


(function () {
  for (var i in Locale.Gettext.prototype) {
    Locale.Gettext[i] = function (func) {
      return function () {
        return func.apply(Locale.Gettext, arguments);
      };
    }(Locale.Gettext.prototype[i]);
  }
})(); // Locale.Gettext.PO


if (typeof Locale.Gettext.PO == 'undefined') {
  Locale.Gettext.PO = function (object) {
    if (typeof object == 'string' || object instanceof String) {
      this.msg = Locale.Gettext.PO.po2object(object);
    } else if (object instanceof Object) {
      this.msg = object;
    } else {
      this.msg = {};
    }
  };
}

Locale.Gettext.PO.VERSION = '0.0.4';
Locale.Gettext.PO.EXPORT_OK = ['po2object', 'po2json'];

Locale.Gettext.PO.po2object = function (po) {
  return eval(Locale.Gettext.PO.po2json(po));
};

Locale.Gettext.PO.po2json = function (po) {
  var first = true,
      plural = false;
  return '({\n' + po.replace(/\r?\n/g, '\n').replace(/#.*\n/g, '').replace(/"(\n+)"/g, '').replace(/msgid "(.*?)"\nmsgid_plural "(.*?)"/g, 'msgid "$1, $2"').replace(/msg(\S+) /g, function (match, op) {
    switch (op) {
      case 'id':
        return first ? (first = false, '') : plural ? (plural = false, ']\n, ') : ', ';

      case 'str':
        return ': ';

      case 'str[0]':
        return plural = true, ': [\n  ';

      default:
        return ' ,';
    }
  }) + (plural ? ']\n})' : '\n})');
};

Locale.Gettext.PO.prototype.get = function (msgid, msgid_plural) {
  // for msgid_plural == ""
  return typeof msgid_plural != 'undefined' ? this.msg[msgid + ', ' + msgid_plural] : this.msg[msgid];
};

Locale.Gettext.PO.prototype.plural = function (n) {
  var nplurals, plural;
  eval((this.msg[''] + 'Plural-Forms: nplurals=2; plural=n != 1\n').match(/Plural-Forms:(.*)\n/)[1]);
  return plural === true ? 1 : plural === false ? 0 : plural;
}; // create dummy domain


Locale.Gettext.prototype._msgs.emptyDomain = new Locale.Gettext.PO({});

/***/ }),

/***/ 61:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2018 Metaways Infosystems GmbH (http://www.metaways.de)
 */
/* harmony default export */ __webpack_exports__["a"] = (function (condition, timeout, interval) {
  return new Promise(function (resolve, reject) {
    interval = interval || 50;
    let until = timeout ? new Date().getTime() + timeout : Infinity;

    let fn = function fn() {
      let result = condition();

      if (!result) {
        if (new Date().getTime() > until) {
          return reject(new Error('did not succeed in given time interval'));
        } else {
          return window.setTimeout(fn, interval);
        }
      }

      resolve(result);
    };

    fn();
  });
});
;

/***/ }),

/***/ 62:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var util_waitFor_es6__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61);
/*
 * Tine 2.0
 * 
 * @package     Tine
 * @subpackage  Tinebase
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2007-2013 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 * TODO         allow to add user defined part to Tine.title
 */

/*global Ext, Tine, google, OpenLayers, Locale, */

/** ------------------------- Ext.ux Initialisation ------------------------ **/

Ext.ux.Printer.BaseRenderer.prototype.stylesheetPath = 'Tinebase/js/ux/Printer/print.css';
/** ------------------------ Tine 2.0 Initialisation ----------------------- **/

/**
 * @class Tine
 */

Ext.namespace('Tine');
/**
 * version of Tine 2.0 javascript client version, gets set a build / release time <br>
 * <b>Supported Properties:</b>
 * <table>
 *   <tr><td><b>buildType</b></td><td> type of build</td></tr>
 *   <tr><td><b>buildDate</b></td><td> date of build</td></tr>
 *   <tr><td><b>buildRevision</b></td><td> revision of build</td></tr>
 *   <tr><td><b>codeName</b></td><td> codename of release</td></tr>
 *   <tr><td><b>packageString</b></td><td> packageString of release</td></tr>
 *   <tr><td><b>releaseTime</b></td><td> releaseTime of release</td></tr>
 * </table>
 * @type {Object}
 */

Tine.clientVersion = {};
Tine.clientVersion.buildType = 'none';
Tine.clientVersion.buildDate = 'none';
Tine.clientVersion.buildRevision = '2019.12.4';
Tine.clientVersion.codeName = '2019.12';
Tine.clientVersion.packageString = '2019.12.4';
Tine.clientVersion.releaseTime = '2020-01-16 10:55:41';
Tine.__appLoader = __webpack_require__(99);
Tine.__onAllAppsLoaded = new Promise(resolve => {
  Tine.__onAllAppsLoadedResolve = resolve;
});
/**
 * returns promise that resolves when app code of given app is loaded
 *
 * @param appName
 * @return {*|Promise<never>}
 */

Tine.onAppLoaded = appName => {
  return _.get(Tine.__appLoader.appLoadedPromises, appName) || Promise.reject();
};
/**
 * returns promise that resolves when code of all user apps is loaded
 * @return {Promise<any>}
 */


Tine.onAllAppsLoaded = () => {
  return Tine.__onAllAppsLoaded;
};
/**
 * quiet logging in release mode
 */


Ext.LOGLEVEL = Tine.clientVersion.buildType === 'RELEASE' ? 0 : 7;
Tine.log = Ext.ux.log;
Ext.namespace('Tine.Tinebase');
/**
 * @class Tine.Tinebase.tineInit
 * @namespace Tine.Tinebase
 * @sigleton
 * static tine init functions
 */

Tine.Tinebase.tineInit = {
  /**
   * @cfg {String} getAllRegistryDataMethod
   */
  getAllRegistryDataMethod: 'Tinebase.getAllRegistryData',

  /**
   * @cfg {Boolean} stateful
   */
  stateful: true,

  /**
   * @cfg {String} jsonKeyCookieId
   */
  jsonKeyCookieId: 'TINE20JSONKEY',

  /**
   * @cfg {String} requestUrl
   */
  requestUrl: 'index.php',

  /**
   * prefix for localStorage keys
   * @type String
   */
  lsPrefix: Tine.Tinebase.common.getUrl('path') + 'Tine',
  onPreferenceChangeRegistered: false,
  initCustomJS: function initCustomJS() {
    _.each(_.get(window, 'Tine.customJS', []), function (initCustomJS) {
      initCustomJS();
    });
  },
  initWindow: function initWindow() {
    Ext.getBody().on('keydown', function (e) {
      if (e.ctrlKey && e.getKey() === e.A && !(e.getTarget('form') || e.getTarget('input') || e.getTarget('textarea'))) {
        // disable the native 'select all'
        e.preventDefault();
      } else if (e.getKey() === e.BACKSPACE && !(e.getTarget('form') || e.getTarget('input') || e.getTarget('textarea'))) {
        // disable the native 'history back'
        e.preventDefault();
      } else if (!window.isMainWindow && e.ctrlKey && e.getKey() === e.T) {
        // disable the native 'new tab' if in popup window
        e.preventDefault();
      } else if (window.isMainWindow && e.ctrlKey && (e.getKey() === e.L || e.getKey() === e.DELETE)) {
        // reload on ctrl-l
        Tine.Tinebase.common.reload({
          clearCache: true
        });
      } else if (window.isMainWindow && e.getKey() === e.ESC) {
        // select first row of current grid panel if available
        var app = Tine.Tinebase.MainScreen.getActiveApp(),
            centerPanel = app.getMainScreen().getCenterPanel(),
            grid = centerPanel && Ext.isFunction(centerPanel.getGrid) ? centerPanel.getGrid() : null,
            sm = grid ? grid.getSelectionModel() : null;

        if (sm) {
          sm.selectFirstRow();
          grid.getView().focusRow(0);
        }
      } else if (e.ctrlKey && e.getKey() === e.S) {
        Ext.ux.screenshot.ux(window, {
          download: true,
          grabMouse: !e.shiftKey
        });
      }
    }); // disable generic drops

    Ext.getBody().on('dragover', function (e) {
      e.stopPropagation();
      e.preventDefault();
      e.browserEvent.dataTransfer.dropEffect = 'none';
    }, this); // generic context menu

    Ext.getBody().on('contextmenu', function (e) {
      var target = e.getTarget('a', 1, true) || e.getTarget('input[type=text]', 1, true) || e.getTarget('textarea', 1, true);

      if (target) {
        // allow native context menu for links
        return;
      } // allow native context menu on second context click


      if (Tine.Tinebase.MainContextMenu.isVisible()) {
        Tine.Tinebase.MainContextMenu.hide();
        return;
      } // deny native context menu if we have an oown one


      if (Tine.Tinebase.MainContextMenu.showIf(e)) {
        e.stopPropagation();
        e.preventDefault();
      }
    }, this);
    Ext.getBody().on('click', function (e) {
      var target = e.getTarget('a', 1, true),
          href = target ? target.getAttribute('href') : '';

      if (target && href && href != '#') {
        // open internal links in same window (use router)
        if (window.isMainWindow === true) {
          if (target.getAttribute('target') === '_blank') {
            if (href.match(new RegExp('^' + window.lodash.escapeRegExp(Tine.Tinebase.common.getUrl())))) {
              target.set({
                href: decodeURI(href),
                target: "_self"
              });
            }
          }
        } else {
          e.preventDefault();

          if (e.ctrlKey || e.metaKey) {
            var win = window.open(href, '_blank', null, true);
            win.opener = null;
          } else {
            window.opener.location.href = href;
            window.close();
          }
        }
      } else {
        let wavesEl = e.getTarget('.x-btn', 10, true) || e.getTarget('.x-tree-node-el', 10, true);

        if (wavesEl) {
          wavesEl.addClass('waves-effect');
          Waves.ripple(wavesEl.dom);
          wavesEl.removeClass.defer(1500, wavesEl, ['waves-effect']);
        }
      }
    }, this);
    Tine.clientVersion.assetHash = window.assetHash;
  },
  initPostal: function initPostal() {
    if (!window.postal) {
      return;
    }

    var config = postal.fedx.transports.xwindow.configure();
    postal.fedx.transports.xwindow.configure({
      localStoragePrefix: Tine.Tinebase.tineInit.lsPrefix + '.' + config.localStoragePrefix
    });
    postal.instanceId('xwindow-' + _.random(0, 1000));

    postal.configuration.promise.createDeferred = function () {
      return Promise.defer();
    };

    postal.configuration.promise.getPromise = function (dfd) {
      return dfd.promise;
    };

    postal.fedx.configure({
      filterMode: 'blacklist'
    });
    postal.fedx.signalReady();
    postal.addWireTap(function (d, e) {
      Tine.log.debug("ID: " + postal.instanceId() + " " + JSON.stringify(e, null, 4));
    });
  },
  initDebugConsole: function initDebugConsole() {
    var map = new Ext.KeyMap(Ext.getDoc(), [{
      key: [122],
      // F11
      ctrl: true,
      fn: Tine.Tinebase.common.showDebugConsole
    }]);
  },

  /**
   * Each window has exactly one viewport containing a card layout in its lifetime
   * The default card is a splash screen.
   * 
   * default wait panel (picture only no string!)
   */
  initBootSplash: function initBootSplash() {
    Tine.Tinebase.viewport = new Ext.Viewport({
      layout: 'fit',
      border: false,
      items: {
        xtype: 'container',
        ref: 'tineViewportMaincardpanel',
        isWindowMainCardPanel: true,
        layout: 'card',
        border: false,
        activeItem: 0,
        items: [{
          xtype: 'container',
          border: false,
          layout: 'fit',
          width: 16,
          height: 16,
          // the content elements come from the initial html so they are displayed fastly
          contentEl: Ext.select('div[class^=tine-viewport-]')
        }]
      }
    });
  },
  initLoginPanel: function initLoginPanel() {
    if (window.isMainWindow && !Tine.loginPanel) {
      var mainCardPanel = Tine.Tinebase.viewport.tineViewportMaincardpanel;
      Tine.loginPanel = new Tine.Tinebase.LoginPanel({
        defaultUsername: Tine.Tinebase.registry.get('defaultUsername'),
        defaultPassword: Tine.Tinebase.registry.get('defaultPassword')
      });
      mainCardPanel.add(Tine.loginPanel);
    }
  },
  showLoginBox: function showLoginBox(cb, scope) {
    var mainCardPanel = Tine.Tinebase.viewport.tineViewportMaincardpanel,
        activeItem = mainCardPanel.layout.activeItem;
    mainCardPanel.layout.setActiveItem(Tine.loginPanel.id);
    Tine.loginPanel.doLayout();

    Tine.loginPanel.onLogin = function (response) {
      mainCardPanel.layout.setActiveItem(activeItem);
      cb.call(scope || window, response);
    };
  },
  renderWindow: function renderWindow() {
    Tine.log.info('renderWindow::start'); // check if user is already logged in

    if (!Tine.Tinebase.registry.get('currentAccount')) {
      Tine.Tinebase.tineInit.showLoginBox(function (response) {
        Tine.log.info('tineInit::renderWindow -fetch users registry');
        Tine.Tinebase.tineInit.initRegistry(true, function () {
          if (Ext.isWebApp) {
            Tine.Tinebase.registry.set('sessionId', response.responseData.sessionId);
            Tine.Tinebase.registry.set('usercredentialcache', Tine.Tinebase.tineInit.jsonKeyCookieProvider.get('usercredentialcache'));
          }

          Tine.log.info('tineInit::renderWindow - registry fetched, render main window');
          Ext.MessageBox.hide();
          Tine.Tinebase.tineInit.checkClientVersion();
          Tine.Tinebase.tineInit.initWindowMgr();
          Tine.Tinebase.tineInit.renderWindow();
        });
      });
      return;
    } else {
      var sessionLifeTime = Tine.Tinebase.registry.get('sessionLifeTime') || 86400,
          // log out after sessionLifeTime of absence (NOTE: session is not over due to background requests)
      sessionLifeTimeObserver = new Tine.Tinebase.PresenceObserver({
        maxAbsenceTime: sessionLifeTime / 60,
        absenceCallback: function absenceCallback(lastPresence, po) {
          Tine.Tinebase.MainMenu.prototype._doLogout();
        }
      }),
          // report users presence to server
      userPresenceObserver = new Tine.Tinebase.PresenceObserver({
        maxAbsenceTime: 3,
        presenceCallback: function presenceCallback(lastPresence, po) {
          Tine.Tinebase.reportPresence(lastPresence);
        }
      });
    }

    Tine.Tinebase.router = new director.Router().init();
    Tine.Tinebase.router.configure({
      notfound: function notfound() {
        var defaultApp = Tine.Tinebase.appMgr.getDefault();
        Tine.Tinebase.router.setRoute('/' + defaultApp.appName);
      }
    });
    var route = Tine.Tinebase.router.getRoute(),
        winConfig = Ext.ux.PopupWindowMgr.get(window);
    Tine.Tinebase.ApplicationStarter.init();
    Tine.Tinebase.appMgr.getAll(); // dispatch _after_ init resolvers/awaits

    _.defer(() => {
      if (winConfig) {
        var mainCardPanel = Tine.Tinebase.viewport.tineViewportMaincardpanel,
            card = Tine.WindowFactory.getCenterPanel(winConfig);
        mainCardPanel.add(card);
        mainCardPanel.layout.setActiveItem(card.id);
        card.doLayout();
      } else {
        Tine.Tinebase.router.dispatch('on', '/' + route.join('/'));
      }
    });
  },
  initAjax: function initAjax() {
    Ext.Ajax.url = Tine.Tinebase.tineInit.requestUrl;
    Ext.Ajax.method = 'POST';
    Ext.Ajax.defaultHeaders = {
      'X-Tine20-Request-Type': 'JSON'
    };
    Ext.Ajax.transactions = {};
    Tine.Tinebase.tineInit.jsonKeyCookieProvider = new Ext.ux.util.Cookie({
      path: String(Tine.Tinebase.common.getUrl('path')).replace(/\/$/, '')
    });
    /**
     * inspect all requests done via the ajax singleton
     * 
     * - send custom headers
     * - send json key 
     * - implicitly transform non jsonrpc requests
     * 
     * NOTE: implicitly transformed reqeusts get their callback fn's proxied 
     *       through generic response inspectors as defined below
     */

    Ext.Ajax.on('beforerequest', function (connection, options) {
      var jsonKey = Tine.Tinebase.registry && Tine.Tinebase.registry.get ? Tine.Tinebase.registry.get('jsonKey') : '',
          jsonKeyCookieId = Tine.Tinebase.tineInit.jsonKeyCookieId,
          cookieJsonKey = Tine.Tinebase.tineInit.jsonKeyCookieProvider.get(jsonKeyCookieId);

      if (cookieJsonKey) {
        Tine.Tinebase.tineInit.jsonKeyCookieProvider.clear(jsonKeyCookieId); // NOTE cookie reset is not always working in IE, so we need to check jsonKey again

        if (cookieJsonKey && cookieJsonKey != "null") {
          jsonKey = cookieJsonKey;
          Tine.Tinebase.registry.set('jsonKey', jsonKey);
        }
      }

      options.headers = options.headers || {};
      options.headers['X-Tine20-JsonKey'] = jsonKey;
      options.headers['X-Tine20-TransactionId'] = Tine.Tinebase.data.Record.generateUID(); // server might not accept outdated clients

      if (Tine.clientVersion.assetHash) {
        options.headers['X-Tine20-ClientAssetHash'] = Tine.clientVersion.assetHash;
      }

      options.url = Ext.urlAppend(options.url ? options.url : Tine.Tinebase.tineInit.requestUrl, 'transactionid=' + options.headers['X-Tine20-TransactionId']); // convert non Ext.Direct request to jsonrpc
      // - convert params
      // - convert error handling

      if (options.params && !options.isUpload) {
        var params = {};
        var def = Tine.Tinebase.registry.get('serviceMap') ? Tine.Tinebase.registry.get('serviceMap').services[options.params.method] : false;

        if (def) {
          // sort parms according to def
          for (var i = 0, p; i < def.parameters.length; i += 1) {
            p = def.parameters[i].name;
            params[p] = options.params[p];
          }
        } else {
          for (var param in options.params) {
            if (options.params.hasOwnProperty(param) && param !== 'method') {
              params[param] = options.params[param];
            }
          }
        }

        options.jsonData = Ext.encode({
          jsonrpc: '2.0',
          method: options.params.method,
          params: params,
          id: ++Ext.Direct.TID
        });
        options.cbs = {};
        options.cbs.success = options.success || null;
        options.cbs.failure = options.failure || null;
        options.cbs.callback = options.callback || null;
        options.isImplicitJsonRpc = true;
        delete options.params;
        delete options.success;
        delete options.failure;
        delete options.callback;
      }

      Ext.Ajax.transactions[options.headers['X-Tine20-TransactionId']] = {
        date: new Date(),
        json: options.jsonData
      };
    });
    /**
     * inspect completed responses => staus code == 200
     * 
     * - detect resoponse errors (e.g. html from xdebug) and convert to exceptional states
     * - implicitly transform requests from JSONRPC
     * 
     *  NOTE: All programatically catchable exceptions lead to successfull requests
     *        with the jsonprc protocol. For implicitly converted jsonprc requests we 
     *        transform error states here and route them to the error methods defined 
     *        in the request options
     *        
     *  NOTE: Illegal json data responses are mapped to error code 530
     *        Empty resonses (Ext.Decode can't deal with them) are maped to 540
     *        Memory exhausted to 550
     */

    Ext.Ajax.on('requestcomplete', function (connection, response, options) {
      delete Ext.Ajax.transactions[options.headers['X-Tine20-TransactionId']]; // detect resoponse errors (e.g. html from xdebug) and convert into error response

      if (!options.isUpload && !response.responseText.match(/^([{\[])|(<\?xml)+/)) {
        var exception = {
          code: response.responseText !== "" ? 530 : 540,
          message: response.responseText !== "" ? 'illegal json data in response' : 'empty response',
          traceHTML: response.responseText,
          request: options.jsonData,
          response: response.responseText
        }; // Fatal error: Allowed memory size of n bytes exhausted (tried to allocate m bytes) 

        if (response.responseText.match(/^Fatal error: Allowed memory size of /m)) {
          Ext.apply(exception, {
            code: 550,
            message: response.responseText
          });
        } // encapsulate as jsonrpc response


        var requestOptions = Ext.decode(options.jsonData);
        response.responseText = Ext.encode({
          jsonrpc: requestOptions.jsonrpc,
          id: requestOptions.id,
          error: {
            code: -32000,
            message: exception.message,
            data: exception
          }
        });
      } // strip jsonrpc fragments for non Ext.Direct requests


      if (options.isImplicitJsonRpc) {
        var jsonrpc = Ext.decode(response.responseText);

        if (jsonrpc.result) {
          response.responseText = Ext.encode(jsonrpc.result);

          if (options.cbs.success) {
            options.cbs.success.call(options.scope, response, options);
          }

          if (options.cbs.callback) {
            options.cbs.callback.call(options.scope, options, true, response);
          }
        } else {
          response.responseText = Ext.encode(jsonrpc.error);

          if (options.cbs.failure) {
            options.cbs.failure.call(options.scope, response, options);
          } else if (options.cbs.callback) {
            options.cbs.callback.call(options.scope, options, false, response);
          } else {
            var responseData = Ext.decode(response.responseText);
            exception = responseData.data ? responseData.data : responseData;
            exception.request = options.jsonData;
            exception.response = response.responseText;
            Tine.Tinebase.ExceptionHandler.handleRequestException(exception);
          }
        }
      }
    });
    /**
     * inspect request exceptions
     *  - convert to jsonrpc compatiple exceptional states
     *  - call generic exception handler if no handler is defined in request options
     *  
     * NOTE: Request exceptions are exceptional state from web-server:
     *       -> status codes != 200 : This kind of exceptions are not part of the jsonrpc protocol
     *       -> timeouts: status code 520
     */

    Ext.Ajax.on('requestexception', function (connection, response, options) {
      delete Ext.Ajax.transactions[options.headers['X-Tine20-TransactionId']]; // map connection errors to errorcode 510 and timeouts to 520

      var errorCode = response.status > 0 ? response.status : response.status === 0 ? 510 : 520; // convert into error response

      if (!options.isUpload) {
        var exception = {
          code: errorCode,
          message: 'request exception: ' + response.statusText,
          traceHTML: response.responseText,
          request: options.jsonData,
          requestHeaders: options.headers,
          openTransactions: Ext.Ajax.transactions,
          response: response.responseText
        }; // encapsulate as jsonrpc response

        var requestOptions = Ext.decode(options.jsonData);
        response.responseText = Ext.encode({
          jsonrpc: requestOptions.jsonrpc,
          id: requestOptions.id,
          error: {
            code: -32000,
            message: exception.message,
            data: exception
          }
        });
      } // NOTE: Tine.data.RecordProxy is implicitRPC atm.


      if (options.isImplicitJsonRpc) {
        var jsonrpc = Ext.decode(response.responseText);
        response.responseText = Ext.encode(jsonrpc.error);

        if (options.cbs.failure) {
          options.cbs.failure.call(options.scope, response, options);
        } else if (options.cbs.callback) {
          options.cbs.callback.call(options.scope, options, false, response);
        } else {
          var responseData = Ext.decode(response.responseText);
          exception = responseData.data ? responseData.data : responseData;
          Tine.Tinebase.ExceptionHandler.handleRequestException(exception);
        }
      } else if (!options.failure && !options.callback) {
        Tine.Tinebase.ExceptionHandler.handleRequestException(exception);
      }
    });
  },

  /**
   * init registry
   *
   * @param {Boolean} forceReload
   * @param {Function} cb
   * @param {Object} scope
   */
  initRegistry: function initRegistry(forceReload, cb, scope) {
    Tine.Tinebase.registry = store.namespace(Tine.Tinebase.tineInit.lsPrefix + '.' + 'Tinebase.registry');
    var version = Tine.Tinebase.registry.get('version'),
        userApplications = Tine.Tinebase.registry.get('userApplications') || [];
    var reloadNeeded = !version || !userApplications || userApplications.length < 2;

    if (forceReload || reloadNeeded) {
      Tine.Tinebase.tineInit.clearRegistry();
      Ext.Ajax.request({
        timeout: 120000,
        // 2 minutes
        params: {
          method: Tine.Tinebase.tineInit.getAllRegistryDataMethod
        },
        failure: function failure(exception) {
          if (exception.responseText.match(/"code":426/)) {
            return Tine.Tinebase.common.reload({
              keepRegistry: false,
              clearCache: true
            });
          } // if registry could not be loaded, this is mostly due to missconfiguaration
          // don't send error reports for that!


          Tine.Tinebase.ExceptionHandler.handleRequestException({
            code: 503
          });
        },
        success: function success(response, request) {
          var registryData = Ext.util.JSON.decode(response.responseText);

          for (var app in registryData) {
            if (registryData.hasOwnProperty(app)) {
              var appData = registryData[app];
              Ext.ns('Tine.' + app);
              Tine[app].registry = store.namespace(Tine.Tinebase.tineInit.lsPrefix + '.' + app + '.registry');

              for (var key in appData) {
                if (appData.hasOwnProperty(key)) {
                  if (key === 'preferences') {
                    Tine[app].preferences = store.namespace(Tine.Tinebase.tineInit.lsPrefix + '.' + app + '.preferences');

                    for (var pref in appData[key]) {
                      if (appData[key].hasOwnProperty(pref)) {
                        Tine[app].preferences.set(pref, appData[key][pref]);
                      }
                    }
                  } else {
                    Tine[app].registry.set(key, appData[key]);
                  }
                }
              }
            }
          }

          Tine.Tinebase.tineInit.onRegistryLoad().then(function () {
            Ext.util.CSS.refreshCache();
            cb.call(scope);
          });
        }
      });
    } else {
      for (var app, i = 0; i < userApplications.length; i++) {
        app = userApplications[i].name;
        Ext.ns('Tine.' + app);
        Tine[app].registry = store.namespace(Tine.Tinebase.tineInit.lsPrefix + '.' + app + '.registry');
        Tine[app].preferences = store.namespace(Tine.Tinebase.tineInit.lsPrefix + '.' + app + '.preferences');
      }

      Tine.Tinebase.tineInit.onRegistryLoad().then(function () {
        Ext.util.CSS.refreshCache();
        cb.call(scope);
      });
    }
  },

  /**
   * apply registry data
   */
  onRegistryLoad: function onRegistryLoad() {
    if (!Tine.Tinebase.tineInit.onPreferenceChangeRegistered && Tine.Tinebase.registry.get('preferences') && Tine.Tinebase.registry.get('currentAccount')) {
      Tine.log.info('tineInit::onRegistryLoad - register onPreferenceChange handler');
      Tine.Tinebase.preferences.on('replace', Tine.Tinebase.tineInit.onPreferenceChange);
      Tine.Tinebase.tineInit.onPreferenceChangeRegistered = true;
    }

    Ext.util.CSS.updateRule('.tine-favicon', 'background-image', 'url(' + Tine.Tinebase.registry.get('brandingFaviconSvg') + ')');
    Tine.title = Tine.Tinebase.registry.get('brandingTitle');
    Tine.descriptoion = Tine.Tinebase.registry.get('brandingTitle');
    Tine.logo = Tine.Tinebase.registry.get('brandingLogo');
    Tine.weburl = Tine.Tinebase.registry.get('brandingWeburl');
    Tine.helpUrl = Tine.Tinebase.registry.get('brandingHelpUrl');
    Tine.shop = Tine.Tinebase.registry.get('brandingShopUrl');
    Tine.bugreportUrl = Tine.Tinebase.registry.get('brandingBugsUrl');
    Tine.installLogo = Tine.Tinebase.registry.get('installLogo') ? Tine.Tinebase.registry.get('installLogo') : Tine.Tinebase.registry.get('brandingLogo');
    Tine.websiteUrl = Tine.Tinebase.registry.get('websiteUrl') ? Tine.Tinebase.registry.get('websiteUrl') : Tine.Tinebase.registry.get('brandingWeburl');

    if (Ext.isWebApp && Tine.Tinebase.registry.get('sessionId')) {
      // restore session cookie
      Tine.Tinebase.tineInit.jsonKeyCookieProvider.set('TINE20SESSID', Tine.Tinebase.registry.get('sessionId'));
      Tine.Tinebase.tineInit.jsonKeyCookieProvider.set('usercredentialcache', Tine.Tinebase.registry.get('usercredentialcache'));
    }

    Ext.override(Ext.ux.file.Upload, {
      maxFileUploadSize: Tine.Tinebase.registry.get('maxFileUploadSize'),
      maxPostSize: Tine.Tinebase.registry.get('maxPostSize')
    });
    Tine.Tinebase.tineInit.initExtDirect();
    formatMessage.setup({
      locale: Tine.Tinebase.registry.get('locale').locale || 'en'
    });
    Tine.Tinebase.tineInit.initState();

    if (Tine.Tinebase.registry.get('currentAccount')) {
      Tine.Tinebase.tineInit.initAppMgr();
    }

    Tine.Tinebase.tineInit.initUploadMgr();
    Tine.Tinebase.tineInit.initLoginPanel(); // we don't want iOS/Andorid to place stuff to some other cloud
    // we might need to add a real config for this
    // it's not clear how to detect devices w.o. local storage or clients which place
    // downloads in a cloud :-(

    Tine.Tinebase.configManager.set('downloadsAllowed', !Ext.isIOS && !Ext.isAndorid);

    var AreaLocks = __webpack_require__(105);

    Tine.Tinebase.areaLocks = new AreaLocks.AreaLocks(); // load initial js of user enabled apps
    // @TODO: move directly after login (login should return requested parts of registry)

    return Tine.__appLoader.loadAllApps(Tine.Tinebase.registry.get('userApplications')).then(function () {
      Tine.Tinebase.tineInit.initCustomJS();

      Tine.__onAllAppsLoadedResolve();
    });
  },

  /**
   * check client version and reload on demand
   */
  checkClientVersion: function checkClientVersion() {
    var serverHash = Tine.Tinebase.registry.get('version').assetHash,
        buildType = Tine.Tinebase.registry.get('version').buildType,
        clientHash = Tine.clientVersion.assetHash;

    if (clientHash && clientHash != serverHash && ['RELEASE', 'DEBUG'].indexOf(buildType) > -1) {
      Ext.MessageBox.show({
        buttons: Ext.Msg.OK,
        icon: Ext.MessageBox.WARNING,
        title: i18n._('Your Client is Outdated'),
        msg: i18n._('A new client is available, press OK to get this version'),
        fn: function fn() {
          Tine.Tinebase.common.reload({
            keepRegistry: false,
            clearCache: true
          });
        }
      });
    }
  },

  /**
   * remove all registry data
   */
  clearRegistry: function clearRegistry() {
    Tine.log.info('tineInit::clearRegistry');

    if (Ext.isFunction(store.namespace)) {
      store.namespace(Tine.Tinebase.tineInit.lsPrefix).clearAll();
    }
  },

  /**
   * executed when a value in Tinebase registry/preferences changed
   *
   * @param {string} key
   * @param {value} oldValue
   * @param {value} newValue
   */
  onPreferenceChange: function onPreferenceChange(key, oldValue, newValue) {
    if (Tine.Tinebase.tineInit.isReloading) {
      return;
    }

    switch (key) {
      case 'windowtype':
      case 'confirmLogout':
      case 'timezone':
      case 'locale':
        Tine.log.info('tineInit::onPreferenceChange - reload mainscreen');
        Tine.Tinebase.common.reload({
          clearCache: key == 'locale'
        });
        break;
    }
  },

  /**
   * initialise window and windowMgr (only popup atm.)
   */
  initWindowMgr: function initWindowMgr() {
    // touch UI support
    if (Ext.isTouchDevice) {
      __webpack_require__.e(/* require.ensure | Tinebase/js/hammerjs */ 26).then((function () {
        __webpack_require__(80); // global by include :-(


        Ext.apply(Ext.EventObject, {
          // NOTE: multipoint gesture events have no xy, so we need to grab it from gesture
          getXY: function getXY() {
            if (this.browserEvent && this.browserEvent.gesture && this.browserEvent.gesture.center) {
              this.xy = [this.browserEvent.gesture.center.x, this.browserEvent.gesture.center.y];
            }

            return this.xy;
          }
        });
        var mc = new Hammer.Manager(Ext.getDoc().dom, {
          domEvents: true
        }); // convert two finger taps into contextmenu clicks

        mc.add(new Hammer.Tap({
          event: 'contextmenu',
          pointers: 2
        })); // convert double taps into double clicks

        mc.add(new Hammer.Tap({
          event: 'dblclick',
          taps: 2
        })); // NOTE: document scroll only happens when soft keybord is displayed and therefore viewport scrolls.
        //       in this case, content might not be accessable
        //Ext.getDoc().on('scroll', function() {
        //
        //}, this);
      }).bind(null, __webpack_require__)).catch(__webpack_require__.oe);
    }

    Ext.getDoc().on('orientationchange', function () {
      // @TODO: iOS safari only?
      var metas = document.getElementsByTagName('meta');

      for (var i = 0; i < metas.length; i++) {
        if (metas[i].name == "viewport") {
          metas[i].content = "width=device-width, maximum-scale=1.0"; // NOTE: if we don't release the max scale here, we get wired layout effects

          metas[i].content = "width=device-width, maximum-scale=10, user-scalable=no";
        }
      } // NOTE: need to hide soft-keybord before relayouting to preserve layout


      document.activeElement.blur();
      Tine.Tinebase.viewport.doLayout.defer(500, Tine.Tinebase.viewport);
    }, this); // adjust modal windows when browser gets resized (also orientation change)

    Tine.Tinebase.viewport.on('resize', function (viewport, adjWidth, adjHeight, rawWidth, rawHeight) {
      Ext.WindowMgr.each(function (win) {
        var currSize = win.getSize(),
            normSize = win.normSize || currSize,
            maxSize = {
          width: adjWidth,
          height: adjHeight
        };
        win.setSize(Math.min(Math.max(currSize.width, normSize.width), maxSize.width), Math.min(Math.max(currSize.height, normSize.height), maxSize.height));
        win.center();
      });
    }, this, {
      buffer: 150
    }); // initialise window types

    var windowType = '';
    Ext.ux.PopupWindow.prototype.url = Tine.Tinebase.common.getUrl();

    if (Tine.Tinebase.registry && Tine.Tinebase.registry.get('preferences')) {
      // update window factory window type (required after login)
      windowType = Tine.Tinebase.registry.get('preferences').get('windowtype');
    }

    if (!windowType || windowType == 'autodetect') {
      // var browserDetection = require('browser-detection');
      windowType = Ext.supportsPopupWindows ? 'Browser' : 'Ext';
    }

    Tine.WindowFactory = new Ext.ux.WindowFactory({
      windowType: windowType
    });
  },

  /**
   * initialise state provider
   */
  initState: function initState() {
    if (Tine.Tinebase.tineInit.stateful === true) {
      if (window.isMainWindow) {
        // NOTE: IE is as always pain in the ass! cross window issues prohibit serialisation of state objects
        Ext.state.Manager.setProvider(new Tine.Tinebase.StateProvider());
      } else {
        var mainWindow = Ext.ux.PopupWindowMgr.getMainWindow();
        Ext.state.Manager = mainWindow.Ext.state.Manager;
      }
    }
  },

  /**
   * add provider to Ext.Direct based on Tine servicemap
   */
  initExtDirect: function initExtDirect() {
    var sam = Tine.Tinebase.registry.get('serviceMap');
    Ext.Direct.addProvider(Ext.apply(sam, {
      'type': 'jsonrpcprovider',
      'namespace': 'Tine',
      'url': sam.target
    }));
  },

  /**
   * initialise application manager
   */
  initAppMgr: function initAppMgr() {
    if (!window.isMainWindow) {
      // return app from main window for non-IE browsers
      Tine.Tinebase.appMgr = Ext.ux.PopupWindowMgr.getMainWindow().Tine.Tinebase.appMgr;
    } else {
      Tine.Tinebase.appMgr = new Tine.Tinebase.AppManager();
    }
  },

  /**
   * initialise upload manager
   */
  initUploadMgr: function initUploadMgr() {
    Tine.Tinebase.uploadManager = new Ext.ux.file.UploadManager();
  },

  /**
   * config locales
   */
  initLocale: async function initLocale() {
    var _ = window.lodash,
        formatMessage = __webpack_require__(9); // NOTE: we use gettext tooling for template selection
    //       as there is almost no tooling for icu-messages out there


    formatMessage.setup({
      missingTranslation: 'ignore'
    }); // auto template selection with gettext

    window.formatMessage = function (template) {
      arguments[0] = window.i18n._hidden(template);
      return formatMessage.apply(formatMessage, arguments);
    };

    window.lodash.assign(window.formatMessage, formatMessage);

    __webpack_require__(44);

    __webpack_require__(45);

    await Object(util_waitFor_es6__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])(function () {
      return Tine.__translationData.__isLoaded;
    });

    _.each(Tine.__translationData.msgs, function (msgs, category) {
      Locale.Gettext.prototype._msgs[category] = new Locale.Gettext.PO(msgs);
    });

    window.i18n = new Locale.Gettext();
    window.i18n.textdomain('Tinebase');
  }
};
Ext.onReady(async function () {
  Tine.Tinebase.tineInit.initWindow();
  Tine.Tinebase.tineInit.initPostal();
  Tine.Tinebase.tineInit.initDebugConsole();
  Tine.Tinebase.tineInit.initBootSplash();
  await Tine.Tinebase.tineInit.initLocale();
  Tine.Tinebase.tineInit.initAjax();
  Tine.Tinebase.tineInit.initRegistry(false, function () {
    Tine.Tinebase.tineInit.checkClientVersion();
    Tine.Tinebase.tineInit.initWindowMgr();
    Tine.Tinebase.tineInit.renderWindow();
  });
});

/***/ }),

/***/ 9:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// @flow

var parse = __webpack_require__(42)
var interpret = __webpack_require__(43)
var plurals = __webpack_require__(15)
var lookupClosestLocale = __webpack_require__(14)
var origFormats = __webpack_require__(13)

/*::
import type { Types } from 'format-message-interpret'
type Locale = string
type Locales = Locale | Locale[]
type Message = string | {|
  id?: string,
  default: string,
  description?: string
|}
type Translations = { [string]: ?{ [string]: string | Translation } }
type Translation = {
  message: string,
  format?: (args?: Object) => string,
  toParts?: (args?: Object) => any[],
}
type Replacement = ?string | (string, string, locales?: Locales) => ?string
type GenerateId = (string) => string
type MissingTranslation = 'ignore' | 'warning' | 'error'
type FormatObject = { [string]: * }
type Options = {
  locale?: Locales,
  translations?: ?Translations,
  generateId?: GenerateId,
  missingReplacement?: Replacement,
  missingTranslation?: MissingTranslation,
  formats?: {
    number?: FormatObject,
    date?: FormatObject,
    time?: FormatObject
  },
  types?: Types
}
type Setup = {|
  locale: Locales,
  translations: Translations,
  generateId: GenerateId,
  missingReplacement: Replacement,
  missingTranslation: MissingTranslation,
  formats: {
    number: FormatObject,
    date: FormatObject,
    time: FormatObject
  },
  types: Types
|}
type FormatMessage = {
  (msg: Message, args?: Object, locales?: Locales): string,
  rich (msg: Message, args?: Object, locales?: Locales): any[],
  setup (opt?: Options): Setup,
  number (value: number, style?: string, locales?: Locales): string,
  date (value: number | Date, style?: string, locales?: Locales): string,
  time (value: number | Date, style?: string, locales?: Locales): string,
  select (value: any, options: Object): any,
  custom (placeholder: any[], locales: Locales, value: any, args: Object): any,
  plural (value: number, offset: any, options: any, locale: any): any,
  selectordinal (value: number, offset: any, options: any, locale: any): any,
  namespace (): FormatMessage
}
*/

function assign/*:: <T: Object> */ (target/*: T */, source/*: Object */) {
  Object.keys(source).forEach(function (key) { target[key] = source[key] })
  return target
}

function namespace ()/*: FormatMessage */ {
  var formats = assign({}, origFormats)
  var currentLocales/*: Locales */ = 'en'
  var translations/*: Translations */ = {}
  var generateId/*: GenerateId */ = function (pattern) { return pattern }
  var missingReplacement/*: Replacement */ = null
  var missingTranslation/*: MissingTranslation */ = 'warning'
  var types/*: Types */ = {}

  function formatMessage (msg/*: Message */, args/*:: ?: Object */, locales/*:: ?: Locales */) {
    var pattern = typeof msg === 'string' ? msg : msg.default
    var id = (typeof msg === 'object' && msg.id) || generateId(pattern)
    var translated = translate(pattern, id, locales || currentLocales)
    var format = translated.format || (
      translated.format = interpret(parse(translated.message), locales || currentLocales, types)
    )
    return format(args)
  }

  formatMessage.rich = function rich (msg/*: Message */, args/*:: ?: Object */, locales/*:: ?: Locales */) {
    var pattern = typeof msg === 'string' ? msg : msg.default
    var id = (typeof msg === 'object' && msg.id) || generateId(pattern)
    var translated = translate(pattern, id, locales || currentLocales)
    var format = translated.toParts || (
      translated.toParts = interpret.toParts(parse(translated.message, { tagsType: tagsType }), locales || currentLocales, types)
    )
    return format(args)
  }

  var tagsType = '<>'
  function richType (node/*: any[] */, locales/*: Locales */) {
    var style = node[2]
    return function (fn, args) {
      var props = typeof style === 'object' ? mapObject(style, args) : style
      return typeof fn === 'function' ? fn(props) : fn
    }
  }
  types[tagsType] = richType

  function mapObject (object/* { [string]: (args?: Object) => any } */, args/*: ?Object */) {
    return Object.keys(object).reduce(function (mapped, key) {
      mapped[key] = object[key](args)
      return mapped
    }, {})
  }

  function translate (pattern/*: string */, id/*: string */, locales/*: Locales */)/*: Translation */ {
    var locale = lookupClosestLocale(locales, translations) || 'en'
    var messages = translations[locale] || (translations[locale] = {})
    var translated = messages[id]
    if (typeof translated === 'string') {
      translated = messages[id] = { message: translated }
    }
    if (!translated) {
      var message = 'Translation for "' + id + '" in "' + locale + '" is missing'
      if (missingTranslation === 'warning') {
        /* istanbul ignore else */
        if (typeof console !== 'undefined') console.warn(message)
      } else if (missingTranslation !== 'ignore') { // 'error'
        throw new Error(message)
      }
      var replacement = typeof missingReplacement === 'function'
        ? missingReplacement(pattern, id, locale) || pattern
        : missingReplacement || pattern
      translated = messages[id] = { message: replacement }
    }
    return translated
  }

  formatMessage.setup = function setup (opt/*:: ?: Options */) {
    opt = opt || {}
    if (opt.locale) currentLocales = opt.locale
    if ('translations' in opt) translations = opt.translations || {}
    if (opt.generateId) generateId = opt.generateId
    if ('missingReplacement' in opt) missingReplacement = opt.missingReplacement
    if (opt.missingTranslation) missingTranslation = opt.missingTranslation
    if (opt.formats) {
      if (opt.formats.number) assign(formats.number, opt.formats.number)
      if (opt.formats.date) assign(formats.date, opt.formats.date)
      if (opt.formats.time) assign(formats.time, opt.formats.time)
    }
    if (opt.types) {
      types = opt.types
      types[tagsType] = richType
    }
    return {
      locale: currentLocales,
      translations: translations,
      generateId: generateId,
      missingReplacement: missingReplacement,
      missingTranslation: missingTranslation,
      formats: formats,
      types: types
    }
  }

  formatMessage.number = function (value/*: number */, style/*:: ?: string */, locales/*:: ?: Locales */) {
    var options = (style && formats.number[style]) ||
      formats.parseNumberPattern(style) ||
      formats.number.default
    return new Intl.NumberFormat(locales || currentLocales, options).format(value)
  }

  formatMessage.date = function (value/*:: ?: number | Date */, style/*:: ?: string */, locales/*:: ?: Locales */) {
    var options = (style && formats.date[style]) ||
      formats.parseDatePattern(style) ||
      formats.date.default
    return new Intl.DateTimeFormat(locales || currentLocales, options).format(value)
  }

  formatMessage.time = function (value/*:: ?: number | Date */, style/*:: ?: string */, locales/*:: ?: Locales */) {
    var options = (style && formats.time[style]) ||
      formats.parseDatePattern(style) ||
      formats.time.default
    return new Intl.DateTimeFormat(locales || currentLocales, options).format(value)
  }

  formatMessage.select = function (value/*: any */, options/*: Object */) {
    return options[value] || options.other
  }

  formatMessage.custom = function (placeholder/*: any[] */, locales/*: Locales */, value/*: any */, args/*: Object */) {
    if (!(placeholder[1] in types)) return value
    return types[placeholder[1]](placeholder, locales)(value, args)
  }

  formatMessage.plural = plural.bind(null, 'cardinal')
  formatMessage.selectordinal = plural.bind(null, 'ordinal')
  function plural (
    pluralType/*: 'cardinal' | 'ordinal' */,
    value/*: number */,
    offset/*: any */,
    options/*: any */,
    locale/*: any */
  ) {
    if (typeof offset === 'object' && typeof options !== 'object') { // offset is optional
      locale = options
      options = offset
      offset = 0
    }
    var closest = lookupClosestLocale(locale || currentLocales, plurals)
    var plural = (closest && plurals[closest][pluralType]) || returnOther
    return options['=' + +value] || options[plural(value - offset)] || options.other
  }
  function returnOther (/*:: n:number */) { return 'other' }

  formatMessage.namespace = namespace

  return formatMessage
}

module.exports = exports = namespace()


/***/ }),

/***/ 99:
/***/ (function(module, exports, __webpack_require__) {

var _ = window.lodash,
     availableApps = {
  "ActiveSync/js/ActiveSync": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/ActiveSync/ActiveSync.jsb2",
  "Addressbook/js/Addressbook": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Addressbook/Addressbook.jsb2",
  "Admin/js/Admin": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Admin/Admin.jsb2",
  "Calendar/js/Calendar": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Calendar/js/Calendar.js",
  "CoreData/js/CoreData": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/CoreData/CoreData.jsb2",
  "Courses/js/Courses": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Courses/Courses.jsb2",
  "Crm/js/Crm": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Crm/Crm.jsb2",
  "ExampleApplication/js/ExampleApplication": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/ExampleApplication/ExampleApplication.jsb2",
  "Felamimail/js/Felamimail": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Felamimail/Felamimail.jsb2",
  "Filemanager/js/Filemanager": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Filemanager/Filemanager.jsb2",
  "HumanResources/js/HumanResources": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/HumanResources/HumanResources.jsb2",
  "Inventory/js/Inventory": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Inventory/Inventory.jsb2",
  "Phone/js/Phone": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Phone/Phone.jsb2",
  "Projects/js/Projects": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Projects/Projects.jsb2",
  "Sales/js/Sales": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Sales/Sales.jsb2",
  "Setup/js/Setup": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Setup/js/Setup.js",
  "SimpleFAQ/js/SimpleFAQ": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/SimpleFAQ/SimpleFAQ.jsb2",
  "Tasks/js/Tasks": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Tasks/Tasks.jsb2",
  "Timetracker/js/Timetracker": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Timetracker/Timetracker.jsb2",
  "Tinebase/js/Tinebase": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Tinebase/js/Tinebase.js",
  "Voipmanager/js/Voipmanager": "/root/packaging/tine20.org/2019.12/source/tine20build/temp/tine20/Voipmanager/Voipmanager.jsb2"
},
     appResolves = {},
     appLoadedPromises = {};

_.each(availableApps, function(index,key) {
  var appName = key.replace(/\/.*$/, "");
  appLoadedPromises[appName] = new Promise(function(resolve) {
    appResolves[appName] = resolve;
  });
});

module.exports = {
  loadAllApps: function(userApps) {
    var pms = _.reduce(userApps, function(p, app) {
      var appName = "ActiveSync"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | ActiveSync/js/ActiveSync */ 1).then(__webpack_require__.t.bind(null, 170, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Addressbook"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Addressbook/js/Addressbook */ 2).then(__webpack_require__.t.bind(null, 171, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Admin"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Admin/js/Admin */ 3).then(__webpack_require__.t.bind(null, 172, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Calendar"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Calendar/js/Calendar */ 4).then(__webpack_require__.t.bind(null, 169, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "CoreData"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | CoreData/js/CoreData */ 6).then(__webpack_require__.t.bind(null, 173, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Courses"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Courses/js/Courses */ 7).then(__webpack_require__.t.bind(null, 174, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Crm"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Crm/js/Crm */ 8).then(__webpack_require__.t.bind(null, 175, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "ExampleApplication"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | ExampleApplication/js/ExampleApplication */ 9).then(__webpack_require__.t.bind(null, 176, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Felamimail"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Felamimail/js/Felamimail */ 10).then(__webpack_require__.t.bind(null, 177, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Filemanager"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Filemanager/js/Filemanager */ 11).then(__webpack_require__.t.bind(null, 178, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "HumanResources"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | HumanResources/js/HumanResources */ 12).then(__webpack_require__.t.bind(null, 179, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Inventory"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Inventory/js/Inventory */ 13).then(__webpack_require__.t.bind(null, 180, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Phone"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Phone/js/Phone */ 14).then(__webpack_require__.t.bind(null, 181, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Projects"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Projects/js/Projects */ 15).then(__webpack_require__.t.bind(null, 182, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Sales"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Sales/js/Sales */ 16).then(__webpack_require__.t.bind(null, 183, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Setup"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Setup/js/Setup */ 17).then(__webpack_require__.t.bind(null, 184, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "SimpleFAQ"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | SimpleFAQ/js/SimpleFAQ */ 19).then(__webpack_require__.t.bind(null, 185, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Tasks"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Tasks/js/Tasks */ 20).then(__webpack_require__.t.bind(null, 186, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Timetracker"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Timetracker/js/Timetracker */ 21).then(__webpack_require__.t.bind(null, 187, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Tinebase"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Tinebase/js/Tinebase */ 23).then(__webpack_require__.t.bind(null, 46, 7))}).then(function() {
          appResolves[appName]();
        });
      }

      var appName = "Voipmanager"; 
      if(app.name == appName) {
        return p.then(function() {return __webpack_require__.e(/* import() | Voipmanager/js/Voipmanager */ 30).then(__webpack_require__.t.bind(null, 188, 7))}).then(function() {
          appResolves[appName]();
        });
      }

    return p;
    }, Promise.resolve());
    return pms;
  },
  appLoadedPromises: appLoadedPromises
}


/***/ })

/******/ });
});