(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[8],{

/***/ 1387:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Crm
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2009-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Crm');
/**
 * @namespace   Tine.Crm
 * @class       Tine.Crm.AddressbookGridPanelHook
 * 
 * <p>Crm Addressbook Hook</p>
 * <p>
 * </p>
 * 
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * 
 * @constructor
 */

Tine.Crm.AddressbookGridPanelHook = Ext.extend(Tine.Addressbook.GenericContactGridPanelHook, {
  modelName: 'Lead'
});

/***/ }),

/***/ 1388:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * Crm combo box and store
 * 
 * @package     Crm
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <alex@stintzing.net>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Crm');
/**
 * Lead selection combo box
 * 
 * @namespace   Tine.Crm
 * @class       Tine.Crm.SearchCombo
 * @extends     Tine.Tinebase.widgets.form.RecordPickerComboBox
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <alex@stintzing.net>
 * @copyright   Copyright (c) 2007-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Crm.SearchCombo
 */

Tine.Crm.SearchCombo = Ext.extend(Tine.Tinebase.widgets.form.RecordPickerComboBox, {
  allowBlank: false,
  itemSelector: 'div.search-item',
  minListWidth: 200,
  //private
  initComponent: function initComponent() {
    this.recordClass = Tine.Crm.Model.Lead;
    this.recordProxy = Tine.Crm.recordBackend;
    this.initTemplate();
    Tine.Crm.SearchCombo.superclass.initComponent.call(this);
    this.displayField = 'lead_name';
  },

  /**
   * init template
   * @private
   */
  initTemplate: function initTemplate() {
    if (!this.tpl) {
      this.tpl = new Ext.XTemplate('<tpl for="."><div class="search-item">', '{[this.encode(values)]}', '</div></tpl>', {
        encode: function encode(values) {
          return Ext.util.Format.htmlEncode(values.lead_name);
        }
      });
    }
  },
  getValue: function getValue() {
    return Tine.Crm.SearchCombo.superclass.getValue.call(this);
  },
  setValue: function setValue(value) {
    return Tine.Crm.SearchCombo.superclass.setValue.call(this, value);
  }
});
Ext.reg('crmleadpickercombobox', Tine.Crm.SearchCombo);
Tine.widgets.form.RecordPickerManager.register('Crm', 'Lead', 'crmleadpickercombobox');

/***/ }),

/***/ 1389:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Crm
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2007-2010 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Crm', 'Tine.Crm.Model');
/**
 * @namespace Tine.Crm.Model
 * @class Tine.Crm.Model.Lead
 * @extends Tine.Tinebase.data.Record
 * 
 * Lead Record Definition
 */

Tine.Crm.Model.Lead = Tine.Tinebase.data.Record.create(Tine.Tinebase.Model.genericFields.concat([{
  name: 'id',
  type: 'string',
  omitDuplicateResolving: true
}, {
  name: 'lead_name',
  type: 'string',
  label: 'Lead name',
  group: 'Lead'
}, {
  name: 'leadstate_id',
  type: 'int',
  omitDuplicateResolving: true
}, {
  name: 'leadtype_id',
  type: 'int',
  omitDuplicateResolving: true
}, {
  name: 'leadsource_id',
  type: 'int',
  omitDuplicateResolving: true
}, {
  name: 'start',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long,
  label: 'Start',
  group: 'Lead'
}, {
  name: 'description',
  type: 'string',
  label: 'Description',
  group: 'Lead'
}, {
  name: 'end',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long,
  label: 'End',
  group: 'Lead'
}, {
  name: 'turnover',
  type: 'float',
  omitDuplicateResolving: true
}, {
  name: 'probability',
  type: 'int',
  omitDuplicateResolving: true
}, {
  name: 'probableTurnover',
  type: 'int',
  omitDuplicateResolving: true
}, {
  name: 'end_scheduled',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long,
  omitDuplicateResolving: true
}, {
  name: 'resubmission_date',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long,
  omitDuplicateResolving: true
}, {
  name: 'lastread',
  omitDuplicateResolving: true
}, {
  name: 'lastreader',
  omitDuplicateResolving: true
}, {
  name: 'responsible',
  omitDuplicateResolving: true
}, {
  name: 'customer',
  omitDuplicateResolving: true,
  label: 'Customer',
  group: 'Relationen'
}, {
  name: 'partner',
  omitDuplicateResolving: true,
  label: 'Partner',
  group: 'Relationen'
}, {
  name: 'tasks',
  omitDuplicateResolving: true
}, {
  name: 'relations',
  label: 'Relationen',
  group: 'Relationen'
}, {
  name: 'products',
  omitDuplicateResolving: true,
  label: 'Products',
  group: 'Relationen'
}, {
  name: 'tags',
  label: 'Tags'
}, {
  name: 'notes',
  omitDuplicateResolving: true
}, {
  name: 'customfields',
  omitDuplicateResolving: true
}, {
  name: 'attachments',
  omitDuplicateResolving: true
}]), {
  appName: 'Crm',
  modelName: 'Lead',
  idProperty: 'id',
  titleProperty: 'lead_name',
  // ngettext('Lead', 'Leads', n);
  recordName: 'Lead',
  recordsName: 'Leads',
  containerProperty: 'container_id',
  // ngettext('lead list', 'lead lists', n); gettext('lead lists');
  containerName: 'lead list',
  containersName: 'lead lists',
  getTitle: function getTitle() {
    return this.get('lead_name') ? this.get('lead_name') : false;
  }
});
/**
 * @namespace Tine.Crm.Model
 * 
 * get default data for a new lead
 *  
 * @return {Object} default data
 * @static
 */

Tine.Crm.Model.Lead.getDefaultData = function () {
  var app = Tine.Tinebase.appMgr.get('Crm');
  var data = {
    start: new Date().clearTime(),
    container_id: app.getMainScreen().getWestPanel().getContainerTreePanel().getDefaultContainer(),
    probability: 0,
    turnover: 0,
    relations: [{
      type: 'RESPONSIBLE',
      related_record: Tine.Tinebase.registry.get('userContact')
    }]
  };
  return data;
};
/**
 * get filtermodel of lead model
 * 
 * @namespace Tine.Crm.Model
 * @static
 * @return {Array} filterModel definition
 */


Tine.Crm.Model.Lead.getFilterModel = function () {
  var app = Tine.Tinebase.appMgr.get('Crm'),
      filters = [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }, {
    filtertype: 'tine.widget.container.filtermodel',
    app: app,
    recordClass: Tine.Crm.Model.Lead
  }, {
    label: app.i18n._('Lead name'),
    field: 'lead_name'
  }, {
    label: app.i18n._('Leadstate'),
    field: 'leadstate_id',
    filtertype: 'tine.widget.keyfield.filter',
    app: app,
    keyfieldName: 'leadstates'
  }, {
    label: app.i18n._('Probability'),
    field: 'probability',
    valueType: 'percentage'
  }, {
    label: app.i18n._('Leadsource'),
    field: 'leadsource_id',
    filtertype: 'tine.widget.keyfield.filter',
    app: app,
    keyfieldName: 'leadsources'
  }, {
    label: app.i18n._('Leadtype'),
    field: 'leadtype_id',
    filtertype: 'tine.widget.keyfield.filter',
    app: app,
    keyfieldName: 'leadtypes'
  }, {
    label: app.i18n._('Turnover'),
    field: 'turnover',
    valueType: 'number',
    defaultOperator: 'greater'
  }, {
    filtertype: 'tinebase.tag',
    app: app
  }, {
    label: i18n._('Last Modified Time'),
    field: 'last_modified_time',
    valueType: 'date'
  }, {
    label: i18n._('Last Modified By'),
    field: 'last_modified_by',
    valueType: 'user'
  }, {
    label: i18n._('Creation Time'),
    field: 'creation_time',
    valueType: 'date'
  }, {
    label: i18n._('Created By'),
    field: 'created_by',
    valueType: 'user'
  }, {
    label: app.i18n._('Estimated end'),
    field: 'end_scheduled',
    valueType: 'date'
  }, {
    label: app.i18n._('Resubmission Date'),
    field: 'resubmission_date',
    valueType: 'date'
  }, {
    filtertype: 'crm.contact'
  }, {
    filtertype: 'foreignrecord',
    app: app,
    foreignRecordClass: Tine.Tasks.Model.Task,
    ownField: 'task'
  }];

  if (Tine.Sales && Tine.Tinebase.common.hasRight('run', 'Sales')) {
    filters.push({
      filtertype: 'foreignrecord',
      app: app,
      foreignRecordClass: Tine.Sales.Model.Product,
      ownField: 'product'
    });
  }

  return filters;
}; // custom keyFieldRecord


Tine.Crm.Model.LeadState = Tine.Tinebase.data.Record.create([{
  name: 'id'
}, {
  name: 'value'
}, {
  name: 'system'
}, {
  name: 'probability',
  label: 'Probability',
  type: 'percentage'
}, // i18n._('Probability')
{
  name: 'endslead',
  label: 'X Lead',
  type: 'bool' // i18n._('X Lead')

}], {
  appName: 'Crm',
  modelName: 'LeadState',
  idProperty: 'id',
  titleProperty: 'value'
}); // custom keyFieldRecord

Tine.Crm.Model.LeadSource = Tine.Tinebase.data.Record.create([{
  name: 'id'
}, {
  name: 'value'
}, {
  name: 'system'
}, {
  name: 'archived',
  label: 'Archived',
  type: 'bool' // i18n._('Archived')

}], {
  appName: 'Crm',
  modelName: 'LeadSource',
  idProperty: 'id',
  titleProperty: 'value'
});

Tine.Crm.Model.getRandomUnusedId = function (store) {
  var result;

  do {
    result = Tine.Tinebase.common.getRandomNumber(0, 21474836);
  } while (store.getById(result) != undefined);

  return result;
};

/***/ }),

/***/ 1390:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Crm
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Crm');
/**
 * @namespace   Tine.Crm
 * @class       Tine.Crm.Application
 * @extends     Tine.Tinebase.Application
 * Crm Application Object <br>
 * 
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 */

Tine.Crm.Application = Ext.extend(Tine.Tinebase.Application, {
  /**
   * auto hook text i18n._('New Lead')
   */
  addButtonText: 'New Lead',
  init: function init() {
    Tine.Crm.Application.superclass.init.apply(this, arguments);
    new Tine.Crm.AddressbookGridPanelHook({
      app: this
    });
  }
});
/**
 * @namespace Tine.Crm
 * @class Tine.Crm.MainScreen
 * @extends Tine.widgets.MainScreen
 * MainScreen of the Crm Application <br>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 * @constructor
 * Constructs mainscreen of the crm application
 */

Tine.Crm.MainScreen = Ext.extend(Tine.widgets.MainScreen, {
  activeContentType: 'Lead',
  contentTypes: [{
    modelName: 'Lead',
    requiredRight: null,
    singularContainerMode: false
  }]
});
/**
 * @namespace Tine.Crm
 * @class Tine.Crm.TreePanel
 * @extends Tine.widgets.container.TreePanel
 * Left Crm Panel including Tree<br>
 * 
 * TODO add d&d support to tree
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 */

Tine.Crm.LeadTreePanel = function (config) {
  Ext.apply(this, config);
  this.id = 'CrmLeadTreePanel';
  this.filterMode = 'filterToolbar';
  this.recordClass = Tine.Crm.Model.Lead;
  Tine.Crm.LeadTreePanel.superclass.constructor.call(this);
};

Ext.extend(Tine.Crm.LeadTreePanel, Tine.widgets.container.TreePanel);
/**
 * @namespace Tine.Crm
 * @class Tine.Crm.FilterPanel
 * @extends Tine.widgets.persistentfilter.PickerPanel
 * Crm Filter Panel<br>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 */

Tine.Crm.LeadFilterPanel = function (config) {
  config.app.enableAdvancedSearch = true;
  Ext.apply(this, config);
  Tine.Crm.LeadFilterPanel.superclass.constructor.call(this);
};

Ext.extend(Tine.Crm.LeadFilterPanel, Tine.widgets.persistentfilter.PickerPanel, {
  filter: [{
    field: 'model',
    operator: 'equals',
    value: 'Crm_Model_LeadFilter'
  }]
});
/**
 * @namespace Tine.Crm
 * @class Tine.Crm.leadBackend
 * @extends Tine.Tinebase.data.RecordProxy
 * 
 * Lead Backend
 */

Tine.Crm.leadBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'Crm',
  modelName: 'Lead',
  recordClass: Tine.Crm.Model.Lead
});
/**
 * returns ids of ended lead states
 */

Tine.Crm.getEndedLeadStateIds = function () {
  var leadstates = Tine.Tinebase.widgets.keyfield.StoreMgr.get('Crm', 'leadstates');
  var ids = [];
  leadstates.each(function (leadstate) {
    if (leadstate.json.endslead == 1) {
      ids.push(leadstate.id);
    }
  }, this);
  return ids;
};

/***/ }),

/***/ 1391:
/***/ (function(module, exports) {

/* 
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Michael Spahn <kontakt@michaelspahn.de>
 * @copyright   Copyright (c) 2015 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Crm');
Tine.Crm.ProductPickerCombo = Ext.extend(Tine.Tinebase.widgets.form.RecordPickerComboBox, {
  initComponent: function initComponent() {
    Tine.Crm.ProductPickerCombo.superclass.initComponent.apply(this, arguments);
  },
  onBeforeLoad: function onBeforeLoad(store, options) {
    Tine.Crm.ProductPickerCombo.superclass.onBeforeLoad.apply(this, arguments);
    store.baseParams.filter.push({
      field: 'is_active',
      operator: 'equals',
      value: true
    });
  }
});
Tine.widgets.form.RecordPickerManager.register('Crm', 'Product', Tine.Crm.ProductPickerCombo);

/***/ }),

/***/ 1392:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Crm
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 * TODO         add to extdoc
 */
Ext.ns('Tine.Crm.LinkGridPanel');
/**
 * @namespace   Tine.Crm.LinkGridPanel
 * 
 * TODO         move change contact type functions
 */

Tine.Crm.LinkGridPanel.initActions = function () {
  var app = Tine.Tinebase.appMgr.get(this.recordClass.getMeta('appName'));

  if (!app) {
    return;
  }

  if (app.i18n) {
    var recordName = app.i18n.n_(this.recordClass.getMeta('recordName'), this.recordClass.getMeta('recordsName'), 1);
  } else {
    var recordName = this.recordClass.getMeta('recordName');
  }

  var addActionText = app.addButtonText && app.i18n ? app.i18n._hidden(app.addButtonText) : String.format(this.app.i18n._('Add new {0}'), recordName);
  this.actionAdd = new Ext.Action({
    requiredGrant: 'editGrant',
    text: addActionText,
    tooltip: addActionText,
    iconCls: 'action_add',
    disabled: !(this.record && this.record.get('container_id') && this.record.get('container_id').account_grants && this.record.get('container_id').account_grants.editGrant),
    scope: this,
    handler: function handler(_button, _event) {
      var editWindow = this.recordEditDialogOpener({
        listeners: {
          scope: this,
          'update': this.onUpdate
        }
      });
    }
  });
  this.actionUnlink = new Ext.Action({
    requiredGrant: 'editGrant',
    text: String.format(this.app.i18n._('Unlink {0}'), recordName),
    tooltip: String.format(this.app.i18n._('Unlink selected {0}'), recordName),
    disabled: true,
    iconCls: 'action_remove',
    onlySingle: true,
    scope: this,
    handler: function handler(_button, _event) {
      var selectedRows = this.getSelectionModel().getSelections();

      for (var i = 0; i < selectedRows.length; ++i) {
        this.store.remove(selectedRows[i]);
      }
    }
  });
  this.actionEdit = new Ext.Action({
    requiredGrant: 'editGrant',
    text: String.format(this.app.i18n._('Edit {0}'), recordName),
    tooltip: String.format(this.app.i18n._('Edit selected {0}'), recordName),
    disabled: true,
    iconCls: 'actionEdit',
    onlySingle: true,
    scope: this,
    handler: function handler(_button, _event) {
      var selectedRows = this.getSelectionModel().getSelections();
      var record = selectedRows[0]; // unset record id for new records

      if (record.phantom) {
        record.id = 0;
      }

      var editWindow = this.recordEditDialogOpener({
        record: record,
        listeners: {
          scope: this,
          'update': this.onUpdate
        }
      });
    }
  }); // init toolbars and ctx menut / add actions

  this.bbar = [this.actionAdd, this.actionUnlink];
  this.actions = [this.actionEdit, this.actionUnlink];

  if (this.otherActions) {
    this.actions = this.actions.concat(this.otherActions);
  }

  this.contextMenu = new Ext.menu.Menu({
    items: this.actions.concat(['-', this.actionAdd]),
    plugins: [{
      ptype: 'ux.itemregistry',
      key: 'Tinebase-MainContextMenu'
    }]
  });
  this.actions.push(this.actionAdd);
};
/**
 * init store
 * 
 */


Tine.Crm.LinkGridPanel.initStore = function () {
  this.store = new Ext.data.JsonStore({
    fields: this.storeFields ? this.storeFields : this.recordClass
  }); // focus+select new record

  this.store.on('add', function (store, records, index) {
    (function () {
      if (this.rendered) {
        this.getView().focusRow(index);
        this.getSelectionModel().selectRow(index);
      }
    }).defer(300, this);
  }, this);
};
/**
 * init ext grid panel
 * 
 * TODO         add grants for linked entries to disable EDIT?
 */


Tine.Crm.LinkGridPanel.initGrid = function () {
  this.cm = this.getColumnModel();
  this.selModel = new Ext.grid.RowSelectionModel({
    multiSelect: true
  });
  this.enableHdMenu = false;
  this.plugins = this.plugins || [];
  this.plugins.push(new Ext.ux.grid.GridViewMenuPlugin({})); // on selectionchange handler

  this.selModel.on('selectionchange', function (sm) {
    var rowCount = sm.getCount();
    var selectedRows = this.getSelectionModel().getSelections();

    if (selectedRows.length > 0) {
      var selectedRecord = selectedRows[0];
    }

    if (this.record && this.record.get('container_id') && this.record.get('container_id').account_grants) {
      for (var i = 0; i < this.actions.length; i++) {
        this.actions[i].setDisabled(!this.record.get('container_id').account_grants.editGrant || this.actions[i].initialConfig.onlySingle && rowCount != 1 || this.actions[i] == this.actionEdit && selectedRecord && selectedRecord.phantom == true);
      }
    }
  }, this); // on rowcontextmenu handler

  this.on('rowcontextmenu', function (grid, row, e) {
    e.stopEvent();
    var selModel = grid.getSelectionModel();

    if (!selModel.isSelected(row)) {
      selModel.selectRow(row);
    }

    this.contextMenu.showAt(e.getXY());
  }, this); // doubleclick handler

  this.on('rowdblclick', function (grid, row, e) {
    var selectedRows = grid.getSelectionModel().getSelections();
    record = selectedRows[0];

    if (!record.phantom && this.recordEditDialogOpener != Ext.emptyFn) {
      var editWindow = this.recordEditDialogOpener({
        record: record,
        listeners: {
          scope: this,
          'update': this.onUpdate
        }
      });
    }
  }, this);
};

/***/ }),

/***/ 1393:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Crm
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Crm');
/**
 * Lead grid panel
 * 
 * @namespace   Tine.Crm
 * @class       Tine.Crm.LeadGridContactFilter
 * @extends     Tine.widgets.grid.FilterModel
 * 
 * <p>Contact Filter for Lead Grid Panel</p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2009 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Crm.LeadGridContactFilter
 */

Tine.Crm.LeadGridContactFilter = Ext.extend(Tine.widgets.grid.ForeignRecordFilter, {
  /**
   * @cfg {Record} foreignRecordClass needed for explicit defined filters
   */
  foreignRecordClass: Tine.Addressbook.Model.Contact,

  /**
   * @cfg {String} ownField for explicit filterRow
   */
  ownField: 'contact',

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.app = Tine.Tinebase.appMgr.get('Crm');
    this.label = this.app.i18n._("Contact");
    Tine.Crm.LeadGridContactFilter.superclass.initComponent.call(this);
  },
  getSubFilters: function getSubFilters() {
    var contactRoleFilter = new Tine.widgets.grid.FilterModel({
      label: this.app.i18n._('CRM Role'),
      field: 'relation_type',
      operators: ['equals'],
      valueRenderer: function valueRenderer(filter, el) {
        var value = new Tine.Crm.Contact.TypeComboBox({
          filter: filter,
          blurOnSelect: true,
          listAlign: 'tr-br',
          value: filter.data.value ? filter.data.value : this.defaultValue,
          renderTo: el
        });
        value.on('specialkey', function (field, e) {
          if (e.getKey() == e.ENTER) {
            this.onFiltertrigger();
          }
        }, this);
        return value;
      }
    });
    return [contactRoleFilter];
  }
});
Tine.widgets.grid.FilterToolbar.FILTERS['crm.contact'] = Tine.Crm.LeadGridContactFilter;

/***/ }),

/***/ 1394:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Crm
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Crm');
/**
 * Lead grid panel
 * 
 * @namespace   Tine.Crm
 * @class       Tine.Crm.LeadGridPanel
 * @extends     Tine.widgets.grid.GridPanel
 * 
 * <p>Lead Grid Panel</p>
 * <p><pre>
 * TODO         add products to grid?
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2007-2010 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Crm.LeadGridPanel
 */

Tine.Crm.LeadGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  /**
   * record class
   * @cfg {Tine.Crm.Model.Lead} recordClass
   */
  recordClass: Tine.Crm.Model.Lead,

  /**
   * eval grants
   * @cfg {Boolean} evalGrants
   */
  evalGrants: true,

  /**
   * ids of lead states that end a lead (needed to determine grid row class)
   */
  endingLeadStateIds: [],

  /**
   * grid specific
   * @private
   */
  defaultSortInfo: {
    field: 'lead_name',
    direction: 'DESC'
  },
  gridConfig: {
    autoExpandColumn: 'title',
    // drag n drop
    enableDragDrop: true,
    ddGroup: 'containerDDGroup'
  },

  /**
   * returns view row class (scope is this.grid.view)
   */
  getViewRowClass: function getViewRowClass(record, index, rowParams, store) {
    var className = Tine.Crm.LeadGridPanel.superclass.getViewRowClass(record, index, rowParams, store);
    var now = new Date();

    if (this.endingLeadStateIds && this.endingLeadStateIds.indexOf(record.get('leadstate_id')) == -1) {
      var rsd = record.get('resubmission_date');
      var esd = record.get('end_scheduled');

      if (esd && esd < now || rsd && rsd < now) {
        className += ' crm-highlight-task';
      }
    }

    return className;
  },

  /**
   * inits this cmp
   * @private
   */
  initComponent: function initComponent() {
    this.recordProxy = Tine.Crm.leadBackend;
    this.gridConfig.cm = this.getColumnModel();
    this.defaultFilters = [{
      field: 'leadstate_id',
      operator: 'notin',
      value: Tine.Crm.getEndedLeadStateIds()
    }];
    this.detailsPanel = new Tine.Crm.LeadGridDetailsPanel({
      grid: this
    });
    Tine.Crm.LeadGridPanel.superclass.initComponent.call(this);
    this.endingLeadStateIds = Tine.Crm.getEndedLeadStateIds();
  },

  /**
   * returns cm
   * 
   * @return Ext.grid.ColumnModel
   * @private
   */
  getColumnModel: function getColumnModel() {
    return new Ext.grid.ColumnModel({
      defaults: {
        sortable: true
      },
      columns: [{
        header: this.app.i18n._('Tags'),
        id: 'tags',
        dataIndex: 'tags',
        width: 50,
        renderer: Tine.Tinebase.common.tagsRenderer,
        sortable: false
      }, {
        header: this.app.i18n._('Lead name'),
        id: 'lead_name',
        dataIndex: 'lead_name',
        width: 200
      }, {
        header: this.app.i18n._('Responsible'),
        id: 'lead_responsible',
        dataIndex: 'lead_responsible',
        width: 175,
        sortable: false,
        hidden: true,
        renderer: this.responsibleRenderer
      }, {
        header: this.app.i18n._('Partner'),
        id: 'lead_partner',
        dataIndex: 'lead_partner',
        width: 175,
        sortable: false,
        renderer: this.partnerRenderer
      }, {
        header: this.app.i18n._('Customer'),
        id: 'lead_customer',
        dataIndex: 'lead_customer',
        width: 175,
        sortable: false,
        renderer: this.customerRenderer
      }, {
        header: this.app.i18n._('Leadstate'),
        id: 'leadstate_id',
        dataIndex: 'leadstate_id',
        width: 100,
        renderer: Tine.Tinebase.widgets.keyfield.Renderer.get('Crm', 'leadstates')
      }, {
        header: this.app.i18n._('Leadtype'),
        id: 'leadtype_id',
        dataIndex: 'leadtype_id',
        width: 100,
        renderer: Tine.Tinebase.widgets.keyfield.Renderer.get('Crm', 'leadtypes')
      }, {
        header: this.app.i18n._('Leadsource'),
        id: 'leadsource_id',
        dataIndex: 'leadsource_id',
        width: 100,
        renderer: Tine.Tinebase.widgets.keyfield.Renderer.get('Crm', 'leadsources')
      }, {
        header: this.app.i18n._('Probability'),
        id: 'probability',
        dataIndex: 'probability',
        width: 50,
        renderer: Ext.ux.PercentRenderer
      }, {
        header: this.app.i18n._('Turnover'),
        id: 'turnover',
        dataIndex: 'turnover',
        width: 100,
        renderer: Ext.util.Format.money
      }, {
        header: this.app.i18n._('Estimated end'),
        id: 'end_scheduled',
        dataIndex: 'end_scheduled',
        width: 100,
        renderer: Tine.Tinebase.common.dateRenderer,
        sortable: true
      }, {
        header: this.app.i18n._('Probable Turnover'),
        id: 'probableTurnover',
        dataIndex: 'probableTurnover',
        width: 100,
        renderer: Ext.util.Format.money,
        sortable: false
      }, {
        header: this.app.i18n._('Resubmission Date'),
        id: 'resubmission_date',
        dataIndex: 'resubmission_date',
        width: 100,
        renderer: Tine.Tinebase.common.dateRenderer,
        sortable: true
      }].concat(this.getModlogColumns().concat(this.getCustomfieldColumns()))
    });
  },

  /**
   * render responsible contact
   * 
   * @param {Array} value
   * @return {String}
   * 
   * TODO use another renderer (with email, phone, ...) here?
   */
  responsibleRenderer: function responsibleRenderer(value, metaData, record) {
    return Tine.Crm.LeadGridPanel.shortContactRenderer(record.get('relations'), 'RESPONSIBLE');
  },

  /**
   * render partner contact
   * 
   * @param {Array} value
   * @return {String}
   */
  partnerRenderer: function partnerRenderer(value, metaData, record) {
    return Tine.Crm.LeadGridPanel.shortContactRenderer(record.get('relations'), 'PARTNER');
  },

  /**
   * render customer contact
   * 
   * @param {Array} value
   * @return {String}
   */
  customerRenderer: function customerRenderer(value, metaData, record) {
    return Tine.Crm.LeadGridPanel.shortContactRenderer(record.get('relations'), 'CUSTOMER');
  },

  /**
   * @private
   */
  initActions: function initActions() {
    this.actions_import = this.app.featureEnabled('featureLeadImport') ? new Ext.Action({
      text: this.app.i18n._('Import leads'),
      disabled: false,
      handler: this.onImport,
      iconCls: 'action_import',
      scope: this,
      allowMultiple: true
    }) : false;
    this.supr().initActions.call(this);
  }
});
/**
 * contact column renderer
 * 
 * @param       {String} data
 * @param       {String} type (CUSTOMER|PARTNER)
 * @return      {String}
 * 
 * @namespace   Tine.Crm
 */

Tine.Crm.LeadGridPanel.shortContactRenderer = function (data, type) {
  if (Ext.isArray(data) && data.length > 0) {
    var index = 0; // get correct relation type from data (contact) array and show first matching record (org_name + n_fileas)

    while (index < data.length && data[index].type != type) {
      index++;
    }

    if (data[index] && data[index].related_record) {
      var org = data[index].related_record.org_name !== null ? data[index].related_record.org_name : '';
      return '<b>' + Ext.util.Format.htmlEncode(org) + '</b><br />' + Ext.util.Format.htmlEncode(data[index].related_record.n_fileas);
    }
  }
};

/***/ }),

/***/ 1395:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Crm
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2009-2015 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Crm');
/**
 * @namespace   Tine.Crm
 * @class       Tine.Crm.LeadGridDetailsPanel
 * @extends     Tine.widgets.grid.DetailsPanel
 * 
 * <p>Lead Grid Details Panel</p>
 * <p>
 * </p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2009 Metaways Infosystems GmbH (http://www.metaways.de)
 */

Tine.Crm.LeadGridDetailsPanel = Ext.extend(Tine.widgets.grid.DetailsPanel, {
  border: false,

  /**
   * renders contact names
   * 
   * @param {String} type
   * @return {String}
   * 
   * TODO add mail link
   * TODO all labels should have the same width
   */
  contactRenderer: function contactRenderer(type) {
    var relations = this.record.get('relations');
    var a = [];
    var fields = [{
      label: type == 'CUSTOMER' ? this.app.i18n._('Customer') : this.app.i18n._('Partner'),
      dataField: 'n_fileas'
    }, {
      label: this.app.i18n._('Phone'),
      dataField: 'tel_work'
    }, {
      label: this.app.i18n._('Mobile'),
      dataField: 'tel_cell'
    }, {
      label: this.app.i18n._('Fax'),
      dataField: 'tel_fax'
    }, {
      label: this.app.i18n._('E-Mail'),
      dataField: 'email'
    }, {
      label: this.app.i18n._('Web'),
      dataField: 'url'
    }, {
      label: this.app.i18n._('Street'),
      dataField: 'adr_one_street'
    }, {
      label: this.app.i18n._('Postalcode'),
      dataField: 'adr_one_postalcode'
    }, {
      label: this.app.i18n._('City'),
      dataField: 'adr_one_locality'
    }];
    var labelMarkup = '<label class="x-form-item x-form-item-label">';

    if (Ext.isArray(relations) && relations.length > 0) {
      // get correct relation type from relations (contact) array
      for (var i = 0; i < relations.length; i++) {
        if (relations[i].type == type) {
          var data = relations[i].related_record;

          for (var j = 0; j < fields.length; j++) {
            if (data[fields[j].dataField]) {
              if (fields[j].dataField == 'url') {
                a.push(labelMarkup + fields[j].label + ':</label> ' + '<a href="' + Ext.util.Format.htmlEncode(data[fields[j].dataField]) + '" target="_blank">' + Ext.util.Format.htmlEncode(data[fields[j].dataField]) + '</a>');
              } else {
                a.push(labelMarkup + fields[j].label + ':</label> ' + Ext.util.Format.htmlEncode(data[fields[j].dataField]));
              }
            }
          }

          a.push('');
        }
      }
    }

    return a.join("\n");
  },

  /**
   * inits this component
   */
  initComponent: function initComponent() {
    this.app = Tine.Tinebase.appMgr.get('Crm'); // define piechart stores

    this.leadstatePiechartStore = new Ext.data.JsonStore({
      fields: ['id', 'label', 'total'],
      id: 'id'
    });
    this.leadsourcePiechartStore = new Ext.data.JsonStore({
      fields: ['id', 'label', 'total'],
      id: 'id'
    });
    this.leadtypePiechartStore = new Ext.data.JsonStore({
      fields: ['id', 'label', 'total'],
      id: 'id'
    });
    this.supr().initComponent.call(this);
  },

  /**
   * default panel w.o. data
   * 
   * @return {Ext.ux.display.DisplayPanel}
   * 
   * TODO add something useful here
   */
  getDefaultInfosPanel: function getDefaultInfosPanel() {
    if (!this.defaultInfosPanel) {
      this.defaultInfosPanel = new Ext.ux.display.DisplayPanel({
        layout: 'fit',
        border: false,
        items: []
      });
    }

    return this.defaultInfosPanel;
  },

  /**
   * get panel for multi selection aggregates/information
   * 
   * @return {Ext.Panel}
   */
  getMultiRecordsPanel: function getMultiRecordsPanel() {
    return this.getDefaultInfosPanel();
  },

  /**
   * main lead details panel
   * 
   * @return {Ext.ux.display.DisplayPanel}
   * 
   * TODO add tasks / products?
   * TODO add contact icons?
   */
  getSingleRecordPanel: function getSingleRecordPanel() {
    if (!this.singleRecordPanel) {
      this.singleRecordPanel = new Ext.ux.display.DisplayPanel({
        layout: 'fit',
        border: false,
        items: [{
          layout: 'vbox',
          border: false,
          layoutConfig: {
            align: 'stretch'
          },
          items: [{
            layout: 'hbox',
            flex: 0,
            height: 16,
            border: false,
            style: 'padding-left: 5px; padding-right: 5px',
            layoutConfig: {
              align: 'stretch'
            },
            items: [{
              flex: 1,
              xtype: 'ux.displayfield',
              cls: 'x-ux-display-header',
              name: 'lead_name'
            }, {
              flex: 1,
              xtype: 'ux.displayfield',
              style: 'text-align: right;',
              name: 'container_id',
              cls: 'x-ux-display-header',
              htmlEncode: false,
              renderer: Tine.Tinebase.common.containerRenderer
            }]
          }, {
            layout: 'hbox',
            flex: 1,
            border: false,
            layoutConfig: {
              padding: '5',
              align: 'stretch'
            },
            defaults: {
              margins: '0 5 0 0'
            },
            items: [{
              flex: 1,
              layout: 'ux.display',
              labelWidth: 90,
              layoutConfig: {
                background: 'solid',
                declaration: this.app.i18n._('Status')
              },
              items: [{
                xtype: 'ux.displayfield',
                name: 'start',
                fieldLabel: this.app.i18n._('Start'),
                renderer: Tine.Tinebase.common.dateRenderer
              }, {
                xtype: 'ux.displayfield',
                name: 'end_scheduled',
                fieldLabel: this.app.i18n._('Estimated end'),
                renderer: Tine.Tinebase.common.dateRenderer
              }, {
                xtype: 'ux.displayfield',
                name: 'leadtype_id',
                fieldLabel: this.app.i18n._('Leadtype'),
                renderer: Tine.Tinebase.widgets.keyfield.Renderer.get('Crm', 'leadtypes')
              }, {
                xtype: 'ux.displayfield',
                name: 'leadsource_id',
                fieldLabel: this.app.i18n._('Leadsource'),
                renderer: Tine.Tinebase.widgets.keyfield.Renderer.get('Crm', 'leadsources')
              }]
            }, {
              flex: 1,
              layout: 'ux.display',
              labelAlign: 'top',
              autoScroll: true,
              layoutConfig: {
                background: 'solid'
              },
              items: [{
                xtype: 'ux.displayfield',
                name: 'partner',
                nl2br: true,
                htmlEncode: false,
                renderer: this.contactRenderer.createDelegate(this, ['PARTNER'])
              }]
            }, {
              flex: 1,
              layout: 'ux.display',
              labelAlign: 'top',
              autoScroll: true,
              layoutConfig: {
                background: 'solid'
              },
              items: [{
                xtype: 'ux.displayfield',
                name: 'customer',
                nl2br: true,
                htmlEncode: false,
                renderer: this.contactRenderer.createDelegate(this, ['CUSTOMER'])
              }]
            }, {
              flex: 1,
              layout: 'fit',
              border: false,
              items: [{
                cls: 'x-ux-display-background-border',
                xtype: 'ux.displaytextarea',
                name: 'description'
              }]
            }]
          }]
        }]
      });
    }

    return this.singleRecordPanel;
  },

  /**
   * update lead details panel
   * 
   * @param {Tine.Tinebase.data.Record} record
   * @param {Mixed} body
   */
  updateDetails: function updateDetails(record, body) {
    this.getSingleRecordPanel().loadRecord.defer(100, this.getSingleRecordPanel(), [record]);
  },

  /**
   * show default panel
   * 
   * @param {Mixed} body
   */
  showDefault: function showDefault(body) {},

  /**
   * show template for multiple rows
   * 
   * @param {Ext.grid.RowSelectionModel} sm
   * @param {Mixed} body
   */
  showMulti: function showMulti(sm, body) {}
});

/***/ }),

/***/ 1396:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Crm
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Crm');
/**
 * @namespace   Tine.Crm
 * @class       Tine.Crm.LeadEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>Lead Edit Dialog</p>
 * <p>
 * TODO         simplify relation handling (move init of stores to relation grids and get data from there later?)
 * TODO         make marking of invalid fields work again
 * TODO         add export button
 * TODO         disable link grids if user has no run right for the app (adb/tasks/sales)
 * </p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Crm.LeadEditDialog
 */

Tine.Crm.LeadEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * linked contacts grid
   * 
   * @type Tine.Crm.Contact.GridPanel
   * @property contactGrid
   */
  contactGrid: null,

  /**
   * linked tasks grid
   * 
   * @type Tine.Crm.Task.GridPanel
   * @property tasksGrid
   */
  tasksGrid: null,
  // problems with relations here
  checkUnsavedChanges: false,

  /**
   * @private
   */
  windowNamePrefix: 'LeadEditWindow_',
  appName: 'Crm',
  recordClass: Tine.Crm.Model.Lead,
  recordProxy: Tine.Crm.leadBackend,
  showContainerSelector: true,
  displayNotes: true,

  /**
   * ignore these models in relation grid
   * @type {Array}
   */
  ignoreRelatedModels: ['Sales_Model_Product', 'Addressbook_Model_Contact', 'Tasks_Model_Task'],
  initComponent: function initComponent() {
    Tine.Crm.LeadEditDialog.superclass.initComponent.call(this);
    this.on('recordUpdate', this.onAfterRecordUpdate, this);
  },

  /**
   * executed after record got updated from proxy
   * 
   * @private
   */
  onAfterRecordLoad: function onAfterRecordLoad() {
    Tine.Crm.LeadEditDialog.superclass.onAfterRecordLoad.call(this); // load contacts/tasks/products into link grid (only first time this function gets called/store is empty)

    if (this.contactGrid && this.tasksGrid && this.productsGrid && this.contactGrid.store.getCount() == 0 && (!this.tasksGrid.store || this.tasksGrid.store.getCount() == 0) && (!this.productsGrid.store || this.productsGrid.store.getCount() == 0)) {
      var relations = this.splitRelations();
      this.contactGrid.store.loadData(relations.contacts, true);

      if (this.tasksGrid.store) {
        this.tasksGrid.store.loadData(relations.tasks, true);
      }

      if (this.productsGrid.store) {
        this.productsGrid.store.loadData(relations.products, true);
      }
    }
  },
  onAfterRecordUpdate: function onAfterRecordUpdate(closeWindow) {
    this.getAdditionalData();
    var relations = [].concat(this.record.get('relations'));
    this.record.data.relations = relations;
  },

  /**
   * getRelationData
   * get the record relation data (switch relation and related record)
   * 
   * @param   Object record with relation data
   * @return  Object relation with record data
   */
  getRelationData: function getRelationData(record) {
    var relation = null;

    if (record.data.relation) {
      relation = record.data.relation;
    } else {
      // empty relation for new record
      relation = {};
    } // set the relation type


    if (!relation.type) {
      relation.type = record.data.relation_type.toUpperCase();
    } // do not do recursion!


    record.data.relation = null;
    delete record.data.relation; // save record data

    relation.related_record = record.data; // add remark values

    relation.remark = {};

    if (record.data.remark_price) {
      relation.remark.price = record.data.remark_price;
    }

    if (record.data.remark_description) {
      relation.remark.description = record.data.remark_description;
    }

    if (record.data.remark_quantity) {
      relation.remark.quantity = record.data.remark_quantity;
    }

    Tine.log.debug('Tine.Crm.LeadEditDialog::getRelationData() -> relation:');
    Tine.log.debug(relation);
    return relation;
  },

  /**
   * getAdditionalData
   * collects additional data (start/end dates, linked contacts, ...)
   */
  getAdditionalData: function getAdditionalData() {
    var relations = this.record.get('relations'),
        grids = [this.contactGrid, this.tasksGrid, this.productsGrid];
    Ext.each(grids, function (grid) {
      if (grid.store) {
        grid.store.each(function (record) {
          relations.push(this.getRelationData(record.copy()));
        }, this);
      }
    }, this);
    this.record.data.relations = relations;
  },

  /**
   * split the relations array in contacts and tasks and switch related_record and relation objects
   * 
   * @return {Array}
   */
  splitRelations: function splitRelations() {
    var contacts = [],
        tasks = [],
        products = [];
    var relations = this.record.get('relations');

    for (var i = 0; i < relations.length; i++) {
      var newLinkObject = relations[i]['related_record'];

      if (newLinkObject) {
        relations[i]['related_record']['relation'] = null;
        delete relations[i]['related_record']['relation']; // this creates a circular structure which could not be converted to json!
        // newLinkObject.relation = relations[i];

        newLinkObject.relation_type = relations[i]['type'].toLowerCase();

        if (newLinkObject.relation_type === 'responsible' || newLinkObject.relation_type === 'customer' || newLinkObject.relation_type === 'partner') {
          contacts.push(newLinkObject);
        } else if (newLinkObject.relation_type === 'task') {
          tasks.push(newLinkObject);
        } else if (newLinkObject.relation_type === 'product') {
          newLinkObject.remark_description = relations[i].remark ? relations[i].remark.description : '';
          newLinkObject.remark_price = relations[i].remark ? relations[i].remark.price : 0;
          newLinkObject.remark_quantity = relations[i].remark ? relations[i].remark.quantity : 1;
          products.push(newLinkObject);
        }
      }
    }

    return {
      contacts: contacts,
      tasks: tasks,
      products: products
    };
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   * 
   * @return {Object}
   * @private
   */
  getFormItems: function getFormItems() {
    this.combo_probability = new Ext.ux.PercentCombo({
      fieldLabel: this.app.i18n._('Probability'),
      id: 'combo_probability',
      anchor: '95%',
      name: 'probability'
    });
    this.date_end = new Ext.ux.form.ClearableDateField({
      fieldLabel: this.app.i18n._('End'),
      id: 'end',
      anchor: '95%'
    });
    this.contactGrid = new Tine.Crm.Contact.GridPanel({
      record: this.record,
      anchor: '100% 98%'
    });

    if (Tine.Tasks && Tine.Tinebase.common.hasRight('run', 'Tasks')) {
      this.tasksGrid = new Tine.Crm.Task.GridPanel({
        record: this.record
      });
    } else {
      this.tasksGrid = new Ext.Panel({
        title: this.app.i18n._('Tasks'),
        html: this.app.i18n._('You do not have the run right for the Tasks application or it is not activated.')
      });
    }

    if (Tine.Sales && Tine.Tinebase.common.hasRight('run', 'Sales')) {
      this.productsGrid = new Tine.Crm.Product.GridPanel({
        record: this.record
      });
    } else {
      this.productsGrid = new Ext.Panel({
        title: this.app.i18n._('Products'),
        html: this.app.i18n._('You do not have the run right for the Sales application or it is not activated.')
      });
    } // Don't show item if it's a archived source!


    var sourceStore = Tine.Tinebase.widgets.keyfield.StoreMgr.get('Crm', 'leadsources');
    var preserveRecords = [];
    sourceStore.each(function (record) {
      preserveRecords.push(record.copy());
    });
    var copiedStore = new Ext.data.Store({
      recordType: sourceStore.recordType
    });
    copiedStore.add(preserveRecords);
    sourceStore.each(function (item) {
      if (item.json.archived == true) {
        sourceStore.remove(item);
      }
    });

    var setdeffered = function setdeffered(combo) {
      var rawValue = parseInt(combo.getRawValue());

      if (Ext.isNumber(rawValue)) {
        combo.setRawValue(copiedStore.getById(combo.getValue()).get('value'));
      }
    };

    return {
      xtype: 'tabpanel',
      plain: true,
      plugins: [{
        ptype: 'ux.tabpanelkeyplugin'
      }],
      defaults: {
        hideMode: 'offsets'
      },
      activeTab: 0,
      border: false,
      items: [{
        title: this.app.i18n._('Lead'),
        autoScroll: true,
        border: true,
        frame: true,
        layout: 'border',
        id: 'editCenterPanel',
        defaults: {
          border: true,
          frame: true
        },
        items: [{
          region: 'center',
          layout: 'border',
          items: [{
            region: 'north',
            height: 40,
            layout: 'form',
            labelAlign: 'top',
            defaults: {
              anchor: '100%',
              labelSeparator: '',
              columnWidth: 1
            },
            items: [{
              xtype: 'textfield',
              hideLabel: true,
              id: 'lead_name',
              emptyText: this.app.i18n._('Enter lead name'),
              name: 'lead_name',
              allowBlank: false,
              selectOnFocus: true,
              maxLength: 255,
              // TODO make this work
              listeners: {
                render: function render(field) {
                  field.focus(false, 2000);
                }
              }
            }]
          }, {
            region: 'center',
            layout: 'form',
            items: [this.contactGrid]
          }, {
            region: 'south',
            height: 390,
            split: true,
            collapseMode: 'mini',
            header: false,
            collapsible: true,
            items: [{
              xtype: 'panel',
              layout: 'column',
              height: 140,
              id: 'lead_combos',
              anchor: '100%',
              labelAlign: 'top',
              items: [{
                columnWidth: 0.33,
                items: [{
                  layout: 'form',
                  defaults: {
                    valueField: 'id',
                    typeAhead: true,
                    mode: 'local',
                    triggerAction: 'all',
                    editable: false,
                    allowBlank: false,
                    forceSelection: true,
                    anchor: '95%',
                    xtype: 'combo'
                  },
                  items: [new Tine.Tinebase.widgets.keyfield.ComboBox({
                    app: 'Crm',
                    keyFieldName: 'leadstates',
                    fieldLabel: this.app.i18n._('Leadstate'),
                    name: 'leadstate_id',
                    showIcon: false,
                    listeners: {
                      'select': function select(combo, record, index) {
                        if (this.record.json.probability !== null) {
                          this.combo_probability.setValue(record.data.probability);
                        }

                        if (record.json.endslead == '1') {
                          this.date_end.setValue(new Date());
                        }
                      },
                      scope: this
                    }
                  }), new Tine.Tinebase.widgets.keyfield.ComboBox({
                    app: 'Crm',
                    keyFieldName: 'leadtypes',
                    fieldLabel: this.app.i18n._('Leadtype'),
                    name: 'leadtype_id',
                    showIcon: false
                  }), new Tine.Tinebase.widgets.keyfield.ComboBox({
                    app: 'Crm',
                    keyFieldName: 'leadsources',
                    fieldLabel: this.app.i18n._('Leadsource'),
                    name: 'leadsource_id',
                    showIcon: false,
                    listeners: {
                      scope: this,
                      // When loading
                      'beforerender': function beforerender(combo) {
                        setdeffered.defer(5, this, [combo]);
                      },
                      // When focus changed
                      'blur': function blur(combo) {
                        setdeffered.defer(5, this, [combo]);
                      }
                    }
                  })]
                }]
              }, {
                columnWidth: 0.33,
                items: [{
                  layout: 'form',
                  border: false,
                  items: [{
                    xtype: 'extuxmoneyfield',
                    fieldLabel: this.app.i18n._('Expected turnover'),
                    name: 'turnover',
                    selectOnFocus: true,
                    anchor: '95%',
                    minValue: 0
                  }, this.combo_probability, new Ext.ux.form.ClearableDateField({
                    fieldLabel: this.app.i18n._('Resubmission Date'),
                    id: 'resubmission_date',
                    anchor: '95%'
                  })]
                }]
              }, {
                columnWidth: 0.33,
                items: [{
                  layout: 'form',
                  border: false,
                  items: [new Ext.form.DateField({
                    fieldLabel: this.app.i18n._('Start'),
                    allowBlank: false,
                    id: 'start',
                    anchor: '95%'
                  }), new Ext.ux.form.ClearableDateField({
                    fieldLabel: this.app.i18n._('Estimated end'),
                    id: 'end_scheduled',
                    anchor: '95%'
                  }), this.date_end]
                }]
              }]
            }, {
              xtype: 'tabpanel',
              id: 'linkPanelBottom',
              activeTab: 0,
              height: 250,
              items: [this.tasksGrid, this.productsGrid]
            }]
          }] // end of center lead panel with border layout

        }, {
          layout: 'ux.multiaccordion',
          animate: true,
          region: 'east',
          width: 210,
          split: true,
          collapsible: true,
          collapseMode: 'mini',
          header: false,
          margins: '0 5 0 5',
          border: true,
          items: [new Ext.Panel({
            title: this.app.i18n._('Description'),
            iconCls: 'descriptionIcon',
            layout: 'form',
            labelAlign: 'top',
            border: false,
            items: [{
              style: 'margin-top: -4px; border 0px;',
              labelSeparator: '',
              xtype: 'textarea',
              name: 'description',
              hideLabel: true,
              grow: false,
              preventScrollbars: false,
              anchor: '100% 100%',
              emptyText: this.app.i18n._('Enter description')
            }]
          }), new Tine.widgets.tags.TagPanel({
            app: 'Crm',
            border: false,
            bodyStyle: 'border:1px solid #B5B8C8;'
          })] // end of accordion panel (east)

        }] // end of lead tabpanel items

      }, new Tine.widgets.activities.ActivitiesTabPanel({
        app: this.appName,
        record_id: this.record.id,
        record_model: this.appName + '_Model_' + this.recordClass.getMeta('modelName')
      })] // end of main tabpanel items

    }; // end of return
  } // end of getFormItems

});
/**
 * Crm Edit Popup
 * 
 * @param   {Object} config
 * @return  {Ext.ux.Window}
 */

Tine.Crm.LeadEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 800,
    height: 750,
    name: Tine.Crm.LeadEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Crm.LeadEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 1397:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Crm
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <alex@stintzing.net>
 * @copyright   Copyright (c) 2009-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Crm');
/**
 * @namespace   Tine.Crm
 * @class       Tine.Crm.AddToLeadPanel
 * @extends     Tine.widgets.dialog.AddToRecordPanel
 * @author      Alexander Stintzing <alex@stintzing.net>
 */

Tine.Crm.AddToLeadPanel = Ext.extend(Tine.widgets.dialog.AddToRecordPanel, {
  // private
  appName: 'Crm',
  recordClass: Tine.Crm.Model.Lead,
  callingApp: 'Addressbook',
  callingModel: 'Contact',

  /**
   * @see Tine.widgets.dialog.AddToRecordPanel::isValid()
   */
  isValid: function isValid() {
    var valid = true;

    if (this.searchBox.getValue() == '') {
      this.searchBox.markInvalid(this.app.i18n._('Please choose the Lead to add the contacts to'));
      valid = false;
    }

    if (this.chooseRoleBox.getValue() == '') {
      this.chooseRoleBox.markInvalid(this.app.i18n._('Please select the attenders\' role'));
      valid = false;
    }

    return valid;
  },
  getRelationConfig: function getRelationConfig() {
    return {
      type: this.chooseRoleBox.getValue()
    };
  },

  /**
   * @see Tine.widgets.dialog.AddToRecordPanel::getFormItems()
   */
  getFormItems: function getFormItems() {
    return {
      border: false,
      frame: false,
      layout: 'border',
      items: [{
        region: 'center',
        border: false,
        frame: false,
        layout: {
          align: 'stretch',
          type: 'vbox'
        },
        items: [{
          layout: 'form',
          margins: '10px 10px',
          border: false,
          frame: false,
          items: [{
            xtype: 'crmleadpickercombobox',
            fieldLabel: this.app.i18n._('Lead'),
            emptyText: this.app.i18n._('Select Lead'),
            anchor: '100% 100%',
            ref: '../../../searchBox'
          }, {
            fieldLabel: this.app.i18n._('Role'),
            amptyText: this.app.i18n._('Select Role'),
            xtype: 'leadcontacttypecombo',
            ref: '../../../chooseRoleBox',
            anchor: '100% 100%'
          }]
        }]
      }]
    };
  }
});

Tine.Crm.AddToLeadPanel.openWindow = function (config) {
  var window = Tine.WindowFactory.getWindow({
    modal: true,
    title: String.format(Tine.Tinebase.appMgr.get('Crm').i18n._('Adding {0} contacts to lead'), config.count),
    width: 250,
    height: 150,
    contentPanelConstructor: 'Tine.Crm.AddToLeadPanel',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 1398:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Crm
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2009-2015 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Crm');
/**
 * admin settings panel
 * 
 * @namespace   Tine.Crm
 * @class       Tine.Crm.AdminPanel
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>Crm Admin Panel</p>
 * <p><pre>
 * TODO         generalize this
 * TODO         revert/rollback changes onCancel
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2009-2015 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Crm.AdminPanel
 */

Tine.Crm.AdminPanel = Ext.extend(Ext.TabPanel, {
  border: false,
  activeTab: 0,

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.app = Tine.Tinebase.appMgr.get('Crm');
    this.items = [new Tine.Admin.config.GridPanel({
      configApp: this.app
    })];
    this.supr().initComponent.call(this);
  }
});
/**
 * Crm admin settings popup
 * 
 * @param   {Object} config
 * @return  {Ext.ux.Window}
 */

Tine.Crm.AdminPanel.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 600,
    height: 470,
    name: Tine.Crm.AdminPanel.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Crm.AdminPanel',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 1399:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Crm
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2009-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 * TODO         use Tine.widgets.grid.LinkGridPanel
 */
Ext.ns('Tine.Crm.Contact');
/**
 * @namespace   Tine.Crm.Contact
 * @class       Tine.Crm.Contact.Combo
 * @extends     Tine.Addressbook.SearchCombo
 * 
 * Lead Dialog Contact Search Combo
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 */

Tine.Crm.Contact.Combo = Ext.extend(Tine.Addressbook.SearchCombo, {
  valueField: 'id',

  /**
   * store to hold all contacts of grid
   * 
   * @type Ext.data.Store
   * @property contactsStore
   */
  contactsStore: null,

  /**
   * override default onSelect
   * 
   * TODO add some logic to determine if contact is customer or partner
   */
  onSelect: function onSelect(record) {
    var data = {
      relation_type: record.get('type') == 'user' ? 'responsible' : 'customer'
    }; // check if already in

    if (!this.contactsStore.getById(record.id)) {
      var recordToAdd = new this.contactsStore.recordType(Ext.apply(data, record.data), record.id);
      this.contactsStore.add([recordToAdd]);
    }

    this.collapse();
    this.clearValue();
  }
});
/**
 * @namespace   Tine.Crm.Contact
 * @class       Tine.Crm.Contact.GridPanel
 * @extends     Ext.grid.EditorGridPanel
 * 
 * Lead Dialog Contact Grid Panel
 * 
 * <p>
 * </p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2009 Metaways Infosystems GmbH (http://www.metaways.de)
 */

Tine.Crm.Contact.GridPanel = Ext.extend(Ext.grid.EditorGridPanel, {
  /**
   * grid config
   * @private
   */
  autoExpandColumn: 'n_fileas',
  clicksToEdit: 1,
  baseCls: 'contact-grid',

  /**
   * The record currently being edited
   * 
   * @type Tine.Crm.Model.Lead
   * @property record
   */
  record: null,

  /**
   * store to hold all contacts
   * 
   * @type Ext.data.Store
   * @property store
   */
  store: null,

  /**
   * @type Ext.Menu
   * @property contextMenu
   */
  contextMenu: null,

  /**
   * @type Array
   * @property otherActions
   */
  otherActions: null,

  /**
   * @type function
   * @property recordEditDialogOpener
   */
  recordEditDialogOpener: null,

  /**
   * record class
   * @cfg {Tine.Addressbook.Model.Contact} recordClass
   */
  recordClass: null,

  /**
   * @private
   */
  initComponent: function initComponent() {
    // init properties
    this.app = this.app ? this.app : Tine.Tinebase.appMgr.get('Crm');
    this.recordEditDialogOpener = Tine.Addressbook.ContactEditDialog.openWindow;
    this.recordClass = Tine.Addressbook.Model.Contact;
    this.storeFields = Tine.Addressbook.Model.ContactArray;
    this.storeFields.push({
      name: 'relation'
    }); // the relation object           

    this.storeFields.push({
      name: 'relation_type'
    }); // create delegates

    this.initStore = Tine.Crm.LinkGridPanel.initStore.createDelegate(this);
    this.initActions = Tine.Crm.LinkGridPanel.initActions.createDelegate(this);
    this.initGrid = Tine.Crm.LinkGridPanel.initGrid.createDelegate(this); //this.onUpdate = Tine.Crm.LinkGridPanel.onUpdate.createDelegate(this);

    this.initStore();
    this.initOtherActions();
    this.initActions();
    this.initGrid(); // add contact type to "add" action

    this.actionAdd.contactType = 'customer'; // init store stuff

    this.store.setDefaultSort('type', 'asc');
    Tine.Crm.Contact.GridPanel.superclass.initComponent.call(this);
  },

  /**
   * init other actions and tbar (change contact type and contact search combo
   */
  initOtherActions: function initOtherActions() {
    this.actionChangeContactTypeCustomer = new Ext.Action({
      requiredGrant: 'editGrant',
      contactType: 'customer',
      text: this.app.i18n._('Customer'),
      tooltip: this.app.i18n._('Change type to Customer'),
      iconCls: 'contactIconCustomer',
      scope: this,
      handler: this.onChangeContactType
    });
    this.actionChangeContactTypeResponsible = new Ext.Action({
      requiredGrant: 'editGrant',
      contactType: 'responsible',
      text: this.app.i18n._('Responsible'),
      tooltip: this.app.i18n._('Change type to Responsible'),
      iconCls: 'contactIconResponsible',
      scope: this,
      handler: this.onChangeContactType
    });
    this.actionChangeContactTypePartner = new Ext.Action({
      requiredGrant: 'editGrant',
      contactType: 'partner',
      text: this.app.i18n._('Partner'),
      tooltip: this.app.i18n._('Change type to Partner'),
      iconCls: 'contactIconPartner',
      scope: this,
      handler: this.onChangeContactType
    });
    var otherActionItems = [this.actionChangeContactTypeCustomer, this.actionChangeContactTypeResponsible, this.actionChangeContactTypePartner];
    this.otherActions = [new Ext.Action({
      text: this.app.i18n._('Change contact type'),
      requiredGrant: 'editGrant',
      disabled: true,
      menu: otherActionItems
    })];
    this.tbar = new Ext.Panel({
      layout: 'fit',
      items: [// TODO perhaps we could add an icon/button (i.e. edit-find.png) here
      new Tine.Crm.Contact.Combo({
        contactsStore: this.store,
        emptyText: this.app.i18n._('Search for Contacts to add ...')
      })]
    });
  },

  /**
   * @return Ext.grid.ColumnModel
   * @private
   */
  getColumnModel: function getColumnModel() {
    return new Ext.grid.ColumnModel({
      defaults: {
        sortable: true
      },
      columns: [{
        id: 'id',
        header: "id",
        dataIndex: 'id',
        width: 25,
        hidden: true
      }, {
        id: 'n_fileas',
        header: this.app.i18n._('Name'),
        dataIndex: 'n_fileas',
        width: 200,
        sortable: true,
        renderer: function renderer(val, meta, record) {
          var org_name = Ext.isEmpty(record.data.org_name) === false ? record.data.org_name : ' ';
          var n_fileas = Ext.isEmpty(record.data.n_fileas) === false ? record.data.n_fileas : ' ';
          var formated_return = '<b>' + Ext.util.Format.htmlEncode(n_fileas) + '</b><br />' + Ext.util.Format.htmlEncode(org_name);
          return formated_return;
        }
      }, {
        id: 'contact_one',
        header: this.app.i18n._("Address"),
        dataIndex: 'adr_one_locality',
        width: 140,
        sortable: false,
        renderer: function renderer(val, meta, record) {
          var adr_one_street = Ext.isEmpty(record.data.adr_one_street) === false ? record.data.adr_one_street : ' ';
          var adr_one_postalcode = Ext.isEmpty(record.data.adr_one_postalcode) === false ? record.data.adr_one_postalcode : ' ';
          var adr_one_locality = Ext.isEmpty(record.data.adr_one_locality) === false ? record.data.adr_one_locality : ' ';
          var formated_return = Ext.util.Format.htmlEncode(adr_one_street) + '<br />' + Ext.util.Format.htmlEncode(adr_one_postalcode) + ' ' + Ext.util.Format.htmlEncode(adr_one_locality);
          return formated_return;
        }
      }, {
        id: 'tel_work',
        header: this.app.i18n._("Data"),
        dataIndex: 'tel_work',
        width: 140,
        sortable: false,
        renderer: function renderer(val, meta, record) {
          var translation = new Locale.Gettext();
          translation.textdomain('Crm');
          var tel_work = Ext.isEmpty(record.data.tel_work) === false ? translation._('Phone') + ': ' + record.data.tel_work : ' ';
          var tel_cell = Ext.isEmpty(record.data.tel_cell) === false ? translation._('Cellphone') + ': ' + record.data.tel_cell : ' ';
          var formated_return = Ext.util.Format.htmlEncode(tel_work) + '<br/>' + Ext.util.Format.htmlEncode(tel_cell) + '<br/>';
          return formated_return;
        }
      }, {
        id: 'relation_type',
        header: this.app.i18n._("Role"),
        dataIndex: 'relation_type',
        width: 60,
        sortable: true,
        renderer: Tine.Crm.Contact.typeRenderer,
        editor: new Tine.Crm.Contact.TypeComboBox({
          autoExpand: true,
          blurOnSelect: true,
          listClass: 'x-combo-list-small'
        })
      }]
    });
  },

  /**
   * onclick handler for changeContactType
   */
  onChangeContactType: function onChangeContactType(_button, _event) {
    var selectedRows = this.getSelectionModel().getSelections();

    for (var i = 0; i < selectedRows.length; ++i) {
      selectedRows[i].data.relation_type = _button.contactType;
    }

    this.store.fireEvent('dataChanged', this.store);
  },

  /**
   * update event handler for related contacts
   * 
   * TODO use generic function?
   */
  onUpdate: function onUpdate(contact) {
    var response = {
      responseText: contact
    };
    contact = Tine.Addressbook.contactBackend.recordReader(response);
    Tine.log.debug('Tine.Crm.Contact.GridPanel::onUpdate - Contact has been updated:');
    Tine.log.debug(contact); // remove contact relations to prevent cyclic relation structure

    contact.data.relations = null;
    var myContact = this.store.getById(contact.id);

    if (myContact) {
      myContact.beginEdit();

      for (var p in contact.data) {
        myContact.set(p, contact.get(p));
      }

      myContact.endEdit();
    } else {
      contact.data.relation_type = 'customer';
      this.store.add(contact);
    }
  }
});
/**
 * @namespace   Tine.Crm.Contact
 * @class       Tine.Crm.Contact.TypeComboBox
 * @extends     Ext.form.ComboBox
 * 
 * Contact type selection combobox
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 */

Tine.Crm.Contact.TypeComboBox = Ext.extend(Ext.form.ComboBox, {
  /**
   * @cfg {bool} autoExpand Autoexpand comboBox on focus.
   */
  autoExpand: false,

  /**
   * @cfg {bool} blurOnSelect blurs combobox when item gets selected
   */
  blurOnSelect: false,
  displayField: 'label',
  valueField: 'relation_type',
  mode: 'local',
  triggerAction: 'all',
  lazyInit: false,
  forceSelection: true,
  allowBlank: false,
  //private
  initComponent: function initComponent() {
    var translation = new Locale.Gettext();
    translation.textdomain('Crm');
    Tine.Crm.Contact.TypeComboBox.superclass.initComponent.call(this); // always set a default

    if (!this.value) {
      this.value = 'responsible';
    }

    this.store = new Ext.data.SimpleStore({
      fields: ['label', 'relation_type'],
      data: [[translation._('Responsible'), 'responsible'], [translation._('Customer'), 'customer'], [translation._('Partner'), 'partner']]
    });

    if (this.autoExpand) {
      this.lazyInit = false;
      this.on('focus', function () {
        this.selectByValue(this.getValue());
        this.onTriggerClick();
      });
    }

    if (this.blurOnSelect) {
      this.on('select', function () {
        this.fireEvent('blur', this);
      }, this);
    }
  }
});
Ext.reg('leadcontacttypecombo', Tine.Crm.Contact.TypeComboBox);
/**
 * contact type renderer function
 * 
 * @param   string type
 * @return  contact type icon
 */

Tine.Crm.Contact.typeRenderer = function (type) {
  var translation = new Locale.Gettext();
  translation.textdomain('Crm');

  switch (type) {
    case 'responsible':
      var iconClass = 'contactIconResponsible';

      var qTip = translation._('Responsible');

      break;

    case 'customer':
      var iconClass = 'contactIconCustomer';

      var qTip = translation._('Customer');

      break;

    case 'partner':
      var iconClass = 'contactIconPartner';

      var qTip = translation._('Partner');

      break;
  }

  var icon = '<img class="x-menu-item-icon contactIcon ' + iconClass + '" src="library/ExtJS/resources/images/default/s.gif" ext:qtip="' + Ext.util.Format.htmlEncode(qTip) + '"/>';
  return icon;
};

/***/ }),

/***/ 1400:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Crm
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2009-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 * TODO         use Tine.widgets.grid.LinkGridPanel
 */
Ext.ns('Tine.Crm.Product');
/**
 * @namespace   Tine.Crm.Product
 * @class       Tine.Crm.Product.GridPanel
 * @extends     Ext.grid.EditorGridPanel
 * 
 * Lead Dialog Products Grid Panel
 * 
 * <p>
 * TODO         allow multiple relations with 1 product or add product quantity?
 * TODO         check if we need edit/add actions again
 * TODO         make resizing work correctly
 * </p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2009 Metaways Infosystems GmbH (http://www.metaways.de)
 */

Tine.Crm.Product.GridPanel = Ext.extend(Ext.grid.EditorGridPanel, {
  /**
   * grid config
   * @private
   */
  autoExpandColumn: 'name',
  clicksToEdit: 1,

  /**
   * The record currently being edited
   * 
   * @type Tine.Crm.Model.Lead
   * @property record
   */
  record: null,

  /**
   * store to hold all contacts
   * 
   * @type Ext.data.Store
   * @property store
   */
  store: null,

  /**
   * @type Ext.Menu
   * @property contextMenu
   */
  contextMenu: null,

  /**
   * @type Array
   * @property otherActions
   */
  otherActions: null,

  /**
   * @type function
   * @property recordEditDialogOpener
   */
  recordEditDialogOpener: null,

  /**
   * record class
   * @cfg {Tine.Sales.Model.Product} recordClass
   */
  recordClass: null,

  /**
   * @private
   */
  initComponent: function initComponent() {
    // init properties
    this.app = this.app ? this.app : Tine.Tinebase.appMgr.get('Crm');
    this.title = this.app.i18n._('Products'); //this.recordEditDialogOpener = Tine.Products.EditDialog.openWindow;

    this.recordEditDialogOpener = Ext.emptyFn;
    this.recordClass = Tine.Sales.Model.Product;
    this.storeFields = Tine.Sales.Model.ProductArray;
    this.storeFields.push({
      name: 'relation'
    }); // the relation object           

    this.storeFields.push({
      name: 'relation_type'
    });
    this.storeFields.push({
      name: 'remark_price'
    });
    this.storeFields.push({
      name: 'remark_description'
    });
    this.storeFields.push({
      name: 'remark_quantity'
    }); // create delegates

    this.initStore = Tine.Crm.LinkGridPanel.initStore.createDelegate(this); //this.initActions = Tine.Crm.LinkGridPanel.initActions.createDelegate(this);

    this.initGrid = Tine.Crm.LinkGridPanel.initGrid.createDelegate(this); //this.onUpdate = Tine.Crm.LinkGridPanel.onUpdate.createDelegate(this);

    this.onUpdate = Ext.emptyFn; // call delegates

    this.initStore();
    this.initActions();
    this.initGrid(); // init store stuff

    this.store.setDefaultSort('name', 'asc');
    this.on('newentry', function (productData) {
      // add new product to store
      var newProduct = [productData];
      this.store.loadData(newProduct, true);
      return true;
    }, this);
    Tine.Crm.Product.GridPanel.superclass.initComponent.call(this);
  },

  /**
   * @return Ext.grid.ColumnModel
   * @private
   */
  getColumnModel: function getColumnModel() {
    return new Ext.grid.ColumnModel({
      defaults: {
        sortable: true
      },
      columns: [{
        header: this.app.i18n._("Product"),
        id: 'name',
        dataIndex: 'name',
        width: 150
      }, {
        header: this.app.i18n._("Description"),
        id: 'remark_description',
        dataIndex: 'remark_description',
        width: 150,
        editor: new Ext.form.TextField({})
      }, {
        header: this.app.i18n._("Price"),
        id: 'remark_price',
        dataIndex: 'remark_price',
        width: 150,
        editor: new Ext.form.NumberField({
          allowBlank: false,
          allowNegative: false,
          // TODO hardcode separator or get it from locale?
          decimalSeparator: ','
        }),
        renderer: Ext.util.Format.money
      }, {
        header: this.app.i18n._("Quantity"),
        id: 'remark_quantity',
        dataIndex: 'remark_quantity',
        width: 50,
        editor: new Ext.form.NumberField({
          allowBlank: false,
          allowNegative: false
        })
      }]
    });
  },

  /**
   * init actions and bars
   */
  initActions: function initActions() {
    var app = Tine.Tinebase.appMgr.get(this.recordClass.getMeta('appName'));

    if (!app) {
      return;
    }

    var recordName = app.i18n.n_(this.recordClass.getMeta('recordName'), this.recordClass.getMeta('recordsName'), 1);
    this.actionUnlink = new Ext.Action({
      requiredGrant: 'editGrant',
      text: String.format(this.app.i18n._('Unlink {0}'), recordName),
      tooltip: String.format(this.app.i18n._('Unlink selected {0}'), recordName),
      disabled: true,
      iconCls: 'action_remove',
      onlySingle: true,
      scope: this,
      handler: function handler(_button, _event) {
        var selectedRows = this.getSelectionModel().getSelections();

        for (var i = 0; i < selectedRows.length; ++i) {
          this.store.remove(selectedRows[i]);
        }
      }
    }); // init toolbars and ctx menut / add actions

    this.bbar = [this.actionUnlink];
    this.actions = [this.actionUnlink];
    this.contextMenu = new Ext.menu.Menu({
      items: this.actions,
      plugins: [{
        ptype: 'ux.itemregistry',
        key: 'Tinebase-MainContextMenu'
      }]
    });
    this.tbar = new Ext.Panel({
      layout: 'fit',
      items: [new Tine.Crm.ProductPickerCombo({
        anchor: '90%',
        emptyText: this.app.i18n._('Search for Products to add ...'),
        productsStore: this.store,
        blurOnSelect: true,
        recordClass: Tine.Sales.Model.Product,
        getValue: function getValue() {
          return this.selectedRecord ? this.selectedRecord.data : null;
        },
        onSelect: function onSelect(record) {
          // check if already in?
          if (!this.productsStore.getById(record.id)) {
            var newRecord = new Ext.data.Record({
              salesprice: record.data.salesprice,
              remark_price: record.data.salesprice,
              remark_quantity: 1,
              name: record.data.name,
              relation_type: 'product',
              related_id: record.id,
              id: record.id
            }, record.id);
            this.productsStore.insert(0, newRecord);
          }

          this.collapse();
          this.clearValue();
        }
      })]
    });
  }
});

/***/ }),

/***/ 1401:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Crm
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2009-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 * TODO         use Tine.widgets.grid.LinkGridPanel
 */
Ext.ns('Tine.Crm.Task');
/**
 * @namespace   Tine.Crm
 * @class       Tine.Crm.Task.GridPanel
 * @extends     Ext.ux.grid.QuickaddGridPanel
 * 
 * Lead Dialog Tasks Grid Panel
 * 
 * <p>
 * </p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 */

Tine.Crm.Task.GridPanel = Ext.extend(Ext.ux.grid.QuickaddGridPanel, {
  /**
   * grid config
   * @private
   */
  quickaddMandatory: 'summary',
  clicksToEdit: 1,
  enableColumnHide: false,
  enableColumnMove: false,

  /**
   * The record currently being edited
   * 
   * @type Tine.Crm.Model.Lead
   * @property record
   */
  record: null,

  /**
   * store to hold all contacts
   * 
   * @type Ext.data.Store
   * @property store
   */
  store: null,

  /**
   * @type Ext.Menu
   * @property contextMenu
   */
  contextMenu: null,

  /**
   * @type Array
   * @property otherActions
   */
  otherActions: null,

  /**
   * @type function
   * @property recordEditDialogOpener
   */
  recordEditDialogOpener: null,

  /**
   * record class
   * @cfg {Tine.Tasks.Model.Task} recordClass
   */
  recordClass: null,

  /**
   * @private
   */
  initComponent: function initComponent() {
    // init properties
    this.app = this.app ? this.app : Tine.Tinebase.appMgr.get('Crm');
    this.title = this.app.i18n._('Tasks');
    this.recordEditDialogOpener = Tine.Tasks.TaskEditDialog.openWindow;
    this.recordClass = Tine.Tasks.Model.Task;
    this.storeFields = Tine.Tasks.Model.TaskArray;
    this.storeFields.push({
      name: 'relation'
    }); // the relation object

    this.storeFields.push({
      name: 'relation_type'
    }); // create delegates

    this.initStore = Tine.Crm.LinkGridPanel.initStore.createDelegate(this);
    this.initActions = Tine.Crm.LinkGridPanel.initActions.createDelegate(this);
    this.initGrid = Tine.Crm.LinkGridPanel.initGrid.createDelegate(this); //this.onUpdate = Tine.Crm.LinkGridPanel.onUpdate.createDelegate(this);
    // call delegates

    this.initStore();
    this.initActions();
    this.initGrid(); // init store stuff

    this.store.setDefaultSort('due', 'asc');
    this.view = new Ext.grid.GridView({
      emptyText: this.app.i18n._('No Tasks to display'),
      onLoad: Ext.emptyFn,
      listeners: {
        beforerefresh: function beforerefresh(v) {
          v.scrollTop = v.scroller.dom.scrollTop;
        },
        refresh: function refresh(v) {
          v.scroller.dom.scrollTop = v.scrollTop;
        }
      }
    });
    this.on('afteredit', this.onAfterEdit);
    this.on('newentry', function (taskData) {
      var newTask = taskData;
      newTask.relation_type = 'task'; // get first responsible person and add it to task as organizer

      var i = 0;

      while (this.record.data.relations.length > i && this.record.data.relations[i].type != 'responsible') {
        i++;
      }

      if (!newTask.organizer) {
        if (this.record.data.relations[i] && this.record.data.relations[i].type == 'responsible' && this.record.data.relations[i].related_record.account_id != '') {
          newTask.organizer = Tine.Tinebase.registry.get('currentAccount');
        }
      } else {
        var contactRecord = this.organizerQuickAdd.selectedRecord;

        if (contactRecord) {
          var organizer = {
            accountId: contactRecord.get('account_id'),
            accountDisplayName: contactRecord.get('n_fileas')
          };
          newTask.organizer = organizer;
        }
      } // add new task to store


      this.store.loadData([newTask], true);
      return true;
    }, this); // hack to get percentage editor working

    this.on('rowclick', function (grid, row, e) {
      var cell = Ext.get(grid.getView().getCell(row, 1));
      var dom = cell.child('div:last');

      while (cell.first()) {
        cell = cell.first();
        cell.on('click', function (e) {
          e.stopPropagation();
          grid.fireEvent('celldblclick', grid, row, 1, e);
        });
      }
    }, this);
    Tine.Crm.Task.GridPanel.superclass.initComponent.call(this);
  },

  /**
   * is called on after edit to set related records
   * @param {} o
   */
  onAfterEdit: function onAfterEdit(o) {
    if (o.field == 'organizer') {
      var contactRecord = this.organizerEditor.selectedRecord;

      if (contactRecord) {
        var organizer = {
          accountId: contactRecord.get('account_id'),
          accountDisplayName: contactRecord.get('n_fileas')
        };
        o.record.set('organizer', organizer);
      } else {
        if (o.originalValue.accountId == o.value) {
          o.record.set('organizer', o.originalValue);
        }
      }
    }
  },

  /**
   * @return Ext.grid.ColumnModel
   * @private
   */
  getColumnModel: function getColumnModel() {
    this.organizerQuickAdd = Tine.widgets.form.RecordPickerManager.get('Addressbook', 'Contact', {
      userOnly: true,
      useAccountRecord: true,
      scope: this,
      allowBlank: true
    });
    this.organizerEditor = Tine.widgets.form.RecordPickerManager.get('Addressbook', 'Contact', {
      userOnly: true,
      useAccountRecord: true,
      scope: this
    });
    return new Ext.grid.ColumnModel({
      defaults: {
        sortable: true
      },
      columns: [{
        id: 'summary',
        header: this.app.i18n._("Summary"),
        width: 150,
        dataIndex: 'summary',
        quickaddField: new Ext.form.TextField({
          emptyText: this.app.i18n._('Add a task...')
        })
      }, {
        id: 'due',
        header: this.app.i18n._("Due Date"),
        width: 110,
        dataIndex: 'due',
        renderer: Tine.Tinebase.common.dateRenderer,
        editor: new Ext.ux.form.ClearableDateField({//format : 'd.m.Y'
        }),
        quickaddField: new Ext.ux.form.ClearableDateField({//value: new Date(),
          //format : "d.m.Y"
        })
      }, {
        id: 'priority',
        header: this.app.i18n._("Priority"),
        width: 80,
        dataIndex: 'priority',
        renderer: Tine.Tinebase.widgets.keyfield.Renderer.get('Tasks', 'taskPriority'),
        editor: {
          xtype: 'widget-keyfieldcombo',
          app: 'Tasks',
          keyFieldName: 'taskPriority'
        },
        quickaddField: new Tine.Tinebase.widgets.keyfield.ComboBox({
          app: 'Tasks',
          keyFieldName: 'taskPriority'
        })
      }, {
        id: 'percent',
        header: this.app.i18n._("Percent"),
        width: 80,
        dataIndex: 'percent',
        renderer: Ext.ux.PercentRenderer,
        editor: new Ext.ux.PercentCombo({
          autoExpand: true,
          blurOnSelect: true
        }),
        quickaddField: new Ext.ux.PercentCombo({
          autoExpand: true
        })
      }, {
        id: 'status',
        header: this.app.i18n._("Status"),
        width: 92,
        dataIndex: 'status',
        renderer: Tine.Tinebase.widgets.keyfield.Renderer.get('Tasks', 'taskStatus'),
        editor: {
          xtype: 'widget-keyfieldcombo',
          app: 'Tasks',
          keyFieldName: 'taskStatus'
        },
        quickaddField: new Tine.Tinebase.widgets.keyfield.ComboBox({
          app: 'Tasks',
          keyFieldName: 'taskStatus',
          value: 'NEEDS-ACTION'
        })
      }, {
        id: 'organizer',
        header: this.app.i18n._("Organizer"),
        width: 180,
        dataIndex: 'organizer',
        renderer: Tine.Tinebase.common.usernameRenderer,
        quickaddField: this.organizerQuickAdd,
        editor: this.organizerEditor
      }]
    });
  },

  /**
   * update event handler for related tasks
   * 
   * TODO use generic function
   */
  onUpdate: function onUpdate(task) {
    var response = {
      responseText: task
    };
    task = Tine.Tasks.JsonBackend.recordReader(response);
    Tine.log.debug('Tine.Crm.Task.GridPanel::onUpdate - Task has been updated:');
    Tine.log.debug(task); // remove task relations to prevent cyclic relation structure

    task.data.relations = null;
    var myTask = this.store.getById(task.id);

    if (myTask) {
      // copy values from edited task
      myTask.beginEdit();

      for (var p in task.data) {
        myTask.set(p, task.get(p));
      }

      myTask.endEdit();
    } else {
      task.data.relation_type = 'task';
      this.store.add(task);
    }
  }
});

/***/ }),

/***/ 1402:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(1403);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(19)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 1403:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(189);
exports = module.exports = __webpack_require__(18)(false);
// imports


// module
exports.push([module.i, ".CrmIconCls, .CrmLead {\n    background-image:url(" + escape(__webpack_require__(1404)) + ") !important;\n}\n\n.activities-item-small {\n    padding: 2px 4px; \n    border-bottom: 1px solid #B5B8C8;\n    font-size: 11px;\n}\n\n.activities-item-small i {\n\n}\n\n.productSummary-item-small {\n    padding: 2px 4px; \n    border-bottom: 1px solid #B5B8C8;\n    font-size: 11px;    \n}\n\n.contact-item-small {\n    padding: 2px 4px; \n    border-bottom: 1px solid #B5B8C8;\n    font-size: 11px;\n}\n\n.contact-item {\n    padding: 2px 4px; \n    border-bottom: 1px solid #B5B8C8;\n}\n\n.contact-item a {\n    text-decoration: none;\n    color: #000000;\n}\n\n.contact-item a:hover {\n    text-decoration: underline;\n    color: #999999\n}\n\n.contact-item p {\n    line-height: 13px;\n    margin: 7px 0px;\n}\n\n.contacts_background {\n    background: #FFFFFF url(" + escape(__webpack_require__(1405)) + ") repeat-x scroll 0pt 19pt;\n    border: 1px solid #B5B8C8;\n    margin-right: 10px;\n}\n\n.contactIcon {\n    position: relative;\n}\n\n\n.contactIconResponsible {\n    background-image:url(" + escape(__webpack_require__(1406)) + ") !important;\n}\n\n.contactIconCustomer {\n    background-image:url(" + escape(__webpack_require__(359)) + ") !important;\n}\n\n.contactIconPartner {\n    background-image:url(" + escape(__webpack_require__(1407)) + ") !important;\n}\n\n.productSummary {\n    background: transparent none repeat;\n    border: 0px;\n    color: #000000;\n    opacity: 1;\n    padding: 0px 0px;\n}\n\n/* if this is realy wantet, limit this to the grid this is wanted!!!\n.x-grid3-cell-inner, .x-grid3-hd-inner {\n    white-space: normal;\n}\n*/\n\n.lowPadding {\n    padding-left: 1px;\n    padding-right: 1px;\n}\n\n.borderTop {\n    border-top: solid;\n    border-top-color: #bbbbbb;\n    border-top-width: 1px;\n    \n}\n\n.x-view-over {\n                background-color: #efefef\n            }\n\n.contact-grid {\n    border: 1px solid #cccccc;\n}\n\n/** details panel **/\n.crm-leadgrid-detailspanel-status {\n    margin: 5px 2px 5px 5px;\n    width: 20%;\n}\n\n.crm-leadgrid-detailspanel-contacts {\n    margin: 5px 2px 5px 5px;\n    width: 36%;\n}\n\n.crm-leadgrid-detailspanel .preview-panel-description {\n    margin: 5px 2px 5px 5px;\n    width: 36%;\n    overflow: hidden;\n}\n\n.crm-leadgrid-detailspanel-status .preview-panel-symbolcompare{\n    width: 90px;    \n}\n\n.crm-leadgrid-detailspanel-contact {\n    width: 50%;\n    float:right;\n    height:108px;\n    position:relative;\n}\n\n.crm-highlight-task {\n    color: red;\n}", ""]);

// exports


/***/ }),

/***/ 1404:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M13.8,21.2v9.4H9.1v-9.4H13.8z M20.9,11.7v18.9h-4.7V11.7H20.9z M39.8,32.9v2.4H2V7h2.4v25.9H39.8z M28,16.4v14.2h-4.7V16.4 H28z M35.1,9.4v21.3h-4.7V9.4H35.1z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1405:
/***/ (function(module, exports) {

module.exports = "data:image/gif;base64,R0lGODlhAQASAIcAAN7j5vDz8/P19fX39/f5+fn7+/z8/f3+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAP8ALAAAAAABABIAAAgQAAEEEDCAQAEDBxAoXMgwIAA7"

/***/ }),

/***/ 1406:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M33.6,24.2c-1.2-2-2.8-3.1-5-3.2c-2.1,1.9-4.6,2.8-7.4,2.8c-2.8,0-5.3-0.9-7.4-2.8c-2.2,0.1-3.8,1.2-5,3.2 C7.6,26.2,7,29,7,32.5c0,1.5,0.5,2.8,1.4,3.8s2,1.6,3.3,1.6h18.9c1.3,0,2.4-0.5,3.3-1.6s1.4-2.3,1.4-3.8 C35.3,29,34.7,26.2,33.6,24.2z M30,26.2l-9.4,9.4c-0.2,0.2-0.5,0.3-0.7,0.3s-0.5-0.1-0.7-0.3L14.7,31c-0.2-0.2-0.3-0.5-0.3-0.7 s0.1-0.5,0.3-0.7l0.3-0.3c0.2-0.2,0.5-0.3,0.7-0.3s0.5,0.1,0.7,0.3l3.4,3.4l8.4-8.4c0.2-0.2,0.5-0.3,0.7-0.3s0.5,0.1,0.7,0.3 l0.3,0.3c0.2,0.2,0.3,0.5,0.3,0.7C30.3,25.7,30.2,26,30,26.2z M15.1,18.5c-1.7-1.7-2.5-3.7-2.5-6s0.8-4.3,2.5-6 c1.7-1.7,3.7-2.5,6-2.5c2.3,0,4.3,0.8,6,2.5c1.7,1.7,2.5,3.7,2.5,6s-0.8,4.3-2.5,6c-1.7,1.7-3.7,2.5-6,2.5 C18.8,21,16.8,20.2,15.1,18.5z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1407:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cg%3E %3Cg%3E %3Cpath d='M29.9,11.8c0.7,0,1.3-0.2,1.9-0.5l5.7-3.2V6.6l-6.4,3.5c-0.5,0.3-1,0.4-1.5,0.4l-7.9-0.1c-0.4-0.1-0.7-0.2-0.8-0.3 c-2.4-0.5-4.4-0.3-5.7,0c-1,0.3-2.1,0.2-3.1-0.2L4,6.6v13.2l1.6,0.4c1.1,0.6,2,1.5,2.5,2.7l-0.4,0.3c-1.1,0.8-1.4,2.4-0.6,3.6 c0.4,0.5,1,0.9,1.7,1c0.1,0,0.2,0,0.3,0c0.2,0,0.5,0,0.7,0c0,0.6,0.1,1.1,0.5,1.5c0.4,0.6,1.2,0.9,1.9,1c0.2,0,0.4,0,0.6,0 c-0.1,0.6,0.1,1.2,0.5,1.7c0.4,0.5,1,0.9,1.7,1c0.1,0,0.2,0,0.3,0c0.6,0,1.2-0.1,1.6-0.5l0.3-0.2c0.1,0.4,0.2,0.7,0.4,1 c0.3,0.5,0.8,0.8,1.4,0.9c0.1,0,0.2,0,0.2,0c0.5,0,1-0.1,1.4-0.4h0l0.3,0.4c0.5,0.8,1.6,0.9,2.4,0.4c0.6-0.4,0.9-1.3,0.6-2l0,0 c0.4,0.7,1.2,1,2,0.8c1.1-0.3,1.6-1.4,1.3-2.3c0.6,0.7,1.7,0.8,2.4,0.3l0,0c0.8-0.5,1-1.5,0.6-2.3c0.7,0.6,1.7,0.7,2.5,0.2 c0.9-0.6,1.1-1.9,0.5-2.8l-0.9-1.3l2-2.4c0.5-0.6,1.2-1.2,1.9-1.6l1.4-0.6v-1.6l-1.8,0.8c-0.8,0.5-1.5,1-2.1,1.7l-2.2,2.5 c-0.7-0.6-1.7-0.7-2.5-0.2c-0.9,0.6-1.1,1.9-0.5,2.8l0,0.1h0c-0.6-0.4-1.5-0.5-2.1,0l0,0c-0.6,0.4-0.9,1.1-0.7,1.8l-0.2,0.2 c-0.6-0.3-1.3-0.3-1.9,0.1c-0.5,0.4-0.8,1-0.8,1.7L22.1,31c-0.4-0.1-0.9,0-1.3,0.3c-0.5,0.3-0.7,0.9-0.7,1.4l-0.3,0.2 c-0.2,0.2-0.5,0.2-0.7,0.2c-0.2-0.1-0.5-0.2-0.6-0.4c-0.2-0.2-0.2-0.5-0.2-0.7c0.1-0.2,0.2-0.5,0.4-0.6l3.2-2.4 c0.2-0.1,0.3-0.3,0.3-0.5c0-0.4-0.3-0.7-0.6-0.7c-0.1,0-0.3,0-0.4,0.1l-5,3.6c-0.3,0.2-0.6,0.3-1,0.2c-0.4-0.1-0.7-0.2-0.9-0.5 c-0.4-0.5-0.3-1.4,0.3-1.8l6-4.3c0.1-0.1,0.2-0.3,0.2-0.5c0-0.3-0.3-0.6-0.6-0.6c-0.2,0-0.4,0.1-0.5,0.2l-5.9,4.2 c-0.2,0.1-0.3,0.2-0.4,0.3c-0.7,0.4-1.8,0.4-2.1-0.2c-0.4-0.5-0.3-1.3,0.2-1.7l0.6-0.4l6.5-4.5c0.2-0.1,0.3-0.3,0.3-0.5 c0-0.2-0.1-0.4-0.3-0.5c-0.2-0.2-0.5-0.2-0.7,0l-7,4.8c0,0.1-0.1,0.1-0.2,0.2L10,26.4c-0.5,0.4-1.4,0.3-1.8-0.3 c-0.4-0.5-0.3-1.4,0.3-1.8l12.8-9.5c1.1-0.1,2.2,1.3,2.2,1.7c1.2,3.8,2.3,3.9,3.3,3.6c0.5-0.2,1.2-0.7,1.1-1.2 c-0.3-2.2-2.3-6.3-3.6-7l4.2,0.1L29.9,11.8z M29.9,11.8'/%3E %3C/g%3E %3C/g%3E %3C/svg%3E\""

/***/ }),

/***/ 1408:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(1409);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(19)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 1409:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(189);
exports = module.exports = __webpack_require__(18)(false);
// imports


// module
exports.push([module.i, "/*\n * Tine 2.0\n *\n * @license      http://www.gnu.org/licenses/agpl.html AGPL Version 3\n * @author       Michael Spahn <m.spahn@metaways.de>\n * @copyright    Copyright (c) 2018 Metaways Infosystems GmbH (http://www.metaways.de)\n *\n */\n\n\n.t-contenttype-lead .action_add {\n    background-image:url(" + escape(__webpack_require__(1410)) + ") !important;\n}\n\n.t-contenttype-lead .action_edit {\n    background-image:url(" + escape(__webpack_require__(1411)) + ") !important;\n}\n\n.t-contenttype-lead .action_export {\n    background-image:url(" + escape(__webpack_require__(1412)) + ") !important;\n}\n\n.t-contenttype-lead .action_import {\n    background-image:url(" + escape(__webpack_require__(1413)) + ") !important;\n}\n\n.t-contenttype-lead .action_delete {\n    background-image:url(" + escape(__webpack_require__(1414)) + ") !important;\n}", ""]);

// exports


/***/ }),

/***/ 1410:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath id='plus' d='M12.8,21.2v9.4H8.1v-9.4H12.8z M19.9,11.7v18.9h-4.7V11.7H19.9z M38.8,32.9v2.4H1V7h2.4v25.9H38.8z M27,16.4v14.2 h-4.7V16.4H27z'/%3E %3Cpath d='M28.7,14.1c-0.1-0.1-0.2-0.3-0.2-0.4v-1.2c0-0.2,0.1-0.3,0.2-0.4s0.3-0.2,0.4-0.2h4.3V7.6c0-0.2,0.1-0.3,0.2-0.4 S33.8,7,34,7h1.2c0.2,0,0.3,0.1,0.4,0.2s0.2,0.3,0.2,0.4v4.3h4.3c0.2,0,0.3,0.1,0.4,0.2s0.2,0.3,0.2,0.4v1.2c0,0.2-0.1,0.3-0.2,0.4 s-0.3,0.2-0.4,0.2h-4.3v4.3c0,0.2-0.1,0.3-0.2,0.4s-0.3,0.2-0.4,0.2H34c-0.2,0-0.3-0.1-0.4-0.2s-0.2-0.3-0.2-0.4v-4.3h-4.3 C29,14.3,28.8,14.2,28.7,14.1z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1411:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath id='edit' d='M11.8,21.2v9.4H7.1v-9.4H11.8z M18.9,11.7v18.9h-4.7V11.7H18.9z M37.8,32.9v2.4H0V7h2.4v25.9H37.8z M26,26.6v4 h-4.7v-4H26z M27.3,23.4l2-1.8L27,19l-2,1.8l0,0.9l1.6,0.1l-0.1,1.6L27.3,23.4z M35,12.1c-0.2-0.2-0.3-0.2-0.5,0l-6,5.4 c-0.2,0.2-0.2,0.4,0,0.5c0.2,0.2,0.3,0.2,0.5,0l6-5.4C35.2,12.5,35.2,12.3,35,12.1z M34.9,9.8l4.4,4.9L27.9,25l-4.7-0.2l0.2-4.7 L34.9,9.8z M42,12.3l-1.6,1.4L36,8.8l1.6-1.4C37.9,7.1,38.2,7,38.7,7c0.4,0,0.8,0.2,1.1,0.5l2.3,2.6c0.3,0.3,0.4,0.7,0.4,1.1 S42.3,12,42,12.3z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1412:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M11.8,21.2v9.4H7.1v-9.4H11.8z M18.9,11.7v18.9h-4.7V11.7H18.9z M37.8,32.9v2.4H0V7h2.4v25.9H37.8z M26,25.4v5.2h-4.7v-5.2 H26z M33.1,9.4v9.2h-4.7V9.4H33.1z M26.1,15.9v2.7h-4.7v-2.7H26.1z M33.1,25.5v5.1h-4.7v-5.1H33.1z M42.5,22.1 c0,0.3-0.1,0.5-0.3,0.7L37,28c-0.2,0.2-0.4,0.3-0.7,0.3c-0.3,0-0.5-0.1-0.7-0.3L35,27.4c-0.2-0.2-0.3-0.4-0.3-0.7s0.1-0.5,0.3-0.7 l2.3-2.3H22.2c-0.3,0-0.5-0.1-0.7-0.3c-0.2-0.2-0.3-0.4-0.3-0.7v-1c0-0.3,0.1-0.5,0.3-0.7c0.2-0.2,0.4-0.3,0.7-0.3h15.2L35,18.2 c-0.2-0.2-0.3-0.4-0.3-0.7c0-0.3,0.1-0.5,0.3-0.7l0.6-0.6c0.2-0.2,0.4-0.3,0.7-0.3c0.3,0,0.5,0.1,0.7,0.3l5.2,5.2 C42.4,21.5,42.5,21.8,42.5,22.1z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1413:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M16.2,28.9v1.7h-4.7v-1.7H16.2z M23.3,11.7v18.9h-4.7V11.7H23.3z M42.2,32.9v2.4H4.4V7h2.4v25.9H42.2z M30.4,17.7v12.9h-4.7 V17.7H30.4z M37.5,9.4v21.2h-4.7V9.4H37.5z M16.5,22.1c0,0.3-0.1,0.5-0.3,0.7L11,28c-0.2,0.2-0.4,0.3-0.7,0.3 c-0.3,0-0.5-0.1-0.7-0.3L9,27.4c-0.2-0.2-0.3-0.4-0.3-0.7s0.1-0.5,0.3-0.7l2.3-2.3H0.9c-0.3,0-0.5-0.1-0.7-0.3S0,22.8,0,22.6v-1 c0-0.3,0.1-0.5,0.3-0.7s0.4-0.3,0.7-0.3h10.4L9,18.2c-0.2-0.2-0.3-0.4-0.3-0.7c0-0.3,0.1-0.5,0.3-0.7l0.6-0.6 c0.2-0.2,0.4-0.3,0.7-0.3c0.3,0,0.5,0.1,0.7,0.3l5.2,5.2C16.4,21.5,16.5,21.8,16.5,22.1z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1414:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath id='plus_1_' d='M12.8,21.2v9.4H8.1v-9.4H12.8z M19.9,11.7v18.9h-4.7V11.7H19.9z M38.8,32.9v2.4H1V7h2.4v25.9H38.8z M27,16.4 v14.2h-4.7V16.4H27z M28.7,10.7c0-0.2,0.1-0.4,0.2-0.5l1-1c0.1-0.1,0.3-0.2,0.5-0.2S30.9,9,31,9.1l3.6,3.6l3.6-3.6 c0.1-0.1,0.3-0.2,0.5-0.2c0.2,0,0.4,0.1,0.5,0.2l1,1c0.1,0.1,0.2,0.3,0.2,0.5c0,0.2-0.1,0.4-0.2,0.5l-3.6,3.6l3.6,3.6 c0.1,0.1,0.2,0.3,0.2,0.5s-0.1,0.4-0.2,0.5l-1,1c-0.1,0.1-0.3,0.2-0.5,0.2c-0.2,0-0.4-0.1-0.5-0.2l-3.6-3.6L31,20.4 c-0.1,0.1-0.3,0.2-0.5,0.2s-0.4-0.1-0.5-0.2l-1-1c-0.1-0.1-0.2-0.3-0.2-0.5s0.1-0.4,0.2-0.5l3.6-3.6L29,11.2 C28.8,11,28.7,10.8,28.7,10.7z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 175:
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(1387);
__webpack_require__(1388);
__webpack_require__(1389);
__webpack_require__(1390);
__webpack_require__(1391);
__webpack_require__(1392);
__webpack_require__(1393);
__webpack_require__(1394);
__webpack_require__(1395);
__webpack_require__(1396);
__webpack_require__(1397);
__webpack_require__(1398);
__webpack_require__(1399);
__webpack_require__(1400);
__webpack_require__(1401);
__webpack_require__(1402);
__webpack_require__(1408);


/***/ }),

/***/ 18:
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),

/***/ 189:
/***/ (function(module, exports) {

module.exports = function escape(url) {
    if (typeof url !== 'string') {
        return url
    }
    // If url is already wrapped in quotes, remove them
    if (/^['"].*['"]$/.test(url)) {
        url = url.slice(1, -1);
    }
    // Should url be wrapped?
    // See https://drafts.csswg.org/css-values-3/#urls
    if (/["'() \t\n]/.test(url)) {
        return '"' + url.replace(/"/g, '\\"').replace(/\n/g, '\\n') + '"'
    }

    return url
}


/***/ }),

/***/ 19:
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getElement = (function (fn) {
	var memo = {};

	return function(selector) {
		if (typeof memo[selector] === "undefined") {
			var styleTarget = fn.call(this, selector);
			// Special case to return head of iframe instead of iframe itself
			if (styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[selector] = styleTarget;
		}
		return memo[selector]
	};
})(function (target) {
	return document.querySelector(target)
});

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(75);

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
	if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertInto + " " + options.insertAt.before);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	options.attrs.type = "text/css";

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	options.attrs.type = "text/css";
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = options.transform(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),

/***/ 359:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M30.6,38c1.3,0,2.4-0.5,3.3-1.6s1.4-2.3,1.4-3.8c0-3.5-0.6-6.3-1.7-8.3s-2.8-3.1-5-3.2c-2.1,1.9-4.6,2.8-7.4,2.8 s-5.3-0.9-7.4-2.8c-2.2,0.1-3.8,1.2-5,3.2S7,29,7,32.5c0,1.5,0.5,2.8,1.4,3.8s2,1.6,3.3,1.6H30.6z'/%3E %3Cpath d='M30.3,10.6c0,0.2-0.1,0.3-0.3,0.5l-3.9,3.8l0.9,5.3c0,0,0,0.1,0,0.2c0,0.1,0,0.3-0.1,0.4s-0.2,0.2-0.3,0.2 c-0.1,0-0.3,0-0.4-0.1l-4.8-2.5l-4.8,2.5c-0.2,0.1-0.3,0.1-0.4,0.1c-0.1,0-0.3-0.1-0.3-0.2c-0.1-0.1-0.1-0.2-0.1-0.4 c0,0,0-0.1,0-0.2l0.9-5.3l-3.9-3.8c-0.2-0.2-0.3-0.4-0.3-0.5c0-0.3,0.2-0.4,0.6-0.5l5.3-0.8l2.4-4.8C21,4.1,21.2,4,21.4,4 c0.2,0,0.4,0.1,0.5,0.4l2.4,4.8l5.3,0.8C30.1,10.1,30.3,10.3,30.3,10.6z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 75:
/***/ (function(module, exports) {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ })

}]);