(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[6],{

/***/ 1373:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2016 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.CoreData');
/**
 * core data grid/edit dialog manager
 *
 *  @singleton
 */

Tine.CoreData.Manager = function () {
  var grids = {},
      editDialogs = {},
      toolbars = {};
  return {
    /**
     * create grid for given core data id
     *
     * @param configRecord
     * @param options
     * @returns Ext.form.Field|null
     */
    getGrid: function getGrid(id, options) {
      var constr = null;

      if (grids.hasOwnProperty(id)) {
        constr = grids[id].constr;

        if (!options) {
          options = grids[id].options;
        }
      } else {
        Tine.log.warn('Id not registered in CoreData manager: ' + id);
      }

      return Ext.isFunction(constr) ? new constr(options) : null;
    },

    /**
     * create grid for given core data id
     *
     * @param configRecord
     * @param options
     * @returns Ext.form.Field|null
     */
    getEditDialog: function getEditDialog(id, options) {
      var constr = null;

      if (editDialogs.hasOwnProperty(id)) {
        constr = editDialogs[type];
      }

      return Ext.isFunction(constr) ? new constr(options) : null;
    },

    /**
     * create grid for given core data id
     *
     * @param configRecord
     * @param options
     * @returns Ext.form.Field|null
     *
     * TODO is this needed?
     */
    getToolbar: function getToolbar(id, options) {
      var constr = null;

      if (toolbars.hasOwnProperty(id)) {
        constr = toolbars[type];

        if (!options) {
          options = toolbars[id].options;
        }
      } else {
        Tine.log.warn('Id not registered in CoreData manager: ' + id);
      }

      return Ext.isFunction(constr) ? new constr(options) : null;
    },

    /**
     * register grid for given core data
     *
     *  @static
     *  @param id string
     *  @param constructor Function
     *  @param options
     */
    registerGrid: function registerGrid(id, constructor, options) {
      grids[id] = {
        constr: constructor,
        options: options
      };
    },

    /**
     * register toolbar for given core data
     *
     *  @static
     *  @param id string
     *  @param constructor Function
     *  @param options
     *
     *  TODO is this needed?
     */
    registerToolbar: function registerToolbar(id, constructor, options) {
      toolbars[id] = {
        constr: constructor,
        options: options
      };
    },

    /**
     * register edit dialog for given core data
     *
     *  @static
     *  @param id string
     *  @param constructor Function
     */
    registerEditDialog: function registerEditDialog(id, constructor) {
      editDialogs[id] = constructor;
    },

    /**
     * is id registered in area
     *
     * @param area
     * @param id
     * @return {*|boolean}
     */
    isRegistered: function isRegistered(area, id) {
      var map = {
        grid: grids,
        toolbars: toolbars,
        editDialogs: editDialogs
      };
      return map[area] && map[area].hasOwnProperty(id);
    }
  };
}();

/***/ }),

/***/ 1374:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 *
 * @package     CoreData
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2016 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine', 'Tine.CoreData');
/**
 * @namespace   Tine.CoreData
 * @class       Tine.CoreData.TreePanel
 * @extends     Tine.Tinebase.Application
 * CoreData TreePanel<br>
 *
 * @author      Philipp Schüle <p.schuele@metaways.de>
 *
 * TODO allow to customize tree layout (remove parent nodes (/general, /applications, maybe even the application nodes)
 */

Tine.CoreData.TreePanel = function (config) {
  Ext.apply(this, config);
  this.id = 'TreePanel';
  Tine.CoreData.TreePanel.superclass.constructor.call(this);
};

Ext.extend(Tine.CoreData.TreePanel, Ext.tree.TreePanel, {
  autoScroll: true,
  border: false,

  /**
   * init this treePanel
   */
  initComponent: function initComponent() {
    if (!this.app) {
      this.app = Tine.Tinebase.appMgr.get('CoreData');
    }

    var generalChildren = this.getCoreDataNodes('/general'),
        applicationChildren = this.getCoreDataNodes('/applications');
    this.root = {
      path: '/',
      cls: 'tinebase-tree-hide-collapsetool',
      text: this.app.i18n._('Core Data'),
      expanded: true,
      children: [{
        path: '/general',
        id: 'general',
        expanded: true,
        text: this.app.i18n._('General Data'),
        hidden: generalChildren.length == 0,
        children: generalChildren
      }, {
        path: '/applications',
        id: 'applications',
        expanded: true,
        text: this.app.i18n._('Application Data'),
        children: applicationChildren
      }]
    };
    this.on('click', this.onClick, this);
    Tine.CoreData.TreePanel.superclass.initComponent.call(this);
  },

  /**
   * get core data nodes
   *
   * @param path
   * @returns Array
   */
  getCoreDataNodes: function getCoreDataNodes(path) {
    if (!Tine.CoreData.registry.get('coreData')) {
      return [];
    }

    var applicationNodes = [],
        coreDataNodes = {}; // applications => [core data nodes]

    Ext.each(Tine.CoreData.registry.get('coreData')['results'], function (coreData) {
      if (path === '/applications' && coreData.application_id.name !== 'Tinebase' || path === '/general' && coreData.application_id.name === 'Tinebase') {
        var coreDataApp = Tine.Tinebase.appMgr.get(coreData.application_id.name);

        if (!coreDataNodes[coreData.application_id.name]) {
          coreDataNodes[coreData.application_id.name] = [];
          applicationNodes.push({
            path: path + '/' + coreData.application_id.id,
            id: coreData.application_id.id,
            text: coreDataApp.i18n._(coreData.application_id.name),
            attributes: coreData.application_id,
            singleClickExpand: true
          });
        }

        coreDataNodes[coreData.application_id.name].push({
          path: path + '/' + coreData.application_id.id + '/' + coreData.id,
          id: coreData.id,
          text: coreDataApp.i18n._(coreData.label),
          leaf: true,
          attributes: coreData
        });
      }
    }, this);

    if (path === '/general') {
      return coreDataNodes['Tinebase'] ? coreDataNodes['Tinebase'] : [];
    } else {
      Ext.each(applicationNodes, function (node) {
        node.children = coreDataNodes[node.attributes.name];
      });
      return applicationNodes;
    }
  },

  /**
   * on node click
   *
   * @param {} node
   * @param {} e
   */
  onClick: function onClick(node, e) {
    // switch content type and set north + center panels
    if (node.attributes.attributes && node.attributes.attributes.id && node.leaf) {
      Tine.log.debug('Tine.CoreData.TreePanel::onClick');
      Tine.log.debug(node);
      var mainscreen = this.app.getMainScreen(),
          coreData = node.attributes.attributes; // autoregister grid

      if (!Tine.CoreData.Manager.isRegistered('grid', coreData.id)) {
        var recordClass = Tine.Tinebase.data.RecordMgr.get(coreData.model),
            appName = recordClass ? recordClass.getMeta('appName') : null,
            modelName = recordClass ? recordClass.getMeta('modelName') : null;

        if (appName && modelName && Tine[appName] && Tine[appName][modelName + 'GridPanel']) {
          Tine.CoreData.Manager.registerGrid(coreData.id, Tine[appName][modelName + 'GridPanel']);
        }
      }

      mainscreen.setActiveContentType(node.attributes.attributes.id);
      mainscreen.getCenterPanel().getStore().reload();
    } else {
      return false;
    }
  }
});

/***/ }),

/***/ 1375:
/***/ (function(module, exports) {

/* 
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 216 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.CoreData');
/**
 * CoreData west panel
 * 
 * @namespace   Tine.CoreData
 * @class       Tine.CoreData.WestPanel
 * @extends     Tine.widgets.mainscreen.WestPanel
 * 
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * 
 * @constructor
 * @xtype       tine.calendar.mainscreenwestpanel
 */

Tine.CoreData.WestPanel = Ext.extend(Tine.widgets.mainscreen.WestPanel, {
  hasFavoritesPanel: false,
  getAdditionalItems: function getAdditionalItems() {
    return [new Tine.CoreData.TreePanel({
      height: 'auto'
    })];
  }
});

/***/ }),

/***/ 1376:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     CoreData
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2007-2016 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine', 'Tine.CoreData');
/**
 * @namespace   Tine.CoreData
 * @class       Tine.CoreData.Application
 * @extends     Tine.Tinebase.Application
 * CoreData Application Object <br>
 * 
 * @author      Philipp Schüle <p.schuele@metaways.de>
 */

Tine.CoreData.Application = Ext.extend(Tine.Tinebase.Application, {}); // default mainscreen

Tine.CoreData.MainScreen = Ext.extend(Tine.widgets.MainScreen, {
  /**
   * returns canonical path part
   * @returns {string}
   */
  getCanonicalPathSegment: function getCanonicalPathSegment() {
    var app = this.getCenterPanel().app,
        appName = app ? app.name : 'unknown';
    return [this.supr().getCanonicalPathSegment.call(this), appName].join(Tine.Tinebase.CanonicalPath.separator);
  },

  /**
   * get north panel for given contentType
   *
   * template method to be overridden by subclasses to modify default behaviour
   *
   * @param {String} contentType
   * @return {Ext.Panel}
   */
  getNorthPanel: function getNorthPanel(contentType) {
    contentType = contentType || this.getActiveContentType();

    if (!this[contentType + 'ActionToolbar']) {
      if (contentType === '') {
        // return empty toolbar
        this[contentType + 'ActionToolbar'] = new Ext.Toolbar({
          items: []
        });
      } else {
        this[contentType + 'ActionToolbar'] = Ext.isFunction(this[contentType + this.centerPanelClassNameSuffix].getActionToolbar) ? this[contentType + this.centerPanelClassNameSuffix].getActionToolbar() : Tine.CoreData.Manager.getToolbar(contentType);
      }
    }

    return this[contentType + 'ActionToolbar'];
  },

  /**
   * get center panel for given contentType / core data
   *
   * template method to be overridden by subclasses to modify default behaviour
   *
   * @param {String} contentType
   * @return {Ext.Panel}
   */
  getCenterPanel: function getCenterPanel(contentType) {
    contentType = contentType || this.getActiveContentType();

    if (!this[contentType + this.centerPanelClassNameSuffix]) {
      if (contentType === '') {
        // show some information text or remove this as mainscreen is responsibilty of core data models/apps
        this[contentType + this.centerPanelClassNameSuffix] = new Ext.Panel({
          // TODO improve wording/styling
          html: this.app.i18n._('Please select core data from tree ...')
        });
      } else {
        // try to find grid in Core Data Manager
        this[contentType + this.centerPanelClassNameSuffix] = Tine.CoreData.Manager.getGrid(contentType);
      }
    }

    return this[contentType + this.centerPanelClassNameSuffix];
  },

  /**
   * get west panel for given contentType
   *
   * template method to be overridden by subclasses to modify default behaviour
   *
   * @return {Ext.Panel}
   *
   * overwrites parent to remove active content type here
   *
   * TODO remove code duplication
   */
  getWestPanel: function getWestPanel() {
    var wpName = 'WestPanel';

    if (!this[wpName]) {
      var wpconfig = {
        app: this.app,
        //contentTypes: this.contentTypes,
        //contentType: contentType,
        listeners: {
          scope: this,
          selectionchange: function selectionchange() {
            var cp = this.getCenterPanel();

            if (cp) {
              try {
                var grid = cp.getGrid();

                if (grid) {
                  var sm = grid.getSelectionModel();

                  if (sm) {
                    sm.clearSelections();
                    cp.actionUpdater.updateActions(sm);
                  }
                }
              } catch (e) {// do nothing - no grid
              }
            }
          }
        }
      };

      try {
        if (Tine[this.app.name].hasOwnProperty(wpName)) this[wpName] = new Tine[this.app.appName][wpName](wpconfig);else this[wpName] = new Tine.widgets.mainscreen.WestPanel(wpconfig);
      } catch (e) {
        Tine.log.error('Could not create westPanel');
        Tine.log.error(e.stack ? e.stack : e);
        this[wpName] = new Ext.Panel({
          html: 'ERROR'
        });
      }
    }

    return this[wpName];
  }
});

/***/ }),

/***/ 1377:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(1378);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(19)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 1378:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(189);
exports = module.exports = __webpack_require__(18)(false);
// imports


// module
exports.push([module.i, "/**\n * Tine 2.0\n * \n * @package     CoreData\n * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3\n * @author      Philipp Schüle <p.schuele@metaways.de>\n * @copyright   Copyright (c) 2016 Metaways Infosystems GmbH (http://www.metaways.de)\n *\n */\n \n.CoreDataIconCls {\n    background-image:url(" + escape(__webpack_require__(354)) + ") !important;\n}\n", ""]);

// exports


/***/ }),

/***/ 173:
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(1373);
__webpack_require__(1374);
__webpack_require__(1375);
__webpack_require__(1376);
__webpack_require__(1377);


/***/ }),

/***/ 18:
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),

/***/ 189:
/***/ (function(module, exports) {

module.exports = function escape(url) {
    if (typeof url !== 'string') {
        return url
    }
    // If url is already wrapped in quotes, remove them
    if (/^['"].*['"]$/.test(url)) {
        url = url.slice(1, -1);
    }
    // Should url be wrapped?
    // See https://drafts.csswg.org/css-values-3/#urls
    if (/["'() \t\n]/.test(url)) {
        return '"' + url.replace(/"/g, '\\"').replace(/\n/g, '\\n') + '"'
    }

    return url
}


/***/ }),

/***/ 19:
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getElement = (function (fn) {
	var memo = {};

	return function(selector) {
		if (typeof memo[selector] === "undefined") {
			var styleTarget = fn.call(this, selector);
			// Special case to return head of iframe instead of iframe itself
			if (styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[selector] = styleTarget;
		}
		return memo[selector]
	};
})(function (target) {
	return document.querySelector(target)
});

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(75);

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
	if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertInto + " " + options.insertAt.before);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	options.attrs.type = "text/css";

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	options.attrs.type = "text/css";
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = options.transform(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),

/***/ 354:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M21.6,34.3c3,0,5.3-0.2,8.4-1c2.8-0.7,4.8-1.6,6.2-3.2v3.1c0,0.9-0.7,1.7-2,2.4s-3.1,1.3-5.3,1.8S24.2,38,21.6,38 s-5.1-0.2-7.3-0.7s-4-1-5.3-1.8S7,34,7,33.1v-3.3c0.7,1.2,2.3,2.4,6,3.5C15.7,34,18.6,34.3,21.6,34.3z M21.6,4 c2.6,0,5.1,0.2,7.3,0.7c2.2,0.4,4,1,5.3,1.8s2,1.6,2,2.4v2.4c0,0.9-0.7,1.7-2,2.4c-1.3,0.7-3.1,1.3-5.3,1.8s-4.7,0.7-7.3,0.7 s-5.1-0.2-7.3-0.7s-4-1-5.3-1.8c-1.3-0.7-2-1.6-2-2.4V8.9C7,8,7.7,7.2,9,6.4s3.1-1.3,5.3-1.8C16.5,4.2,18.9,4,21.6,4z M21.6,27 c3,0,5.3-0.2,8.4-1c2.8-0.7,4.8-1.6,6.2-3.2v3.1c0,0.9-0.7,1.7-2,2.4s-3.1,1.3-5.3,1.8c-2.2,0.4-4.7,0.7-7.3,0.7s-5.1-0.2-7.3-0.7 c-2.2-0.4-4-1-5.3-1.8s-2-1.6-2-2.4v-3.3c0.7,1.2,2.3,2.4,6,3.5C15.7,26.7,18.6,27,21.6,27z M21.6,19.6c3,0,5.3-0.2,8.4-1 c2.8-0.7,4.8-1.6,6.2-3.2v3.1c0,0.9-0.7,1.7-2,2.4s-3.1,1.3-5.3,1.8c-2.2,0.4-4.7,0.7-7.3,0.7s-5.1-0.2-7.3-0.7 c-2.2-0.4-4-1-5.3-1.8s-2-1.6-2-2.4v-3.3c0.7,1.2,2.3,2.4,6,3.5C15.7,19.3,18.6,19.6,21.6,19.6z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 75:
/***/ (function(module, exports) {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ })

}]);