(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[1],{

/***/ 1176:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @copyright   Copyright (c) 2010-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 */
Ext.ns('Tine.ActiveSync');
/**
 * @namespace   Tine.ActiveSync
 * @class       Tine.ActiveSync.Application
 * @extends     Tine.Tinebase.Application
 * 
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 */

Tine.ActiveSync.Application = Ext.extend(Tine.Tinebase.Application, {
  hasMainScreen: false,

  /**
   * Get translated application title of the calendar application
   * 
   * @return {String}
   */
  getTitle: function getTitle() {
    return this.i18n.gettext('Active Sync');
  },

  /**
   * returns additional items for persistent filter context menu
   * 
   * @todo rework this to be event/hook 
   * 
   * @param {Tine.widgets.persistentfilter.PickerPanel} picker
   * @param {Tine.widgets.persistentfilter.model.PersistentFilter} filter
   */
  getPersistentFilterPickerCtxItems: function getPersistentFilterPickerCtxItems(picker, filter) {
    var items = [];

    if (picker.app.appName.match(/Addressbook|Calendar|Email|Tasks/)) {
      var devices = Tine.ActiveSync.getDeviceStore();
      var menuItems = ['<b class="x-menu-title">' + this.i18n._('Select a Device') + '</b>'];
      devices.each(function (device) {
        var contentClass = Tine.ActiveSync.Model.getContentClass(picker.app.appName);
        menuItems.push({
          text: Ext.util.Format.htmlEncode(device.getTitle()),
          checked: device.get([Ext.util.Format.lowercase(contentClass) + 'filter_id']) === filter.id,
          //iconCls: 'activesync-device-standard',
          handler: this.setDeviceContentFilter.createDelegate(this, [device, contentClass, filter], true)
        });
      }, this);

      if (!devices.getCount()) {
        menuItems.push({
          text: this.i18n._('No ActiveSync Device registered'),
          disabled: true,
          checked: false,
          handler: Ext.emptyFn
        });
      }

      items.push({
        text: String.format(this.i18n._('Set as {0} Filter'), this.getTitle()),
        iconCls: this.getIconCls(),
        menu: menuItems
      });
    }

    return items;
  },

  /**
   * persistently set filter for device
   * 
   * @param {Ext.Action} btn
   * @param {Ext.EventObject} e
   * @param {Tine.ActiveSync.Model.Device} device
   * @param {} contentClass
   * @param {Tine.widgets.persistentfilter.model.PersistentFilter} filter
   */
  setDeviceContentFilter: function setDeviceContentFilter(btn, e, device, contentClass, filter) {
    if (btn.checked) {
      // if btn was checked, we need to reset filter
      Tine.ActiveSync.setDeviceContentFilter(device.id, contentClass, null, function (response) {
        device.set([Ext.util.Format.lowercase(contentClass) + 'filter_id'], null);
        Ext.Msg.alert(this.i18n._('Resetted Sync Filter'), String.format(this.i18n._('{0} filter for device "{1}" is now "{2}"'), this.getTitle(), Ext.util.Format.htmlEncode(device.getTitle()), this.i18n._('resetted')));
      }, this);
    } else {
      Tine.ActiveSync.setDeviceContentFilter(device.id, contentClass, filter.id, function (response) {
        device.set([Ext.util.Format.lowercase(contentClass) + 'filter_id'], filter.id);
        Ext.Msg.alert(this.i18n._('Set Sync Filter'), String.format(this.i18n._('{0} filter for device "{1}" is now "{2}"'), this.getTitle(), Ext.util.Format.htmlEncode(device.getTitle()), Ext.util.Format.htmlEncode(filter.get('name'))));
      }, this);
    }
  }
});

/***/ }),

/***/ 1177:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @copyright   Copyright (c) 2010-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 */
Ext.ns('Tine.ActiveSync.Model');
/**
 * @namespace   Tine.ActiveSync.Model
 * @class       Tine.ActiveSync.Model.Device
 * @extends     Tine.Tinebase.data.Record
 * 
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * Device record definition
 */

Tine.ActiveSync.Model.Device = Tine.Tinebase.data.Record.create(Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'deviceid'
}, {
  name: 'devicetype'
}, {
  name: 'policykey'
}, {
  name: 'owner_id'
}, {
  name: 'acsversion'
}, {
  name: 'useragent'
}, {
  name: 'policy_id'
}, {
  name: 'pinglifetime',
  type: 'number'
}, {
  name: 'remotewipe',
  type: 'number'
}, {
  name: 'pingfolder'
}, {
  name: 'model'
}, {
  name: 'imei'
}, {
  name: 'friendlyname'
}, {
  name: 'os'
}, {
  name: 'oslanguage'
}, {
  name: 'phonenumber'
}]), {
  appName: 'ActiveSync',
  modelName: 'Device',
  idProperty: 'id',
  titleProperty: 'friendlyname',
  // ngettext('Device', 'Devices', n); gettext('Devices');
  recordName: 'Device',
  recordsName: 'Devices',

  /**
   * returns title of this record
   * 
   * @return {String}
   */
  getTitle: function getTitle() {
    return this.get('friendlyname') || this.get('useragent');
  }
});
/**
 * @namespace   Tine.ActiveSync.Model
 * @class       Tine.ActiveSync.Model.Device
 * @extends     Tine.Tinebase.data.Record
 * 
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * 
 * get content type of app
 * 
 * @static
 * @param {String} appName
 * @return {String}
 */

Tine.ActiveSync.Model.getContentClass = function (appName) {
  switch (appName) {
    case 'Calendar':
      return 'Calendar';

    case 'Addressbook':
      return 'Contacts';

    case 'Felamimail':
      return 'Email';

    case 'Tasks':
      return 'Tasks';

    default:
      throw new Ext.Error('no contentClass for this app');
  }
};
/**
 * @namespace   Tine.ActiveSync.Model
 * @class       Tine.ActiveSync.Model.DeviceJsonBackend
 * @extends     Tine.Tinebase.data.RecordProxy
 * 
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * JSON backend for devices
 */


Tine.ActiveSync.Model.DeviceJsonBackend = Ext.extend(Tine.Tinebase.data.RecordProxy, {
  /**
   * Creates a recuring event exception
   * 
   * @param {Tine.Calendar.Model.Event} event
   * @param {Boolean} deleteInstance
   * @param {Boolean} deleteAllFollowing
   * @param {Object} options
   * @return {String} transaction id
   */
  setDeviceContentFilter: function setDeviceContentFilter(device, contentClass, filterId) {
    options = options || {};
    options.params = options.params || {};

    options.beforeSuccess = function (response) {
      return [this.recordReader(response)];
    };

    var p = options.params;
    p.method = this.appName + '.setDeviceContentFilter';
    p.deviceId = event.data;
    p.contentClass = contentClass;
    p.filterId = filterId;
    return this.doXHTTPRequest(options);
  }
});

/***/ }),

/***/ 1178:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @copyright   Copyright (c) 2010-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 */
Ext.ns('Tine.ActiveSync');
/**
 * @namespace   Tine.ActiveSync
 * @class       Tine.ActiveSync.DeviceStore
 * @extends     Ext.data.ArrayStore
 * 
 * <p>Store for Device Records</p>
 * 
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.ActiveSync.DeviceStore
 */

Tine.ActiveSync.DeviceStore = Ext.extend(Ext.data.ArrayStore, {});
/**
 * @namespace   Tine.ActiveSync
 * 
 * get store of all device records
 * 
 * @static
 * @sigleton
 * @return {DeviceStore}
 */

Tine.ActiveSync.getDeviceStore = function () {
  if (!Tine.ActiveSync.deviceStore) {
    // create store
    Tine.ActiveSync.deviceStore = new Tine.ActiveSync.DeviceStore({
      fields: Tine.ActiveSync.Model.Device.getFieldDefinitions(),
      sortInfo: {
        field: 'friendlyname',
        direction: 'ASC'
      }
    });
    var app = Tine.Tinebase.appMgr.get('ActiveSync'),
        registry = app ? app.getRegistry() : null;
    recordsData = registry ? registry.get('userDevices') : []; // populate store

    Ext.each(recordsData, function (data) {
      var r = new Tine.ActiveSync.Model.Device(data);
      Tine.ActiveSync.deviceStore.addSorted(r);
    }, this);
  }

  return Tine.ActiveSync.deviceStore;
};

/***/ }),

/***/ 1179:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Lars Kneschke <l.kneschke@metaways.de>
 * @copyright   Copyright (c) 2014-2015 Metaways Infosystems GmbH (http://www.metaways.de)
 */

/*global Ext, Tine*/
Ext.ns('Tine.ActiveSync.syncdevices');
/**
 * SyncDevices 'mainScreen'
 * 
 * @static
 */

Tine.ActiveSync.syncdevices.show = function () {
  var app = Tine.Tinebase.appMgr.get('ActiveSync');

  if (!Tine.ActiveSync.syncDevicesGridPanel) {
    Tine.ActiveSync.syncDevicesGridPanel = new Tine.ActiveSync.SyncDevicesGridPanel({
      app: app,
      asAdminModule: true
    });
  } else {
    Tine.ActiveSync.syncDevicesGridPanel.loadGridData.defer(100, Tine.ActiveSync.syncDevicesGridPanel, []);
  }

  Tine.Tinebase.MainScreen.setActiveContentPanel(Tine.ActiveSync.syncDevicesGridPanel, true);
  Tine.Tinebase.MainScreen.setActiveToolbar(Tine.ActiveSync.syncDevicesGridPanel.actionToolbar, true);
};
/************** models *****************/


Ext.ns('Tine.ActiveSync.Model');
/**
 * Model of an account
 */

Tine.ActiveSync.Model.SyncDeviceArray = [{
  name: 'id'
}, {
  name: 'deviceid'
}, {
  name: 'devicetype'
}, {
  name: 'owner_id'
}, {
  name: 'policy_id'
}, //{ name: 'policykey' },
{
  name: 'acsversion'
}, {
  name: 'useragent'
}, {
  name: 'model'
}, {
  name: 'imei'
}, {
  name: 'friendlyname'
}, {
  name: 'os'
}, {
  name: 'oslanguage'
}, {
  name: 'phonenumber'
}, {
  name: 'pinglifetime'
}, {
  name: 'pingfolder'
}, {
  name: 'remotewipe'
}, {
  name: 'monitor_lastping'
}, {
  name: 'calendarfilter_id'
}, {
  name: 'contactsfilter_id'
}, {
  name: 'emailfilter_id'
}, {
  name: 'tasksfilter_id'
}, {
  name: 'lastping',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long
}];
Tine.ActiveSync.Model.SyncDevice = Tine.Tinebase.data.Record.create(Tine.ActiveSync.Model.SyncDeviceArray, {
  appName: 'ActiveSync',
  modelName: 'SyncDevice',
  idProperty: 'id',
  //titleProperty: 'name',
  titleProperty: 'deviceid',
  // ngettext('SyncDevice', 'SyncDevices', n);
  recordName: 'SyncDevice',
  recordsName: 'SyncDevices'
});
/**
 * returns default account data
 * 
 * @namespace Tine.ActiveSync.Model.SyncDevice
 * @static
 * @return {Object} default data
 */

Tine.ActiveSync.Model.SyncDevice.getDefaultData = function () {
  return {};
};
/************** backend *****************/


Tine.ActiveSync.syncdevicesBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'ActiveSync',
  modelName: 'SyncDevice',
  recordClass: Tine.ActiveSync.Model.SyncDevice,
  idProperty: 'id'
});

/***/ }),

/***/ 1180:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Lars Kneschke <l.kneschke@metaways.de>
 * @copyright   Copyright (c) 2014-2015 Metaways Infosystems GmbH (http://www.metaways.de)
 */

/*global Ext, Tine*/
Ext.ns('Tine.ActiveSync.syncdevices');
/**
 * @namespace   Tine.ActiveSync.syncdevices
 * @class       Tine.ActiveSync.SyncDeviceEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>Sync devices edit dialog</p>
 * <p>
 * </p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Lars Kneschke <l.kneschke@metaways.de>
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Admin.SyncDeviceEditDialog
 */

Tine.ActiveSync.SyncDeviceEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowNamePrefix: 'syncdeviceEditWindow_',
  appName: 'ActiveSync',
  recordClass: Tine.ActiveSync.Model.SyncDevice,
  recordProxy: Tine.ActiveSync.syncdevicesBackend,
  evalGrants: false,

  /**
   * executed after record got updated from proxy
   */
  onRecordLoad: function onRecordLoad() {
    Tine.ActiveSync.SyncDeviceEditDialog.superclass.onRecordLoad.apply(this, arguments);
  },

  /**
   * executed when record gets updated from form
   */
  onRecordUpdate: function onRecordUpdate() {
    Tine.ActiveSync.SyncDeviceEditDialog.superclass.onRecordUpdate.apply(this, arguments);
  },

  /**
   * returns dialog
   */
  getFormItems: function getFormItems() {
    return {
      layout: 'vbox',
      layoutConfig: {
        align: 'stretch',
        pack: 'start'
      },
      border: false,
      items: [{
        xtype: 'columnform',
        border: false,
        autoHeight: true,
        items: [[{
          columnWidth: 0.33,
          fieldLabel: this.app.i18n._('Device ID'),
          name: 'deviceid',
          allowBlank: false,
          readOnly: true,
          maxLength: 40
        }, {
          columnWidth: 0.33,
          fieldLabel: this.app.i18n._('Devicetype'),
          name: 'devicetype',
          allowBlank: false,
          readOnly: true,
          maxLength: 40
        }, {
          columnWidth: 0.333,
          fieldLabel: this.app.i18n._('Owner'),
          name: 'owner_id',
          allowBlank: false,
          xtype: 'addressbookcontactpicker',
          userOnly: true,
          useAccountRecord: true,
          blurOnSelect: true,
          selectOnFocus: true,
          readOnly: true,
          maxLength: 40
        }], [{
          columnWidth: 0.33,
          fieldLabel: this.app.i18n._('Policy'),
          name: 'policy_id',
          readOnly: true,
          maxLength: 40
        }, {
          columnWidth: 0.33,
          fieldLabel: this.app.i18n._('AS Version'),
          name: 'acsversion',
          readOnly: true,
          maxLength: 40
        }, {
          columnWidth: 0.333,
          fieldLabel: this.app.i18n._('Useragent'),
          name: 'useragent',
          readOnly: true,
          maxLength: 40
        }], [{
          columnWidth: 0.33,
          fieldLabel: this.app.i18n._('Model'),
          name: 'model',
          readOnly: true,
          maxLength: 40
        }, {
          columnWidth: 0.33,
          fieldLabel: this.app.i18n._('IMEI'),
          name: 'imei',
          readOnly: true,
          maxLength: 40
        }, {
          columnWidth: 0.333,
          fieldLabel: this.app.i18n._('Friendly Name'),
          name: 'friendlyname',
          readOnly: true,
          maxLength: 40
        }], [{
          columnWidth: 0.33,
          fieldLabel: this.app.i18n._('OS'),
          name: 'os',
          readOnly: true,
          maxLength: 40
        }, {
          columnWidth: 0.33,
          fieldLabel: this.app.i18n._('OS Language'),
          name: 'oslanguage',
          readOnly: true,
          maxLength: 40
        }, {
          columnWidth: 0.333,
          fieldLabel: this.app.i18n._('Phonenumber'),
          name: 'phonenumber',
          readOnly: true,
          maxLength: 40
        }]]
      }]
    };
  }
});
/**
 * Container Edit Popup
 * 
 * @param   {Object} config
 * @return  {Ext.ux.Window}
 */

Tine.ActiveSync.SyncDeviceEditDialog.openWindow = function (config) {
  var window = Tine.WindowFactory.getWindow({
    width: 600,
    height: 400,
    name: Tine.ActiveSync.SyncDeviceEditDialog.prototype.windowNamePrefix + Ext.id(),
    contentPanelConstructor: 'Tine.ActiveSync.SyncDeviceEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 1181:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     ActiveSync
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Stefanie Stamer <s.stamer@metaways.de>
 * @copyright   Copyright (c) 2015-2017 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.ActiveSync');
/**
 * @namespace Tine.ActiveSync
 * @class     Tine.ActiveSync.SyncDevicesGridPanel
 * @extends   Tine.widgets.grid.GridPanel
 * SyncDevicess Grid Panel <br>
 * 
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 */

Tine.ActiveSync.SyncDevicesGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  /**
   * @cfg
   */
  recordClass: Tine.ActiveSync.Model.SyncDevice,
  recordProxy: Tine.ActiveSync.syncdevicesBackend,
  defaultSortInfo: {
    field: 'deviceid',
    direction: 'ASC'
  },
  evalGrants: false,
  gridConfig: {
    autoExpandColumn: 'deviceid'
  },
  addButton: false,
  asAdminModule: false,

  /**
   * initComponent
   */
  initComponent: function initComponent() {
    this.app = Tine.Tinebase.appMgr.get('ActiveSync');
    this.gridConfig.cm = this.getColumnModel();
    this.contextMenuItems = this.getAdditionalCtxItems();
    Tine.ActiveSync.SyncDevicesGridPanel.superclass.initComponent.call(this);
  },

  /**
   * returns column model
   * 
   * @return Ext.grid.ColumnModel
   * @private
   */
  getColumnModel: function getColumnModel() {
    return new Ext.grid.ColumnModel({
      defaults: {
        sortable: true,
        hidden: true,
        resizable: true
      },
      columns: this.getColumns()
    });
  },

  /**
   * returns columns
   * @private
   * @return Array
   */
  getColumns: function getColumns() {
    return [{
      header: this.app.i18n._('ID'),
      id: 'id',
      dataIndex: 'id',
      hidden: true,
      width: 50
    }, {
      header: this.app.i18n._('Device ID'),
      id: 'deviceid',
      dataIndex: 'deviceid',
      hidden: false,
      width: 200
    }, {
      header: this.app.i18n._('Devicetype'),
      id: 'devicetype',
      dataIndex: 'devicetype',
      hidden: false,
      width: 100
    }, {
      header: this.app.i18n._('Owner'),
      id: 'owner_id',
      dataIndex: 'owner_id',
      hidden: false,
      width: 80,
      renderer: Tine.Tinebase.common.usernameRenderer
    }, {
      header: this.app.i18n._('Policy'),
      id: 'policy_id',
      dataIndex: 'policy_id',
      hidden: false,
      width: 200
    }, {
      header: this.app.i18n._('AS Version'),
      id: 'acsversion',
      dataIndex: 'acsversion',
      hidden: false,
      width: 100
    }, {
      header: this.app.i18n._('Useragent'),
      id: 'useragent',
      dataIndex: 'useragent',
      hidden: true,
      width: 200
    }, {
      header: this.app.i18n._('Model'),
      id: 'model',
      dataIndex: 'model',
      hidden: false,
      width: 200
    }, {
      header: this.app.i18n._('IMEI'),
      id: 'imei',
      dataIndex: 'imei',
      hidden: true,
      width: 200
    }, {
      header: this.app.i18n._('Friendly Name'),
      id: 'friendlyname',
      dataIndex: 'friendlyname',
      hidden: false,
      width: 200
    }, {
      header: this.app.i18n._('OS'),
      id: 'os',
      dataIndex: 'os',
      hidden: false,
      width: 200
    }, {
      header: this.app.i18n._('OS Language'),
      id: 'oslanguage',
      dataIndex: 'oslanguage',
      hidden: true,
      width: 200
    }, {
      header: this.app.i18n._('Phonenumber'),
      id: 'phonenumber',
      dataIndex: 'phonenumber',
      hidden: false,
      width: 200
    }, {
      header: this.app.i18n._('Ping Lifetime'),
      id: 'pinglifetime',
      dataIndex: 'pinglifetime',
      hidden: true,
      width: 200
    }, //{ header: this.app.i18n._('Ping Folder'),    id: 'pingfolder',        dataIndex: 'pingfolder',        hidden: false, width: 200},
    {
      header: this.app.i18n._('Remote Wipe'),
      id: 'remotewipe',
      dataIndex: 'remotewipe',
      hidden: false,
      width: 100
    }, {
      header: this.app.i18n._('Calendarfilter'),
      id: 'calendarfilter_id',
      dataIndex: 'calendarfilter_id',
      hidden: true,
      width: 200
    }, {
      header: this.app.i18n._('Contactsfilter'),
      id: 'contactsfilter_id',
      dataIndex: 'contactsfilter_id',
      hidden: true,
      width: 200
    }, {
      header: this.app.i18n._('Emailfilter'),
      id: 'emailfilter_id',
      dataIndex: 'emailfilter_id',
      hidden: true,
      width: 200
    }, {
      header: this.app.i18n._('Tasksfilter'),
      id: 'tasksfilter_id',
      dataIndex: 'tasksfilter_id',
      hidden: true,
      width: 200
    }, {
      header: this.app.i18n._('Last Ping'),
      id: 'lastping',
      dataIndex: 'lastping',
      hidden: false,
      width: 200,
      renderer: Tine.Tinebase.common.dateTimeRenderer
    }, {
      header: this.app.i18n._('Monitor Last Ping'),
      id: 'monitor_lastping',
      dataIndex: 'monitor_lastping',
      hidden: false,
      width: 100
    }];
  },

  /**
   * getAdditionalCtxItems
   *
   * @returns {Array}
   */
  getAdditionalCtxItems: function getAdditionalCtxItems() {
    this.actionRemoteResetDevices = new Ext.Action({
      text: this.app.i18n._('Remote Reset Device'),
      disabled: !Tine.Tinebase.common.hasRight('RESET DEVICES', 'ActiveSync'),
      scope: this,
      handler: this.onRemoteResetDevices,
      iconCls: 'action_wipeDevice'
    });
    return [this.actionRemoteResetDevices];
  },

  /**
   * onRemoteResetDevices
   */
  onRemoteResetDevices: function onRemoteResetDevices() {
    Ext.MessageBox.confirm(this.app.i18n._('Please Confirm'), this.app.i18n._('Do you really want to wipe the selected devices? All personal data will be removed and the device is reset to factory settings!'), function (button) {
      if (button == 'yes') {
        var selectedRows = this.grid.getSelectionModel().getSelections(),
            ids = [];

        for (var i = 0; i < selectedRows.length; ++i) {
          ids.push(selectedRows[i].id);
        }

        Ext.Ajax.request({
          params: {
            method: 'ActiveSync.remoteResetDevices',
            ids: ids
          },
          scope: this,
          success: function success() {
            this.loadGridData();
          },
          failure: function failure(exception) {
            this.loadGridData();
            Tine.Tinebase.ExceptionHandler.handleRequestException(exception);
          }
        });
      }
    }, this);
  },

  /**
   * initialises filter toolbar
   */
  initFilterPanel: function initFilterPanel() {
    this.filterToolbar = new Tine.widgets.grid.FilterToolbar({
      filterModels: [{
        label: this.app.i18n._('Quicksearch'),
        field: 'query',
        operators: ['contains']
      }, {
        label: this.app.i18n._('Device ID'),
        field: 'deviceid',
        operators: ['contains']
      }],
      defaultFilter: 'query',

      /*filters: [
          {field: 'deviceid', operator: 'equals', value: 'shared'}
      ],*/
      plugins: [new Tine.widgets.grid.FilterToolbarQuickFilterPlugin()]
    });
    this.plugins = this.plugins || [];
    this.plugins.push(this.filterToolbar);
  },
  initLayout: function initLayout() {
    this.supr().initLayout.call(this);

    if (!this.asAdminModule) {
      this.items.push({
        region: 'north',
        height: 55,
        border: false,
        items: this.actionToolbar
      });
    }
  }
});

/***/ }),

/***/ 1182:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     ActiveSync
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2015 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.ActiveSync');
/**
 * admin settings panel
 * 
 * @namespace   Tine.ActiveSync
 * @class       Tine.ActiveSync.AdminPanel
 * @extends     Ext.TabPanel
 * 
 * <p>ActiveSync Admin Panel</p>
 * <p><pre>
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2009 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.ActiveSync.AdminPanel
 */

Tine.ActiveSync.AdminPanel = Ext.extend(Ext.TabPanel, {
  border: false,
  activeTab: 0,

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.app = Tine.Tinebase.appMgr.get('ActiveSync');
    this.items = [new Tine.ActiveSync.SyncDevicesGridPanel({
      title: this.app.i18n._('Sync Devices'),
      // TODO make this work
      disabled: !Tine.Tinebase.common.hasRight('manage_devices', 'ActiveSync')
    })];
    Tine.ActiveSync.AdminPanel.superclass.initComponent.call(this);
  }
});
/**
 * ActiveSync Admin Panel Popup
 * 
 * @param   {Object} config
 * @return  {Ext.ux.Window}
 */

Tine.ActiveSync.AdminPanel.openWindow = function (config) {
  var window = Tine.WindowFactory.getWindow({
    width: 700,
    height: 470,
    name: 'activesync-manage-syncdevice',
    contentPanelConstructor: 'Tine.ActiveSync.AdminPanel',
    contentPanelConstructorConfig: config
  });
};

/***/ }),

/***/ 1183:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(1184);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(19)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 1184:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(189);
exports = module.exports = __webpack_require__(18)(false);
// imports


// module
exports.push([module.i, ".ActiveSyncIconCls {\n    background-image:url(" + escape(__webpack_require__(200)) + ") !important;\n}\n\n.activesync-device-standard {\n    background-image:url(" + escape(__webpack_require__(1185)) + ") !important;\n}\n\n.action_wipeDevice {\n    background-image:url(" + escape(__webpack_require__(349)) + ") !important;\n}\n", ""]);

// exports


/***/ }),

/***/ 1185:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cg%3E %3Cg%3E %3Cpath d='M29.1,4H14.2C12.4,4,11,5.4,11,7.2v27.6c0,1.8,1.4,3.2,3.2,3.2h14.9c1.8,0,3.2-1.4,3.2-3.2V7.2C32.3,5.4,30.8,4,29.1,4 L29.1,4z M17.4,5.6h8.5v1.1h-8.5V5.6z M21.6,35.9c-1.2,0-2.1-1-2.1-2.1c0-1.2,1-2.1,2.1-2.1s2.1,1,2.1,2.1 C23.8,34.9,22.8,35.9,21.6,35.9L21.6,35.9z M30.1,29.5h-17V8.3h17V29.5z M30.1,29.5'/%3E %3C/g%3E %3C/g%3E %3C/svg%3E\""

/***/ }),

/***/ 170:
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(1176);
__webpack_require__(1177);
__webpack_require__(1178);
__webpack_require__(1179);
__webpack_require__(1180);
__webpack_require__(1181);
__webpack_require__(1182);
__webpack_require__(1183);


/***/ }),

/***/ 18:
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),

/***/ 189:
/***/ (function(module, exports) {

module.exports = function escape(url) {
    if (typeof url !== 'string') {
        return url
    }
    // If url is already wrapped in quotes, remove them
    if (/^['"].*['"]$/.test(url)) {
        url = url.slice(1, -1);
    }
    // Should url be wrapped?
    // See https://drafts.csswg.org/css-values-3/#urls
    if (/["'() \t\n]/.test(url)) {
        return '"' + url.replace(/"/g, '\\"').replace(/\n/g, '\\n') + '"'
    }

    return url
}


/***/ }),

/***/ 19:
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getElement = (function (fn) {
	var memo = {};

	return function(selector) {
		if (typeof memo[selector] === "undefined") {
			var styleTarget = fn.call(this, selector);
			// Special case to return head of iframe instead of iframe itself
			if (styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[selector] = styleTarget;
		}
		return memo[selector]
	};
})(function (target) {
	return document.querySelector(target)
});

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(75);

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
	if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertInto + " " + options.insertAt.before);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	options.attrs.type = "text/css";

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	options.attrs.type = "text/css";
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = options.transform(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),

/***/ 200:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M28.1,21c0-2-0.7-3.7-2.1-5.1s-3.1-2.1-5.1-2.1s-3.7,0.7-5.1,2.1S13.8,19,13.8,21s0.7,3.7,2.1,5.1s3.1,2.1,5.1,2.1 s3.7-0.7,5.1-2.1S28.1,22.9,28.1,21z M37.9,18.5v4.9c0,0.2-0.1,0.3-0.2,0.5c-0.1,0.2-0.3,0.3-0.4,0.3l-4.1,0.6 c-0.3,0.8-0.6,1.5-0.9,2c0.5,0.7,1.3,1.8,2.4,3c0.1,0.2,0.2,0.4,0.2,0.6s-0.1,0.4-0.2,0.5c-0.4,0.5-1.1,1.3-2.2,2.4 c-1.1,1-1.8,1.6-2.1,1.6c-0.2,0-0.4-0.1-0.6-0.2l-3-2.4c-0.6,0.3-1.3,0.6-2,0.8c-0.2,2-0.4,3.4-0.6,4.1c-0.1,0.4-0.4,0.6-0.8,0.6 h-4.9c-0.2,0-0.4-0.1-0.5-0.2c-0.2-0.1-0.2-0.3-0.3-0.5l-0.6-4.1c-0.7-0.2-1.4-0.5-2-0.8L12,34.7c-0.1,0.1-0.3,0.2-0.6,0.2 c-0.2,0-0.4-0.1-0.6-0.2C9,33,7.8,31.8,7.2,31c-0.1-0.1-0.2-0.3-0.2-0.5c0-0.2,0.1-0.3,0.2-0.5c0.2-0.3,0.6-0.8,1.1-1.5 s0.9-1.2,1.2-1.6c-0.4-0.7-0.7-1.5-0.9-2.2l-4-0.6c-0.2,0-0.3-0.1-0.5-0.3C4.1,23.7,4,23.5,4,23.4v-4.9c0-0.2,0.1-0.3,0.2-0.5 s0.3-0.3,0.4-0.3L8.7,17c0.2-0.7,0.5-1.4,0.9-2c-0.6-0.8-1.4-1.9-2.4-3C7.1,11.8,7,11.6,7,11.4c0-0.1,0.1-0.3,0.2-0.5 c0.4-0.5,1.1-1.3,2.2-2.4S11.1,7,11.4,7c0.2,0,0.4,0.1,0.6,0.2l3,2.4c0.6-0.3,1.3-0.6,2-0.8c0.2-2,0.4-3.4,0.6-4.1 C17.8,4.2,18.1,4,18.5,4h4.9c0.2,0,0.4,0.1,0.5,0.2c0.2,0.1,0.2,0.3,0.3,0.5l0.6,4.1c0.7,0.2,1.4,0.5,2,0.8l3.1-2.4 C30.1,7,30.2,7,30.5,7c0.2,0,0.4,0.1,0.6,0.2c1.9,1.8,3.1,3,3.6,3.8c0.1,0.1,0.2,0.3,0.2,0.5c0,0.2-0.1,0.3-0.2,0.5 c-0.2,0.3-0.6,0.8-1.1,1.5c-0.5,0.7-0.9,1.2-1.2,1.6c0.4,0.7,0.7,1.5,0.9,2.2l4,0.6c0.2,0,0.3,0.1,0.5,0.3 C37.8,18.2,37.9,18.4,37.9,18.5z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 349:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M17.4,18.2v10.6c0,0.2-0.1,0.3-0.2,0.4c-0.1,0.1-0.3,0.2-0.4,0.2h-1.2c-0.2,0-0.3-0.1-0.4-0.2c-0.1-0.1-0.2-0.3-0.2-0.4 V18.2c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2C17.4,17.9,17.4,18,17.4,18.2z M22.2,18.2v10.6 c0,0.2-0.1,0.3-0.2,0.4c-0.1,0.1-0.3,0.2-0.4,0.2h-1.2c-0.2,0-0.3-0.1-0.4-0.2c-0.1-0.1-0.2-0.3-0.2-0.4V18.2c0-0.2,0.1-0.3,0.2-0.4 c0.1-0.1,0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2C22.1,17.9,22.2,18,22.2,18.2z M26.9,18.2v10.6c0,0.2-0.1,0.3-0.2,0.4 c-0.1,0.1-0.3,0.2-0.4,0.2h-1.2c-0.2,0-0.3-0.1-0.4-0.2c-0.1-0.1-0.2-0.3-0.2-0.4V18.2c0-0.2,0.1-0.3,0.2-0.4 c0.1-0.1,0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2C26.8,17.9,26.9,18,26.9,18.2z M29.3,31.6V14.1H12.7v17.5c0,0.3,0,0.5,0.1,0.7 c0.1,0.2,0.2,0.4,0.3,0.5c0.1,0.1,0.2,0.2,0.2,0.2h15.4c0,0,0.1-0.1,0.2-0.2c0.1-0.1,0.2-0.3,0.3-0.5C29.2,32.1,29.3,31.9,29.3,31.6 z M16.9,11.7h8.3l-0.9-2.2c-0.1-0.1-0.2-0.2-0.3-0.2h-5.9c-0.1,0-0.2,0.1-0.3,0.2L16.9,11.7z M34,12.3v1.2c0,0.2-0.1,0.3-0.2,0.4 c-0.1,0.1-0.3,0.2-0.4,0.2h-1.8v17.5c0,1-0.3,1.9-0.9,2.6s-1.3,1.1-2.1,1.1H13.3c-0.8,0-1.5-0.4-2.1-1.1c-0.6-0.7-0.9-1.6-0.9-2.6 V14.1H8.6c-0.2,0-0.3-0.1-0.4-0.2S8,13.7,8,13.5v-1.2c0-0.2,0.1-0.3,0.2-0.4s0.3-0.2,0.4-0.2h5.7l1.3-3.1c0.2-0.5,0.5-0.8,1-1.2 C17.1,7.2,17.5,7,18,7h5.9c0.5,0,1,0.2,1.5,0.5c0.5,0.3,0.8,0.7,1,1.2l1.3,3.1h5.7c0.2,0,0.3,0.1,0.4,0.2C33.9,12,34,12.1,34,12.3z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 75:
/***/ (function(module, exports) {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ })

}]);